/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.engine.ServiceDashBoardProvider;
import com.blixx.boom.gui.dialogs.SelectDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.graph.AddCustomizedIcon;
import com.blixx.boom.gui.graph.BTreeLayout2;
import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.boom.gui.graph.GraphUtils;
import com.blixx.boom.gui.graph.MapAddAction;
import com.blixx.boom.gui.graph.MapAddFFilterAction;
import com.blixx.boom.gui.graph.MapDeleteAction;
import com.blixx.boom.gui.graph.MapDeleteFilterAction;
import com.blixx.boom.gui.graph.MapDeleteLinkAction;
import com.blixx.boom.gui.graph.MapEditLabelAction;
import com.blixx.boom.gui.graph.MapLinkAction;
import com.blixx.boom.gui.graph.MapSelectChildren;
import com.blixx.boom.gui.graph.MapShiftXAction;
import com.blixx.boom.gui.graph.MapShiftYAction;
import com.blixx.boom.gui.graph.NodeGroupsView;
import com.blixx.boom.gui.graph.ServiceTab;
import com.blixx.boom.gui.graph.ZoomAction;
import com.blixx.boom.gui.graph.ZoomAction2;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.DashBoardServicesView;
import com.blixx.log.RTLogger;
import com.blixx.shared.UserRole;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.zest.core.widgets.GraphConnection;

public class ServiceEditorTab
extends ServiceTab
implements KeyListener {
    private static final String GLOBAL = "GLOBAL                                                  ";
    private static String UPLOAD_BUTTON = "UPLOAD_BUTTON";
    private static String DOWNLOAD_BUTTON = "DOWNLOAD_BUTTON";
    private static String DOWNLOAD_FOR_ROLE_BUTTON = "DOWNLOAD_FOR_ROLE_BUTTON";
    private Label m_currentURLabel;
    private ServiceDashBoardProvider m_serviceProviderOrig;
    private ServiceDashBoardProvider m_serviceProvider;
    private Composite graphComp;
    private Composite btnComp;
    private NodeGroupsView m_parentTreeView;

    public ServiceEditorTab(CTabFolder parent, int style, GCube cube) {
        super(parent, style);
        this.m_serviceProvider = this.m_serviceProviderOrig = new ServiceDashBoardProvider();
        this.m_parentTreeView = null;
        this.m_instance = this;
        this.m_parent = parent;
        this.m_gcube = cube;
        this.comp = new Composite((Composite)parent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.comp.setLayout((Layout)gridLayout);
        if (this.m_gcube == null) {
            this.m_gcube = this.createCube(this.m_gcube);
        }
        this.graphComp = new Composite(this.comp, 0);
        this.graphComp.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.graphComp.setLayoutData((Object)gridData);
        this.createGraph();
        GUIDisplayElements gui = new GUIDisplayElements();
        this.btnComp = new Composite(this.comp, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.btnComp.setLayout((Layout)gl);
        this.btnComp.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        Button upload_btn = gui.addButton(this.btnComp, UPLOAD_BUTTON, "Upload to the Server", true, this);
        upload_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        upload_btn.setEnabled(this.m_serviceProvider.isLocalChangesAllowed());
        int rights = Repository.getInstance().getRights(DashBoardServicesView.VIEW_ID);
        if (rights > 0 && rights < 3) {
            upload_btn.setEnabled(false);
        }
        Button download_btn = gui.addButton(this.btnComp, DOWNLOAD_BUTTON, "Download from Server", true, this);
        download_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        Button download_FU_btn = gui.addButton(this.btnComp, DOWNLOAD_FOR_ROLE_BUTTON, "Switch User role...", true, this);
        download_FU_btn.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_currentURLabel = new Label(this.btnComp, 0);
        this.m_currentURLabel.setText(GLOBAL);
        if (rights != 3) {
            download_FU_btn.setVisible(false);
            this.m_currentURLabel.setVisible(false);
        }
        this.setText(" Edit ");
        this.setControl((Control)this.comp);
    }

    public void setParentTreeView(NodeGroupsView tree) {
        this.m_parentTreeView = tree;
    }

    @Override
    public void createGraph() {
        if (this.m_graph == null) {
            this.m_graph = new Graph(this.graphComp, 0);
            this.m_graph.setLayoutData(new GridData(4, 4, true, true, 1, 1));
            this.m_graph.setVisible(false);
            this.m_graph.setConnectionStyle(4);
            BTreeLayout2 layout = new BTreeLayout2(this.m_gcube);
            this.m_graph.setLayoutAlgorithm(layout, true);
            this.m_graph.addSelectionListener(this);
            this.m_graph.addMouseListener(this);
            this.m_graph.addKeyListener(this);
            this.addContentMenu();
        } else {
            this.m_graph.setVisible(false);
            BTreeLayout2 layout = new BTreeLayout2(this.m_gcube);
            this.m_graph.setLayoutAlgorithm(layout, true);
        }
        GraphUtils.initGraph(this.m_graph, this.m_gcube);
        this.m_graph.setVisible(true);
        this.m_graph.applyLayout();
    }

    @Override
    public void addContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)this.m_graph);
        this.m_graph.setMenu(menu);
        NodeGroupsView.getInstance().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                block11: {
                    try {
                        manager.add((IAction)new ZoomAction2(ServiceEditorTab.this.m_graph, "-50%", 1.5));
                        manager.add((IAction)new ZoomAction2(ServiceEditorTab.this.m_graph, "+50%", 1.5));
                        manager.add((IAction)new ZoomAction2(ServiceEditorTab.this.m_graph, "-100%", 2.0));
                        manager.add((IAction)new ZoomAction2(ServiceEditorTab.this.m_graph, "+100%", 2.0));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ZoomAction(ServiceEditorTab.this.m_graph, "Layout -50%", (int)((double)ServiceEditorTab.this.m_width * 0.66), (int)((double)ServiceEditorTab.this.m_height / 1.5), ServiceEditorTab.this.m_instance));
                        manager.add((IAction)new ZoomAction(ServiceEditorTab.this.m_graph, "Layout +50%", (int)((double)ServiceEditorTab.this.m_width * 1.5), (int)((double)ServiceEditorTab.this.m_height * 1.5), ServiceEditorTab.this.m_instance));
                        manager.add((IAction)new ZoomAction(ServiceEditorTab.this.m_graph, "Layout -100%", (int)((double)ServiceEditorTab.this.m_width * 0.5), ServiceEditorTab.this.m_height / 2, ServiceEditorTab.this.m_instance));
                        manager.add((IAction)new ZoomAction(ServiceEditorTab.this.m_graph, "Layout +100%", ServiceEditorTab.this.m_width * 2, ServiceEditorTab.this.m_height * 2, ServiceEditorTab.this.m_instance));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Refresh";
                            }

                            public ImageDescriptor getImageDescriptor() {
                                return BMUI.IMAGE_DESCR_REFRESH;
                            }

                            public void run() {
                                (this).ServiceEditorTab.this.m_graph.applyLayout();
                                (this).ServiceEditorTab.this.m_graph.redraw();
                            }
                        });
                        List selection = ServiceEditorTab.this.m_graph.getSelection();
                        if (selection.size() == 1) {
                            Object sel = selection.get(0);
                            if (sel instanceof GraphConnection) {
                                GraphConnection conn = (GraphConnection)((Object)sel);
                                manager.add((IAction)new MapDeleteLinkAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, conn));
                                manager.add((IAction)new MapAddFFilterAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, conn));
                                manager.add((IAction)new MapDeleteFilterAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, conn));
                                break block11;
                            }
                            if (!(sel instanceof GraphNode)) break block11;
                            GraphNode node = (GraphNode)((Object)sel);
                            manager.add((IAction)new MapSelectChildren(ServiceEditorTab.this.m_graph, node));
                            manager.add((IContributionItem)new Separator());
                            Node parent = null;
                            try {
                                parent = (Node)node.getData();
                            }
                            catch (Throwable throwable) {
                                parent = null;
                            }
                            if (parent != null && ("".equals(parent.getType()) || "min".equals(parent.getType()) || "max".equals(parent.getType()))) {
                                manager.add((IAction)new AddCustomizedIcon(ServiceEditorTab.this.m_graph, node, parent));
                            }
                            manager.add((IAction)new MapAddAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent, Node.MAX_SERVICE, "Add Maximum"));
                            manager.add((IAction)new MapAddAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent, Node.MIN_SERVICE, "Add Minimum"));
                            manager.add((IAction)new MapAddAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent, BMUI.type_folder, "Add Folder"));
                            manager.add((IAction)new MapEditLabelAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent));
                            manager.add((IAction)new MapDeleteAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent));
                            manager.add((IAction)new MapShiftXAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent, 1));
                            manager.add((IAction)new MapShiftXAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent, -1));
                            manager.add((IAction)new MapShiftYAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent, 1));
                            manager.add((IAction)new MapShiftYAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, node, parent, -1));
                            break block11;
                        }
                        if (selection.size() == 2) {
                            Object sel1 = selection.get(0);
                            Object sel2 = selection.get(1);
                            if (sel1 instanceof GraphNode && sel2 instanceof GraphNode) {
                                GraphNode gn1 = (GraphNode)((Object)sel1);
                                GraphNode gn2 = (GraphNode)((Object)sel2);
                                Object n1 = gn1.getData();
                                Object n2 = gn2.getData();
                                if (n1 != null && n2 != null) {
                                    boolean skip;
                                    boolean bl = skip = n1 instanceof com.blixx.shared.space.Separator || n2 instanceof com.blixx.shared.space.Separator;
                                    if (!skip) {
                                        manager.add((IAction)new MapLinkAction(ServiceEditorTab.this.m_graph, ServiceEditorTab.this.m_gcube, gn1, gn2, (Node)n1, (Node)n2));
                                    }
                                }
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        RTLogger.print(5, "Error creating context menu", e);
                    }
                }
            }
        });
    }

    private GCube createCube(GCube cube) {
        if (cube == null) {
            cube = new GCube(true);
        }
        cube.clear();
        this.init(cube);
        Map<String, ServiceDashBoard> services = this.m_serviceProvider.getServices();
        Iterator<Map.Entry<String, ServiceDashBoard>> its = services.entrySet().iterator();
        int x = -1;
        int y = cube.getRealSlices();
        while (its.hasNext()) {
            ServiceDashBoard sdb = its.next().getValue();
            Node node = new Node(cube, sdb.getID(), ++x, y, 0.0, sdb.getName(), "service");
            node.setObject(sdb);
            cube.addNode(node);
        }
        return cube;
    }

    protected void init(GCube cube) {
        File m_streefile = this.m_serviceProvider.getCubeFile();
        if (m_streefile.exists() && m_streefile.canRead() && m_streefile.length() > 0L) {
            cube.loadXML(m_streefile);
        } else {
            Node root = new Node(cube, "servicesROOT", 0.0, 0.0, 0.0, "Services", "root");
            cube.addRoot(root);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        Object obj = ke.getSource();
        if (obj instanceof Graph) {
            List selection = this.m_graph.getSelection();
            if (selection.size() == 1) {
                Object sel = selection.get(0);
                if (sel instanceof GraphConnection) {
                    GraphConnection conn = (GraphConnection)((Object)sel);
                    if (ke.character == '\u007f') {
                        MapDeleteLinkAction a = new MapDeleteLinkAction(this.m_graph, this.m_gcube, conn);
                        a.run();
                    }
                } else if (sel instanceof GraphNode) {
                    GraphNode node = (GraphNode)((Object)sel);
                    if (ke.keyCode == 0x1000003) {
                        MapShiftXAction a = new MapShiftXAction(this.m_graph, this.m_gcube, node, (Node)node.getData(), -1);
                        a.run();
                    } else if (ke.keyCode == 0x1000004) {
                        MapShiftXAction a = new MapShiftXAction(this.m_graph, this.m_gcube, node, (Node)node.getData(), 1);
                        a.run();
                    } else if (ke.keyCode == 0x1000002) {
                        if (ke.stateMask == 262144) {
                            MapSelectChildren a = new MapSelectChildren(this.m_graph, node);
                            a.run();
                        } else {
                            MapShiftYAction a = new MapShiftYAction(this.m_graph, this.m_gcube, node, (Node)node.getData(), 1);
                            a.run();
                        }
                    } else if (ke.keyCode == 0x1000001) {
                        MapShiftYAction a = new MapShiftYAction(this.m_graph, this.m_gcube, node, (Node)node.getData(), -1);
                        a.run();
                    } else if (ke.character == '\u007f') {
                        Node data = null;
                        if (node != null && !node.isDisposed()) {
                            data = (Node)node.getData();
                        }
                        new MapDeleteAction(this.m_graph, this.m_gcube, node, data).run();
                    }
                }
            } else if (selection.size() == 2) {
                Object sel1 = selection.get(0);
                Object sel2 = selection.get(1);
                if (sel1 instanceof GraphNode && sel2 instanceof GraphNode && ke.character == ' ') {
                    GraphNode gn1 = (GraphNode)((Object)sel1);
                    GraphNode gn2 = (GraphNode)((Object)sel2);
                    Object n1 = gn1.getData();
                    Object n2 = gn2.getData();
                    if (n1 instanceof Node && n2 instanceof Node) {
                        MapLinkAction a = new MapLinkAction(this.m_graph, this.m_gcube, gn1, gn2, (Node)n1, (Node)n2);
                        a.run();
                    }
                }
            }
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof Button) {
            Button b = (Button)e.widget;
            String name = (String)b.getData();
            if (name.equals(UPLOAD_BUTTON)) {
                try {
                    ArrayList<String> exceptTypes = new ArrayList<String>();
                    exceptTypes.add("service");
                    exceptTypes.add("efg");
                    exceptTypes.add("agt");
                    this.m_gcube.storeXML(this.m_serviceProvider.getCubeFile().getCanonicalPath(), exceptTypes);
                    this.m_serviceProvider.uploadCubeToServer();
                    if (this.m_parentTreeView != null) {
                        this.m_parentTreeView.recreateCubeForAll();
                    }
                }
                catch (Throwable throwable) {
                    new ShowMessageBox("Server update", "Can't save intermediate config. Upload is canceled", 1);
                }
            } else if (name.equals(DOWNLOAD_BUTTON)) {
                this.m_serviceProvider.loadCubeFromServer();
                this.m_serviceProvider.loadFromServer();
                this.m_graph.clean();
                this.createCube(this.m_gcube);
                this.createGraph();
            } else if (name.equals(DOWNLOAD_FOR_ROLE_BUTTON)) {
                List<UserRole> list = Repository.getInstance().getUserManager().getRoleList();
                SelectDialog sd = new SelectDialog(this.m_parent.getShell(), list.toArray(), "Select User role", null);
                sd.setBlockOnOpen(true);
                int res = sd.open();
                if (res == 0) {
                    UserRole ur = (UserRole)sd.getResult();
                    String currentID = Repository.getInstance().getUserManager().getUserByLoginName((String)Repository.m_user).m_roleID;
                    if (ur.getID().equals(currentID)) {
                        this.m_serviceProvider = this.m_serviceProviderOrig;
                        this.m_currentURLabel.setText(GLOBAL);
                    } else {
                        this.m_serviceProvider = new ServiceDashBoardProvider(ur.getID());
                        this.m_serviceProvider.loadCubeFromServer();
                        this.m_serviceProvider.loadFromServer();
                        this.m_currentURLabel.setText("Current User role: " + ur.getName());
                    }
                    this.m_graph.clean();
                    this.createCube(this.m_gcube);
                    this.createGraph();
                }
            }
        }
    }
}

