/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.graph.BTreeLayout2;
import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphLabel;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.boom.gui.graph.GraphUtils;
import com.blixx.boom.gui.graph.MapImpactAV;
import com.blixx.boom.gui.graph.MapImpactKPI;
import com.blixx.boom.gui.graph.MapImpactOther;
import com.blixx.boom.gui.graph.MapRootCostAV;
import com.blixx.boom.gui.graph.MapRootCostKPI;
import com.blixx.boom.gui.graph.MapRootCostOther;
import com.blixx.boom.gui.graph.MapSelectChildren;
import com.blixx.boom.gui.graph.MapSetTopAction;
import com.blixx.boom.gui.graph.MapShowTopAction;
import com.blixx.boom.gui.graph.NodeGroupsView;
import com.blixx.boom.gui.graph.ShowIndication;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.IServiceStatus;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.zest.core.widgets.GraphConnection;

public class ServiceTab
extends CTabItem
implements SelectionListener,
ISelectionProvider,
MouseListener,
KeyListener {
    protected GUIDisplayElements m_gui = null;
    protected Graph m_graph;
    protected GCube m_gcube;
    protected Composite comp;
    CTabFolder m_parent = null;
    public int m_width = 800;
    public int m_height = 400;
    public ServiceTab m_instance = null;
    public Scale zoomSlider = null;
    public Group toolsGroup = null;
    Text zoomText = null;
    private Button resetZoom = null;
    private static double m_previousZoom = 100.0;

    public ServiceTab(CTabFolder parent, int style, GCube cube) {
        this(parent, style);
        this.m_instance = this;
        this.m_parent = parent;
        this.m_gcube = cube;
        this.comp = new Composite((Composite)parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        this.comp.setLayout((Layout)layout);
        this.setText(" Status ");
        this.setControl((Control)this.comp);
        parent.setSelection((CTabItem)this);
        this.toolsGroup = new Group(this.comp, 16);
        this.zoomSlider = new Scale((Composite)this.toolsGroup, 512);
        this.zoomText = new Text((Composite)this.toolsGroup, 2048);
        this.createGraph();
    }

    protected ServiceTab(CTabFolder parent, int style) {
        super(parent, style);
    }

    public Graph getGraph() {
        return this.m_graph;
    }

    public GCube getCube() {
        return this.m_gcube;
    }

    public void createGraph() {
        if (this.m_graph == null) {
            GridData gridData = new GridData(32, 4, false, false);
            gridData.horizontalSpan = 0;
            gridData.horizontalIndent = 0;
            gridData.horizontalSpan = 0;
            this.toolsGroup.setLayoutData((Object)gridData);
            this.toolsGroup.setLayout((Layout)new GridLayout(1, false));
            this.toolsGroup.setLocation(0, 0);
            this.toolsGroup.setText("Zoom");
            this.zoomSlider.setMaximum(300);
            this.zoomSlider.setSelection(200);
            this.zoomSlider.setIncrement(5);
            this.zoomSlider.setPageIncrement(5);
            this.zoomSlider.setBounds(this.toolsGroup.getClientArea().x + 10, 30, 40, 500);
            this.zoomSlider.setLayoutData((Object)new GridData(64));
            GridData textGD = new GridData(1, 2, true, false);
            textGD.minimumWidth = 40;
            this.zoomText.setLayoutData((Object)textGD);
            this.zoomText.setText("100%");
            this.zoomText.setTextLimit(4);
            this.zoomText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String string = e.text;
                    char[] chars = new char[string.length()];
                    string.getChars(0, chars.length, chars, 0);
                    int i = 0;
                    while (i < chars.length) {
                        if (('0' > chars[i] || chars[i] > '9') && chars[i] != '%') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.zoomText.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    int value;
                    String percentage = ServiceTab.this.zoomText.getText();
                    StringBuilder sb = new StringBuilder(percentage);
                    if (percentage.contains("%")) {
                        int i = 0;
                        while (i < sb.length()) {
                            if (sb.charAt(i) == '%') {
                                sb.deleteCharAt(i);
                            }
                            ++i;
                        }
                        percentage = sb.toString();
                    }
                    if ((value = Integer.parseInt(percentage)) > 300 || value < 0) {
                        MessageBox messageBox = new MessageBox(ServiceTab.this.toolsGroup.getShell(), 8);
                        messageBox.setText("Warning");
                        messageBox.setMessage("Zoom ranges from 0% to 300%");
                        messageBox.open();
                    } else {
                        value -= 300;
                        value = Math.abs(value);
                        ServiceTab.this.zoomSlider.setSelection(value);
                        ServiceTab.this.setZoom(value);
                    }
                }
            });
            this.toolsGroup.pack();
            this.zoomSlider.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ServiceTab.this.setZoom(ServiceTab.this.zoomSlider.getSelection());
                }
            });
            this.resetZoom = new Button((Composite)this.toolsGroup, 524288);
            this.resetZoom.setText("Reset");
            this.resetZoom.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServiceTab.this.setZoom(200);
                    ServiceTab.this.zoomSlider.setSelection(200);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            GridData graphGridData = new GridData(4, 4, true, true);
            this.m_graph = new Graph(this.comp, 0);
            this.m_graph.setLayoutData(graphGridData);
            this.m_graph.setVisible(false);
            this.m_graph.setConnectionStyle(4);
            if (this.m_gcube == null) {
                this.m_gcube = new GCube(false);
            }
            BTreeLayout2 layout = new BTreeLayout2(this.m_gcube);
            this.m_graph.setLayoutAlgorithm(layout, true);
            this.m_graph.addSelectionListener(this);
            this.m_graph.addMouseListener(this);
            this.m_graph.addKeyListener(this);
            this.addContentMenu();
        } else {
            this.m_graph.setVisible(false);
            this.m_graph.clean();
            BTreeLayout2 layout = new BTreeLayout2(this.m_gcube);
            this.m_graph.setLayoutAlgorithm(layout, true);
        }
        GraphUtils.initGraph(this.m_graph, this.m_gcube);
        this.m_graph.setVisible(true);
    }

    private void setZoom(int desiredZoom) {
        int currentValue = desiredZoom;
        currentValue -= 300;
        if ((currentValue = Math.abs(currentValue)) == 100) {
            this.m_graph.getRootLayer().setScale(1.0);
            m_previousZoom = currentValue;
        } else if (m_previousZoom < (double)currentValue) {
            this.zoomIn(currentValue);
        } else {
            this.zoomOut(currentValue);
        }
        this.zoomText.setText(String.valueOf(Integer.toString(currentValue)) + "%");
    }

    private void zoomOut(double currentValue) {
        double temp = currentValue;
        currentValue -= m_previousZoom;
        double scale = this.m_graph.getRootLayer().getScale();
        currentValue /= 100.0;
        currentValue = Math.abs(currentValue);
        m_previousZoom = temp;
        this.m_graph.getRootLayer().setScale(scale -= currentValue);
    }

    private void zoomIn(double currentValue) {
        double temp = currentValue;
        currentValue -= m_previousZoom;
        double scale = this.m_graph.getRootLayer().getScale();
        currentValue /= 100.0;
        currentValue = Math.abs(currentValue);
        m_previousZoom = temp;
        this.m_graph.getRootLayer().setScale(scale += currentValue);
    }

    public void addContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)this.m_graph);
        this.m_graph.setMenu(menu);
        NodeGroupsView.getInstance().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    Object sel;
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new Action(){

                        public String getText() {
                            return "Refresh";
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return BMUI.IMAGE_DESCR_REFRESH;
                        }

                        public void run() {
                            ServiceTab.this.recreateGraph();
                        }
                    });
                    List selection = ServiceTab.this.m_graph.getSelection();
                    if (selection.size() == 1 && !((sel = selection.get(0)) instanceof GraphConnection) && sel instanceof GraphNode) {
                        GraphNode node = (GraphNode)((Object)sel);
                        if (Repository.getInstance().getRights(1000) > 2) {
                            manager.add((IAction)new ShowIndication(node));
                        }
                        manager.add((IAction)new MapShowTopAction(ServiceTab.this.m_instance));
                        manager.add((IAction)new MapSetTopAction(ServiceTab.this.m_graph, node, ServiceTab.this.m_gcube));
                        manager.add((IAction)new MapSelectChildren(ServiceTab.this.m_graph, node));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new MapRootCostAV(ServiceTab.this.m_graph, node));
                        manager.add((IAction)new MapRootCostKPI(ServiceTab.this.m_graph, node));
                        manager.add((IAction)new MapRootCostOther(ServiceTab.this.m_graph, node));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new MapImpactAV(ServiceTab.this.m_graph, node));
                        manager.add((IAction)new MapImpactKPI(ServiceTab.this.m_graph, node));
                        manager.add((IAction)new MapImpactOther(ServiceTab.this.m_graph, node));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void recreateGraph() {
        this.createGraph();
        this.m_graph.applyLayout();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof Graph) {
            Graph g = (Graph)e.widget;
            List list = g.getSelection();
            for (Object obj : list) {
                if (!(obj instanceof GraphNode)) continue;
                GraphNode cfr_ignored_0 = (GraphNode)((Object)obj);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Graph) {
            Graph gr = (Graph)obj;
            Point mousePoint = new Point(e.x, e.y);
            gr.getRootLayer().translateToRelative((Translatable)mousePoint);
            IFigure fig = gr.getFigureAt(mousePoint.x, mousePoint.y);
            if (fig instanceof GraphLabel) {
                GraphLabel gl = (GraphLabel)fig;
                Node node = gl.getNode();
                if (node == null) {
                    return;
                }
                if (node.getType().equals(BMUI.type_agt)) {
                    AgentCard ac = Repository.getInstance().getAgentCard(node.getID());
                    MessagesView.showMessagesForAgent(ac, ac.toString());
                } else if (node.getObject() instanceof ServiceDashBoard) {
                    MessagesView.showMessages((ServiceDashBoard)node.getObject());
                } else if (node.getType().equals("efg")) {
                    EventFilterGroup efg = (EventFilterGroup)node.getObject();
                    MessagesView.showMessages(efg);
                } else if (node.isStatusAvailable()) {
                    MessagesView.showMessages((IServiceStatus)node.getObject());
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Graph) {
            Graph gr = (Graph)obj;
            Point mousePoint = new Point(e.x, e.y);
            gr.getRootLayer().translateToRelative((Translatable)mousePoint);
            IFigure iFigure = gr.getFigureAt(mousePoint.x, mousePoint.y);
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.m_graph.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent ke) {
        Object obj = ke.getSource();
        if (obj instanceof Graph) {
            Object sel;
            List selection = this.m_graph.getSelection();
            if (selection.size() == 1 && (sel = selection.get(0)) instanceof GraphNode && ke.keyCode == 0x1000002 && ke.stateMask == 262144) {
                MapSelectChildren a = new MapSelectChildren(this.m_graph, (GraphNode)((Object)sel));
                a.run();
            }
            if (ke.character == 'A' && ke.stateMask == 262144) {
                ((Graph)obj).selectAll();
            }
        }
    }

    public void dispose() {
        this.m_graph.dispose();
        this.m_gcube.clear();
        super.dispose();
    }
}

