/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.notify;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.notify.NotificationConfigTableProvider;
import com.blixx.boom.gui.notify.NotificationView;
import com.blixx.boom.gui.notify.NovelUtils;
import com.blixx.boom.gui.notify.ServerCfgMgr;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.InputValidator;
import com.blixx.boom.gui.views.Proposals;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardConditions;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.notify.NovelConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;

public class NotificationConfigTab
extends CTabItem
implements SelectionListener,
ISelectionChangedListener,
IDoubleClickListener,
ModifyListener,
Listener {
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String STARTTLS_BTN_NAME = "STARTTLS";
    public static final String QUEUE_SIZE_LABEL = "Queue Size:";
    public static final String EXPIRED_FILE_SIZE_LABEL = "Expired File Size (MB):  ";
    public static final String RETRY_INTERVAL_LABEL = "Retry Interval (sec):";
    public static final String EXPIRE_INTERVAL_LABEL = "Expire Interval (sec):";
    private static NotificationConfigTab m_notificationTab = null;
    private CTabFolder m_folder = null;
    private SashForm m_sash = null;
    private GUIDisplayElements m_gui = null;
    private boolean m_oninit = true;
    private boolean m_isNew = false;
    private boolean m_isDirty = false;
    private NovelConfig m_current_ConfigItem = null;
    private Color m_defaultColor = null;
    private Composite m_compTable = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private NotificationConfigTableProvider m_tableProvider = null;
    private Button m_refresh_btn = null;
    private Button m_add_btn = null;
    private Button m_dup_btn = null;
    private Button m_del_btn = null;
    private Button m_start_btn = null;
    private Button m_stop_btn = null;
    private ScrolledComposite m_sc = null;
    private Composite m_comp_in_sc = null;
    private static CTabFolder m_detailFolder = null;
    private CTabItem m_detailTab = null;
    private Composite m_mainComp = null;
    private Text m_name_field = null;
    private Text m_desc_field = null;
    private Text m_expire_interval_field = null;
    private Text m_retry_interval_field = null;
    private Text m_queue_size_field = null;
    private Text m_expire_fileSize_field = null;
    private Text m_from_field = null;
    private Text m_to_field = null;
    private Text m_message_field = null;
    private Text m_mail_subject_field = null;
    private Text m_mail_smtp_host_field = null;
    private Text m_mail_smtp_port_field = null;
    private Button m_mail_auth_chk = null;
    private Text m_mail_smtp_user_field = null;
    private Text m_mail_smtp_pwd_field = null;
    private Text m_exec_call_field = null;
    private Text m_newLineReplaceStr_field = null;
    private Button m_save_btn = null;
    private Button m_undo_btn = null;
    private Button m_cancel_btn = null;
    private Button m_test_btn = null;
    private Button m_startTLS_btn = null;
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String CONFIG_TABLE = "CONFIG_TABLE";
    public static String TABLE_VIEWER = "TABLE_VIEWER";
    public static String NAME = "NAME";
    public static String DESCRIPTION = "DESCRIPTION";
    public static String EXPIRE_INTERVAL = "EXPIRE_INTERVAL";
    public static String RETRY_INTERVAL = "RETRY_INTERVAL";
    public static String EXPIRED_FILE_SIZE = "EXPIRED_FILE_SIZE";
    public static String QUEUE_SIZE = "QUEUE_SIZE";
    public static String FROM = "FROM";
    public static String TO = "TO";
    public static String SUBJECT = "SUBJECT";
    public static String MESSAGE = "MESSAGE";
    public static String MAIL_SMTP_HOST = "MAIL_SMTP_HOST";
    public static String MAIL_SMTP_PORT = "MAIL_SMTP_PORT";
    public static String MAIL_SMTP_AUTH = "MAIL_SMTP_AUTH";
    public static String MAIL_SMTP_USER = "MAIL_SMTP_USER";
    public static String MAIL_SMTP_PWD = "MAIL_SMTP_PWD";
    public static String EXEC_CALL = "EXEC_CALL";
    public static String NEWLINE_REPLACE_STR = "NEWLINE_REPLACE_STR";
    public static String REFRESH_BTN = "REFRESH";
    public static String ADD_BTN = "ADD";
    public static String DUPLICATE_BTN = "DUPLICATE";
    public static String DEL_BTN = "DEL";
    public static String START_BTN = "START";
    public static String STOP_BTN = "STOP";
    public static String SAVE_BTN = "SAVE";
    public static String UNDO_BTN = "UNDO";
    public static String CANCEL_BTN = "CANCEL";
    public static String TEST_BTN = "TEST";
    private Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            TableColumn currentColumn = (TableColumn)e.widget;
            Table table = currentColumn.getParent();
            TableViewer tableViewer = (TableViewer)table.getData(TABLE_VIEWER);
            if (e.type == 13) {
                TableColumn sortColumn = tableViewer.getTable().getSortColumn();
                int dir = tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                ISelection iSelection = tableViewer.getSelection();
                NotificationConfigTab.this.m_tableProvider.setConfig(currentColumn.getText(), dir);
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.refresh();
                tableViewer.setSelection(iSelection);
            }
        }
    };

    public NotificationConfigTab(CTabFolder parent) {
        super(parent, 0, 0);
        m_notificationTab = this;
        this.m_folder = parent;
        this.setText("Configuration");
        this.createMainArea();
        this.m_oninit = false;
    }

    public static NotificationConfigTab getInstance() {
        return m_notificationTab;
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.setNew(false);
        this.m_sash = new SashForm((Composite)this.m_folder, 256);
        this.m_sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTable();
        if (this.m_table.getItemCount() == 0) {
            this.createDetailArea(null, null);
        } else {
            this.setTableSelection(0);
        }
        this.m_sash.setWeights(new int[]{50, 50});
        this.setControl((Control)this.m_sash);
        if (Repository.getInstance().getRights(2014) < 3) {
            this.setReadOnly();
        }
    }

    public void createTable() {
        this.m_compTable = new Composite((Composite)this.m_sash, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compTable.setLayout((Layout)gl);
        this.m_compTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_table = new Table(this.m_compTable, 268503812);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        this.m_table.setLayout((Layout)gl);
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn col0 = new TableColumn(this.m_table, 16384);
        col0.setText("Type");
        col0.setWidth(24);
        col0.addListener(13, this.sortListener);
        TableColumn col1 = new TableColumn(this.m_table, 16384);
        col1.setText("Name");
        col1.setWidth(150);
        col1.addListener(13, this.sortListener);
        TableColumn col2 = new TableColumn(this.m_table, 16384);
        col2.setText("Description");
        col2.setWidth(190);
        col2.addListener(13, this.sortListener);
        TableColumn col3 = new TableColumn(this.m_table, 16384);
        col3.setText("isStarted");
        col3.setWidth(65);
        col3.addListener(13, this.sortListener);
        TableColumn col4 = new TableColumn(this.m_table, 16384);
        col4.setText("Queue Size");
        col4.setWidth(50);
        col4.addListener(13, this.sortListener);
        TableColumn col5 = new TableColumn(this.m_table, 16384);
        col5.setText("Failed");
        col5.setWidth(50);
        col5.addListener(13, this.sortListener);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)CONFIG_TABLE);
        this.m_tableProvider = new NotificationConfigTableProvider("Name", 128);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider.labelProvider);
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
        this.m_tableViewer.setSorter((ViewerSorter)this.m_tableProvider);
        this.m_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_table.setData(TABLE_VIEWER, (Object)this.m_tableViewer);
        this.m_table.addSelectionListener((SelectionListener)this);
        this.createCM_Table();
        ScrolledComposite sc = new ScrolledComposite(this.m_compTable, 768);
        sc.setAlwaysShowScrollBars(false);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        sc.setLayout((Layout)gl);
        sc.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite compBtn = new Composite((Composite)sc, 0);
        gl = new GridLayout(7, false);
        gl.marginWidth = 0;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(4, 4, false, false));
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.m_refresh_btn = this.m_gui.addButton(compBtn, REFRESH_BTN, "Refresh", true, 0, 0, 0, 0, this);
        ((GridData)this.m_refresh_btn.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalAlignment = 1024;
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH);
        this.m_start_btn = this.m_gui.addButton(compBtn, START_BTN, " Start ", true, 60, 10, 0, 0, this);
        ((GridData)this.m_start_btn.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_start_btn.getLayoutData()).verticalAlignment = 1024;
        this.m_start_btn.setImage(BMUI.IMAGE_START_16x16);
        this.m_stop_btn = this.m_gui.addButton(compBtn, STOP_BTN, " Stop ", true, 60, 10, 0, 0, this);
        ((GridData)this.m_stop_btn.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_stop_btn.getLayoutData()).verticalAlignment = 1024;
        this.m_stop_btn.setImage(BMUI.IMAGE_STOP_16x16);
        Label filler = this.m_gui.addTextField(compBtn, null, "", 1, 1, 0, 0, null);
        filler.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_add_btn = this.m_gui.addButton(compBtn, ADD_BTN, " Add ", true, 60, 10, 0, 0, this);
        ((GridData)this.m_add_btn.getLayoutData()).horizontalAlignment = 131072;
        ((GridData)this.m_add_btn.getLayoutData()).verticalAlignment = 1024;
        this.m_add_btn.setImage(sharedImages.getImage("IMG_OBJ_ADD"));
        this.m_dup_btn = this.m_gui.addButton(compBtn, DUPLICATE_BTN, " Duplicate ", true, 60, 10, 0, 0, this);
        ((GridData)this.m_dup_btn.getLayoutData()).horizontalAlignment = 131072;
        ((GridData)this.m_dup_btn.getLayoutData()).verticalAlignment = 1024;
        this.m_dup_btn.setImage(sharedImages.getImage("IMG_TOOL_COPY"));
        this.m_del_btn = this.m_gui.addButton(compBtn, DEL_BTN, " Delete ", true, 60, 10, 0, 0, this);
        ((GridData)this.m_del_btn.getLayoutData()).horizontalAlignment = 131072;
        ((GridData)this.m_del_btn.getLayoutData()).verticalAlignment = 1024;
        this.m_del_btn.setImage(sharedImages.getImage("IMG_TOOL_DELETE"));
        sc.setContent((Control)compBtn);
        sc.setMinSize(compBtn.computeSize(-1, -1, true));
    }

    public void createCM_Table() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = NotificationView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)NotificationConfigTab.this.m_tableViewer.getSelection();
                    manager.add((IAction)new RefreshTableAction(m_notificationTab));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new StartAction(ssel, m_notificationTab));
                    manager.add((IAction)new StopAction(ssel, m_notificationTab));
                    manager.add((IContributionItem)new Separator());
                    ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
                    MenuManager subMenu = new MenuManager("Add Notification", sharedImages.getImageDescriptor("IMG_OBJ_ADD"), null);
                    manager.add((IContributionItem)subMenu);
                    subMenu.add((IAction)new AddNewConfigItemAction(NovelConfig.NovelCgfType.MAIL, m_notificationTab));
                    subMenu.add((IAction)new AddNewConfigItemAction(NovelConfig.NovelCgfType.EXEC, m_notificationTab));
                    manager.add((IAction)new DuplicateConfigAction(ssel, m_notificationTab));
                    manager.add((IAction)new DeleteConfigItemAction(ssel, m_notificationTab));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createDetailArea(String cfgType, NovelConfig cfgItem) {
        this.m_current_ConfigItem = cfgItem;
        if (this.m_oninit || this.m_sc == null || this.m_sc.isDisposed() || this.m_comp_in_sc == null || this.m_comp_in_sc.isDisposed()) {
            this.m_sc = new ScrolledComposite((Composite)this.m_sash, 768);
            this.m_sc.setAlwaysShowScrollBars(false);
            this.m_sc.setExpandHorizontal(true);
            this.m_sc.setExpandVertical(true);
            this.m_sc.setLayout((Layout)new GridLayout(1, false));
            this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_sc.addListener(37, new Listener(){

                public void handleEvent(Event event) {
                    ScrolledComposite sc = (ScrolledComposite)event.widget;
                    sc.getVerticalBar().setIncrement(event.count * 4);
                }
            });
            this.m_comp_in_sc = new Composite((Composite)this.m_sc, 0);
            this.m_comp_in_sc.setLayout((Layout)new GridLayout(1, false));
            this.m_comp_in_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        } else if (this.m_mainComp != null && !this.m_mainComp.isDisposed()) {
            Control[] controls = this.m_mainComp.getChildren();
            int i = 0;
            while (i < controls.length) {
                Control child = controls[i];
                child.dispose();
                ++i;
            }
            this.m_gui.enableField(this.m_save_btn, false);
            this.m_gui.enableField(this.m_undo_btn, false);
        }
        if (this.m_current_ConfigItem == null) {
            if (cfgType == null) {
                return;
            }
            this.setNew(true);
        } else if (cfgType == null) {
            cfgType = this.getCurrentConfigType().getText();
        }
        if (m_detailFolder == null || m_detailFolder.isDisposed()) {
            m_detailFolder = new CTabFolder(this.m_comp_in_sc, 768);
            m_detailFolder.setSimple(false);
            m_detailFolder.setBorderVisible(false);
            m_detailFolder.setBackground(BMUI.color_unknown);
            m_detailFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            int style = 0;
            this.m_detailTab = new CTabItem(m_detailFolder, style);
            this.m_mainComp = new Composite((Composite)m_detailFolder, 0);
            this.m_mainComp.setLayout((Layout)new GridLayout(1, false));
            this.m_mainComp.setLayoutData((Object)new GridData());
            this.m_detailTab.setControl((Control)this.m_mainComp);
            m_detailFolder.setSelection(this.m_detailTab);
            this.m_sc.setContent((Control)this.m_comp_in_sc);
            this.m_sc.setMinSize(this.m_comp_in_sc.computeSize(-1, -1, true));
        }
        if (cfgType.equals(NovelConfig.NovelCgfType.SMS.getText())) {
            this.m_detailTab.setImage(BMUI.IMAGE_SMS_16x16);
            this.createSMSDetails(this.m_mainComp, this.m_current_ConfigItem);
            this.createButtons(this.m_mainComp, NovelConfig.NovelCgfType.SMS.getText());
        } else if (cfgType.equals(NovelConfig.NovelCgfType.MAIL.getText())) {
            this.m_detailTab.setImage(BMUI.IMAGE_EMAIL_16x16);
            this.createEmailDetails(this.m_mainComp, this.m_current_ConfigItem);
            this.createButtons(this.m_mainComp, NovelConfig.NovelCgfType.MAIL.getText());
        } else if (cfgType.equals(NovelConfig.NovelCgfType.EXEC.getText())) {
            this.m_detailTab.setImage(BMUI.IMAGE_EXEC_16x16);
            this.createExecDetails(this.m_mainComp, this.m_current_ConfigItem);
            this.createButtons(this.m_mainComp, NovelConfig.NovelCgfType.EXEC.getText());
        }
        if (this.m_desc_field != null && !this.m_desc_field.isDisposed()) {
            this.m_defaultColor = this.m_desc_field.getBackground();
        }
        this.m_comp_in_sc.layout(true);
        this.m_mainComp.layout(true);
        this.m_sc.setContent((Control)this.m_comp_in_sc);
        this.m_sc.setMinSize(this.m_comp_in_sc.computeSize(-1, -1, true));
    }

    public void createEmailDetails(Composite parent, NovelConfig cfgItm) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginTop = 8;
        gl.marginWidth = 8;
        parent.setLayout((Layout)gl);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Properties default_props = NovelUtils.getDefaultProperties();
        NovelConfig nc = new NovelConfig(default_props, NovelConfig.NovelCgfType.MAIL, "temp");
        String header = "E-MAIL";
        String name = "";
        String desc = "";
        String expire_interval = "" + nc.getExpireIntervalSeconds();
        String retry_interval = "" + nc.getRetryIntervalSeconds();
        String expired_files_size = "" + nc.getMaxExpiredFileSize();
        String queue_size = "" + nc.getMaxQueueSize();
        String mail_from = "";
        String mail_to = "";
        String subject = "";
        String message = "";
        String smtp_host = "";
        String smtp_port = "";
        boolean use_auth = false;
        String smtp_user = "";
        String smtp_pwd = "";
        boolean startTLS = true;
        if (cfgItm != null) {
            name = cfgItm.getId();
            desc = cfgItm.getDescription();
            expire_interval = "" + cfgItm.getExpireIntervalSeconds();
            retry_interval = "" + cfgItm.getRetryIntervalSeconds();
            expired_files_size = "" + cfgItm.getMaxExpiredFileSize();
            queue_size = "" + cfgItm.getMaxQueueSize();
            mail_from = cfgItm.getFrom();
            mail_to = cfgItm.getTo();
            subject = cfgItm.getSubject();
            message = cfgItm.getMessage();
            smtp_host = cfgItm.getProperties().getProperty("mail.smtp.host");
            smtp_port = cfgItm.getProperties().getProperty("mail.smtp.port");
            if (smtp_port == null || smtp_port.length() == 0) {
                smtp_port = "25";
            }
            use_auth = Boolean.valueOf(cfgItm.getProperties().getProperty("mail.smtp.auth"));
            smtp_user = cfgItm.getProperties().getProperty("mail.smtp.user");
            smtp_pwd = cfgItm.getProperties().getProperty("mail.smtp.password");
            startTLS = Boolean.valueOf(cfgItm.getProperties().getProperty(MAIL_SMTP_STARTTLS_ENABLE, "true"));
        }
        this.m_detailTab.setText(name);
        this.m_gui.addTextReadOnlyNoBorder(parent, null, header, 1, 1, 0, 0, BMUI.font_arial8_bold);
        Group group0 = new Group(parent, 32);
        group0.setText("Config Information");
        group0.setFont(BMUI.font_arial7_bold);
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 3;
        group0.setLayout((Layout)gl);
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 10;
        group0.setLayoutData((Object)gd);
        this.m_name_field = this.isNew() || this.m_tableProvider.getCfgItemByID(name) == null ? this.m_gui.addInputFieldSingle((Composite)group0, NAME, "Name: ", name, 2, 1, 1, 0, 80, this) : this.m_gui.addTextReadOnlyNoBorder((Composite)group0, "Name: ", name, 2, 1, 0, 0, BMUI.font_arial8);
        this.m_desc_field = this.m_gui.addInputFieldSingle((Composite)group0, DESCRIPTION, "Description: ", desc, 2, 1, 1, 0, 80, this);
        this.m_expire_interval_field = this.m_gui.addInputFieldSingle((Composite)group0, EXPIRE_INTERVAL, EXPIRE_INTERVAL_LABEL, expire_interval, 1, 1, 1, 0, 50, this);
        ((GridData)this.m_expire_interval_field.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_expire_interval_field.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_gui.addTextField((Composite)group0, null, "(default=60sec)", 1, 1, 0, 3, BMUI.font_arial7);
        this.m_expire_interval_field.setToolTipText("Default Expire Intervall=60sec");
        this.m_retry_interval_field = this.m_gui.addInputFieldSingle((Composite)group0, RETRY_INTERVAL, RETRY_INTERVAL_LABEL, retry_interval, 1, 1, 1, 0, 50, this);
        ((GridData)this.m_retry_interval_field.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_retry_interval_field.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_gui.addTextField((Composite)group0, null, "(default=5sec)", 1, 1, 0, 3, BMUI.font_arial7);
        this.m_retry_interval_field.setToolTipText("Default Retry Intervall=5sec");
        this.m_expire_fileSize_field = this.m_gui.addInputFieldSingle((Composite)group0, EXPIRED_FILE_SIZE, EXPIRED_FILE_SIZE_LABEL, expired_files_size, 1, 1, 1, 0, 50, this);
        ((GridData)this.m_expire_fileSize_field.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_expire_fileSize_field.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_gui.addTextField((Composite)group0, null, "(default=1024MB)", 1, 1, 0, 3, BMUI.font_arial7);
        this.m_expire_fileSize_field.setToolTipText("Default Expire File Size=1024MB");
        this.m_queue_size_field = this.m_gui.addInputFieldSingle((Composite)group0, QUEUE_SIZE, QUEUE_SIZE_LABEL, queue_size, 1, 1, 1, 0, 50, this);
        ((GridData)this.m_queue_size_field.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_queue_size_field.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_gui.addTextField((Composite)group0, null, "(default=1000)", 1, 1, 0, 3, BMUI.font_arial7);
        this.m_queue_size_field.setToolTipText("Default Queue Size=1000");
        Group group1 = new Group(parent, 32);
        group1.setText("Message Information");
        group1.setFont(BMUI.font_arial7_bold);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 3;
        group1.setLayout((Layout)gl);
        gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 10;
        group1.setLayoutData((Object)gd);
        this.m_from_field = this.m_gui.addInputFieldSingle((Composite)group1, FROM, "From:", mail_from, 1, 1, 1, 1, 180, this);
        if (!this.isValidMAILAddress(mail_from)) {
            this.m_from_field.setBackground(BMUI.color_critical);
        }
        this.m_to_field = this.m_gui.addInputFieldSingle((Composite)group1, TO, "To:", mail_to, 1, 1, 1, 1, 180, this);
        if (!this.isValidMAILAddress(mail_to)) {
            this.m_to_field.setBackground(BMUI.color_critical);
        }
        this.m_mail_subject_field = this.m_gui.addInputFieldSingle((Composite)group1, SUBJECT, "Subject:  ", subject, 1, 1, 1, 1, 80, this);
        this.m_message_field = this.m_gui.addInputFieldMultiLineWrap((Composite)group1, MESSAGE, null, message, 2, 1, 150, 80, 1, 1, this);
        Group group2 = new Group(parent, 32);
        group2.setText("Server Information");
        group2.setFont(BMUI.font_arial7_bold);
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 3;
        group2.setLayout((Layout)gl);
        gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 10;
        group2.setLayoutData((Object)gd);
        this.m_mail_smtp_host_field = this.m_gui.addInputFieldSingle((Composite)group2, MAIL_SMTP_HOST, "Outgoing Host (SMTP):  ", smtp_host, 2, 1, 1, 1, 80, this);
        this.m_mail_smtp_port_field = this.m_gui.addInputFieldSingle((Composite)group2, MAIL_SMTP_PORT, "Port:  ", smtp_port, 1, 1, 1, 1, 30, this);
        this.m_mail_smtp_port_field.setToolTipText("Default SMTP Port=25");
        ((GridData)this.m_mail_smtp_port_field.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_mail_smtp_port_field.getLayoutData()).grabExcessHorizontalSpace = false;
        this.m_gui.addTextField((Composite)group2, null, "(default=25)", 1, 1, 0, 3, BMUI.font_arial7);
        this.m_startTLS_btn = this.m_gui.addCheckbox((Composite)group2, STARTTLS_BTN_NAME, STARTTLS_BTN_NAME, true, 3, 1, 3, this);
        this.m_startTLS_btn.setSelection(startTLS);
        this.m_mail_auth_chk = this.m_gui.addCheckbox((Composite)group2, MAIL_SMTP_AUTH, "SMTP Authentication:", use_auth, 3, 1, 3, this);
        this.m_mail_smtp_user_field = this.m_gui.addInputFieldSingle((Composite)group2, MAIL_SMTP_USER, "User:", smtp_user, 2, 1, 20, 1, 80, this);
        this.m_mail_smtp_pwd_field = this.m_gui.addInputFieldSingle((Composite)group2, MAIL_SMTP_PWD, "Password:  ", smtp_pwd, 2, 1, 20, 1, 80, this);
        this.m_mail_smtp_pwd_field.setEchoChar('*');
        this.enable_SMTPAuthentication(use_auth);
    }

    public void createSMSDetails(Composite parent, NovelConfig cfgItm) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginTop = 8;
        gl.marginWidth = 8;
        parent.setLayout((Layout)gl);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Properties default_props = NovelUtils.getDefaultProperties();
        NovelConfig nc = new NovelConfig(default_props, NovelConfig.NovelCgfType.SMS, "temp");
        String header = "SMS";
        String name = "";
        String desc = "";
        String expire_interval = "" + nc.getExpireIntervalSeconds();
        String retry_interval = "" + nc.getRetryIntervalSeconds();
        String expired_files_size = "" + nc.getMaxExpiredFileSize();
        String queue_size = "" + nc.getMaxQueueSize();
        String sms_from = "";
        String sms_to = "";
        String message = "";
        if (cfgItm != null) {
            name = cfgItm.getId();
            desc = cfgItm.getDescription();
            expire_interval = "" + cfgItm.getExpireIntervalSeconds();
            retry_interval = "" + cfgItm.getRetryIntervalSeconds();
            expired_files_size = "" + cfgItm.getMaxExpiredFileSize();
            queue_size = "" + cfgItm.getMaxQueueSize();
            sms_from = cfgItm.getFrom();
            sms_to = cfgItm.getTo();
            message = cfgItm.getMessage();
        }
        this.m_detailTab.setText(name);
        this.m_gui.addTextReadOnlyNoBorder(parent, null, header, 1, 1, 0, 0, BMUI.font_arial8_bold);
        Group group0 = new Group(parent, 32);
        group0.setText("Config Information");
        group0.setFont(BMUI.font_arial7_bold);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 3;
        group0.setLayout((Layout)gl);
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 10;
        group0.setLayoutData((Object)gd);
        this.m_name_field = this.isNew() || this.m_tableProvider.getCfgItemByID(name) == null ? this.m_gui.addInputFieldSingle((Composite)group0, NAME, "Name: ", name, 1, 1, 1, 0, 80, this) : this.m_gui.addTextReadOnlyNoBorder((Composite)group0, "Name: ", name, 1, 1, 0, 0, BMUI.font_arial8);
        this.m_desc_field = this.m_gui.addInputFieldSingle((Composite)group0, DESCRIPTION, "Description: ", desc, 1, 1, 1, 0, 80, this);
        this.m_expire_interval_field = this.m_gui.addInputFieldSingle((Composite)group0, EXPIRE_INTERVAL, EXPIRE_INTERVAL_LABEL, expire_interval, 1, 1, 1, 0, 80, this);
        this.m_retry_interval_field = this.m_gui.addInputFieldSingle((Composite)group0, RETRY_INTERVAL, RETRY_INTERVAL_LABEL, retry_interval, 1, 1, 1, 0, 80, this);
        this.m_expire_fileSize_field = this.m_gui.addInputFieldSingle((Composite)group0, EXPIRED_FILE_SIZE, EXPIRED_FILE_SIZE_LABEL, expired_files_size, 1, 1, 1, 0, 80, this);
        this.m_queue_size_field = this.m_gui.addInputFieldSingle((Composite)group0, QUEUE_SIZE, QUEUE_SIZE_LABEL, queue_size, 1, 1, 1, 0, 80, this);
        Group group1 = new Group(parent, 32);
        group1.setText("Message Information");
        group1.setFont(BMUI.font_arial7_bold);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 3;
        group1.setLayout((Layout)gl);
        gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 10;
        group1.setLayoutData((Object)gd);
        this.m_from_field = this.m_gui.addInputFieldSingle((Composite)group1, FROM, "From:  ", sms_from, 1, 1, 1, 1, 180, this);
        this.isValidSMSNumber(sms_from);
        this.m_to_field = this.m_gui.addInputFieldSingle((Composite)group1, TO, "To:  ", sms_to, 1, 1, 1, 1, 180, this);
        if (!this.isValidSMSNumber(sms_to)) {
            this.m_to_field.setBackground(BMUI.color_critical);
        }
        this.m_message_field = this.m_gui.addInputFieldMultiLineWrap((Composite)group1, MESSAGE, null, message, 2, 1, 150, 80, 1, 1, this);
    }

    public void createExecDetails(Composite parent, NovelConfig cfgItm) {
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginTop = 8;
        gl.marginWidth = 8;
        parent.setLayout((Layout)gl);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Properties default_props = NovelUtils.getDefaultProperties();
        NovelConfig nc = new NovelConfig(default_props, NovelConfig.NovelCgfType.MAIL, "temp");
        String header = "EXEC";
        String name = "";
        String desc = "";
        String call = "";
        String expire_interval = "" + nc.getExpireIntervalSeconds();
        String retry_interval = "" + nc.getRetryIntervalSeconds();
        String expired_files_size = "" + nc.getMaxExpiredFileSize();
        String queue_size = "" + nc.getMaxQueueSize();
        String replaceStr = NovelConfig.DEFAULT_EXEC_NEWLINE_REPLACE_STRING;
        if (cfgItm != null) {
            name = cfgItm.getId();
            desc = cfgItm.getDescription();
            call = cfgItm.getMessage();
            replaceStr = cfgItm.getNewlineReplaceStr();
            if (call == null) {
                call = "";
            }
            expire_interval = "" + cfgItm.getExpireIntervalSeconds();
            retry_interval = "" + cfgItm.getRetryIntervalSeconds();
            expired_files_size = "" + cfgItm.getMaxExpiredFileSize();
            queue_size = "" + cfgItm.getMaxQueueSize();
        }
        this.m_detailTab.setText(name);
        this.m_gui.addTextReadOnlyNoBorder(parent, null, header, 1, 1, 0, 0, BMUI.font_arial8_bold);
        Group group0 = new Group(parent, 32);
        group0.setText("Config Information");
        group0.setFont(BMUI.font_arial7_bold);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 3;
        group0.setLayout((Layout)gl);
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 10;
        group0.setLayoutData((Object)gd);
        this.m_name_field = this.isNew() || this.m_tableProvider.getCfgItemByID(name) == null ? this.m_gui.addInputFieldSingle((Composite)group0, NAME, "Name: ", name, 1, 1, 1, 0, 80, this) : this.m_gui.addTextReadOnlyNoBorder((Composite)group0, "Name: ", name, 1, 1, 0, 0, BMUI.font_arial8);
        this.m_desc_field = this.m_gui.addInputFieldSingle((Composite)group0, DESCRIPTION, "Description: ", desc, 1, 1, 1, 0, 80, this);
        this.m_expire_interval_field = this.m_gui.addInputFieldSingle((Composite)group0, EXPIRE_INTERVAL, EXPIRE_INTERVAL_LABEL, expire_interval, 1, 1, 1, 0, 80, this);
        this.m_retry_interval_field = this.m_gui.addInputFieldSingle((Composite)group0, RETRY_INTERVAL, RETRY_INTERVAL_LABEL, retry_interval, 1, 1, 1, 0, 80, this);
        this.m_expire_fileSize_field = this.m_gui.addInputFieldSingle((Composite)group0, EXPIRED_FILE_SIZE, EXPIRED_FILE_SIZE_LABEL, expired_files_size, 1, 1, 1, 0, 80, this);
        this.m_queue_size_field = this.m_gui.addInputFieldSingle((Composite)group0, QUEUE_SIZE, QUEUE_SIZE_LABEL, queue_size, 1, 1, 1, 0, 80, this);
        Group group1 = new Group(parent, 32);
        group1.setText("Exec Call Information");
        group1.setFont(BMUI.font_arial7_bold);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 3;
        group1.setLayout((Layout)gl);
        gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 10;
        group1.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group1, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.m_exec_call_field = this.m_gui.addInputFieldMultiLineWrap((Composite)group1, EXEC_CALL, "Exec Call:  ", call, 2, 1, 200, 80, 1, 1, this);
        this.createContentAssist((Control)this.m_exec_call_field, Proposals.NOTIFICATIONS);
        if (call == null || call.equals("")) {
            this.m_exec_call_field.setBackground(BMUI.color_critical);
        }
        this.m_newLineReplaceStr_field = this.m_gui.addInputFieldSingle((Composite)group1, NEWLINE_REPLACE_STR, "Replace Newline Chars with:   ", replaceStr, 1, 1, 1, 0, 80, this);
    }

    public void createButtons(Composite parent, String type) {
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        Composite btn_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginTop = 15;
        btn_comp.setLayout((Layout)gl);
        btn_comp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_save_btn = this.m_gui.addButton(btn_comp, SAVE_BTN, " Save ", false, 120, 10, 0, 0, this);
        ((GridData)this.m_save_btn.getLayoutData()).verticalAlignment = 1024;
        ((GridData)this.m_save_btn.getLayoutData()).grabExcessVerticalSpace = true;
        this.m_save_btn.setImage(sharedImages.getImage("IMG_ETOOL_SAVE_EDIT"));
        if (this.isNew()) {
            this.m_cancel_btn = this.m_gui.addButton(btn_comp, CANCEL_BTN, " Cancel ", true, 120, 10, 0, 0, this);
            ((GridData)this.m_cancel_btn.getLayoutData()).verticalAlignment = 1024;
            ((GridData)this.m_cancel_btn.getLayoutData()).grabExcessVerticalSpace = false;
            this.m_cancel_btn.setImage(sharedImages.getImage("IMG_ETOOL_CLEAR"));
        } else {
            this.m_undo_btn = this.m_gui.addButton(btn_comp, UNDO_BTN, " Undo Changes ", false, 120, 10, 0, 0, this);
            ((GridData)this.m_undo_btn.getLayoutData()).verticalAlignment = 1024;
            ((GridData)this.m_undo_btn.getLayoutData()).grabExcessVerticalSpace = true;
            this.m_undo_btn.setImage(sharedImages.getImage("IMG_TOOL_UNDO"));
            this.m_test_btn = this.m_gui.addButton(btn_comp, TEST_BTN, " Send Test " + type + " ", true, 120, 10, 0, 0, this);
            ((GridData)this.m_test_btn.getLayoutData()).verticalAlignment = 1024;
            ((GridData)this.m_test_btn.getLayoutData()).grabExcessVerticalSpace = false;
        }
    }

    public void enable_SMTPAuthentication(boolean enable) {
        if (enable) {
            this.m_gui.enableField(this.m_mail_smtp_user_field, true);
            this.m_gui.enableField(this.m_mail_smtp_pwd_field, true);
        } else {
            this.m_gui.enableField(this.m_mail_smtp_user_field, false);
            this.m_gui.enableField(this.m_mail_smtp_pwd_field, false);
        }
    }

    public void clearDetailArea() {
        if (this.m_comp_in_sc != null && !this.m_comp_in_sc.isDisposed()) {
            Control[] controls = this.m_comp_in_sc.getChildren();
            int i = 0;
            while (i < controls.length) {
                Control child = controls[i];
                child.dispose();
                ++i;
            }
        }
        m_notificationTab.removeTableSelection();
        this.m_isDirty = false;
        this.setNew(false);
    }

    private List<NovelConfig> getTableSelection() {
        ArrayList<NovelConfig> cfgItemList = new ArrayList<NovelConfig>();
        TableItem[] tableItems = this.m_table.getSelection();
        int i = 0;
        while (i < tableItems.length) {
            TableItem ti = tableItems[i];
            if (ti != null) {
                NovelConfig cfgItem = (NovelConfig)ti.getData();
                cfgItemList.add(cfgItem);
            }
            ++i;
        }
        return cfgItemList;
    }

    private void removeTableSelection() {
        this.m_table.deselectAll();
        this.checkTableButtons();
    }

    private void setReadOnly() {
        this.m_gui.enableField(this.m_add_btn, false);
        this.m_gui.enableField(this.m_cancel_btn, false);
        this.m_gui.enableField(this.m_del_btn, false);
        this.m_gui.enableField(this.m_undo_btn, false);
        this.m_gui.enableField(this.m_desc_field, false);
        this.m_gui.enableField(this.m_dup_btn, false);
        this.m_gui.enableField(this.m_expire_fileSize_field, false);
        this.m_gui.enableField(this.m_expire_interval_field, false);
        this.m_gui.enableField(this.m_from_field, false);
        this.m_gui.enableField(this.m_to_field, false);
        this.m_gui.enableField(this.m_test_btn, false);
        this.m_gui.enableField(this.m_mail_auth_chk, false);
        this.m_gui.enableField(this.m_mail_smtp_host_field, false);
        this.m_gui.enableField(this.m_mail_smtp_port_field, false);
        this.m_gui.enableField(this.m_mail_smtp_pwd_field, false);
        this.m_gui.enableField(this.m_mail_smtp_user_field, false);
        this.m_gui.enableField(this.m_message_field, false);
        this.m_gui.enableField(this.m_name_field, false);
        this.m_gui.enableField(this.m_queue_size_field, false);
        this.m_gui.enableField(this.m_retry_interval_field, false);
        this.m_gui.enableField(this.m_start_btn, false);
        this.m_gui.enableField(this.m_stop_btn, false);
        this.m_gui.enableField(this.m_mail_subject_field, false);
        this.m_gui.enableField(this.m_startTLS_btn, false);
        this.m_gui.enableField(this.m_exec_call_field, false);
        this.m_gui.enableField(this.m_newLineReplaceStr_field, false);
    }

    public void reloadTable() {
        try {
            if (m_notificationTab != null && !m_notificationTab.isDisposed() && m_notificationTab.isShowing()) {
                Table table = m_notificationTab.getTableViewer().getTable();
                int[] selection = table.getSelectionIndices();
                RefreshTableAction refresh = new RefreshTableAction(m_notificationTab);
                refresh.run();
                table.select(selection);
            }
        }
        catch (Throwable throwable) {}
        if (Repository.getInstance().getRights(2014) < 3) {
            this.setReadOnly();
        }
    }

    public boolean doesConfigItemExist(String name) {
        boolean doesExist = false;
        NovelConfig cfgItem = this.m_tableProvider.getCfgItemByID(name);
        if (cfgItem != null) {
            doesExist = true;
        }
        return doesExist;
    }

    public void test() {
        NovelConfig.NovelCgfType type = this.getCurrentConfigType();
        if (type == null) {
            return;
        }
        String rcp = null;
        NovelConfig testConfig = new NovelConfig();
        testConfig.setId(this.m_current_ConfigItem.getId());
        if (type.getText().equals(NovelConfig.NovelCgfType.MAIL.getText())) {
            testConfig.setType(NovelConfig.NovelCgfType.MAIL);
            this.updateEmail_CfgItem(testConfig);
            rcp = this.m_to_field.getText().trim();
        } else if (type.getText().equals(NovelConfig.NovelCgfType.SMS.getText())) {
            testConfig.setType(NovelConfig.NovelCgfType.SMS);
            this.updateSMS_CfgItem(testConfig);
            rcp = this.m_to_field.getText().trim();
        } else if (type.getText().equals(NovelConfig.NovelCgfType.EXEC.getText())) {
            testConfig.setType(NovelConfig.NovelCgfType.EXEC);
            this.updateExec_CfgItem(testConfig);
        }
        ServerCfgMgr.getInstance().testNotifierConfig(testConfig, rcp);
    }

    public void undo() {
        this.createDetailArea(this.getCurrentConfigType().getText(), this.m_current_ConfigItem);
        this.setDirty(false);
    }

    public boolean save() {
        boolean doReloadDetailArea = this.isNew();
        NovelConfig.NovelCgfType type = this.getCurrentConfigType();
        if (type == null) {
            return false;
        }
        if (this.isNew()) {
            String id = this.m_name_field.getText().trim();
            this.m_current_ConfigItem = new NovelConfig(NovelUtils.getDefaultProperties(), type, id);
        }
        if (type.getText().equals(NovelConfig.NovelCgfType.MAIL.getText())) {
            this.updateEmail_CfgItem(this.getCurrentConfigItem());
        } else if (type.getText().equals(NovelConfig.NovelCgfType.SMS.getText())) {
            this.updateSMS_CfgItem(this.getCurrentConfigItem());
        } else if (type.getText().equals(NovelConfig.NovelCgfType.EXEC.getText())) {
            this.updateExec_CfgItem(this.getCurrentConfigItem());
        }
        boolean success = ServerCfgMgr.getInstance().saveNotifierConfig(this.m_current_ConfigItem);
        if (success) {
            this.setNew(false);
            this.setDirty(false);
        } else {
            doReloadDetailArea = false;
            new ShowMessageBox("Error", "Cannot save Configuration to the server!", 1);
        }
        return doReloadDetailArea;
    }

    public void updateEmail_CfgItem(NovelConfig config) {
        config.setDescription(this.m_desc_field.getText().trim());
        try {
            long expireInterval = Long.parseLong(this.m_expire_interval_field.getText().trim());
            config.setExpireIntervalSeconds(expireInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            long retryInterval = Long.parseLong(this.m_retry_interval_field.getText().trim());
            config.setRetryIntervalSeconds(retryInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            int queueSize = Integer.parseInt(this.m_queue_size_field.getText().trim());
            config.setMaxQueueSize(queueSize);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            long expireFileSize = Long.parseLong(this.m_expire_fileSize_field.getText().trim());
            config.setMaxExpiredFileSize(expireFileSize);
        }
        catch (NumberFormatException numberFormatException) {}
        config.setFrom(this.m_from_field.getText().trim());
        config.setTo(this.m_to_field.getText().trim());
        config.setSubject(this.m_mail_subject_field.getText().trim());
        config.setMessage(this.m_message_field.getText().trim());
        config.getProperties().setProperty("mail.smtp.host", this.m_mail_smtp_host_field.getText().trim());
        config.getProperties().setProperty("mail.smtp.port", this.m_mail_smtp_port_field.getText().trim());
        boolean needSMTPAuth = this.m_mail_auth_chk.getSelection();
        String smtpUser = "";
        String smtpPassword = "";
        if (needSMTPAuth) {
            smtpUser = this.m_mail_smtp_user_field.getText().trim();
            smtpPassword = this.m_mail_smtp_pwd_field.getText().trim();
        }
        if (this.m_startTLS_btn.getSelection()) {
            config.getProperties().setProperty(MAIL_SMTP_STARTTLS_ENABLE, "true");
        } else {
            config.getProperties().setProperty(MAIL_SMTP_STARTTLS_ENABLE, "false");
        }
        config.getProperties().setProperty("mail.smtp.auth", "" + needSMTPAuth);
        config.getProperties().setProperty("mail.smtp.user", smtpUser);
        config.getProperties().setProperty("mail.smtp.password", smtpPassword);
    }

    public void updateSMS_CfgItem(NovelConfig config) {
        config.setDescription(this.m_desc_field.getText().trim());
        try {
            long expireInterval = Long.parseLong(this.m_expire_interval_field.getText().trim());
            config.setExpireIntervalSeconds(expireInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            long retryInterval = Long.parseLong(this.m_retry_interval_field.getText().trim());
            config.setRetryIntervalSeconds(retryInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            int queueSize = Integer.parseInt(this.m_queue_size_field.getText().trim());
            config.setMaxQueueSize(queueSize);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            long expireFileSize = Long.parseLong(this.m_expire_fileSize_field.getText().trim());
            config.setMaxExpiredFileSize(expireFileSize);
        }
        catch (NumberFormatException numberFormatException) {}
        config.setFrom(this.m_from_field.getText().trim());
        config.setTo(this.m_to_field.getText().trim());
        config.setMessage(this.m_message_field.getText().trim());
    }

    public void updateExec_CfgItem(NovelConfig config) {
        long retryInterval;
        long expireInterval;
        config.setDescription(this.m_desc_field.getText().trim());
        try {
            expireInterval = Long.parseLong(this.m_expire_interval_field.getText().trim());
            config.setExpireIntervalSeconds(expireInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            retryInterval = Long.parseLong(this.m_retry_interval_field.getText().trim());
            config.setRetryIntervalSeconds(retryInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            long expireFileSize = Long.parseLong(this.m_expire_fileSize_field.getText().trim());
            config.setMaxExpiredFileSize(expireFileSize);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            expireInterval = Long.parseLong(this.m_expire_interval_field.getText().trim());
            config.setExpireIntervalSeconds(expireInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            retryInterval = Long.parseLong(this.m_retry_interval_field.getText().trim());
            config.setRetryIntervalSeconds(retryInterval);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            int queueSize = Integer.parseInt(this.m_queue_size_field.getText().trim());
            config.setMaxQueueSize(queueSize);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            long expireFileSize = Long.parseLong(this.m_expire_fileSize_field.getText().trim());
            config.setMaxExpiredFileSize(expireFileSize);
        }
        catch (NumberFormatException numberFormatException) {}
        config.setMessage(this.m_exec_call_field.getText().trim());
        config.setNewlineReplaceStr(this.m_newLineReplaceStr_field.getText());
    }

    public void setTableSelection(int index) {
        TableItem ti;
        if (index < this.m_table.getItemCount() && (ti = this.m_table.getItem(index)) != null) {
            String id = ti.getText(1);
            NovelConfig cfgItem = this.m_tableProvider.getCfgItemByID(id);
            this.createDetailArea(cfgItem.getType().getText(), cfgItem);
            this.m_table.setSelection(index);
            this.m_table.select(index);
            return;
        }
        this.clearDetailArea();
    }

    public void setTableSelection(NovelConfig cfgItem) {
        TableItem[] items = this.m_table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem ti = items[i];
            NovelConfig conf = (NovelConfig)ti.getData();
            if (conf != null && conf.equals(cfgItem)) {
                this.createDetailArea(cfgItem.getType().getText(), cfgItem);
                this.m_table.setSelection(i);
                this.m_table.select(i);
                return;
            }
            ++i;
        }
    }

    public NotificationConfigTableProvider getTableProvider() {
        return this.m_tableProvider;
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public NovelConfig getCurrentConfigItem() {
        if (this.m_current_ConfigItem != null && this.m_current_ConfigItem.getNotifierStatus() != null) {
            this.m_current_ConfigItem.setStartFlag(this.m_current_ConfigItem.getNotifierStatus().isStarted());
        }
        return this.m_current_ConfigItem;
    }

    public NovelConfig.NovelCgfType getCurrentConfigType() {
        if (this.m_current_ConfigItem != null) {
            return this.m_current_ConfigItem.getType();
        }
        return null;
    }

    public boolean isValidMAILAddress(String email) {
        return email != null && !email.trim().equals("");
    }

    public boolean isValidSMSNumber(String value) {
        return value.length() > 0 & InputValidator.validateInteger_MIN(value, 0);
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setDirty(boolean dirty) {
        this.m_isDirty = dirty;
        boolean readyToSave = this.readyToSave();
        try {
            this.m_gui.enableField(this.m_save_btn, this.m_isDirty && readyToSave);
            if (this.isNew()) {
                this.m_gui.enableField(this.m_undo_btn, false);
            } else {
                this.m_gui.enableField(this.m_undo_btn, this.m_isDirty);
            }
            this.m_gui.enableField(this.m_test_btn, !this.isNew() && readyToSave);
            if (this.m_detailTab != null && !this.m_detailTab.isDisposed()) {
                if (this.m_detailTab.getText() != null && !this.m_detailTab.getText().startsWith("*") && this.m_isDirty) {
                    this.m_detailTab.setText("* " + this.m_detailTab.getText());
                } else if (this.m_detailTab.getText().startsWith("*") && !this.m_isDirty && this.m_current_ConfigItem != null) {
                    this.m_detailTab.setText(this.m_current_ConfigItem.getId());
                }
            }
        }
        catch (Exception exception) {}
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    public void setNew(boolean isNew) {
        this.m_isNew = isNew;
    }

    public boolean readyToSave() {
        if (this.m_current_ConfigItem == null) {
            return true;
        }
        if (this.m_name_field.isDisposed()) {
            return false;
        }
        String name = this.m_name_field.getText().trim();
        NameValidatorFile pnv = new NameValidatorFile();
        if (this.isNew() && (this.doesConfigItemExist(name) || pnv.isValid(name) != null)) {
            return false;
        }
        String type = this.getCurrentConfigType().getText();
        if (type.equals(NovelConfig.NovelCgfType.MAIL.getText())) {
            if (this.m_to_field.isDisposed() || !this.isValidMAILAddress(this.m_to_field.getText().trim())) {
                return false;
            }
            try {
                Integer.parseInt(this.m_mail_smtp_port_field.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        } else if (type.equals(NovelConfig.NovelCgfType.SMS.getText()) ? this.m_to_field.isDisposed() || !this.isValidSMSNumber(this.m_to_field.getText().trim()) : type.equals(NovelConfig.NovelCgfType.EXEC.getText()) && (this.m_exec_call_field.isDisposed() || "".equals(this.m_exec_call_field.getText().trim()))) {
            return false;
        }
        return true;
    }

    public void checkTableButtons() {
        if (Repository.getInstance().getRights(2014) < 3) {
            this.setReadOnly();
        } else if (this.m_tableViewer != null) {
            StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
            if (ssel.isEmpty()) {
                this.m_gui.enableField(this.m_refresh_btn, true);
                this.m_gui.enableField(this.m_dup_btn, false);
                this.m_gui.enableField(this.m_del_btn, false);
                this.m_gui.enableField(this.m_start_btn, false);
                this.m_gui.enableField(this.m_stop_btn, false);
            } else if (ssel.size() == 1) {
                NovelConfig nc = (NovelConfig)ssel.getFirstElement();
                this.m_gui.enableField(this.m_refresh_btn, true);
                this.m_gui.enableField(this.m_dup_btn, true);
                this.m_gui.enableField(this.m_del_btn, true);
                this.m_gui.enableField(this.m_start_btn, !nc.getNotifierStatus().isStarted());
                this.m_gui.enableField(this.m_stop_btn, nc.getNotifierStatus().isStarted());
            } else if (ssel.size() > 1) {
                this.m_gui.enableField(this.m_refresh_btn, true);
                this.m_gui.enableField(this.m_dup_btn, false);
                this.m_gui.enableField(this.m_del_btn, false);
                this.m_gui.enableField(this.m_start_btn, false);
                this.m_gui.enableField(this.m_stop_btn, false);
            }
            if (this.isDirty()) {
                this.m_gui.enableField(this.m_dup_btn, false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        Object obj = e.getSource();
        if (!(obj instanceof Table)) {
            if (obj instanceof Button) {
                Button btn = (Button)e.getSource();
                name = (String)btn.getData();
                if (name.equals(MAIL_SMTP_AUTH)) {
                    this.enable_SMTPAuthentication(btn.getSelection());
                    this.setDirty(true);
                } else if (name.equals(STARTTLS_BTN_NAME)) {
                    this.setDirty(true);
                } else if (name.equals(REFRESH_BTN)) {
                    this.reloadTable();
                } else if (name.equals(ADD_BTN)) {
                    if (this.isDirty()) {
                        new ShowMessageBox("Add Notification", "The Notification '" + this.m_name_field.getText() + "' has not yet been saved. \nPlease save or cancel this Notification before creating a new one!", 32);
                    } else {
                        AddDialog dialog = new AddDialog(this.m_compTable.getShell());
                        dialog.setBlockOnOpen(true);
                        int res = dialog.open();
                        if (res == 0) {
                            String type = dialog.getNovelCgfType();
                            if (type.equals(NovelConfig.NovelCgfType.MAIL.getText())) {
                                AddNewConfigItemAction add = new AddNewConfigItemAction(NovelConfig.NovelCgfType.MAIL, m_notificationTab);
                                add.run();
                            } else if (type.equals(NovelConfig.NovelCgfType.EXEC.getText())) {
                                AddNewConfigItemAction add = new AddNewConfigItemAction(NovelConfig.NovelCgfType.EXEC, m_notificationTab);
                                add.run();
                            }
                        }
                    }
                } else if (name.equals(DUPLICATE_BTN)) {
                    DuplicateConfigAction dup_action = new DuplicateConfigAction((StructuredSelection)this.m_tableViewer.getSelection(), m_notificationTab);
                    if (dup_action.isEnabled()) {
                        dup_action.run();
                    }
                } else if (name.equals(DEL_BTN)) {
                    DeleteConfigItemAction del_action = new DeleteConfigItemAction((StructuredSelection)this.m_tableViewer.getSelection(), m_notificationTab);
                    if (del_action.isEnabled()) {
                        del_action.run();
                    }
                } else if (name.equals(START_BTN)) {
                    StartAction start_action = new StartAction((StructuredSelection)this.m_tableViewer.getSelection(), m_notificationTab);
                    if (start_action.isEnabled()) {
                        start_action.run();
                    }
                } else if (name.equals(STOP_BTN)) {
                    StopAction stop_action = new StopAction((StructuredSelection)this.m_tableViewer.getSelection(), m_notificationTab);
                    if (stop_action.isEnabled()) {
                        stop_action.run();
                    }
                } else if (name.equals(SAVE_BTN)) {
                    SaveAction save = new SaveAction(m_notificationTab);
                    save.run();
                } else if (name.equals(UNDO_BTN)) {
                    UndoAction undo = new UndoAction(m_notificationTab);
                    undo.run();
                } else if (name.equals(TEST_BTN)) {
                    this.test();
                } else if (name.equals(CANCEL_BTN)) {
                    this.clearDetailArea();
                }
                this.checkTableButtons();
            } else if (obj instanceof Table) {
                this.checkTableButtons();
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TableViewer tv;
        String data;
        Object obj = event.getSource();
        if (obj instanceof TableViewer && (data = (String)(tv = (TableViewer)obj).getData(VIEWER_TYPE)) != null && data.equals(CONFIG_TABLE)) {
            List<NovelConfig> list = this.getTableSelection();
            if (list.size() == 0) {
                this.setNew(false);
                this.createDetailArea(null, null);
                this.removeTableSelection();
            } else {
                NovelConfig cfgItem = list.get(0);
                if (this.m_current_ConfigItem != null && this.m_current_ConfigItem.equals(cfgItem) && !this.m_mainComp.isDisposed()) {
                    this.checkTableButtons();
                    return;
                }
                if (this.isDirty()) {
                    if (this.readyToSave()) {
                        ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "Save", "Save changes?", "YES", "NO");
                        int res = dialog.open();
                        if (res == 0) {
                            this.save();
                        } else {
                            this.setDirty(false);
                            this.setNew(false);
                        }
                    } else {
                        new ShowMessageBox("Error", "Invalid values! Cannot save configuration", 1);
                        return;
                    }
                }
                this.createDetailArea(cfgItem.getType().getText(), cfgItem);
            }
            this.checkTableButtons();
        }
    }

    public void modifyText(ModifyEvent e) {
        String fieldName = "";
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)e.getSource();
            fieldName = (String)field.getData();
            String value = field.getText().trim();
            NovelConfig.NovelCgfType type = this.getCurrentConfigType();
            if (fieldName.equals(NAME)) {
                this.m_detailTab.setText(value);
                NameValidatorFile pnv = new NameValidatorFile();
                if (this.doesConfigItemExist(value) || pnv.isValid(value) != null) {
                    field.setBackground(BMUI.color_critical);
                } else {
                    field.setBackground(this.m_defaultColor);
                }
            } else if (!fieldName.equals(DESCRIPTION)) {
                if (fieldName.equals(EXPIRE_INTERVAL)) {
                    if (value.length() == 0 || InputValidator.validateLong_MIN(value, 1L)) {
                        field.setBackground(this.m_defaultColor);
                        field.setToolTipText(null);
                    } else {
                        field.setBackground(BMUI.color_critical);
                        field.setToolTipText("Please insert a valid Number!");
                    }
                } else if (fieldName.equals(RETRY_INTERVAL)) {
                    if (value.length() == 0 || InputValidator.validateLong_MIN(value, 1L)) {
                        field.setBackground(this.m_defaultColor);
                        field.setToolTipText(null);
                    } else {
                        field.setBackground(BMUI.color_critical);
                        field.setToolTipText("Please insert a valid Number!");
                    }
                } else if (fieldName.equals(EXPIRED_FILE_SIZE)) {
                    if (value.length() == 0 || InputValidator.validateLong_MIN(value, 1L)) {
                        field.setBackground(this.m_defaultColor);
                        field.setToolTipText(null);
                    } else {
                        field.setBackground(BMUI.color_critical);
                        field.setToolTipText("Please insert a valid Number!");
                    }
                } else if (fieldName.equals(QUEUE_SIZE)) {
                    if (value.length() == 0) {
                        field.setBackground(this.m_defaultColor);
                    } else if (InputValidator.validateInteger_MIN(value, 1)) {
                        field.setBackground(this.m_defaultColor);
                    } else {
                        field.setBackground(BMUI.color_critical);
                    }
                } else if (fieldName.equals(FROM) || fieldName.equals(TO)) {
                    if (type.equals((Object)NovelConfig.NovelCgfType.MAIL)) {
                        if (!this.isValidMAILAddress(value)) {
                            field.setBackground(BMUI.color_critical);
                            field.setToolTipText("Please insert valid email address!");
                        } else {
                            field.setBackground(this.m_defaultColor);
                            field.setToolTipText(null);
                        }
                    } else if (type.equals((Object)NovelConfig.NovelCgfType.SMS)) {
                        if (!this.isValidSMSNumber(value)) {
                            field.setBackground(BMUI.color_critical);
                            field.setToolTipText("Please insert valid phone number!");
                        } else {
                            field.setBackground(this.m_defaultColor);
                            field.setToolTipText(null);
                        }
                    }
                } else if (!(fieldName.equals(SUBJECT) || fieldName.equals(MESSAGE) || fieldName.equals(MAIL_SMTP_HOST))) {
                    if (fieldName.equals(MAIL_SMTP_PORT)) {
                        if (InputValidator.validateInteger_MIN(value, 0)) {
                            field.setBackground(this.m_defaultColor);
                            field.setToolTipText(null);
                        } else {
                            field.setBackground(BMUI.color_critical);
                            field.setToolTipText("Please insert a valid Port Number");
                        }
                    } else if (!fieldName.equals(MAIL_SMTP_USER) && !fieldName.equals(MAIL_SMTP_PWD) && fieldName.equals(EXEC_CALL)) {
                        if (value.equals("")) {
                            field.setBackground(BMUI.color_critical);
                            field.setToolTipText("Please insert a valid exec call!");
                        } else {
                            field.setBackground(this.m_defaultColor);
                            field.setToolTipText(null);
                        }
                    }
                }
            }
            this.setDirty(true);
            this.checkTableButtons();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public SimpleContentProposalProvider createContentAssist(Control ct, String[] proposals) {
        char[] autoActivationCharacters = new char[]{};
        SimpleContentProposalProvider defaultProposalProvider = null;
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            defaultProposalProvider = new SimpleContentProposalProvider(proposals);
            new ContentProposalAdapter(ct, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)defaultProposalProvider, keyStroke, autoActivationCharacters);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return defaultProposalProvider;
    }

    public void handleEvent(Event event) {
    }

    private class AddDialog
    extends Dialog
    implements SelectionListener {
        private String m_selection;

        protected AddDialog(Shell parentShell) {
            super(parentShell);
            this.m_selection = NovelConfig.NovelCgfType.MAIL.getText();
        }

        protected Control createDialogArea(Composite parent) {
            GUIDisplayElements gui = new GUIDisplayElements();
            GridLayout gl = new GridLayout(1, false);
            gl.verticalSpacing = 20;
            gl.marginRight = 10;
            parent.setLayout((Layout)gl);
            parent.setLayoutData((Object)new GridData(16384, 4, false, false));
            Group grp = new Group(parent, 0);
            grp.setText("Select Type: ");
            gl = new GridLayout(1, false);
            gl.marginHeight = 10;
            grp.setLayout((Layout)gl);
            GridData gd = new GridData(4, 4, false, false);
            gd.verticalIndent = 10;
            gd.horizontalIndent = 10;
            grp.setLayoutData((Object)gd);
            Button mail_btn = gui.addRadioButton((Composite)grp, "", NovelConfig.NovelCgfType.MAIL.getText(), true, 1, 1, 15, 0, this);
            mail_btn.setImage(BMUI.IMAGE_EMAIL_16x16);
            Button exec_btn = gui.addRadioButton((Composite)grp, "", NovelConfig.NovelCgfType.EXEC.getText(), false, 1, 1, 15, 0, this);
            exec_btn.setImage(BMUI.IMAGE_EXEC_16x16);
            return grp;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(" Add Notification");
        }

        protected Control createButtonBar(Composite parent) {
            Composite comp = (Composite)super.createButtonBar(parent);
            ((GridLayout)comp.getLayout()).marginHeight = 0;
            ((GridLayout)comp.getLayout()).marginLeft = 10;
            ((GridLayout)comp.getLayout()).verticalSpacing = 0;
            ((GridLayout)comp.getLayout()).marginBottom = 10;
            return comp;
        }

        public String getNovelCgfType() {
            return this.m_selection;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b;
            if (e.getSource() instanceof Button && (b = (Button)e.getSource()).getSelection()) {
                this.m_selection = b.getText();
            }
        }
    }

    private class AddNewConfigItemAction
    extends Action {
        private NotificationConfigTab m_nTab;
        private NovelConfig.NovelCgfType m_type;

        public AddNewConfigItemAction(NovelConfig.NovelCgfType type, NotificationConfigTab tab) {
            super("addConfigItem");
            this.m_nTab = null;
            this.m_type = null;
            this.setId("addConfigItem");
            this.m_type = type;
            this.m_nTab = tab;
            this.setText(this.m_type.getText());
            if (this.m_type.equals((Object)NovelConfig.NovelCgfType.MAIL)) {
                this.setImageDescriptor(BMUI.IMAGE_DESCR_EMAIL_16x16);
                this.setDisabledImageDescriptor(BMUI.IMAGE_DESCR_EMAIL_16x16_DISABLED);
            } else if (this.m_type.equals((Object)NovelConfig.NovelCgfType.SMS)) {
                this.setImageDescriptor(BMUI.IMAGE_DESCR_SMS_16x16);
            } else if (this.m_type.equals((Object)NovelConfig.NovelCgfType.EXEC)) {
                this.setImageDescriptor(BMUI.IMAGE_DESCR_EXEC_16x16);
            }
            if (this.m_nTab.isDirty()) {
                this.setEnabled(false);
            }
            this.setEnabled(Repository.getInstance().getRights(2014) == 3);
        }

        public void run() {
            NovelConfig newConfigItem = new NovelConfig(NovelUtils.getDefaultProperties(), this.m_type, "NEW_" + System.currentTimeMillis());
            NotificationConfigTab.this.setNew(true);
            this.m_nTab.createDetailArea(this.m_type.getText(), newConfigItem);
            NotificationConfigTab.this.setDirty(true);
            this.m_nTab.removeTableSelection();
        }
    }

    private class DeleteConfigItemAction
    extends Action {
        private NotificationConfigTab m_nTab;
        private List<NovelConfig> m_elements;

        public DeleteConfigItemAction(StructuredSelection ssel, NotificationConfigTab tab) {
            super("deleteConfigItem");
            this.m_nTab = null;
            this.m_elements = null;
            this.setId("deleteConfigItem");
            this.setText("Delete");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            this.m_nTab = tab;
            this.m_elements = new ArrayList<NovelConfig>();
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            Iterator it = ssel.iterator();
            while (it.hasNext()) {
                this.m_elements.add((NovelConfig)it.next());
            }
            this.setEnabled(Repository.getInstance().getRights(2014) == 3);
        }

        public void run() {
            if (this.m_elements == null || this.m_elements.size() == 0) {
                return;
            }
            Repository.getInstance().fetchForwardPolicies(false);
            ArrayList<ForwardPolicy> fPolicies = FPolicyManager.getInstance().getAllForwardPolicies();
            Collections.sort(fPolicies);
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < this.m_elements.size()) {
                String notifiyID2delete = this.m_elements.get(i).getId();
                StringBuffer sb = new StringBuffer();
                for (ForwardPolicy fp : fPolicies) {
                    ForwardConditions fConditions = fp.getConditions();
                    ArrayList<ForwardCondition> fcs = fConditions.getConditionList();
                    for (ForwardCondition fc : fcs) {
                        String notifiID;
                        if (!fc.type.equals("NOTIFICATION") || !(notifiID = fc.to).equals(notifiyID2delete)) continue;
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append("   - ").append(fp.policyName);
                    }
                }
                if (sb.toString().length() > 0) {
                    if (text.length() > 0) {
                        text.append("\n\n");
                    }
                    text.append(notifiyID2delete).append(":\n").append(sb.toString());
                }
                ++i;
            }
            if (text.toString().length() == 0) {
                this.m_nTab.getTableProvider().deleteCfgItems(this.m_elements);
                this.m_nTab.reloadTable();
                this.m_nTab.setTableSelection(0);
            } else {
                ShowMessageDialog md = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Delete Notification Service", "Not able to delete the selected Notification Service! \nThe Service is in used by the following Server Filter: ", text.toString(), null, false, "OK");
                md.setIconInHeader(BMUI.IMAGE_ERROR);
                md.setHight(300);
                md.setBlockOnOpen(true);
                md.open();
            }
        }
    }

    private class DuplicateConfigAction
    extends Action {
        private NotificationConfigTab m_nTab;
        private NovelConfig m_selectedItem;

        public DuplicateConfigAction(StructuredSelection ssel, NotificationConfigTab tab) {
            super("duplicateconfig");
            this.m_nTab = null;
            this.m_selectedItem = null;
            this.setId("duplicateconfig");
            this.setText("Duplicate");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            this.m_nTab = tab;
            if (ssel == null || ssel.size() != 1 || this.m_nTab.isDirty()) {
                this.setEnabled(false);
                return;
            }
            this.m_selectedItem = (NovelConfig)ssel.getFirstElement();
            this.setEnabled(Repository.getInstance().getRights(2014) == 3);
        }

        public void run() {
            if (this.m_selectedItem == null) {
                return;
            }
            NovelConfig.NovelCgfType type = this.m_selectedItem.getType();
            String name = this.m_selectedItem.getId();
            Properties props = this.m_selectedItem.getProperties();
            Properties props_new = NovelUtils.getDefaultProperties();
            for (Map.Entry<Object, Object> set : props.entrySet()) {
                String key = (String)set.getKey();
                String value = (String)set.getValue();
                props_new.put(key, value);
            }
            NovelConfig duplicate = new NovelConfig(props_new, type, String.valueOf(name) + "_" + System.currentTimeMillis());
            duplicate.setStartFlag(false);
            this.m_nTab.setNew(true);
            this.m_nTab.createDetailArea(duplicate.getType().getText(), duplicate);
            this.m_nTab.removeTableSelection();
            this.m_nTab.setDirty(true);
        }
    }

    private class RefreshTableAction
    extends Action {
        private NotificationConfigTableProvider m_tp;
        private TableViewer m_tv;

        public RefreshTableAction(NotificationConfigTab tab) {
            super("refreshtable");
            this.m_tp = null;
            this.m_tv = null;
            this.setId("refreshtable");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
            this.m_tp = tab.getTableProvider();
            this.m_tv = tab.getTableViewer();
        }

        public void run() {
            this.m_tv.setInput((Object)this.m_tp.getElements(null));
            this.m_tv.refresh();
        }
    }

    private class SaveAction
    extends Action {
        private NotificationConfigTab m_nTab;

        public SaveAction(NotificationConfigTab tab) {
            super("save");
            this.m_nTab = null;
            this.setId("Save");
            this.setText("Save Configuration");
            this.m_nTab = tab;
        }

        public void run() {
            boolean doRefresh = this.m_nTab.save();
            this.m_nTab.reloadTable();
            if (doRefresh) {
                NovelConfig currentCfgItem = this.m_nTab.getCurrentConfigItem();
                this.m_nTab.setTableSelection(currentCfgItem);
            }
        }
    }

    private class StartAction
    extends Action {
        private NotificationConfigTab m_nTab;
        private List<String> m_elements;

        public StartAction(StructuredSelection ssel, NotificationConfigTab tab) {
            super("startAction");
            this.m_nTab = null;
            this.m_elements = null;
            this.setId("startAction");
            this.setText("Start");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_START_16x16);
            this.m_nTab = tab;
            this.m_elements = new ArrayList<String>();
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            for (NovelConfig conf : ssel) {
                this.m_elements.add(conf.getId());
            }
            this.setEnabled(Repository.getInstance().getRights(2014) == 3);
        }

        public void run() {
            if (this.m_elements == null || this.m_elements.size() == 0) {
                return;
            }
            NotificationConfigTableProvider tableProvider = this.m_nTab.getTableProvider();
            StringBuffer errStatus = tableProvider.start(this.m_elements);
            if (errStatus != null) {
                MessageBox dialog = new MessageBox(NotificationConfigTab.this.m_folder.getShell(), 32);
                dialog.setText("Error");
                dialog.setMessage(errStatus.toString());
                dialog.open();
            } else {
                this.m_nTab.getTableViewer().refresh();
            }
        }
    }

    private class StopAction
    extends Action {
        private NotificationConfigTab m_nTab;
        private List<NovelConfig> m_elements;

        public StopAction(StructuredSelection ssel, NotificationConfigTab tab) {
            super("stopAction");
            this.m_nTab = null;
            this.m_elements = null;
            this.setId("stopAction");
            this.setText("Stop");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_STOP_16x16);
            this.m_nTab = tab;
            this.m_elements = new ArrayList<NovelConfig>();
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            Iterator it = ssel.iterator();
            while (it.hasNext()) {
                this.m_elements.add((NovelConfig)it.next());
            }
            this.setEnabled(Repository.getInstance().getRights(2014) == 3);
        }

        public void run() {
            if (this.m_elements == null || this.m_elements.size() == 0) {
                return;
            }
            StringBuffer errStatus = this.m_nTab.getTableProvider().stop(this.m_elements);
            if (errStatus != null) {
                MessageBox dialog = new MessageBox(NotificationConfigTab.this.m_folder.getShell(), 32);
                dialog.setText("Error");
                dialog.setMessage(errStatus.toString());
                dialog.open();
            } else {
                this.m_nTab.reloadTable();
            }
        }
    }

    private class UndoAction
    extends Action {
        private NotificationConfigTab m_nTab;

        public UndoAction(NotificationConfigTab tab) {
            super("undo");
            this.m_nTab = null;
            this.setId("undo");
            this.setText("Undo Changes");
            this.m_nTab = tab;
        }

        public void run() {
            this.m_nTab.undo();
            this.m_nTab.reloadTable();
        }
    }
}

