/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.notify;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.notify.ServerCfgMgr;
import com.blixx.shared.notify.NovelConfig;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class NotificationConfigTableProvider
extends ViewerSorter
implements IElementComparer,
Comparator,
IStructuredContentProvider {
    private List<NovelConfig> m_elements = null;
    private String column = null;
    private int dir = 1024;
    public static final String REFRESH = "REFRESH";
    public static final String COL_TYPE = "Type";
    public static final String COL_NAME = "Name";
    public static final String COL_DESCRIPTION = "Description";
    public static final String COL_IS_STARTED = "isStarted";
    public static final String COL_QUEUE_SIZE = "Queue Size";
    public static final String COL_FAILED_QUEUE_SIZE = "Failed";
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            String htmlStr = null;
            return htmlStr;
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }

        public void update(ViewerCell cell) {
            String result = "";
            Image image = null;
            NovelConfig item = null;
            int columnIndex = cell.getColumnIndex();
            if (cell.getElement() instanceof NovelConfig) {
                item = (NovelConfig)cell.getElement();
                switch (columnIndex) {
                    case 0: {
                        String type;
                        result = type = item.getType().getText();
                        if (type.equals(NovelConfig.NovelCgfType.MAIL.getText())) {
                            image = BMUI.IMAGE_EMAIL_16x16;
                            break;
                        }
                        if (type.equals(NovelConfig.NovelCgfType.SMS.getText())) {
                            image = BMUI.IMAGE_SMS_16x16;
                            break;
                        }
                        if (!type.equals(NovelConfig.NovelCgfType.EXEC.getText())) break;
                        image = BMUI.IMAGE_EXEC_16x16;
                        break;
                    }
                    case 1: {
                        result = item.getId();
                        break;
                    }
                    case 2: {
                        result = item.getDescription();
                        break;
                    }
                    case 3: {
                        result = item.getNotifierStatus().isStarted() ? "true" : "false";
                        image = item.getNotifierStatus().isStarted() ? BMUI.IMAGE_START_16x16 : BMUI.IMAGE_TRANSPARENT_16x16;
                        cell.setBackground(item.getNotifierStatus().isStarted() ? null : BMUI.color_light_red);
                        break;
                    }
                    case 4: {
                        result = String.valueOf(item.getNotifierStatus().getQueueSize());
                        break;
                    }
                    case 5: {
                        result = String.valueOf(item.getNotifierStatus().getFailedCount());
                    }
                }
            }
            cell.setText(result);
            cell.setImage(image);
        }
    };

    public NotificationConfigTableProvider(String colName, int sortDir) {
        this.column = colName;
        this.dir = sortDir;
    }

    public void setConfig(String column, int direction) {
        this.column = column;
        this.dir = direction;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null || this.m_elements.size() == 0) {
            this.fetchNotificationConfig();
        }
        return this.m_elements.toArray();
    }

    public void fetchNotificationConfig() {
        this.m_elements = new ArrayList<NovelConfig>();
        List<NovelConfig> configList = ServerCfgMgr.getInstance().getServerNotificationConfigs();
        if (configList != null) {
            for (NovelConfig conf : configList) {
                NovelConfig cfgItm = new NovelConfig(conf.getProperties(), conf.getType(), conf.getId());
                cfgItm.setNotifierStatus(conf.getNotifierStatus());
                this.m_elements.add(cfgItm);
            }
        }
    }

    public NovelConfig getCfgItemByID(String id) {
        int i = 0;
        while (i < this.m_elements.size()) {
            NovelConfig item = this.m_elements.get(i);
            if (item.getId().equals(id)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void deleteCfgItems(List<NovelConfig> itemList) {
        int i = 0;
        while (i < itemList.size()) {
            NovelConfig cfgItem = itemList.get(i);
            ServerCfgMgr.getInstance().deleteNotifierConfig(cfgItem.getId(), cfgItem.getType().getText());
            ++i;
        }
    }

    public StringBuffer start(List<String> itemList) {
        StringBuffer sb = null;
        int i = 0;
        while (i < itemList.size()) {
            String id = itemList.get(i);
            NovelConfig cfgItem = this.getCfgItemByID(id);
            String errStatus = ServerCfgMgr.getInstance().startNotifier(cfgItem.getId());
            if (errStatus == null) {
                cfgItem.getNotifierStatus().setStarted(true);
            } else {
                cfgItem.getNotifierStatus().setStarted(false);
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(errStatus).append("\n");
            }
            ++i;
        }
        return sb;
    }

    public StringBuffer stop(List<NovelConfig> itemList) {
        StringBuffer sb = null;
        int i = 0;
        while (i < itemList.size()) {
            NovelConfig cfgItem = itemList.get(i);
            String errStatus = ServerCfgMgr.getInstance().stopNotifier(cfgItem.getId());
            if (errStatus != null) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(errStatus).append("\n");
            }
            ++i;
        }
        return sb;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2);
    }

    public int compare(Object e1, Object e2) {
        int returnValue = 0;
        String p1Str = "";
        String p2Str = "";
        NovelConfig p1_cfgItm = (NovelConfig)e1;
        NovelConfig p2_cfgItm = (NovelConfig)e2;
        if (this.column == COL_TYPE) {
            p1Str = p1_cfgItm.getType().getText();
            p2Str = p2_cfgItm.getType().getText();
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_NAME) {
            p1Str = p1_cfgItm.getId();
            p2Str = p2_cfgItm.getId();
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_DESCRIPTION) {
            p1Str = p1_cfgItm.getDescription();
            p2Str = p2_cfgItm.getDescription();
            returnValue = p1Str.compareTo(p2Str);
        } else if (this.column == COL_IS_STARTED) {
            p1Str = p1_cfgItm.getNotifierStatus().isStarted() ? "true" : "false";
            p2Str = p2_cfgItm.getNotifierStatus().isStarted() ? "true" : "false";
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_QUEUE_SIZE) {
            p1Str = String.valueOf(p1_cfgItm.getNotifierStatus().getQueueSize());
            p2Str = String.valueOf(p2_cfgItm.getNotifierStatus().getQueueSize());
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_FAILED_QUEUE_SIZE) {
            p1Str = String.valueOf(p1_cfgItm.getNotifierStatus().getFailedCount());
            p2Str = String.valueOf(p2_cfgItm.getNotifierStatus().getFailedCount());
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        }
        returnValue = p1Str.compareToIgnoreCase(p2Str);
        if (this.dir == 1024) {
            returnValue *= -1;
        }
        return returnValue;
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this);
    }

    public boolean equals(Object a, Object b) {
        if (a instanceof GroupTreeObjectLast && b instanceof GroupTreeObjectLast) {
            return a == null ? b == null : ((GroupTreeObjectLast)a).getName().equals(((GroupTreeObjectLast)b).getName());
        }
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        if (element instanceof GroupTreeObjectLast) {
            return ((GroupTreeObjectLast)element).getName().hashCode();
        }
        return element.hashCode();
    }
}

