/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.notify;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.ctrl.sc.in.ScDeleteNotificationCfg;
import com.blixx.ctrl.sc.in.ScGetNotificationAvailableSMSTransports;
import com.blixx.ctrl.sc.in.ScGetNotificationCfg;
import com.blixx.ctrl.sc.in.ScNotificationStart;
import com.blixx.ctrl.sc.in.ScNotificationStop;
import com.blixx.ctrl.sc.in.ScNotificationTest;
import com.blixx.ctrl.sc.in.ScSaveNotificationCfg;
import com.blixx.shared.notify.NovelConfig;
import java.util.ArrayList;
import java.util.List;

public class ServerCfgMgr {
    private static ServerCfgMgr m_instance = null;
    private List<NovelConfig> m_notifyConfigList = null;

    public static ServerCfgMgr getInstance() {
        if (m_instance == null) {
            m_instance = new ServerCfgMgr();
        }
        return m_instance;
    }

    public List<NovelConfig> getServerNotificationConfigs() {
        Object result = null;
        ScGetNotificationCfg sc = new ScGetNotificationCfg(Repository.getInstance());
        sc.run();
        if (sc.isSuccess()) {
            result = sc.getResultObject();
        }
        return result;
    }

    public String startNotifier(String name) {
        String errMsg = null;
        ScNotificationStart sc = new ScNotificationStart(Repository.getInstance(), name);
        sc.run();
        if (!sc.isSuccess()) {
            errMsg = sc.getResultObject();
        }
        return errMsg;
    }

    public String stopNotifier(String name) {
        String errMsg = null;
        ScNotificationStop sc = new ScNotificationStop(Repository.getInstance(), name);
        sc.run();
        if (!sc.isSuccess()) {
            errMsg = sc.getResultObject();
        }
        return errMsg;
    }

    public boolean deleteNotifierConfig(String name, String type) {
        boolean success = true;
        ScDeleteNotificationCfg sc = new ScDeleteNotificationCfg(Repository.getInstance(), name, type);
        sc.run();
        if (!sc.isSuccess()) {
            new ShowMessageBox("Error", "Server failed to delete configuration", 1);
            success = false;
        }
        return success;
    }

    public boolean saveNotifierConfig(NovelConfig conf) {
        boolean success = true;
        ScSaveNotificationCfg sc = new ScSaveNotificationCfg(Repository.getInstance(), conf);
        sc.run();
        if (!sc.isSuccess()) {
            new ShowMessageBox("Error saving Notification Configuration", sc.getLastException().getMessage(), 1);
            success = false;
        }
        return success;
    }

    public void testNotifierConfig(NovelConfig conf, String rcp) {
        ScNotificationTest sc = new ScNotificationTest(Repository.getInstance(), conf, rcp);
        sc.run();
        String result = sc.getResultObject();
        new ShowMessageBox("Result", result, 32);
    }

    public List<String> getAvailableSmsTransports() {
        Object result = new ArrayList<String>(0);
        ScGetNotificationAvailableSMSTransports sc = new ScGetNotificationAvailableSMSTransports(Repository.getInstance());
        sc.run();
        if (sc.isSuccess()) {
            result = sc.getResultObject();
        }
        return result;
    }

    public List<NovelConfig> getNotifyConfigList() {
        return this.m_notifyConfigList;
    }

    public void setNotifyConfigList(List<NovelConfig> notifyConfigList) {
        this.m_notifyConfigList = notifyConfigList;
    }
}

