/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.policies;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.ctrl.sc.in.ScPutForwardFilters;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.FPolicyFactory;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class FFilterManager
implements IStructuredContentProvider,
ITableLabelProvider {
    private String m_filterFilePath = null;
    private static FFilterManager m_fFilterManager = null;
    private FPolicyFactory m_fPolicyFactory = null;
    private Map<Integer, ForwardFilter> m_fFilterList = new TreeMap<Integer, ForwardFilter>();
    private int m_highestNumber = 0;

    public static FFilterManager getInstance() {
        if (m_fFilterManager == null) {
            m_fFilterManager = new FFilterManager();
        }
        return m_fFilterManager;
    }

    private FFilterManager() {
        this.m_fPolicyFactory = new FPolicyFactory();
        this.initFFilters();
    }

    public void initFFilters() {
        this.setFilterFilePath();
        this.m_fFilterList.clear();
        List<ForwardFilter> fFilterList = this.m_fPolicyFactory.initFilters(new File(this.m_filterFilePath));
        int i = 0;
        while (i < fFilterList.size()) {
            ForwardFilter ff = fFilterList.get(i);
            if (ff.getNumber() > this.m_highestNumber) {
                this.m_highestNumber = ff.getNumber();
            }
            this.m_fFilterList.put(ff.getNumber(), ff);
            ++i;
        }
    }

    public void setFilterFilePath() {
        File fold;
        this.m_filterFilePath = String.valueOf(Repository.getUserPoliciesDirectory()) + File.separator + "filters.fgf.xml";
        File f = new File(this.m_filterFilePath);
        if (!f.exists() && (fold = new File(String.valueOf(Repository.getUserPoliciesDirectory()) + File.separator + "Boom_filters.fgf.xml")).exists() && !fold.renameTo(f)) {
            this.m_filterFilePath = String.valueOf(Repository.getUserPoliciesDirectory()) + File.separator + "Boom_filters.fgf.xml";
        }
    }

    public List<ForwardFilter> getForwardFilters() {
        return new ArrayList<ForwardFilter>(this.m_fFilterList.values());
    }

    public void putFFilters() {
        File file = new File(this.m_filterFilePath);
        this.m_fPolicyFactory.storeFilters(new ArrayList<ForwardFilter>(this.m_fFilterList.values()), file);
        ScPutForwardFilters sc = new ScPutForwardFilters(Repository.getInstance(), this.m_filterFilePath);
        sc.run();
        if (!sc.isSuccess()) {
            RTLogger.print(1, "Error saving FFilters");
            new ShowMessageBox("Error saving Server filters", sc.getResultObject(), 1);
        }
    }

    public void removeFFilters(ArrayList<ForwardFilter> list) {
        int i = 0;
        while (i < list.size()) {
            ForwardFilter ff = list.get(i);
            if (this.m_fFilterList.containsKey(ff.getNumber())) {
                this.m_fFilterList.remove(ff.getNumber());
                Properties p = ff.getProperties();
                RTLogger.print(5, "Delete Forward Filter " + p.getProperty("NAME"));
            }
            ++i;
        }
        this.putFFilters();
    }

    public void addFFilters(ArrayList<ForwardFilter> list) {
        int i = 0;
        while (i < list.size()) {
            ForwardFilter ff = list.get(i);
            Properties p = ff.getProperties();
            if (!this.m_fFilterList.containsKey(ff.getNumber())) {
                RTLogger.print(5, "Add new Forward Filter " + p.getProperty("NAME"));
                ++this.m_highestNumber;
            } else {
                RTLogger.print(5, "Update Forward Filter " + p.getProperty("NAME"));
            }
            this.m_fFilterList.put(ff.getNumber(), ff);
            ++i;
        }
        this.putFFilters();
    }

    public ForwardFilter getFilter(int number) {
        return this.m_fFilterList.get(number);
    }

    public ForwardFilter getFilter(String name) {
        ForwardFilter res = null;
        for (ForwardFilter forwardFilter : this.m_fFilterList.values()) {
            if (!forwardFilter.getName().equals(name)) continue;
            res = forwardFilter;
            break;
        }
        return res;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_fFilterList.values().toArray();
    }

    public int getHighestNumber() {
        return this.m_highestNumber;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ForwardFilter ff = (ForwardFilter)element;
        Properties p = ff.getProperties();
        switch (columnIndex) {
            case 0: {
                return "" + ff.getNumber();
            }
            case 1: {
                return p.getProperty("NAME");
            }
            case 2: {
                return p.getProperty("DESCRIPTION");
            }
            case 3: {
                return p.getProperty("ATTRIBUTE");
            }
            case 4: {
                String pattern = null;
                if (ff instanceof NodeGroupForwardFilter) {
                    NodeGroupForwardFilter ngFF = (NodeGroupForwardFilter)ff;
                    pattern = ngFF.getPath();
                } else {
                    pattern = p.getProperty("PATTERN");
                    if (p.getProperty("PATTERN").toLowerCase().startsWith("java=")) {
                        pattern = p.getProperty("PATTERN").substring(5);
                    }
                }
                return pattern;
            }
            case 5: {
                String relatedPolicies = "";
                Set<String> relatedFPolicies = FPolicyManager.getInstance().getLinkedFPolicyNames(ff.getNumber());
                if (relatedFPolicies != null && relatedFPolicies.size() > 0) {
                    String tmp = relatedFPolicies.toString();
                    relatedPolicies = tmp.substring(1, tmp.length() - 1);
                }
                return relatedPolicies;
            }
        }
        return "";
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

