/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.policies;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.FFilterManager;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.ctrl.sc.in.ScDeleteForwardPolicy;
import com.blixx.ctrl.sc.in.ScPutForwardPolicy;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.FPolicyFactory;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class FPolicyManager {
    private static FPolicyManager m_fPolicyManager = null;
    private FPolicyFactory m_fPolicyFactory = new FPolicyFactory();
    private ConcurrentHashMap<String, ForwardPolicy> m_forwardPolicies = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FPolicyManager getInstance() {
        if (m_fPolicyManager != null) return m_fPolicyManager;
        Class<FPolicyManager> clazz = FPolicyManager.class;
        synchronized (FPolicyManager.class) {
            if (m_fPolicyManager != null) return m_fPolicyManager;
            m_fPolicyManager = new FPolicyManager();
            File f = new File(Repository.getUserPoliciesDirectory());
            if (f.exists()) return m_fPolicyManager;
            f.mkdirs();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_fPolicyManager;
        }
    }

    private FPolicyManager() {
        this.initFPolicies();
    }

    public void initFPolicies() {
        File policyDir = new File(Repository.getUserPoliciesDirectory());
        if (policyDir != null && policyDir.isDirectory()) {
            File[] farr = policyDir.listFiles();
            FPolicyFactory pf = new FPolicyFactory();
            this.m_forwardPolicies.clear();
            int i = 0;
            while (i < farr.length) {
                if (farr[i].getName().endsWith(".fwd.xml")) {
                    try {
                        ForwardPolicy fp = pf.loadForwardPolicy(farr[i]);
                        if (fp == null) {
                            throw new RuntimeException("Invalid FwdPolicy file. " + farr[i].getName());
                        }
                        this.m_forwardPolicies.put(fp.policyName, fp);
                    }
                    catch (Throwable e) {
                        RTLogger.print(3, "", e);
                    }
                }
                ++i;
            }
        } else {
            RTLogger.print(1, "ERROR 'policies' directory not found");
        }
    }

    public ArrayList<ForwardPolicy> getAllForwardPolicies() {
        ArrayList<ForwardPolicy> arr = new ArrayList<ForwardPolicy>();
        arr.addAll(this.m_forwardPolicies.values());
        return arr;
    }

    public ArrayList<ForwardPolicy> getUserPolicies() {
        ArrayList<ForwardPolicy> arr = new ArrayList<ForwardPolicy>();
        Collection<ForwardPolicy> col = this.m_forwardPolicies.values();
        for (ForwardPolicy fp : col) {
            if (!fp.isUserPolicyValid()) continue;
            arr.add(fp);
        }
        return arr;
    }

    public ArrayList<ForwardPolicy> getUserPoliciesByRoleID(String roleID) {
        ArrayList<ForwardPolicy> arr = new ArrayList<ForwardPolicy>();
        if (roleID != null && roleID.length() > 0) {
            String roleName = Repository.getInstance().getUserManager().getRoleByID(roleID).getName();
            arr = this.getUserPoliciesByRoleName(roleName);
        }
        return arr;
    }

    public ArrayList<ForwardPolicy> getUserPoliciesByRoleName(String roleName) {
        ArrayList<ForwardPolicy> arr = new ArrayList<ForwardPolicy>();
        if (roleName != null && roleName.length() > 0) {
            roleName = this.removeBrackets(roleName);
            Collection<ForwardPolicy> col = this.m_forwardPolicies.values();
            for (ForwardPolicy fp : col) {
                if (!fp.isUserPolicyValid()) continue;
                List<String> userRoles = fp.getConditions().getConditionList().get(0).getUsersAssociated();
                int i = 0;
                while (i < userRoles.size()) {
                    String foundRoleName = this.removeBrackets(userRoles.get(i));
                    if (roleName.equals(foundRoleName)) {
                        arr.add(fp);
                    }
                    ++i;
                }
            }
        }
        return arr;
    }

    public String removeBrackets(String roleName) {
        if (roleName.startsWith("[")) {
            roleName = roleName.substring(1);
        }
        if (roleName.endsWith("]")) {
            roleName = roleName.substring(0, roleName.length() - 1);
        }
        return roleName;
    }

    public ArrayList<ForwardPolicy> getServerPolicies() {
        ArrayList<ForwardPolicy> arr = new ArrayList<ForwardPolicy>();
        Collection<ForwardPolicy> col = this.m_forwardPolicies.values();
        for (ForwardPolicy fp : col) {
            if (fp.isUserPolicyValid()) continue;
            arr.add(fp);
        }
        return arr;
    }

    public Set<Integer> getAllFilters() {
        HashSet<Integer> ffset = new HashSet<Integer>();
        for (ForwardPolicy fp : this.m_forwardPolicies.values()) {
            ffset.addAll(fp.getFilters());
        }
        return ffset;
    }

    public Set<String> getLinkedFPolicyNames(Integer ffNumber) {
        TreeSet<String> names = new TreeSet<String>();
        for (ForwardPolicy fp : this.m_forwardPolicies.values()) {
            if (!fp.getFilters().contains(ffNumber)) continue;
            names.add(fp.policyName);
        }
        return names;
    }

    public ForwardPolicy getFPolicyByName(String fpName) {
        return this.m_forwardPolicies.get(fpName);
    }

    public void addForwardPolicy(ForwardPolicy fp) {
        this.m_forwardPolicies.put(fp.policyName, fp);
    }

    public void removeForwardPolicy(ForwardPolicy fp) {
        this.m_forwardPolicies.remove(fp.policyName, fp);
    }

    public boolean saveForwardPolicy(ForwardPolicy fp, String origPolicyName, boolean displayMsg) {
        boolean isOK = false;
        RTLogger.print(5, "Save Forward Policy " + fp.policyName + " (origPolName=" + origPolicyName + ")");
        String fullPath = String.valueOf(Repository.getUserPoliciesDirectory()) + origPolicyName + ".fwd.xml";
        File file = new File(fullPath);
        this.m_fPolicyFactory.storeForwardPolicy(fp, file);
        ScPutForwardPolicy sc = new ScPutForwardPolicy(Repository.getInstance(), origPolicyName, fullPath);
        sc.run();
        if (sc.isSuccess()) {
            isOK = true;
            if (displayMsg) {
                new ShowMessageBox("Save Forward Policy", String.valueOf(fp.policyName) + " has been saved!", 2);
            }
            RTLogger.print(5, "Saved FPolicy to the server " + fp.policyName);
        } else {
            RTLogger.print(1, "Error saving FPolicy to the server " + fp.policyName);
            new ShowMessageBox("Error saving FPolicy", "Error saving FPolicy " + fp.policyName + " to the server!\n" + sc.getResultObject(), 1);
        }
        return isOK;
    }

    public void deleteForwardPolicy(ForwardPolicy fp, String origName) {
        RTLogger.print(5, "Delete Forward Policy " + fp.policyName);
        ScDeleteForwardPolicy sc = new ScDeleteForwardPolicy(Repository.getInstance(), fp.policyName);
        sc.run();
        if (sc.isSuccess()) {
            String fullPath = String.valueOf(Repository.getUserPoliciesDirectory()) + fp.policyName + ".fwd.xml";
            File file = new File(fullPath);
            this.m_fPolicyFactory.deleteForwardPolicy(fp, file);
            this.m_forwardPolicies.remove(fp.policyName);
            new ShowMessageBox("Delete Forward Policy", "The Forward Policy " + fp.policyName + " has been deleted", 2);
        } else {
            RTLogger.print(1, "Error deleting FPolicy from the server " + fp.policyName);
            new ShowMessageBox("Error deleting FPolicy", "Error deleting FPolicy " + fp.policyName + " from the server!\n" + sc.getResultObject(), 1);
        }
    }

    public void deleteForwardPolicy(List<ForwardPolicy> fPolicies) {
        if (fPolicies.isEmpty()) {
            return;
        }
        RTLogger.print(5, "Delete " + fPolicies.size() + " Forward Policies");
        StringBuffer sb_success = new StringBuffer();
        StringBuffer sb_error = new StringBuffer();
        int i = 0;
        while (i < fPolicies.size()) {
            ForwardPolicy fp = fPolicies.get(i);
            ScDeleteForwardPolicy sc = new ScDeleteForwardPolicy(Repository.getInstance(), fp.policyName);
            sc.run();
            if (sc.isSuccess()) {
                String fullPath = String.valueOf(Repository.getUserPoliciesDirectory()) + fp.policyName + ".fwd.xml";
                File file = new File(fullPath);
                this.m_fPolicyFactory.deleteForwardPolicy(fp, file);
                this.m_forwardPolicies.remove(fp.policyName);
                sb_success.append("\n").append(fp.policyName);
            } else {
                RTLogger.print(1, "Error deleting FPolicy from the server " + fp.policyName);
                sb_error.append("\n").append(fp.policyName).append(" -> ").append(sc.getResultObject());
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        if (sb_success.length() > 0) {
            sb.append("Successfully deleted: ").append(sb_success.toString());
        }
        if (sb_error.length() > 0) {
            sb.append("\nError deleting FPolicies from the Server: ").append(sb_error.toString());
        }
        new ShowMessageBox("Delete Forward Policies", sb.toString(), 2);
    }

    public void refreshServerFilterView() {
        ServerFilterView instance = ServerFilterView.getInstance();
        if (instance != null && !instance.isNew()) {
            instance.refreshView(false);
        }
    }

    public void refreshFFilterView() {
        ServerFilterView instance = ServerFilterView.getInstance();
        if (instance != null) {
            instance.refreshAttributeFilterTab(null);
            ServerFilterUsersTab.getInstance().refreshGraph();
        }
    }

    public GCube getCube() {
        GCube gcube = new GCube(false);
        ArrayList<ForwardPolicy> list = new ArrayList<ForwardPolicy>();
        list.addAll(this.m_forwardPolicies.values());
        Collections.sort(list);
        list.iterator();
        int countUsers = 0;
        int countFilters = 0;
        int i = 0;
        while (i < list.size()) {
            ForwardPolicy fp = (ForwardPolicy)list.get(i);
            String fpolicyID = "FWD:" + fp.policyName;
            Node node = new Node(gcube, fpolicyID, i, 2.0, 0.0, fp.policyName, "fwd");
            node.setProperty("ACTIVE", "" + fp.isActive());
            gcube.addNode(node);
            List<String> users = fp.getAllUsers();
            int j = 0;
            while (j < users.size()) {
                String userNodeID;
                Node nodeUser;
                String tmp;
                String user = users.get(j);
                if (user.startsWith("[")) {
                    tmp = Repository.getInstance().getUserManager().getCorrectRoleName(user);
                    if (tmp != null) {
                        user = "[" + tmp + "]";
                    }
                } else {
                    tmp = Repository.getInstance().getUserManager().getCorrectUserName(user);
                    if (tmp != null) {
                        user = tmp;
                    }
                }
                if ((nodeUser = gcube.getNode(userNodeID = "User:" + user)) == null) {
                    nodeUser = new Node(gcube, userNodeID, countUsers, 1.0, 0.0, user, "usr");
                    if (Repository.getInstance().getRights(1004) > 2) {
                        if (user.startsWith("[")) {
                            String roleName = user.replace("[", "");
                            roleName = roleName.replace("]", "");
                            if (!Repository.getInstance().getUserManager().roleExist(roleName)) {
                                nodeUser.setProperty("ACTIVE", "false");
                            }
                        } else if (!Repository.getInstance().getUserManager().userExist(user)) {
                            nodeUser.setProperty("ACTIVE", "false");
                        }
                    }
                    gcube.addNode(nodeUser);
                    ++countUsers;
                }
                nodeUser.addTargetYminus(gcube, fpolicyID, "");
                ++j;
            }
            int k = 0;
            while (k < fp.m_filters.size()) {
                try {
                    Integer id = fp.m_filters.get(k);
                    ForwardFilter ff = FFilterManager.getInstance().getFilter(id);
                    String filterNodeID = "FF:" + id;
                    if (gcube.getNode(filterNodeID) == null) {
                        Node filter = new Node(gcube, filterNodeID, countFilters, 3.0, 0.0, id + " " + ff.toString(), "fgf");
                        gcube.addNode(filter);
                        ++countFilters;
                    }
                    node.addTargetYminus(gcube, filterNodeID, "");
                }
                catch (Exception e) {
                    RTLogger.print(1, e.getMessage());
                }
                ++k;
            }
            ++i;
        }
        gcube.setDataObject("N_USERS", countUsers - 1);
        gcube.setDataObject("N_FILTERS", countFilters - 1);
        gcube.setDataObject("N_POLICIES", list.size());
        return gcube;
    }
}

