/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.policies;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetAsnPermissionTree;
import com.blixx.ctrl.sc.in.ScGetPolicyPermissionTree;
import com.blixx.ctrl.sc.in.ScUpdatePolicy;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.BM;
import com.blixx.shared.Condition;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.PolicyParsingException;
import com.blixx.shared.pg.IAssignmentTree;
import com.blixx.shared.pg.IPolicyTree;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class PolicyManager
implements ICmdPostProcess,
ICommandListener,
IPolicyTree,
IAssignmentTree {
    private static PolicyManager m_instance = null;
    private boolean m_isRefreshAllowed = true;
    private String policyGroups = String.valueOf(Repository.getUserPoliciesDirectory()) + BM.PolicyGroups_xml;
    protected PolicyFactory pf;
    private GroupTreeObject m_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
    private String assignmentGroups = String.valueOf(Repository.getUserPoliciesDirectory()) + "assignmentGroups.xml";
    private GroupTreeObject m_assignment_root;
    private XMLTree m_xt = new XMLTree();
    private Map<GroupTreeObjectUnsubmitted, String> m_notSubmittedElements = new ConcurrentHashMap<GroupTreeObjectUnsubmitted, String>();
    public static String CURRENT_NAME = "CURRENT_NAME";
    public static String POLICIES_TREE_NAME = "Policies";

    public static PolicyManager getInstance() {
        if (m_instance == null) {
            m_instance = new PolicyManager();
            File f = new File(Repository.getUserPoliciesDirectory());
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        return m_instance;
    }

    private PolicyManager() {
        m_instance = this;
    }

    @Override
    public GroupTreeObject getAsnTree() {
        block15: {
            if (this.m_assignment_root == null) {
                FileInputStream io = null;
                try {
                    try {
                        io = new FileInputStream(this.getAssignmentGroupsFilename());
                        this.m_assignment_root = this.m_xt.parseXML(io, true);
                    }
                    catch (Throwable e) {
                        RTLogger.print(4, "FNF ", e);
                        try {
                            io.close();
                        }
                        catch (Throwable throwable) {}
                        if (this.m_assignment_root == null) {
                            this.m_assignment_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        io.close();
                    }
                    catch (Throwable throwable2) {}
                    if (this.m_assignment_root == null) {
                        this.m_assignment_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                    }
                    throw throwable;
                }
                try {
                    io.close();
                }
                catch (Throwable throwable) {}
                if (this.m_assignment_root == null) {
                    this.m_assignment_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                }
            }
        }
        return this.m_assignment_root;
    }

    public String getAssignmentGroupsFilename() {
        return this.assignmentGroups;
    }

    public GroupTreeObject refreshAssignmentTree() {
        TreeViewer aTree;
        RTLogger.print(3, "Assignment groups refresh start");
        Object[] expanded = null;
        try {
            aTree = AssignmentListView.getInstance().getTreeViewer();
            if (aTree != null) {
                expanded = aTree.getExpandedElements();
            }
        }
        catch (Throwable throwable) {}
        this.scheduleGetAsnPowerGroupPermissions();
        try {
            aTree = AssignmentListView.getInstance().getTreeViewer();
            if (aTree != null) {
                this.checkLinks();
                aTree.refresh();
                if (expanded != null) {
                    int index = 0;
                    while (index < expanded.length) {
                        aTree.setExpandedState(expanded[index], true);
                        ++index;
                    }
                }
            }
        }
        catch (Throwable throwable) {}
        RTLogger.print(3, "Assignment groups refresh finish");
        return this.m_assignment_root;
    }

    public void processResult() {
        block15: {
            RTLogger.print(3, "Assignment groups processing started");
            FileInputStream io = null;
            try {
                io = new FileInputStream(this.getAssignmentGroupsFilename());
                GroupTreeObject root = this.m_xt.parseXML(io, true);
                if (this.m_assignment_root == null) {
                    this.m_assignment_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                }
                this.m_assignment_root.clean();
                this.m_assignment_root.addElements(root.getElements());
                RTLogger.print(3, "Assignment groups parsing finished");
                this.checkLinks();
            }
            catch (FileNotFoundException e) {
                RTLogger.print(2, "", e);
                RTLogger.print(3, "Assignment groups processing finished");
                try {
                    io.close();
                }
                catch (Throwable throwable) {}
                break block15;
            }
            catch (Throwable e) {
                try {
                    RTLogger.print(2, "", e);
                }
                catch (Throwable throwable) {
                    RTLogger.print(3, "Assignment groups processing finished");
                    try {
                        io.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                RTLogger.print(3, "Assignment groups processing finished");
                try {
                    io.close();
                }
                catch (Throwable throwable) {}
                break block15;
            }
            RTLogger.print(3, "Assignment groups processing finished");
            try {
                io.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void checkLinks() {
        List<GroupTreeObjectLast> al = GroupTreeObject.collectElements(this.m_assignment_root);
        GroupTreeObject root_bin = Repository.getInstance().getBinaryTree();
        int i = 0;
        while (i < al.size()) {
            GroupTreeObjectLast gtol = al.get(i);
            String type = gtol.getTreeObject().getType();
            if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                if (this.m_root == null) {
                    this.getPolicyTree();
                }
                if (this.m_root != null && this.m_root.findElement(gtol.getName(), type) == null) {
                    gtol.setLinkOK(false);
                    if (type.equals(BMUI.type_mon)) {
                        gtol.setIcon("IMAGE_MON_LNK_BROKEN");
                    } else {
                        gtol.setIcon("IMAGE_MSG_LNK__BROKEN");
                    }
                } else {
                    gtol.setLinkOK(true);
                    if (type.equals(BMUI.type_mon)) {
                        gtol.setIcon("IMAGE_MON_LNK");
                    } else {
                        gtol.setIcon("IMAGE_MSG_LNK");
                    }
                }
            } else if (type.equals(BMUI.type_assignment_bin)) {
                GroupTreeObject gto_bin = root_bin.findFirstGroupByName(gtol.getName());
                if (gto_bin == null) {
                    gtol.setLinkOK(false);
                    gtol.setIcon("IMAGE_PKG_LNK_BROKEN");
                } else {
                    gtol.setLinkOK(true);
                    gtol.setIcon("IMAGE_PKG_LNK");
                }
            }
            ++i;
        }
    }

    public String getPolicyGroupsFilename() {
        return this.policyGroups;
    }

    @Override
    public GroupTreeObject getPolicyTree() {
        block15: {
            if (this.m_root == null) {
                FileInputStream io = null;
                this.m_xt = new XMLTree();
                try {
                    try {
                        io = new FileInputStream(this.getPolicyGroupsFilename());
                        this.m_root = this.m_xt.parseXML(io, true);
                        this.scheduleGetPolicyPowerGroupPermissions();
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "", e);
                        if (this.m_assignment_root == null) {
                            this.m_assignment_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                        }
                        try {
                            io.close();
                        }
                        catch (Throwable throwable) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (this.m_assignment_root == null) {
                        this.m_assignment_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                    }
                    try {
                        io.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                if (this.m_assignment_root == null) {
                    this.m_assignment_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                }
                try {
                    io.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return this.m_root;
    }

    @Override
    public void onCommand(String command, String action) {
        if ("GET_POLICYTREEPERMISSIONS".equals(command)) {
            this.scheduleGetPolicyPowerGroupPermissions();
        } else if ("GET_ASNTREEPERMISSIONS".equals(command)) {
            this.scheduleGetAsnPowerGroupPermissions();
        }
    }

    public void scheduleGetPolicyPowerGroupPermissions() {
        ScGetPolicyPermissionTree scgp = new ScGetPolicyPermissionTree(Repository.getInstance());
        scgp.addCmdPostProcess(this);
        JobManager.getInstance().schedule(scgp);
    }

    public void scheduleGetAsnPowerGroupPermissions() {
        ScGetAsnPermissionTree scgp2 = new ScGetAsnPermissionTree(Repository.getInstance());
        scgp2.addCmdPostProcess(this);
        JobManager.getInstance().schedule(scgp2);
    }

    public GroupTreeObject refreshTree() {
        TreeItem[] selected;
        Object[] expanded;
        block30: {
            if (!this.m_isRefreshAllowed) {
                return this.m_root;
            }
            FileInputStream io = null;
            expanded = null;
            selected = null;
            try {
                try {
                    io = new FileInputStream(this.getPolicyGroupsFilename());
                    GroupTreeObject root = this.m_xt.parseXML(io, true);
                    if (this.m_root == null) {
                        this.m_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                    }
                    try {
                        root.sortElementsRecursive();
                        TreeViewer aTree = PolicyListView.getInstance().getTreeViewer();
                        if (aTree != null) {
                            expanded = aTree.getExpandedElements();
                            try {
                                selected = aTree.getTree().getSelection();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable throwable) {}
                    this.m_root.clean();
                    this.m_root.addElements(root.getElements());
                    this.scheduleGetPolicyPowerGroupPermissions();
                    if (this.hasUnsubmitted()) {
                        for (GroupTreeObjectUnsubmitted o : this.m_notSubmittedElements.keySet()) {
                            String parentPath = this.m_notSubmittedElements.get(o);
                            GroupTreeObject gtoParent = this.m_root.searchPath(parentPath, BMUI.type_folder);
                            while (gtoParent == null && parentPath.indexOf(BM.GTO_PATH_SEPARATOR, 1) != -1) {
                                parentPath = parentPath.substring(0, parentPath.lastIndexOf(BM.GTO_PATH_SEPARATOR));
                                gtoParent = this.m_root.searchPath(parentPath, BMUI.type_folder);
                            }
                            if (gtoParent == null) {
                                gtoParent = this.m_root;
                            }
                            this.m_notSubmittedElements.put(o, gtoParent.getPath());
                            gtoParent.addElement(o);
                        }
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(2, "", e);
                    try {
                        io.close();
                    }
                    catch (Throwable throwable) {}
                    break block30;
                }
            }
            catch (Throwable throwable) {
                try {
                    io.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                io.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            TreeViewer aTree = PolicyListView.getInstance().getTreeViewer();
            if (aTree != null) {
                aTree.refresh();
                if (expanded != null && expanded.length > 0) {
                    int index = 0;
                    while (index < expanded.length) {
                        aTree.setExpandedState(expanded[index], true);
                        ++index;
                    }
                    try {
                        aTree.getTree().setSelection(selected);
                    }
                    catch (Throwable throwable) {}
                } else {
                    aTree.expandToLevel(2);
                }
            }
        }
        catch (Throwable throwable) {}
        this.checkLinks();
        return this.m_root;
    }

    public Policy getMonitorPolicy(File file) {
        PolicyFactory pf = new PolicyFactory();
        Policy ret = null;
        try {
            ret = pf.initPolicy(file);
        }
        catch (Throwable throwable) {}
        return ret;
    }

    public MsgPolicy getMessagePolicy(File file) {
        PolicyFactory pf = new PolicyFactory();
        MsgPolicy mp = null;
        try {
            mp = pf.initMsgPolicy(file);
        }
        catch (Throwable throwable) {}
        return mp;
    }

    public Policy getMonitorPolicyThrowEx(File file) throws PolicyParsingException {
        PolicyFactory pf = new PolicyFactory();
        Policy p = null;
        p = pf.initPolicy(file);
        this.throwFailedConditions(p);
        return p;
    }

    public MsgPolicy getMessagePolicyThrowEx(File file) throws PolicyParsingException {
        PolicyFactory pf = new PolicyFactory();
        MsgPolicy mp = null;
        mp = pf.initMsgPolicy(file);
        this.throwFailedConditions(mp);
        return mp;
    }

    public void throwFailedConditions(AbstractPolicy p) throws PolicyParsingException {
        if (p.getConditions().getFailedConditions().size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(p.getConditions().getFailedConditions().size()).append(" conditions failed parsing\n\n");
            for (Properties pr : p.getConditions().getFailedConditions()) {
                sb.append("CONDITION_ID").append('=').append(pr.getProperty("CONDITION_ID", "id not found!")).append(' ');
                sb.append("C_DESCRIPTION").append('=').append(pr.getProperty("C_DESCRIPTION", "no description found")).append('\n');
                if (p instanceof MsgPolicy) {
                    try {
                        MsgCondition.getInstance(pr, 0, 0);
                    }
                    catch (Throwable e) {
                        sb.append("Exception=").append(e.getMessage()).append("\n\n");
                    }
                    continue;
                }
                if (!(p instanceof Policy)) continue;
                try {
                    Condition.getInstance(pr, false);
                }
                catch (Throwable e) {
                    sb.append("Exception=").append(e.getMessage()).append("\n\n");
                }
            }
            throw new PolicyParsingException(sb.toString());
        }
    }

    public boolean deleteMessagePolicy(ServerClientBatch scBatch, String policyName) {
        scBatch.setCommand("DELETEPOLICY", null, new String[]{policyName, BMUI.type_msg, ""});
        Object res = scBatch.runBatch();
        if (scBatch.isSuccess()) {
            RTLogger.print(3, "DELETEMSGPOLICY OK: " + res);
        } else {
            RTLogger.print(3, "DELETEMSGPOLICY Error: " + res);
        }
        return scBatch.isSuccess();
    }

    public boolean deleteMonitorPolicy(ServerClientBatch scBatch, String monitorName) {
        scBatch.setCommand("DELETEPOLICY", null, new String[]{monitorName, BMUI.type_mon, ""});
        Object res = scBatch.runBatch();
        if (scBatch.isSuccess()) {
            RTLogger.print(3, "DELETEPOLICY OK: " + res);
        } else {
            RTLogger.print(3, "DELETEPOLICY Error: " + res);
        }
        return scBatch.isSuccess();
    }

    public ServerClientBatch saveAbstractPolicyBatch(ServerClientBatch scBatch, AbstractPolicy pOld, AbstractPolicy pChanged, String fileName, String treePath) {
        PolicyFactory pf = new PolicyFactory();
        String filePath = String.valueOf(Repository.getUserPoliciesDirectory()) + fileName;
        pf.storePolicy(Repository.getUserPoliciesDirectory(), pChanged);
        String type = "";
        if (pChanged instanceof Policy) {
            type = BMUI.type_mon;
        } else if (pChanged instanceof MsgPolicy) {
            type = BMUI.type_msg;
        }
        if (scBatch == null) {
            scBatch = new ServerClientBatch("BATCH");
            scBatch.openSocket();
        }
        scBatch.setCommand("UPDATEPOLICY", null, new String[]{pChanged.getName(), type, filePath, treePath});
        Object res = scBatch.runBatch();
        if (scBatch.isSuccess()) {
            Map.Entry<GroupTreeObjectUnsubmitted, String> en;
            Iterator<Map.Entry<GroupTreeObjectUnsubmitted, String>> it;
            RTLogger.print(3, "UPDATEPOLICY OK: " + res);
            if (pOld != null) {
                it = this.m_notSubmittedElements.entrySet().iterator();
                while (it.hasNext()) {
                    en = it.next();
                    if (!en.getKey().getName().equals(pOld.getName())) continue;
                    it.remove();
                }
            }
            if (pChanged != null) {
                it = this.m_notSubmittedElements.entrySet().iterator();
                while (it.hasNext()) {
                    en = it.next();
                    if (!en.getKey().getName().equals(pChanged.getName())) continue;
                    it.remove();
                }
            }
        } else {
            RTLogger.print(3, "UPDATEPOLICY Error: " + res);
        }
        return scBatch;
    }

    public boolean isUnsubmitted(String pName) {
        boolean b = false;
        for (GroupTreeObjectUnsubmitted o : this.m_notSubmittedElements.keySet()) {
            AbstractPolicy p;
            if (!(o instanceof Policy ? pName.equals((p = (Policy)((Object)o)).getName()) : o instanceof MsgPolicy && pName.equals((p = (MsgPolicy)((Object)o)).getName()))) continue;
            return true;
        }
        return b;
    }

    public boolean hasUnsubmitted() {
        return this.m_notSubmittedElements.size() > 0;
    }

    public void addUnsubmitted(GroupTreeObjectUnsubmitted newElement, String parentPath) {
        if (newElement != null) {
            this.m_notSubmittedElements.put(newElement, parentPath);
        }
    }

    public Map<GroupTreeObjectUnsubmitted, String> getUnsubmitted() {
        return this.m_notSubmittedElements;
    }

    public void updateUnsubmitted(String oldName, String newName, String type) {
        for (GroupTreeObjectUnsubmitted gtoU : this.m_notSubmittedElements.keySet()) {
            String parentPath = this.m_notSubmittedElements.get(gtoU);
            String polName = gtoU.getTreeObject().getComparableName();
            String polType = gtoU.getTreeObject().getType();
            if (!type.equals(polType) || !oldName.equals(polName)) continue;
            gtoU.setAttribute(CURRENT_NAME, newName);
            this.m_notSubmittedElements.put(gtoU, parentPath);
            TreeViewer aTree = PolicyListView.getInstance().getTreeViewer();
            if (aTree == null) break;
            aTree.refresh();
            break;
        }
    }

    public void removeUnsubmitted(String name, String type) {
        Iterator<GroupTreeObjectUnsubmitted> it = this.m_notSubmittedElements.keySet().iterator();
        while (it.hasNext()) {
            GroupTreeObjectUnsubmitted o;
            GroupTreeObjectUnsubmitted gtoU = o = it.next();
            String tabname = gtoU.getTreeObject().getComparableName();
            String tabtype = gtoU.getTreeObject().getType();
            if (!type.equals(tabtype) || !name.equals(tabname)) continue;
            this.m_notSubmittedElements.remove(o);
            break;
        }
    }

    public void allowRefresh(boolean allowRefresh) {
        this.m_isRefreshAllowed = allowRefresh;
    }

    public boolean isRefreshAllowed() {
        return this.m_isRefreshAllowed;
    }

    public void postProcess(ServerClient sc) {
        if (sc instanceof ScUpdatePolicy) {
            ScUpdatePolicy scn = (ScUpdatePolicy)sc;
            if (scn.isSuccess()) {
                RTLogger.print(3, "UPDATEPOLICY OK: " + scn.getPolicyName());
                this.removeUnsubmitted(scn.getPolicyName(), scn.getPolicyType());
            } else {
                RTLogger.print(3, "UPDATEPOLICY Error: " + scn.getPolicyName(), scn.getLastException());
            }
        } else if (sc instanceof ScGetPolicyPermissionTree) {
            if (sc.isSuccess()) {
                this.m_root.clearAttributesRecursive();
                this.m_root.mergeAttributesFromTree((GroupTreeObject)sc.getResultObject());
                UIJob job = new UIJob("POLTREEPermRfr"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TreeViewer aTree = PolicyListView.getInstance().getTreeViewer();
                        if (aTree != null) {
                            aTree.refresh();
                        }
                        return Status.OK_STATUS;
                    }
                };
                UIJobManager.getInstance().schedule(job);
            }
        } else if (sc instanceof ScGetAsnPermissionTree && sc.isSuccess()) {
            this.m_assignment_root.clearAttributesRecursive();
            this.m_assignment_root.mergeAttributesFromTree((GroupTreeObject)sc.getResultObject());
            UIJob job = new UIJob("ASNTPEEPermRfr"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TreeViewer aTree = AssignmentListView.getInstance().getTreeViewer();
                    if (aTree != null) {
                        aTree.refresh();
                    }
                    return Status.OK_STATUS;
                }
            };
            UIJobManager.getInstance().schedule(job);
        }
    }

    public boolean isPermittedPolicyRead(String name, String type) {
        GroupTreeObjectLast policyGTOL = this.getPolicyTree().findElement(name, type);
        return this.isPermittedPolicyRead(policyGTOL);
    }

    public boolean isPermittedPolicyModify(String name, String type) {
        GroupTreeObjectLast policyGTOL = this.getPolicyTree().findElement(name, type);
        return this.isPermittedPolicyModify(policyGTOL);
    }

    public boolean isPermittedPolicyModify(GroupTreeObject policyGTOL) {
        String readAttribute;
        if (!this.isPermittedPolicyRead(policyGTOL)) {
            return false;
        }
        boolean isPermitted = Repository.getInstance().getRights(1001) >= 3;
        Boolean byPowerGroup = null;
        if (policyGTOL != null && (readAttribute = policyGTOL.findTopAttribute(PGEntityAction.MODIFY.name())) != null) {
            byPowerGroup = PGEntityPermissionFlag.RESTRICT == PGEntityPermissionFlag.valueOf(readAttribute) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return byPowerGroup == null ? isPermitted : byPowerGroup;
    }

    public boolean isPermittedPolicyRead(GroupTreeObject policyGTOL) {
        String readAttribute;
        boolean isPermitted = Repository.getInstance().getRights(1001) >= 2;
        Boolean byPowerGroup = null;
        if (policyGTOL != null && (readAttribute = policyGTOL.findTopAttribute(PGEntityAction.READ.name())) != null) {
            byPowerGroup = PGEntityPermissionFlag.RESTRICT == PGEntityPermissionFlag.valueOf(readAttribute) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return byPowerGroup == null ? isPermitted : byPowerGroup;
    }

    public boolean isPermittedPolicyModifyRecursive(GroupTreeObject gto) {
        List<GroupTreeObject> list;
        boolean isPermitted = this.isPermittedPolicyModify(gto);
        if (isPermitted && (list = gto.getElements()) != null) {
            for (GroupTreeObject g : list) {
                String readPerm = g.getAttribute(PGEntityAction.READ.name());
                String modifyPerm = g.getAttribute(PGEntityAction.MODIFY.name());
                if (readPerm != null && PGEntityPermissionFlag.RESTRICT == PGEntityPermissionFlag.valueOf(readPerm) || modifyPerm != null && PGEntityPermissionFlag.RESTRICT == PGEntityPermissionFlag.valueOf(modifyPerm)) {
                    return false;
                }
                if (g.hasElements().booleanValue() && !(isPermitted = this.isPermittedPolicyModifyRecursive(g))) break;
            }
        }
        return isPermitted;
    }

    public boolean isPermittedPGAModifyRecursive(GroupTreeObject gto) {
        List<GroupTreeObject> list;
        boolean isPermitted = this.isPermittedPGAModify(gto);
        if (isPermitted && (list = gto.getElements()) != null) {
            for (GroupTreeObject g : list) {
                String readPerm = g.getAttribute(PGEntityAction.READ.name());
                String modifyPerm = g.getAttribute(PGEntityAction.MODIFY.name());
                if (readPerm != null && PGEntityPermissionFlag.RESTRICT == PGEntityPermissionFlag.valueOf(readPerm) || modifyPerm != null && PGEntityPermissionFlag.RESTRICT == PGEntityPermissionFlag.valueOf(modifyPerm)) {
                    return false;
                }
                if (g.hasElements().booleanValue() && !(isPermitted = this.isPermittedPGAModifyRecursive(g))) break;
            }
        }
        return isPermitted;
    }

    public boolean isPermittedPGAModify(String name) {
        GroupTreeObjectLast asnGTO = this.getAsnTree().findElement(name, BMUI.type_assignment_pol);
        return this.isPermittedPGAModify(asnGTO);
    }

    public boolean isPermittedPGAModify(GroupTreeObject asnGTO) {
        String readAttribute;
        boolean isPermitted = Repository.getInstance().getRights(1008) >= 3;
        Boolean byPowerGroup = null;
        if (asnGTO != null && (readAttribute = asnGTO.findTopAttribute(PGEntityAction.MODIFY.name())) != null) {
            byPowerGroup = PGEntityPermissionFlag.RESTRICT == PGEntityPermissionFlag.valueOf(readAttribute) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return byPowerGroup == null ? isPermitted : byPowerGroup;
    }
}

