/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.policies;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GAssignments;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetPoliciesDetails;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PolicyOverviewTableProvider
extends ViewerSorter
implements IElementComparer,
Comparator,
IStructuredContentProvider,
ICmdPostProcess {
    private static final String MORE = "...";
    private TableViewer m_tableViewer = null;
    private ArrayList<String[]> m_elements = null;
    private ArrayList<String> m_pendingASN = null;
    private Map<String, String[]> m_policyDetails = null;
    private int m_policyCount = 0;
    private int m_msgCount = 0;
    private int m_monCount = 0;
    private String column = "Name";
    private int dir = 128;
    public static final String REFRESH = "REFRESH";
    public static final String COL_POLICY_TYPE = "Policy Type";
    public static final String COL_POLICY_NAME = "Name";
    public static final String COL_VERSION = "Version";
    public static final String COL_GROUP = "Group";
    public static final String COL_APPLICATION = "Application";
    public static final String COL_TYPE = "Call Type";
    public static final String COL_PATH = "Path";
    public static final String COL_RELATED_ASN = "Related Assignments";
    public static final String COL_RELATED_AGENTS = "Related Agents";
    public static int MAX_LINES = 3;
    private boolean m_hasAsnRights = true;
    private boolean m_hasAgentRights = true;
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            String htmlStr = null;
            if (element instanceof String[]) {
                String[] item = (String[])element;
                String polType = item[0];
                if (polType.equals(BMUI.type_mon)) {
                    polType = "Monitor";
                } else if (polType.equals(BMUI.type_msg)) {
                    polType = "Indication";
                }
                String polName = item[1];
                String version = item[2];
                String group = item[3];
                String application = item[4];
                String callType = item[5];
                String parentPath = item[6];
                if (parentPath.startsWith("/root/Policies/")) {
                    parentPath = parentPath.substring(15);
                }
                String relAgents = "";
                String relAssign = "";
                int i = 0;
                while (i < PolicyOverviewTableProvider.this.m_elements.size()) {
                    String[] elem = (String[])PolicyOverviewTableProvider.this.m_elements.get(i);
                    if (elem[1].equals(polName)) {
                        relAssign = elem[7].replace("|", "<br>");
                        relAgents = elem[8].replace("|", "<br>");
                    }
                    ++i;
                }
                htmlStr = "<html><body bgcolor='#FFFFE1'>";
                htmlStr = String.valueOf(htmlStr) + "<table border='0' cellspacing='0' cellpadding='0'>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Name:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + polName + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Type:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + polType + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Version:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + version + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Group:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'>" + group + "</font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Application:&nbsp;&nbsp;</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'>" + application + "</font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>CallType:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'>" + callType + "</font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Tree Path:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'>" + parentPath + "</font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Rel. Assign:&nbsp;&nbsp;</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'>" + relAssign + "</font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Rel. Agents:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'>" + relAgents + "</font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "</table>";
                htmlStr = String.valueOf(htmlStr) + "</body></html>";
            }
            return htmlStr;
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }

        public void update(ViewerCell cell) {
            String result = "";
            Image image = null;
            String[] item = null;
            int columnIndex = cell.getColumnIndex();
            if (!(cell.getElement() instanceof String[])) {
                return;
            }
            item = (String[])cell.getElement();
            switch (columnIndex) {
                case 0: {
                    String type = item[0];
                    image = BMUI.IMAGE_MAP.get(type);
                    break;
                }
                case 1: {
                    result = item[1];
                    break;
                }
                case 2: {
                    result = item[2];
                    break;
                }
                case 3: {
                    result = item[3];
                    break;
                }
                case 4: {
                    result = item[4];
                    break;
                }
                case 5: {
                    result = item[5];
                    break;
                }
                case 6: {
                    result = item[6];
                    if (!result.startsWith("/root/Policies/")) break;
                    result = result.substring(15);
                    break;
                }
                case 7: {
                    String[] strList = new String[]{};
                    String colName = PolicyOverviewTableProvider.this.m_tableViewer.getTable().getColumn(columnIndex).getText();
                    if (colName.equals(PolicyOverviewTableProvider.COL_RELATED_ASN)) {
                        if (item[7].length() > 0) {
                            strList = item[7].split("\\Q|\\E");
                        }
                    } else if (colName.equals(PolicyOverviewTableProvider.COL_RELATED_AGENTS) && item[8].length() > 0) {
                        strList = item[8].split("\\Q|\\E");
                    }
                    int count = strList.length;
                    if (strList.length > MAX_LINES) {
                        count = MAX_LINES;
                    }
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < count) {
                        if (strList[i].length() != 0) {
                            sb.append(strList[i]).append('\n');
                        }
                        ++i;
                    }
                    result = sb.toString();
                    if (!result.endsWith("\n")) break;
                    result = result.substring(0, result.length() - 1);
                    break;
                }
                case 8: {
                    String[] strList2 = new String[]{};
                    String colName2 = PolicyOverviewTableProvider.this.m_tableViewer.getTable().getColumn(columnIndex).getText();
                    if (colName2.equals(PolicyOverviewTableProvider.COL_RELATED_ASN)) {
                        if (item[7].length() > 0) {
                            strList2 = item[7].split("\\Q|\\E");
                        }
                    } else if (colName2.equals(PolicyOverviewTableProvider.COL_RELATED_AGENTS) && item[8].length() > 0) {
                        strList2 = item[8].split("\\Q|\\E");
                    }
                    int count2 = strList2.length;
                    if (strList2.length > MAX_LINES) {
                        count2 = MAX_LINES;
                    }
                    StringBuffer sb2 = new StringBuffer();
                    int i = 0;
                    while (i < count2) {
                        if (strList2[i].length() != 0) {
                            sb2.append(strList2[i]).append('\n');
                        }
                        ++i;
                    }
                    result = sb2.toString();
                    if (!result.endsWith("\n")) break;
                    result = result.substring(0, result.length() - 1);
                }
            }
            cell.setText(result);
            cell.setImage(image);
        }
    };

    public PolicyOverviewTableProvider(TableViewer tableViewer, boolean hasAsnRights, boolean hasAgentRights) {
        this.m_tableViewer = tableViewer;
        this.m_hasAsnRights = hasAsnRights;
        this.m_hasAgentRights = hasAgentRights;
        this.m_elements = new ArrayList();
    }

    public void setConfig(String column, int direction) {
        this.column = column;
        this.dir = direction;
    }

    public void getPolicyDetailsFromServer() {
        this.m_elements = new ArrayList();
        this.m_pendingASN = PolicyOverviewTableProvider.getPendingAssingments();
        this.m_policyCount = 0;
        this.m_msgCount = 0;
        this.m_monCount = 0;
        try {
            ScGetPoliciesDetails sc = new ScGetPoliciesDetails(Repository.getInstance());
            sc.addCmdPostProcess(this);
            JobManager.getInstance().schedule(sc, 0L);
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error getting policy details from server", e);
        }
    }

    public void postProcess(ServerClient sc) {
        if (sc instanceof ScGetPoliciesDetails) {
            this.processResponse((ScGetPoliciesDetails)sc);
        }
    }

    private void processResponse(ScGetPoliciesDetails sc) {
        if (sc.isSuccess()) {
            this.m_policyDetails = sc.getResultObject();
            if (this.m_policyDetails.size() != 0) {
                List<GroupTreeObject> list = PolicyManager.getInstance().getPolicyTree().getAllElements();
                this.m_elements = new ArrayList(list.size());
                int i = 0;
                while (i < list.size()) {
                    GroupTreeObject o = list.get(i);
                    if (!(o instanceof GroupTreeObjectUnsubmitted) && o instanceof GroupTreeObjectLast) {
                        try {
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                            String polType = gtol.getTreeObject().getType();
                            if (!PolicyManager.getInstance().isPermittedPolicyModify(gtol) || !PolicyManager.getInstance().isPermittedPolicyRead(gtol)) {
                                polType = String.valueOf(polType) + '-';
                            }
                            String name = gtol.getName();
                            String parentPath = gtol.getParentPath();
                            String[] arr = this.m_policyDetails.get(name);
                            String version = "";
                            String group = "";
                            String app = "";
                            String type = "";
                            int count = 0;
                            while (count < arr.length) {
                                switch (count) {
                                    case 0: {
                                        version = arr[0];
                                        break;
                                    }
                                    case 1: {
                                        group = arr[1];
                                        break;
                                    }
                                    case 2: {
                                        app = arr[2];
                                        break;
                                    }
                                    case 3: {
                                        type = arr[3];
                                    }
                                }
                                ++count;
                            }
                            String relatedAsn = "";
                            if (this.m_hasAsnRights) {
                                relatedAsn = this.getRelatedAsnString(name);
                            }
                            String relatedAgents = MORE;
                            if (this.m_hasAgentRights) {
                                relatedAgents = this.getRelatedAgentString(name, polType);
                            }
                            String[] props = new String[]{polType, name, version, group, app, type, parentPath, relatedAsn, relatedAgents};
                            this.m_elements.add(props);
                            if (polType.equals(BMUI.type_mon)) {
                                ++this.m_monCount;
                            } else if (polType.equals(BMUI.type_msg)) {
                                ++this.m_msgCount;
                            }
                            ++this.m_policyCount;
                        }
                        catch (Throwable throwable) {
                            RTLogger.print(2, "Error processing GTOL: " + o + ". Policy can be already deleted from server, but remains in policyGroup.xml file");
                        }
                    }
                    ++i;
                }
                UIJob job = new UIJob("Refresh Policy Overview"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            PolicyOverviewTableProvider.this.m_tableViewer.refresh();
                        }
                        catch (Throwable throwable) {}
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(job);
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null && inputElement instanceof String && ((String)inputElement).equals(REFRESH)) {
            this.getPolicyDetailsFromServer();
        }
        return this.m_elements.toArray();
    }

    public Map<String, String[]> getPolicyDetails() {
        return this.m_policyDetails;
    }

    public int getPolicyCount() {
        return this.m_policyCount;
    }

    public int getMsgCount() {
        return this.m_msgCount;
    }

    public int getMonCount() {
        return this.m_monCount;
    }

    public static ArrayList<String> getPendingAssingments() {
        ArrayList<String> pendingASN = new ArrayList<String>();
        GAssignments gAssignmnets = Repository.getInstance().getAllAssignments();
        List<Assignment> pendingElements = gAssignmnets.getPendingAssignments();
        int i = 0;
        while (i < pendingElements.size()) {
            Assignment asn = pendingElements.get(i);
            if (asn.getLock() == 1) {
                pendingASN.add(String.valueOf(asn.getName()) + "|" + asn.getAgentID());
            }
            ++i;
        }
        return pendingASN;
    }

    private String getRelatedAsnString(String policyName) {
        StringBuffer asnStr = new StringBuffer();
        ArrayList<String> asn = PolicyOverviewTableProvider.getRelatedAssignments(policyName);
        int i = 0;
        while (i < asn.size()) {
            if (i > 0) {
                asnStr.append("|");
            }
            asnStr.append(asn.get(i));
            ++i;
        }
        if (asnStr.length() > 0 && asnStr.charAt(0) == '|') {
            asnStr.deleteCharAt(0);
        }
        return asnStr.toString();
    }

    private String getRelatedAgentString(String policyName, String policyType) {
        StringBuffer agentStr = new StringBuffer();
        ArrayList<AgentCard> agents = PolicyOverviewTableProvider.getRelatedAgentCards(policyName, policyType);
        if (agents == null) {
            return "";
        }
        int i = 0;
        while (i < agents.size()) {
            agentStr.append("|").append(agents.get(i));
            ++i;
        }
        if (agentStr.length() > 0 && agentStr.charAt(0) == '|') {
            agentStr.deleteCharAt(0);
        }
        return agentStr.toString();
    }

    public static ArrayList<String> getRelatedAssignments(String policyName) {
        ArrayList<String> relatedAsn = new ArrayList<String>();
        if (AssignmentListView.getInstance() == null) {
            return relatedAsn;
        }
        List<GroupTreeObject> elem = AssignmentListView.getInstance().m_assignmentROOT.getElements();
        if (elem != null && elem.size() > 0) {
            GroupTreeObject root = elem.get(0);
            List<GroupTreeObject> assignments = root.getElements();
            int i = 0;
            while (i < assignments.size()) {
                GroupTreeObject asnGTO;
                GroupTreeObject o = assignments.get(i);
                if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast) && (asnGTO = o).getTreeObject().getType().equals(BMUI.type_assignment_pol) && (asnGTO.findElement(policyName, "mon") != null || asnGTO.findElement(policyName, "msg") != null) && !relatedAsn.contains(asnGTO.getName())) {
                    relatedAsn.add(asnGTO.getName());
                }
                ++i;
            }
        }
        return relatedAsn;
    }

    public static ArrayList<AgentCard> getRelatedAgentCards(String policyName, String policyType) {
        Map<AgentCard, Object> rahm = Repository.getInstance().getAllAssignments().getAllRelatedAgents(policyName, policyType);
        ArrayList<AgentCard> relatedAgents = new ArrayList<AgentCard>();
        if (rahm != null) {
            relatedAgents = new ArrayList<AgentCard>(rahm.keySet());
        }
        return relatedAgents;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2);
    }

    public int compare(Object e1, Object e2) {
        int returnValue = 0;
        String p1Str = "";
        String p2Str = "";
        String[] p1_item = (String[])e1;
        String[] p2_item = (String[])e2;
        if (this.column == COL_POLICY_TYPE) {
            p1Str = p1_item[0];
            p2Str = p2_item[0];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_POLICY_NAME) {
            p1Str = p1_item[1];
            p2Str = p2_item[1];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_VERSION) {
            p1Str = p1_item[2];
            p2Str = p2_item[2];
            returnValue = p1Str.compareTo(p2Str);
        } else if (this.column == COL_GROUP) {
            p1Str = p1_item[3];
            p2Str = p2_item[3];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_APPLICATION) {
            p1Str = p1_item[4];
            p2Str = p2_item[4];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_TYPE) {
            p1Str = p1_item[5];
            p2Str = p2_item[5];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_PATH) {
            p1Str = p1_item[6];
            p2Str = p2_item[6];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_RELATED_ASN) {
            p1Str = p1_item[7];
            p2Str = p2_item[7];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_RELATED_AGENTS) {
            p1Str = p1_item[8];
            p2Str = p2_item[8];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        }
        if (this.dir == 1024) {
            returnValue *= -1;
        }
        return returnValue;
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this);
    }

    public boolean equals(Object a, Object b) {
        if (a instanceof GroupTreeObjectLast && b instanceof GroupTreeObjectLast) {
            return a == null ? b == null : ((GroupTreeObjectLast)a).getName().equals(((GroupTreeObjectLast)b).getName());
        }
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        if (element instanceof GroupTreeObjectLast) {
            return ((GroupTreeObjectLast)element).getName().hashCode();
        }
        return element.hashCode();
    }
}

