/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.policies;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PolicySearchTableProvider
extends ViewerSorter
implements IElementComparer,
Comparator,
IStructuredContentProvider {
    private ArrayList<String[]> m_elements = null;
    private Map<String, String> m_result = null;
    private Map<String, List<String[]>> m_elements_allResult = new HashMap<String, List<String[]>>();
    private Map<String, String[]> m_policyDetails = null;
    private String column = "Name";
    private int dir = 128;
    public static final String REFRESH = "REFRESH";
    public static final String COL_POLICY_TYPE = "Type";
    public static final String COL_POLICY_NAME = "Name";
    public static final String COL_VERSION = "Version";
    public static final String COL_MATCHES_MAIN_PROPS = "Results in Main Properties";
    public static final String COL_MATCHES_COND_PROPS = "Results in Condition Properties";
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            StringBuffer html = new StringBuffer();
            if (element instanceof String[]) {
                String[] item = (String[])element;
                String polType = item[0];
                if (polType.equals(BMUI.type_mon)) {
                    polType = "Monitor";
                } else if (polType.equals(BMUI.type_msg)) {
                    polType = "Indication";
                }
                String polName = item[1];
                StringBuffer mainProps = new StringBuffer();
                StringBuffer condProps = new StringBuffer();
                List list = (List)PolicySearchTableProvider.this.m_elements_allResult.get(polName);
                for (String[] match : list) {
                    if (match.length == 3) {
                        String propName = match[2];
                        mainProps.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(propName).append("<br>");
                        continue;
                    }
                    if (match.length != 5) continue;
                    String condID = match[2];
                    String condDesc = match[3];
                    String propName = match[4];
                    condProps.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(condID).append(" ").append(condDesc).append(" (").append(propName).append(")<br>");
                }
                html.append("<html><body bgcolor='#FFFFE1'>").append("<table border='0' cellspacing='0' cellpadding='0'>").append("<tr valign='top'>").append("<td nowrap><font face='Arial' size='1' color='#000000'>Name:&nbsp;&nbsp;&nbsp;&nbsp;</font></td>").append("<td nowrap><font face='Arial' size='1' color='#000000'><b>" + polName + "</b></font></td>").append("</tr>").append("<tr valign='top'>").append("<td nowrap><font face='Arial' size='1' color='#000000'>Type:</font></td>").append("<td nowrap><font face='Arial' size='1' color='#000000'><b>" + polType + "</b></font></td>").append("</tr>").append("</table>").append("<table border='0' cellspacing='0' cellpadding='0'>").append("<tr valign='top'>").append("<td colspan='2' nowrap><font face='Arial' size='1' color='#000000'>Result in MainProps:</font></td>").append("</tr>").append("<tr valign='top'>");
                if (mainProps.length() > 0) {
                    html.append("<td colspan='2' nowrap><font face='Arial' size='1' color='#000000'><b>" + mainProps.toString() + "</b></font></td>");
                } else {
                    html.append("<td colspan='2' nowrap><font face='Arial' size='1' color='#000000'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-</font></td>");
                }
                html.append("</tr>").append("<tr valign='top'>").append("<td colspan='2' nowrap><font face='Arial' size='1' color='#000000'>Result in CondProps:</font></td>").append("</tr>").append("<tr valign='top'>");
                if (condProps.length() > 0) {
                    html.append("<td colspan='2' nowrap><font face='Arial' size='1' color='#000000'><b>" + condProps.toString() + "</b></font></td>");
                } else {
                    html.append("<td colspan='2' nowrap><font face='Arial' size='1' color='#000000'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-</font></td>");
                }
                html.append("</tr>");
                html.append("</table>").append("</body></html>");
            }
            return html.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }

        public void update(ViewerCell cell) {
            String result = "";
            Image image = null;
            String[] item = null;
            int columnIndex = cell.getColumnIndex();
            if (!(cell.getElement() instanceof String[])) {
                return;
            }
            item = (String[])cell.getElement();
            switch (columnIndex) {
                case 0: {
                    String type = item[0];
                    if (type.equals(BMUI.type_mon)) {
                        image = BMUI.IMAGE_MON;
                        break;
                    }
                    if (!type.equals(BMUI.type_msg)) break;
                    image = BMUI.IMAGE_MSG;
                    break;
                }
                case 1: {
                    result = item[1];
                    break;
                }
                case 2: {
                    result = item[2];
                    break;
                }
                case 3: {
                    result = item[3];
                    break;
                }
                case 4: {
                    result = item[4];
                    break;
                }
                case 5: {
                    break;
                }
            }
            if (result == null) {
                result = "";
            }
            cell.setText(result);
            cell.setImage(image);
        }
    };

    public PolicySearchTableProvider(Map<String, String> searchResult) {
        this.setResult(searchResult);
        this.m_elements = new ArrayList();
        this.m_elements_allResult = new HashMap<String, List<String[]>>();
    }

    public void setConfig(String column, int direction) {
        this.column = column;
        this.dir = direction;
    }

    public void setResult(Map<String, String> searchResult) {
        this.m_result = searchResult;
        this.m_elements = new ArrayList();
    }

    public void createTableItems() {
        this.m_elements.clear();
        this.m_elements_allResult.clear();
        if (this.m_result != null && this.m_result.size() > 0) {
            for (String str : this.m_result.keySet()) {
                List<Object> l;
                String[] result = str.split("\u25ba");
                String[] allResults = null;
                String polType = "";
                String polName = "";
                if (result.length == 3) {
                    polType = result[0];
                    polName = result[1];
                    String mainPropName = result[2];
                    allResults = new String[]{polType, polName, mainPropName};
                } else if (result.length == 5) {
                    polType = result[0];
                    polName = result[1];
                    String condID = result[2];
                    String condDesc = result[3];
                    String condPropName = result[4];
                    allResults = new String[]{polType, polName, condID, condDesc, condPropName};
                }
                if (this.m_elements_allResult.containsKey(polName)) {
                    l = this.m_elements_allResult.get(polName);
                    l.add(allResults);
                    continue;
                }
                l = new LinkedList<String[]>();
                l.add(allResults);
                this.m_elements_allResult.put(polName, l);
            }
        }
        this.getPolicyDetails();
        StringBuffer sb1 = null;
        StringBuffer sb2 = null;
        Iterator<String> it2 = this.m_elements_allResult.keySet().iterator();
        while (it2.hasNext()) {
            int mainPropsCount = 0;
            int condPropsCount = 0;
            sb1 = new StringBuffer();
            sb2 = new StringBuffer();
            String polType = "";
            String polName = it2.next();
            if (polName == null || "".equals(polName)) continue;
            String polVersion = this.getPolicyVersion(polName);
            List<String[]> searchResult = this.m_elements_allResult.get(polName);
            for (String[] matches : searchResult) {
                if (matches == null || matches.length == 0) continue;
                polType = matches[0];
                if (matches.length == 3) {
                    if (mainPropsCount < 4) {
                        String propName = matches[2];
                        if (sb1.length() > 0) {
                            sb1.append(" | ");
                        }
                        sb1.append(propName);
                    } else if (mainPropsCount == 4) {
                        sb1.append(" | ").append("...");
                    }
                    ++mainPropsCount;
                    continue;
                }
                if (matches.length != 5) continue;
                if (condPropsCount < 4) {
                    String condDesc = matches[3];
                    String propName = matches[4];
                    if (sb2.length() > 0) {
                        sb2.append(" | ");
                    }
                    sb2.append(condDesc).append(" (").append(propName).append(")");
                } else if (condPropsCount == 4) {
                    sb2.append(" | ").append("...");
                }
                ++condPropsCount;
            }
            String[] props4Table = new String[]{polType, polName, polVersion, sb1.toString(), sb2.toString()};
            this.m_elements.add(props4Table);
        }
    }

    private void getPolicyDetails() {
        try {
            PolicyView.getInstance();
            this.m_policyDetails = PolicyView.m_policyOverviewTab.m_policyTableProvider.getPolicyDetails();
        }
        catch (Exception exception) {
            this.m_policyDetails = new HashMap<String, String[]>();
        }
    }

    public String getPolicyVersion(String polName) {
        String[] arr;
        String version = "";
        if (this.m_policyDetails != null && (arr = this.m_policyDetails.get(polName)) != null && arr.length > 0) {
            version = arr[0];
        }
        return version;
    }

    public int getPolicyCount() {
        return this.m_elements.size();
    }

    public Object[] getElements(Object inputElement) {
        this.createTableItems();
        return this.m_elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public int compare(Object e1, Object e2) {
        int returnValue = 0;
        String p1Str = "";
        String p2Str = "";
        String[] p1_item = (String[])e1;
        String[] p2_item = (String[])e2;
        if (this.column == COL_POLICY_TYPE) {
            p1Str = p1_item[0];
            p2Str = p2_item[0];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_POLICY_NAME) {
            p1Str = p1_item[1];
            p2Str = p2_item[1];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_VERSION) {
            p1Str = p1_item[2];
            p2Str = p2_item[2];
            returnValue = p1Str.compareTo(p2Str);
        } else if (this.column == COL_MATCHES_MAIN_PROPS) {
            p1Str = p1_item[3];
            p2Str = p2_item[3];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        } else if (this.column == COL_MATCHES_COND_PROPS) {
            p1Str = p1_item[4];
            p2Str = p2_item[4];
            returnValue = p1Str.compareToIgnoreCase(p2Str);
        }
        if (this.dir == 1024) {
            returnValue *= -1;
        }
        return returnValue;
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this);
    }

    public boolean equals(Object a, Object b) {
        if (a instanceof GroupTreeObjectLast && b instanceof GroupTreeObjectLast) {
            return a == null ? b == null : ((GroupTreeObjectLast)a).getName().equals(((GroupTreeObjectLast)b).getName());
        }
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        if (element instanceof GroupTreeObjectLast) {
            return ((GroupTreeObjectLast)element).getName().hashCode();
        }
        return element.hashCode();
    }
}

