/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.policies;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.IColorer;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.ExportMPIView;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.shared.notify.NovelConfig;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ViewLabelProvider
extends LabelProvider
implements IColorProvider {
    private IColorer m_colorer = null;
    private String m_treeType = null;

    public ViewLabelProvider(IColorer colorer, TreeViewer treeViewer) {
        this.m_colorer = colorer;
        if (treeViewer != null) {
            this.m_treeType = (String)treeViewer.getData(AssignmentListView.TREE_VIEWER_TYPE);
        }
    }

    public String getText(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof GroupTreeObject) {
            if (this.m_treeType != null) {
                if (this.m_treeType.equals(AssignmentListView.ASSIGNMENT_LIST) || this.m_treeType.equals(ExportMPIView.ASSIGNMENT) || this.m_treeType.equals(ExportMPIView.ASSIGNMENT_4EXPORT)) {
                    GroupTreeObject gto = (GroupTreeObject)obj;
                    if (gto.getType().equals(BMUI.type_toplevel) && gto.getName().equals("Assignments")) {
                        return "Assignment Groups";
                    }
                } else if (this.m_treeType.equals(PolicyListView.POLICY_LIST) && obj instanceof GroupTreeObjectUnsubmitted) {
                    GroupTreeObjectUnsubmitted gtou = (GroupTreeObjectUnsubmitted)obj;
                    String current_name = gtou.getAttribute(PolicyManager.CURRENT_NAME);
                    if (current_name == null) {
                        Map<String, CTabItem> openTabs = PolicyView.getInstance().getTabList();
                        for (CTabItem cTab : openTabs.values()) {
                            AbstractPolicyTab tab;
                            GroupTreeObjectLast gtol = null;
                            if (cTab instanceof MonitorPolicyTab) {
                                tab = (MonitorPolicyTab)cTab;
                                gtol = PolicyManager.getInstance().getPolicyTree().findElement(tab.getPolicyNameUnsubmitted(), BMUI.type_mon);
                                if (gtol == null || !gtol.equals(gtou)) continue;
                                current_name = ((MonitorPolicyTab)tab).m_policy.getName();
                                break;
                            }
                            if (!(cTab instanceof FilterPolicyTab)) continue;
                            tab = (FilterPolicyTab)cTab;
                            gtol = PolicyManager.getInstance().getPolicyTree().findElement(tab.getPolicyNameUnsubmitted(), BMUI.type_msg);
                            if (gtol == null || !gtol.equals(gtou)) continue;
                            current_name = ((FilterPolicyTab)tab).m_policy.getName();
                            break;
                        }
                    }
                    if (current_name != null && !current_name.equals(gtou.getName())) {
                        return current_name;
                    }
                }
            } else if (obj instanceof GroupTreeObjectLast) {
                NovelConfig nc;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                if ("agt".equals(gtol.getType()) && gtol.getTreeObject() instanceof AgentCard) {
                    return gtol.getTreeObject().toString();
                }
                if (gtol.getTreeObject() != null && gtol.getTreeObject().getObject() instanceof NovelConfig && (nc = (NovelConfig)gtol.getTreeObject().getObject()) != null && nc.getNotifierStatus() != null && !nc.getNotifierStatus().isStarted()) {
                    return String.valueOf(obj.toString()) + "   (Not Running!)";
                }
            }
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        String imageKey = "";
        boolean modifyRestricted = false;
        if (obj instanceof GroupTreeObject) {
            GroupTreeObject gt = (GroupTreeObject)obj;
            String path = gt.getPath();
            if (path.startsWith("/root/Assignments")) {
                if (!PolicyManager.getInstance().isPermittedPGAModify(gt)) {
                    modifyRestricted = true;
                }
            } else if (!(!path.startsWith("/root/Policies") || PolicyManager.getInstance().isPermittedPolicyModify(gt) && PolicyManager.getInstance().isPermittedPolicyRead(gt))) {
                modifyRestricted = true;
            }
            if (obj instanceof GroupTreeObjectUnsubmitted) {
                imageKey = "IMG_TOOL_NEW_WIZARD";
            } else if (obj instanceof GroupTreeObjectLast) {
                Image iconLock;
                GroupTreeObjectLast g = (GroupTreeObjectLast)obj;
                String iconName = g.getIcon();
                Image icon = BMUI.IMAGE_MAP.get(iconName);
                if (modifyRestricted && (iconLock = BMUI.IMAGE_MAP.get(String.valueOf(iconName) + '-')) != null) {
                    return iconLock;
                }
                if (icon != null) {
                    return icon;
                }
                imageKey = "IMG_OBJ_FILE";
            } else if (obj instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)obj;
                String type = gto.getTreeObject().getType();
                if (type != null) {
                    Image iconLock;
                    Image icon = BMUI.IMAGE_MAP.get(type);
                    if (modifyRestricted && (iconLock = BMUI.IMAGE_MAP.get(String.valueOf(type) + '-')) != null) {
                        return iconLock;
                    }
                    if (icon != null) {
                        return icon;
                    }
                }
                return BMUI.IMAGE_FOLDER_DEFAULT;
            }
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }

    public void dispose() {
    }

    public Color getBackground(Object element) {
        if (this.m_colorer != null) {
            return this.m_colorer.getBackground(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.m_colorer != null) {
            return this.m_colorer.getForeground(element);
        }
        return null;
    }
}

