/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.policies;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.IColorer;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.ExportMPIView;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ViewLabelProviderMPIExport
extends LabelProvider
implements IColorProvider {
    private IColorer m_colorer = null;
    private String m_treeType = null;
    private Map<String, List<GroupTreeObject>> m_conflicts = null;

    public ViewLabelProviderMPIExport(IColorer colorer, TreeViewer treeViewer) {
        this.m_colorer = colorer;
        this.m_treeType = (String)treeViewer.getData(ExportMPIView.TREE_VIEWER_TYPE);
    }

    public ViewLabelProviderMPIExport(IColorer colorer, TreeViewer treeViewer, Map<String, List<GroupTreeObject>> conflicts) {
        this.m_colorer = colorer;
        this.m_treeType = (String)treeViewer.getData(ExportMPIView.TREE_VIEWER_TYPE);
        this.m_conflicts = conflicts;
    }

    public String getText(Object obj) {
        GroupTreeObject gto;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof GroupTreeObject && this.m_treeType != null && (this.m_treeType.equals(AssignmentListView.ASSIGNMENT_LIST) || this.m_treeType.equals(ExportMPIView.ASSIGNMENT) || this.m_treeType.equals(ExportMPIView.ASSIGNMENT_4EXPORT)) && (gto = (GroupTreeObject)obj).getType().equals(BMUI.type_toplevel) && gto.getName().equals("Assignments")) {
            return "Assignment Groups";
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        String imageKey = "";
        if (obj instanceof GroupTreeObjectUnsubmitted) {
            imageKey = "IMG_TOOL_NEW_WIZARD";
        } else if (obj instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
            String iconName = gtol.getIcon();
            Image icon = BMUI.IMAGE_MAP.get(iconName);
            if (icon != null) {
                return icon;
            }
            imageKey = "IMG_OBJ_FILE";
        } else if (obj instanceof GroupTreeObject) {
            Image icon;
            GroupTreeObject gto = (GroupTreeObject)obj;
            String type = gto.getTreeObject().getType();
            if (type != null && (icon = BMUI.IMAGE_MAP.get(type)) != null) {
                return icon;
            }
            return BMUI.IMAGE_FOLDER_DEFAULT;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }

    public void dispose() {
    }

    public Color getBackground(Object element) {
        GroupTreeObjectLast gtol;
        if (element == null || this.m_treeType == null) {
            return null;
        }
        if (this.m_treeType.equals(ExportMPIView.ASSIGNMENT_4EXPORT) && element instanceof GroupTreeObjectLast && (gtol = (GroupTreeObjectLast)element).isItLink() && !gtol.isLinkOK()) {
            return BMUI.color_light_red;
        }
        if (this.m_treeType.equals(ExportMPIView.BINARY_4EXPORT) && this.m_conflicts != null && this.m_conflicts.containsKey(this.m_treeType) && element instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)element;
            List<GroupTreeObject> cList = this.m_conflicts.get(this.m_treeType);
            if (cList.contains(gto)) {
                return BMUI.color_light_red;
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.m_colorer != null) {
            return this.m_colorer.getForeground(element);
        }
        return null;
    }
}

