/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.policies.ViewLabelProviderMPIExport;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ActionSettings
implements SelectionListener,
ISelectionChangedListener,
IDoubleClickListener {
    private GroupTreeObject m_actRoot = null;
    private GroupTreeObject m_actFavRoot = null;
    private STreeViewer m_tv_act = null;
    private TreeViewer m_tv_actFav = null;
    private GUIDisplayElements m_gui = new GUIDisplayElements();
    private FormToolkit m_toolkit = BMUI.getFormToolkit(Display.getCurrent());
    private static GridData m_gd_tree = new GridData(4, 4, true, true);
    private Button m_add_btn = null;
    private Button m_remove_btn = null;
    private Composite m_selCountComp = null;
    private Label m_selCountLabel = null;
    private Composite m_fastActionCountComp = null;
    private Label m_fastActionCountLabel = null;
    public static String TREE_VIEWER_TYPE;
    public static String ACTION;
    public static String ACTION_FAVORITS;
    public static String ADD_ACTION_BTN;
    public static String REMOVE_ACTION_BTN;
    private Button m_btn_apply = null;
    private static String BTN_APPLY;
    private List<String> m_actionFavorites = null;
    public static final int MAX_NUM_OF_FAST_ACTION = 15;

    static {
        ActionSettings.m_gd_tree.heightHint = 200;
        ActionSettings.m_gd_tree.widthHint = 150;
        TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
        ACTION = "ACTION";
        ACTION_FAVORITS = "ACTION_FAVORITS";
        ADD_ACTION_BTN = "ADD_ACTTION_BTN";
        REMOVE_ACTION_BTN = "REMOVE_ACTTION_BTN";
        BTN_APPLY = "BTN_APPLY";
    }

    public void createSection(Composite parent) {
        GridLayout gl;
        this.m_actionFavorites = UISettings.getInstance().getActionSettings();
        Composite mainComposite = this.m_toolkit.createComposite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(3, false));
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_gui.addTextField(mainComposite, null, "Agent Actions: ", 2, 1, 0, 0, null);
        this.m_gui.addTextField(mainComposite, null, "Fast Actions: ", 1, 1, 0, 0, null);
        if (Repository.getInstance().getRights(1007) > 1) {
            this.m_tv_act = new STreeViewer(mainComposite, 268438274);
            this.m_tv_act.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_act.setData(TREE_VIEWER_TYPE, ACTION);
            this.m_tv_act.setUseHashlookup(true);
            this.m_tv_act.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_act.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
            this.m_actRoot = this.createActionTree();
            this.m_tv_act.setInput(this.m_actRoot);
            this.m_tv_act.expandToLevel(1);
            this.m_tv_act.addSelectionChangedListener(this);
            this.m_tv_act.addDoubleClickListener(this);
            Composite btnComp = new Composite(mainComposite, 0);
            btnComp.setLayout((Layout)new GridLayout(1, false));
            btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.m_add_btn = this.m_gui.addButton(btnComp, ADD_ACTION_BTN, " >> ", false, 120, 10, 1, 0, this);
            this.m_remove_btn = this.m_gui.addButton(btnComp, REMOVE_ACTION_BTN, " << ", false, 120, 10, 1, 0, this);
            this.m_tv_actFav = new STreeViewer(mainComposite, 268438274);
            this.m_tv_actFav.getTree().setLayoutData((Object)m_gd_tree);
            this.m_tv_actFav.setData(TREE_VIEWER_TYPE, (Object)ACTION_FAVORITS);
            this.m_tv_actFav.setUseHashlookup(true);
            this.m_tv_actFav.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv_actFav.setLabelProvider((IBaseLabelProvider)new ViewLabelProviderMPIExport(null, this.m_tv_actFav));
            this.m_actFavRoot = this.createActionFavoriteTree();
            this.m_tv_actFav.setInput((Object)this.m_actFavRoot);
            this.m_tv_actFav.addSelectionChangedListener((ISelectionChangedListener)this);
            this.m_tv_actFav.addDoubleClickListener((IDoubleClickListener)this);
            this.m_selCountComp = new Composite(mainComposite, 0);
            gl = new GridLayout(1, false);
            gl.horizontalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.m_selCountComp.setLayout((Layout)gl);
            this.m_selCountComp.setLayoutData((Object)new GridData(4, 1024, true, false));
            this.m_selCountLabel = this.m_gui.addTextField(this.m_selCountComp, null, "Selected: 0", 1, 1, 0, 0, null);
            this.m_gui.addTextField(mainComposite, null, "", 1, 1, 0, 0, null);
            this.m_fastActionCountComp = new Composite(mainComposite, 0);
            gl = new GridLayout(2, false);
            gl.horizontalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.m_fastActionCountComp.setLayout((Layout)gl);
            this.m_fastActionCountComp.setLayoutData((Object)new GridData(4, 1024, true, false));
            this.m_fastActionCountLabel = this.m_gui.addTextField(this.m_fastActionCountComp, null, "Fast-Actions: " + this.m_actFavRoot.getAllGTOLs().size(), 1, 1, 0, 0, null);
            ((GridData)this.m_fastActionCountLabel.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_fastActionCountLabel.getLayoutData()).grabExcessHorizontalSpace = true;
            Label max_label = this.m_gui.addTextField(this.m_fastActionCountComp, null, "(max 15)", 1, 1, 0, 0, null);
            max_label.setAlignment(131072);
            ((GridData)max_label.getLayoutData()).horizontalAlignment = 131072;
        }
        Composite compFooter = new Composite(parent, 0);
        gl = new GridLayout(1, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compFooter.setLayout((Layout)gl);
        compFooter.setLayoutData((Object)new GridData(131072, 1024, true, true));
        this.m_btn_apply = this.m_gui.addButton(compFooter, BTN_APPLY, " Apply ", true, 80, 60, 0, this);
        this.m_btn_apply.setToolTipText("Apply Changes");
        this.m_btn_apply.setLayoutData((Object)new GridData(4, 1024, false, false));
        parent.layout(true);
    }

    public GroupTreeObject createActionTree() {
        GroupTreeObject actionTreeCloned = null;
        try {
            actionTreeCloned = Repository.getInstance().getActionTree((Viewer)this.m_tv_act).clone();
            List<GroupTreeObject> groups = actionTreeCloned.getAllGroups();
            for (GroupTreeObject gto : groups) {
                List<GroupTreeObjectLast> actionList = gto.getAllGTOLs();
                for (GroupTreeObjectLast gtol : actionList) {
                    Action action = this.getActionObject(gtol);
                    if (!action.m_serverAction) continue;
                    gtol.getParent().removeElement(gtol);
                }
            }
            for (GroupTreeObject gto : groups) {
                if (gto.hasElements().booleanValue()) continue;
                gto.getParent().removeElement(gto);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return actionTreeCloned;
    }

    private Action getActionObject(GroupTreeObjectLast gtol) {
        Object o = gtol.getTreeObject().getObject();
        if (o instanceof Action) {
            return (Action)o;
        }
        return null;
    }

    public GroupTreeObject createActionFavoriteTree() {
        GroupTreeObject root = new GroupTreeObject(new TreeObject("Actions", BMUI.type_folder, null));
        for (GroupTreeObjectLast gtol : this.m_actRoot.getAllGTOLs()) {
            Object o = gtol.getTreeObject().getObject();
            if (o == null || !(o instanceof Action)) continue;
            Action action = (Action)o;
            if (!this.m_actionFavorites.contains(action.m_ID)) continue;
            try {
                GroupTreeObject parent = root.getChild(gtol.getParent().getName(), "");
                if (parent == null) {
                    parent = new GroupTreeObject(new TreeObject(gtol.getParent().getName(), gtol.getParent().getType(), null));
                    root.addElement(parent);
                    parent.addElement(gtol.clone());
                    continue;
                }
                if (parent.findElement(gtol.getName(), gtol.getType()) != null) continue;
                parent.addElement(gtol.clone());
            }
            catch (CloneNotSupportedException e) {
                RTLogger.print(5, "UI Settings: Error cloning/adding element to Fast-Action tree: " + gtol.getName(), e);
            }
        }
        return root;
    }

    public void processAddToFavorites() {
        if (this.m_tv_act == null || this.m_tv_actFav == null || this.m_actFavRoot == null) {
            RTLogger.print(5, "UI Settings: Error proccessing AddToFavorites. ");
            return;
        }
        StructuredSelection ssel = (StructuredSelection)this.m_tv_act.getSelection();
        if (ssel == null || ssel.isEmpty()) {
            return;
        }
        boolean maxNumReached = false;
        if (this.getNumberOfFastActions() < 15) {
            for (GroupTreeObject gto : ssel) {
                if (!(!(gto instanceof GroupTreeObjectLast) ? (maxNumReached = this.addElementGto(gto)) : (maxNumReached = this.addElementGtol((GroupTreeObjectLast)gto)))) {
                    continue;
                }
                break;
            }
        } else {
            maxNumReached = true;
        }
        if (maxNumReached) {
            new ShowMessageBox("Adding Fast-Actions", "You have reached the Maximum number of 15 Fast-Actions!", 2);
        }
        this.refreshTree(this.m_tv_actFav, this.m_actFavRoot);
    }

    public boolean addElementGto(GroupTreeObject actionGroupGTO) {
        boolean maxNumReached = false;
        if (actionGroupGTO == null) {
            return maxNumReached;
        }
        if (this.getNumberOfFastActions() >= 15) {
            return true;
        }
        GroupTreeObject existingActionGroup = this.m_actFavRoot.searchPath(actionGroupGTO.getPath(), actionGroupGTO.getType());
        if (existingActionGroup == null) {
            GroupTreeObject actionGroupGto = new GroupTreeObject(new TreeObject(actionGroupGTO.getName(), actionGroupGTO.getType(), null));
            this.m_actFavRoot.addElement(actionGroupGto);
        }
        for (GroupTreeObjectLast action : actionGroupGTO.getAllGTOLs()) {
            maxNumReached = this.addElementGtol(action);
            if (maxNumReached) break;
        }
        return maxNumReached;
    }

    public boolean addElementGtol(GroupTreeObjectLast actionGTOL) {
        boolean maxNumReached = false;
        if (actionGTOL == null) {
            return maxNumReached;
        }
        Object o = actionGTOL.getTreeObject().getObject();
        if (o == null || !(o instanceof Action)) {
            return maxNumReached;
        }
        Action action = (Action)o;
        if (this.getNumberOfFastActions() >= 15) {
            return true;
        }
        if (this.m_actionFavorites.contains(action.m_ID)) {
            return maxNumReached;
        }
        GroupTreeObject existingParent = this.m_actFavRoot.searchPath(actionGTOL.getParentPath(), actionGTOL.getParent().getType());
        GroupTreeObject existingGTO = this.m_actFavRoot.searchPath(actionGTOL.getPath(), actionGTOL.getType());
        if (existingParent == null) {
            try {
                GroupTreeObject actionGroupGto = new GroupTreeObject(new TreeObject(actionGTOL.getParent().getName(), actionGTOL.getParent().getType(), null));
                this.m_actFavRoot.addElement(actionGroupGto);
                actionGroupGto.addElement(actionGTOL.clone());
                this.m_actionFavorites.add(action.m_ID);
            }
            catch (CloneNotSupportedException e) {
                RTLogger.print(5, "Error cloning element " + actionGTOL.getName(), e);
            }
        } else if (existingGTO == null) {
            try {
                GroupTreeObjectLast clone = actionGTOL.clone();
                if (clone != null) {
                    existingParent.addElement(clone);
                    this.m_actionFavorites.add(action.m_ID);
                }
            }
            catch (CloneNotSupportedException e) {
                RTLogger.print(5, "Error cloning element " + actionGTOL.getName(), e);
            }
        }
        return maxNumReached;
    }

    public void processRemoveFromFavorits() {
        if (this.m_tv_actFav == null || this.m_actFavRoot == null) {
            RTLogger.print(5, "UI Settings: Error proccessing RemoveFromFavorites. ");
            return;
        }
        StructuredSelection ssel = (StructuredSelection)this.m_tv_actFav.getSelection();
        if (ssel == null || ssel.isEmpty()) {
            return;
        }
        for (GroupTreeObject gto : ssel) {
            if (gto instanceof GroupTreeObjectLast) {
                this.removeElementGtol((GroupTreeObjectLast)gto);
                continue;
            }
            this.removeElementGto(gto);
        }
        this.refreshTree(this.m_tv_actFav, this.m_actFavRoot);
    }

    private void removeElementGto(GroupTreeObject actionGroupGTO) {
        for (GroupTreeObjectLast gtol : actionGroupGTO.getAllGTOLs()) {
            this.removeElementGtol(gtol);
        }
    }

    private void removeElementGtol(GroupTreeObjectLast actionGTOL) {
        Object o;
        GroupTreeObject actionGroupGTOL = actionGTOL.getParent();
        actionGroupGTOL.removeElement(actionGTOL);
        if (!actionGroupGTOL.hasElements().booleanValue()) {
            actionGroupGTOL.getParent().removeElement(actionGroupGTOL);
        }
        if ((o = actionGTOL.getTreeObject().getObject()) == null || !(o instanceof Action)) {
            return;
        }
        Action action = (Action)o;
        this.m_actionFavorites.remove(action.m_ID);
    }

    public void actionTreeFreshLoad() {
        this.m_actRoot = Repository.getInstance().getActionTree((Viewer)this.m_tv_act);
    }

    public void refreshTree(TreeViewer tv, GroupTreeObject root) {
        if (tv == null || root == null) {
            return;
        }
        Object[] expanded = tv.getExpandedElements();
        tv.setInput((Object)root);
        if (expanded == null || expanded.length == 0) {
            tv.expandToLevel(0);
        } else {
            tv.setExpandedElements(expanded);
        }
        tv.refresh();
        this.updateFastActionCounter();
    }

    public void updateSelectionCounter() {
        if (this.m_selCountLabel != null && !this.m_selCountLabel.isDisposed()) {
            this.m_selCountLabel.setText("Total " + this.m_actFavRoot.getAllGTOLs().size());
            this.m_selCountComp.layout(true);
        }
    }

    public void updateFastActionCounter() {
        if (this.m_fastActionCountLabel != null && !this.m_fastActionCountLabel.isDisposed()) {
            this.m_fastActionCountLabel.setText("Total " + this.m_actFavRoot.getAllGTOLs().size());
            this.m_fastActionCountComp.layout(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button btn = (Button)e.getSource();
            String name = (String)btn.getData();
            if (name.equals(ADD_ACTION_BTN)) {
                this.processAddToFavorites();
            } else if (name.equals(REMOVE_ACTION_BTN)) {
                this.processRemoveFromFavorits();
            } else if (name.equals(BTN_APPLY)) {
                UISettings.getInstance().storeAndReload();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeViewer tv = (TreeViewer)event.getSource();
        String treeType = (String)tv.getData(TREE_VIEWER_TYPE);
        StructuredSelection ssel = (StructuredSelection)tv.getSelection();
        if (!ssel.isEmpty()) {
            if (treeType.equals(ACTION)) {
                this.m_selCountLabel.setText("Selected: " + ssel.size());
                this.m_selCountComp.pack();
                this.m_add_btn.setEnabled(true);
                this.m_remove_btn.setEnabled(false);
            } else if (treeType.equals(ACTION_FAVORITS)) {
                this.m_remove_btn.setEnabled(true);
                this.m_add_btn.setEnabled(false);
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        Viewer v = event.getViewer();
        if (v instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)v;
            StructuredSelection ssel = (StructuredSelection)event.getViewer().getSelection();
            if (ssel.size() == 1) {
                Object obj = ssel.getFirstElement();
                if (obj instanceof GroupTreeObjectLast) {
                    if (tv.getData(TREE_VIEWER_TYPE).equals(ACTION)) {
                        this.processAddToFavorites();
                    } else if (tv.getData(TREE_VIEWER_TYPE).equals(ACTION_FAVORITS)) {
                        this.processRemoveFromFavorits();
                    }
                } else if (obj instanceof GroupTreeObject) {
                    tv.setExpandedState((Object)((GroupTreeObject)obj), !tv.getExpandedState((Object)((GroupTreeObject)obj)));
                }
            }
        }
    }

    public static Action getActionFromRepo(String id) {
        GroupTreeObject actionTree = Repository.getInstance().m_actionRepository.getTree();
        for (GroupTreeObjectLast gtol : actionTree.getAllGTOLs()) {
            Object o = gtol.getTreeObject().getObject();
            if (o == null || !(o instanceof Action)) continue;
            Action action = (Action)o;
            if (!id.equals(action.m_ID)) continue;
            return action;
        }
        return null;
    }

    public int getNumberOfFastActions() {
        return this.m_actFavRoot.getAllGTOLs().size();
    }
}

