/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.Repository;
import com.blixx.ctrl.sc.in.ScPutFileFromString;
import com.blixx.log.RTLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class BrowserLabelManager {
    protected static BrowserLabelManager m_browserLabelManager = null;
    protected static String m_serverPath = "srv/etc/cfg/browserLabels";
    private String m_error = null;
    private TableViewer m_tv = null;
    protected static String LABEL = "LABEL";
    protected static String VALUE = "VALUE";
    private AtomicBoolean m_shutdown = new AtomicBoolean(false);
    private static Map<String, String> m_mapping = null;
    private static Map<String, String> m_mapping_default = new HashMap<String, String>();
    private static Map<String, String> m_tooltip;

    static {
        m_mapping_default.put("Severity", null);
        m_mapping_default.put("Duplicates", null);
        m_mapping_default.put("Time", null);
        m_mapping_default.put("Host", null);
        m_mapping_default.put("Application", null);
        m_mapping_default.put("Group", null);
        m_mapping_default.put("Object", null);
        m_mapping_default.put("Text", null);
        m_mapping_default.put("J", null);
        m_mapping_default.put("AA", null);
        m_mapping_default.put("!AV", null);
        m_mapping_default.put("^KPI", null);
        m_mapping_default.put("Agent", null);
        m_mapping_default.put("Source", null);
        m_mapping_default.put("SrvTime", null);
        m_mapping_default.put("ID", null);
        m_mapping_default.put("Owned", null);
        m_mapping_default.put("Notifications", null);
        m_mapping_default.put("O", null);
        m_mapping_default.put("CA1", null);
        m_mapping_default.put("CA2", null);
        m_mapping_default.put("CA3", null);
        m_mapping_default.put("CA4", null);
        m_mapping_default.put("CA5", null);
        m_mapping_default.put("CA6", null);
        m_mapping_default.put("CA7", null);
        m_mapping_default.put("CA8", null);
        m_mapping_default.put("CA9", null);
        m_mapping_default.put("CA10", null);
        m_mapping_default.put("CA11", null);
        m_mapping_default.put("CA12", null);
        m_mapping_default.put("CA13", null);
        m_mapping_default.put("CA14", null);
        m_mapping_default.put("CA15", null);
        m_mapping_default.put("SlaveServerName", null);
        m_mapping_default.put("AgentID", null);
        m_mapping_default.put("Key", null);
        m_tooltip = new HashMap<String, String>();
        m_tooltip.put("Severity", "Severity");
        m_tooltip.put("Duplicates", "Duplicates");
        m_tooltip.put("Time", "Time");
        m_tooltip.put("Host", "Host");
        m_tooltip.put("Application", "Application");
        m_tooltip.put("Group", "Group");
        m_tooltip.put("Object", "Object");
        m_tooltip.put("Text", "Text");
        m_tooltip.put("J", "Annotations");
        m_tooltip.put("AA", "AutoAction assigned");
        m_tooltip.put("!AV", "Availability Metric");
        m_tooltip.put("^KPI", "KPI Metric");
        m_tooltip.put("Agent", "Agent Hostname");
        m_tooltip.put("Source", "Source");
        m_tooltip.put("SrvTime", "SrvTime");
        m_tooltip.put("ID", "ID");
        m_tooltip.put("Owned", "Owned");
        m_tooltip.put("Notifications", "Notifications");
        m_tooltip.put("O", "Closed by Operator");
        m_tooltip.put("CA1", "Custom Attribute 1");
        m_tooltip.put("CA2", "Custom Attribute 2");
        m_tooltip.put("CA3", "Custom Attribute 3");
        m_tooltip.put("CA4", "Custom Attribute 4");
        m_tooltip.put("CA5", "Custom Attribute 5");
        m_tooltip.put("CA6", "Custom Attribute 6");
        m_tooltip.put("CA7", "Custom Attribute 7");
        m_tooltip.put("CA8", "Custom Attribute 8");
        m_tooltip.put("CA9", "Custom Attribute 9");
        m_tooltip.put("CA10", "Custom Attribute 10");
        m_tooltip.put("CA11", "Custom Attribute 11");
        m_tooltip.put("CA12", "Custom Attribute 12");
        m_tooltip.put("CA13", "Custom Attribute 13");
        m_tooltip.put("CA14", "Custom Attribute 14");
        m_tooltip.put("CA15", "Custom Attribute 15");
        m_tooltip.put("SlaveServerName", "Slave Server Name");
        m_tooltip.put("AgentID", "Agent ID");
        m_tooltip.put("Key", "Key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BrowserLabelManager getInstance() {
        if (m_browserLabelManager != null) return m_browserLabelManager;
        Class<BrowserLabelManager> clazz = BrowserLabelManager.class;
        synchronized (BrowserLabelManager.class) {
            if (m_browserLabelManager != null) return m_browserLabelManager;
            m_browserLabelManager = new BrowserLabelManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_browserLabelManager;
        }
    }

    public BrowserLabelManager() {
        m_mapping = new HashMap<String, String>();
    }

    public boolean store() {
        HashMap<String, String> new_mapping = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        TableItem[] items = this.m_tv.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem ti = items[i];
            if (i > 0) {
                sb.append("\n");
            }
            String name = ti.getText(0).trim();
            String label = ti.getText(1).trim();
            sb.append(name).append("=").append(label);
            new_mapping.put(name, label);
            ++i;
        }
        ScPutFileFromString scf = null;
        boolean success = false;
        try {
            scf = new ScPutFileFromString(Repository.getInstance(), m_serverPath, sb.toString());
            scf.run();
            if (scf.isSuccess()) {
                success = true;
                RTLogger.print(5, "Uploading FileFromString to " + m_serverPath);
            } else {
                RTLogger.print(5, "Error uploading FileFromString to " + m_serverPath);
            }
        }
        catch (Exception e) {
            success = false;
            RTLogger.print(5, "Error uploading FileFromString to " + m_serverPath, e);
        }
        if (success) {
            this.setMapping(new_mapping);
        }
        return success;
    }

    public void shutdown() {
        this.setShutdown(true);
    }

    public void setShutdown(boolean active) {
        this.m_shutdown.set(active);
    }

    public void setTableViewer(TableViewer tv) {
        this.m_tv = tv;
    }

    public void setMappingToDefault() {
        m_mapping = new HashMap<String, String>(m_mapping_default);
    }

    public void setMapping(Map<String, String> mapping) {
        m_mapping.clear();
        for (String colName : m_mapping_default.keySet()) {
            if (!mapping.containsKey(colName)) continue;
            String label = mapping.get(colName);
            m_mapping.put(colName, label == null ? "" : label);
        }
    }

    public Map<String, String> getMapping() {
        return m_mapping;
    }

    public Map<String, String> getDefaultMapping() {
        return m_mapping_default;
    }

    public String getServerPath() {
        return m_serverPath;
    }

    public String getLabel(String name) {
        String label = m_mapping.get(name);
        if (label == null || "".equals(label)) {
            label = name;
        }
        return label;
    }

    public String getName(String label) {
        String name = label;
        for (Map.Entry<String, String> en : m_mapping.entrySet()) {
            if (en.getValue() == null || !en.getValue().equals(label)) continue;
            name = en.getKey();
        }
        return name;
    }

    public String getToolTipShort(String colName) {
        return m_tooltip.get(colName);
    }

    public String getToolTipLong(String colName) {
        String tooltip = m_tooltip.get(colName);
        String label = this.getLabel(colName);
        if (!label.equals(colName)) {
            tooltip = String.valueOf(label) + " [" + tooltip + "]";
        }
        return tooltip;
    }

    public void setErrorMsg(String error) {
        this.m_error = error;
    }

    public String getErrorMsg() {
        return this.m_error;
    }
}

