/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.settings.IndicationBrowserSettings;
import com.blixx.boom.gui.settings.TblColumn;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogEditTableColSettings
extends StatusDialog
implements DisposeListener,
ModifyListener,
SelectionListener {
    private Composite m_comp = null;
    private Integer m_width = 20;
    private boolean m_coloringActive = false;
    private TblColumn m_tblCol = null;
    private String m_tableType = null;

    public DialogEditTableColSettings(Shell shell, TblColumn tblCol, String tableType) {
        super(shell);
        this.setShellStyle(this.getShellStyle());
        this.setTitle(" Column Settings");
        this.m_tblCol = tblCol;
        if (this.m_tblCol == null) {
            return;
        }
        this.m_tableType = tableType;
        this.m_width = this.m_tblCol.getWidth();
        this.m_coloringActive = UISettings.getInstance().IB_isBGColoringActive(this.m_tblCol.getName());
    }

    protected Control createDialogArea(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        this.m_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        gl.marginTop = 5;
        gl.marginLeft = 5;
        gl.marginRight = 5;
        this.m_comp.setLayout((Layout)gl);
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_comp.addDisposeListener((DisposeListener)this);
        gui.addTextReadOnlyNoBorder(this.m_comp, "Position:", "" + (this.m_tblCol.getPosition() + 1), 1, 1, 0, 0, BMUI.font_arial8_bold);
        gui.addTextReadOnlyNoBorder(this.m_comp, "Name:", this.m_tblCol.getName(), 1, 1, 0, 0, BMUI.font_arial8_bold);
        gui.addInputFieldSingle(this.m_comp, null, "Width: ", "" + this.m_width, 1, 1, 0, 0, 200, this);
        Composite comp = new Composite(this.m_comp, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, false, false, 2, 1);
        comp.setLayoutData((Object)gd);
        if (this.m_tableType.equals(IndicationBrowserSettings.TABLE_IB_CS)) {
            gui.addCheckbox(comp, null, "Activate background coloring", this.m_coloringActive, 1, 1, 0, this);
        }
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Composite comp = (Composite)super.createButtonBar(parent);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, false, false));
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Apply", true);
        this.getButton(0).setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
        this.getButton(1);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.m_tblCol.setWidth(this.m_width);
            this.m_tblCol.setColoringActive(this.m_coloringActive);
            super.okPressed();
        } else if (buttonId == 1) {
            super.cancelPressed();
        }
    }

    public void modifyText(ModifyEvent event) {
        Object o = event.getSource();
        if (o instanceof Text) {
            Text width_field = (Text)o;
            String text = width_field.getText().trim();
            int width = -1;
            try {
                width = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width > 0) {
                this.m_width = width;
                width_field.setBackground(null);
                this.getButton(0).setEnabled(true);
            } else {
                width_field.setBackground(BMUI.color_critical);
                width_field.setToolTipText("Invalid Value!");
                this.getButton(0).setEnabled(false);
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            this.m_coloringActive = ((Button)e.getSource()).getSelection();
            this.getButton(0).setEnabled(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

