/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.settings.DialogEditTableColSettings;
import com.blixx.boom.gui.settings.IndicationBrowserSettings;
import com.blixx.boom.gui.settings.PredefinedFilterDialog;
import com.blixx.boom.gui.settings.PredefinedTab;
import com.blixx.boom.gui.settings.SetColWidthAction;
import com.blixx.boom.gui.settings.TblColumn;
import com.blixx.boom.gui.settings.TblFilter;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.log.RTLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DialogEditTablePT
extends StatusDialog
implements DisposeListener,
ModifyListener,
SelectionListener {
    private DialogEditTablePT m_instance = null;
    private Shell m_parentShell = null;
    private PredefinedTab m_predefinedTab = null;
    private Composite m_comp = null;
    private CCombo m_viewID_cbo = null;
    private CCombo m_browserType_cbo = null;
    private Text m_tabName_field = null;
    private Button m_showActive_radio = null;
    private Button m_showClosed_radio = null;
    private Button m_allowToCloseTab_chb = null;
    private Table m_tbl = null;
    private Button m_btn_up = null;
    private Button m_btn_down = null;
    private Button m_btn_edit = null;
    private Button m_btn_reload = null;
    private Button m_btn_edit_filter = null;
    private boolean m_isNew = false;
    private boolean m_isCloseable = true;
    private boolean m_showActive = true;
    private String m_viewID = UISettings.MSG_VIEW1;
    private String m_tabName = "";
    private String m_col = "Time";
    private String m_dir = UISettings.DOWN;
    private int m_browserType = 0;
    public static String TABLE_PT_CS = "TABLE_PT_CS";
    private static String VIEW_ID = "VIEW_ID";
    private static String TAB_NAME = "TAB_NAME";
    private static String SHOW_ACTIVE = "SHOW_ACTIVE";
    private static String SHOW_CLOSED = "SHOW_CLOSED";
    private static String CLOSABLE = "CLOSABLE";
    private static String COL = "COL";
    private static String DIR = "DIR";
    private static String BROWSER_TYPE = "BROWSER_TYPE";
    private static String BTN_UP = "BTN_UP";
    private static String BTN_DOWN = "BTN_DOWN";
    private static String BTN_EDIT_COLSETTINGS = "BTN_EDIT_COLSETTINGS";
    private static String BTN_RELOAD = "BTN_RELOAD";
    private static String BTN_EDIT_FILTER = "BTN_EDIT_FILTER";
    private static String LIST_FILTERS = "LIST_FILTERS";
    private org.eclipse.swt.widgets.List m_filterList = null;
    private Map<String, EventFilter> m_filters = null;
    private List<TblColumn> m_colSorted_clones = null;
    private String[] m_colList4Combo_sorted = null;

    public DialogEditTablePT(Shell parentShell, PredefinedTab predefinedTab) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_parentShell = parentShell;
        this.m_instance = this;
        this.m_predefinedTab = predefinedTab;
        this.m_filters = new HashMap<String, EventFilter>();
        this.m_colSorted_clones = new ArrayList<TblColumn>();
        if (this.m_predefinedTab != null) {
            this.setTitle(" Edit Predefined Tab");
            this.m_isNew = false;
            this.m_viewID = this.m_predefinedTab.getViewID();
            this.m_isCloseable = this.m_predefinedTab.getClosable();
            this.m_tabName = this.m_predefinedTab.getName();
            this.m_showActive = this.m_predefinedTab.getShowActive();
            this.m_browserType = this.m_predefinedTab.getType();
            this.m_col = this.m_predefinedTab.getSortCol();
            if (this.m_col == null) {
                this.m_col = "Time";
            }
            this.m_dir = this.m_predefinedTab.getSortDir();
            if (this.m_dir == null) {
                this.m_dir = UISettings.DOWN;
            }
            List<TblColumn> colSorted = this.m_predefinedTab.getColumnsSorted();
            int i = 0;
            while (i < colSorted.size()) {
                TblColumn col = colSorted.get(i);
                TblColumn col_clone = col.clone(col);
                this.m_colSorted_clones.add(col_clone);
                ++i;
            }
            Map<String, TblFilter> filters = this.m_predefinedTab.getFilters();
            if (filters != null) {
                for (String name : filters.keySet()) {
                    TblFilter filter = filters.get(name);
                    EventFilter ef = new EventFilter(filter.getLabelOrName(), filter.getColumnName(), filter.getPattern(), filter.caseSensitive(), filter.getMode(), null, filter.isLocked(), filter.getAvailability(), filter.getKPIs(), filter.isNot());
                    this.m_filters.put(ef.toString(), ef);
                }
            }
        } else {
            this.setTitle(" Add Predefined Tab");
            this.m_isNew = true;
            this.m_colSorted_clones = IndicationBrowserSettings.getSetOfDefaultColumnsSorted();
        }
        this.m_colList4Combo_sorted = new String[EventStorageUtils.defaultColumnOrder.length];
        int[] defaultColOrder = EventStorageUtils.defaultColumnOrder;
        int i = 0;
        while (i < defaultColOrder.length) {
            int pos = i;
            int colID = defaultColOrder[i];
            for (String colName : EventStorageUtils.m_columnMap.keySet()) {
                int id = EventStorageUtils.m_columnMap.get(colName);
                if (colID != id) continue;
                this.m_colList4Combo_sorted[pos] = colName;
                break;
            }
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        this.m_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = 10;
        gl.marginLeft = 10;
        gl.marginRight = 10;
        gl.horizontalSpacing = 10;
        gl.horizontalSpacing = 10;
        this.m_comp.setLayout((Layout)gl);
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_comp.addDisposeListener((DisposeListener)this);
        this.m_tabName_field = gui.addInputFieldSingle(this.m_comp, TAB_NAME, "Name: ", this.m_tabName, 1, 1, 0, 0, 300, this);
        this.m_viewID_cbo = gui.addDropDown(this.m_comp, VIEW_ID, "ViewID: ", new String[]{UISettings.MSG_VIEW1, UISettings.MSG_VIEW2}, "com.blixx.boom.gui.views.msgview", "Select View", 1, 1, 0, 0, this);
        this.m_browserType_cbo = gui.addDropDown(this.m_comp, BROWSER_TYPE, "Browser Type: ", new String[]{"Normal", "Maintenance"}, this.m_browserType == 0 ? "Normal" : "Maintenance", "", 1, 1, 0, 0, this);
        ((GridData)this.m_browserType_cbo.getLayoutData()).horizontalAlignment = 1;
        Group showActiveClosed_grp = new Group(this.m_comp, 0);
        showActiveClosed_grp.setText("Show Indications");
        showActiveClosed_grp.setLayout((Layout)new GridLayout(2, false));
        showActiveClosed_grp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_showActive_radio = gui.addRadioButton((Composite)showActiveClosed_grp, SHOW_ACTIVE, "Show Active", this.m_showActive, 1, 1, 0, 0, this);
        this.m_showClosed_radio = gui.addRadioButton((Composite)showActiveClosed_grp, SHOW_CLOSED, "Show Closed", !this.m_showActive, 1, 1, 0, 0, this);
        Group sorting_grp = new Group(this.m_comp, 0);
        sorting_grp.setText("Table Sorting");
        sorting_grp.setLayout((Layout)new GridLayout(4, false));
        sorting_grp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        gui.addDropDown((Composite)sorting_grp, COL, "Column: ", this.m_colList4Combo_sorted, this.m_col, "", 1, 1, 0, 0, this);
        gui.addDropDown((Composite)sorting_grp, DIR, null, new String[]{UISettings.UP, UISettings.DOWN}, this.m_dir, "", 1, 1, 0, 0, this);
        this.m_allowToCloseTab_chb = gui.addCheckbox(this.m_comp, CLOSABLE, "Allow to close Tab", this.m_isCloseable, 2, 1, 0, this);
        Group grp_colSettings = new Group(this.m_comp, 4);
        grp_colSettings.setText("Column Settings");
        grp_colSettings.setLayout((Layout)new GridLayout(2, false));
        grp_colSettings.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_tbl = new Table((Composite)grp_colSettings, 68354);
        this.m_tbl.setHeaderVisible(true);
        this.m_tbl.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true, 1, 4);
        gd.widthHint = 350;
        gd.heightHint = 140;
        this.m_tbl.setLayoutData((Object)gd);
        this.m_tbl.setData((Object)TABLE_PT_CS);
        TableColumn col0 = new TableColumn(this.m_tbl, 0x1000000);
        col0.setText(IndicationBrowserSettings.POSITION);
        col0.setWidth(60);
        TableColumn col1 = new TableColumn(this.m_tbl, 16384);
        col1.setText("Name");
        col1.setWidth(170);
        TableColumn col2 = new TableColumn(this.m_tbl, 131072);
        col2.setText("Width");
        col2.setWidth(50);
        this.m_tbl.addSelectionListener((SelectionListener)this);
        TableViewer tv = new TableViewer(this.m_tbl);
        this.addContentMenu(tv);
        this.fillTable();
        if (this.m_tbl.getItemCount() > 0) {
            this.m_tbl.setSelection(0);
        }
        this.m_btn_up = gui.addButton((Composite)grp_colSettings, BTN_UP, "Up", false, 80, 60, 0, this);
        this.m_btn_up.setToolTipText("Move column one position up");
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 80;
        this.m_btn_up.setLayoutData((Object)gd);
        this.m_btn_down = gui.addButton((Composite)grp_colSettings, BTN_DOWN, "Down", false, 80, 60, 0, this);
        this.m_btn_down.setToolTipText("Move colum one position down");
        this.m_btn_down.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_edit = gui.addButton((Composite)grp_colSettings, BTN_EDIT_COLSETTINGS, " Edit... ", true, 80, 60, 0, this);
        this.m_btn_edit.setToolTipText("Edit column settings");
        this.m_btn_edit.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_reload = gui.addButton((Composite)grp_colSettings, BTN_RELOAD, " Reload ", true, 80, 60, 0, this);
        this.m_btn_reload.setToolTipText("Reload column settings");
        this.m_btn_reload.setLayoutData((Object)new GridData(4, 128, false, true));
        Group grp_filters = new Group(this.m_comp, 4);
        grp_filters.setText("Filters");
        grp_filters.setLayout((Layout)new GridLayout(2, false));
        grp_filters.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_filterList = new org.eclipse.swt.widgets.List((Composite)grp_filters, 2560);
        this.m_filterList.setData((Object)LIST_FILTERS);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        gd.heightHint = 90;
        this.m_filterList.setLayoutData((Object)gd);
        if (this.m_filters != null) {
            for (String filterName : this.m_filters.keySet()) {
                EventFilter ef = this.m_filters.get(filterName);
                this.m_filterList.add(ef.getLabelOrName());
            }
        }
        this.m_filterList.addSelectionListener((SelectionListener)this);
        this.m_btn_edit_filter = gui.addButton((Composite)grp_filters, BTN_EDIT_FILTER, " Edit... ", true, 80, 60, 0, this);
        this.m_btn_edit_filter.setToolTipText("Edit...");
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 70;
        this.m_btn_edit_filter.setLayoutData((Object)gd);
        this.checkBtnStatus();
        return parent;
    }

    public void addContentMenu(TableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new SetColWidthAction(DialogEditTablePT.this.m_parentShell, DialogEditTablePT.this.m_tbl, (Object)DialogEditTablePT.this.m_instance));
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public void fillTable() {
        int i = 0;
        while (i < this.m_colSorted_clones.size()) {
            TblColumn col_clone = this.m_colSorted_clones.get(i);
            TableItem item = new TableItem(this.m_tbl, 0);
            int pos = col_clone.getPosition();
            item.setText(new String[]{"" + (pos + 1), col_clone.getName(), "" + col_clone.getWidth()});
            item.setData(IndicationBrowserSettings.POSITION, (Object)i);
            item.setData(IndicationBrowserSettings.OBJECT, (Object)col_clone);
            ++i;
        }
    }

    public void updateTableItem(Table table, TableItem selItem, Object obj) {
        if (table == null || table.isDisposed() || selItem == null || obj == null) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        int selIndex = table.getSelectionIndex();
        if (tableType.equals(TABLE_PT_CS) && obj instanceof TblColumn) {
            TblColumn col = (TblColumn)obj;
            int colWidth = col.getWidth();
            selItem.setText(2, "" + colWidth);
            table.update();
            if (table.getItemCount() > selIndex) {
                table.setSelection(selIndex);
            } else if (table.getItemCount() > 0) {
                table.setSelection(0);
            }
        }
    }

    public void updateTableItem(Table table, TableItem[] selItems) {
        if (table == null || table.isDisposed() || selItems == null || selItems.length == 0) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        int selIndex = table.getSelectionIndex();
        if (tableType.equals(TABLE_PT_CS)) {
            int i = 0;
            while (i < selItems.length) {
                TableItem ti = selItems[i];
                TblColumn col = (TblColumn)ti.getData(IndicationBrowserSettings.OBJECT);
                if (col != null) {
                    ti.setText(0, "" + col.getPosition());
                    ti.setText(1, col.getName());
                    ti.setText(2, "" + col.getWidth());
                }
                ++i;
            }
            table.update();
            if (table.getItemCount() > selIndex) {
                table.setSelection(selIndex);
            } else if (table.getItemCount() > 0) {
                table.setSelection(0);
            }
        }
    }

    public void refreshTable(boolean keepSelection) {
        int selIndex = this.m_tbl.getSelectionIndex();
        this.m_tbl.removeAll();
        int i = 0;
        while (i < this.m_colSorted_clones.size()) {
            TblColumn col_clone = this.m_colSorted_clones.get(i);
            TableItem item = new TableItem(this.m_tbl, 0);
            int pos = col_clone.getPosition();
            item.setText(new String[]{"" + (pos + 1), col_clone.getName(), "" + col_clone.getWidth()});
            item.setData(IndicationBrowserSettings.POSITION, (Object)i);
            item.setData(IndicationBrowserSettings.OBJECT, (Object)col_clone);
            ++i;
        }
        if (keepSelection) {
            if (selIndex == -1) {
                if (this.m_tbl.getItemCount() > 0) {
                    this.m_tbl.setSelection(0);
                }
            } else if (this.m_tbl.getItemCount() > selIndex) {
                this.m_tbl.setSelection(selIndex);
            } else if (this.m_tbl.getItemCount() > 0) {
                this.m_tbl.setSelection(0);
            }
        }
    }

    private void restore() {
        if (this.m_isNew) {
            this.m_viewID_cbo.select(0);
            this.m_tabName_field.setText("");
            this.m_browserType_cbo.select(0);
            this.m_showActive_radio.setSelection(true);
            this.m_showClosed_radio.setSelection(false);
            this.m_col = "Time";
            this.m_dir = UISettings.DOWN;
            this.m_allowToCloseTab_chb.setSelection(true);
            this.m_tbl.removeAll();
            this.m_colSorted_clones = IndicationBrowserSettings.getSetOfDefaultColumnsSorted();
            this.refreshTable(true);
        } else {
            this.m_viewID = this.m_predefinedTab.getViewID();
            this.m_isCloseable = this.m_predefinedTab.getClosable();
            this.m_tabName = this.m_predefinedTab.getName();
            this.m_showActive = this.m_predefinedTab.getShowActive();
            this.m_browserType = this.m_predefinedTab.getType();
            this.m_col = this.m_predefinedTab.getSortCol();
            if (this.m_col == null) {
                this.m_col = "Time";
            }
            this.m_dir = this.m_predefinedTab.getSortDir();
            if (this.m_dir == null) {
                this.m_dir = UISettings.DOWN;
            }
            this.m_colSorted_clones.clear();
            List<TblColumn> colSorted = this.m_predefinedTab.getColumnsSorted();
            int i = 0;
            while (i < colSorted.size()) {
                TblColumn col = colSorted.get(i);
                TblColumn col_clone = col.clone(col);
                this.m_colSorted_clones.add(col_clone);
                ++i;
            }
            this.refreshTable(true);
        }
    }

    public void checkBtnStatus() {
        int[] sel = this.m_tbl.getSelectionIndices();
        if (sel.length <= 0) {
            this.m_btn_up.setEnabled(false);
            this.m_btn_down.setEnabled(false);
            this.m_btn_edit.setEnabled(false);
        } else if (sel.length == 1) {
            int index = sel[0];
            if (index == -1) {
                this.m_btn_up.setEnabled(false);
                this.m_btn_down.setEnabled(false);
                this.m_btn_edit.setEnabled(false);
            } else if (index == 0) {
                this.m_btn_up.setEnabled(false);
                this.m_btn_down.setEnabled(true);
                this.m_btn_edit.setEnabled(true);
            } else if (index == this.m_tbl.getItemCount() - 1) {
                this.m_btn_up.setEnabled(true);
                this.m_btn_down.setEnabled(false);
                this.m_btn_edit.setEnabled(true);
            } else {
                this.m_btn_up.setEnabled(true);
                this.m_btn_down.setEnabled(true);
                this.m_btn_edit.setEnabled(true);
            }
        } else {
            this.m_btn_up.setEnabled(false);
            this.m_btn_down.setEnabled(false);
            this.m_btn_edit.setEnabled(false);
        }
    }

    public void moveTableItemUp() {
        int selIndex = this.m_tbl.getSelectionIndex();
        if (selIndex == 0) {
            return;
        }
        int newIndex = selIndex - 1;
        if (selIndex == -1) {
            this.checkBtnStatus();
            return;
        }
        TableItem ti1 = this.m_tbl.getItem(selIndex);
        TblColumn col1 = (TblColumn)ti1.getData(IndicationBrowserSettings.OBJECT);
        col1.setPosition(newIndex);
        TableItem ti2 = this.m_tbl.getItem(newIndex);
        TblColumn col2 = (TblColumn)ti2.getData(IndicationBrowserSettings.OBJECT);
        col2.setPosition(selIndex);
        this.reSortColumList();
        this.refreshTable(false);
        this.m_tbl.setSelection(newIndex);
    }

    public void moveTableItemDown() {
        int selIndex = this.m_tbl.getSelectionIndex();
        if (selIndex == this.m_tbl.getItemCount() - 1) {
            return;
        }
        int newIndex = selIndex + 1;
        if (selIndex == -1) {
            this.checkBtnStatus();
            return;
        }
        TableItem ti1 = this.m_tbl.getItem(selIndex);
        TblColumn col1 = (TblColumn)ti1.getData(IndicationBrowserSettings.OBJECT);
        col1.setPosition(newIndex);
        TableItem ti2 = this.m_tbl.getItem(newIndex);
        TblColumn col2 = (TblColumn)ti2.getData(IndicationBrowserSettings.OBJECT);
        col2.setPosition(selIndex);
        this.reSortColumList();
        this.refreshTable(false);
        this.m_tbl.setSelection(newIndex);
    }

    private void editTableItem() {
        String tableType = (String)this.m_tbl.getData();
        TableItem[] selection = this.m_tbl.getSelection();
        if (selection.length > 0) {
            TableItem seletedItem = selection[0];
            TblColumn tblCol = (TblColumn)seletedItem.getData(IndicationBrowserSettings.OBJECT);
            DialogEditTableColSettings dialog = new DialogEditTableColSettings(this.m_comp.getShell(), tblCol, tableType);
            dialog.setBlockOnOpen(true);
            int value = dialog.open();
            if (value == 0) {
                this.updateTableItem(this.m_tbl, seletedItem, tblCol);
            }
        }
    }

    public void reSortColumList() {
        HashMap<Integer, TblColumn> tmpMap = new HashMap<Integer, TblColumn>();
        for (TblColumn col : this.m_colSorted_clones) {
            tmpMap.put(col.getPosition(), col);
        }
        ArrayList list = new ArrayList();
        list.addAll(tmpMap.keySet());
        Collections.sort(list);
        this.m_colSorted_clones.clear();
        new ArrayList();
        int i = 0;
        while (i < list.size()) {
            int pos = (Integer)list.get(i);
            this.m_colSorted_clones.add((TblColumn)tmpMap.get(pos));
            ++i;
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite comp = (Composite)super.createButtonBar(parent);
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Apply", true);
        Button ok = this.getButton(0);
        ok.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
        Button cancel = this.getButton(1);
        cancel.setFocus();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.m_isNew) {
                this.m_predefinedTab = new PredefinedTab(this.m_viewID, this.m_tabName, this.m_browserType, this.m_showActive, this.m_isCloseable, this.m_col, this.m_dir);
                TableItem[] items = this.m_tbl.getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem ti = items[i];
                    TblColumn colClone = (TblColumn)ti.getData(IndicationBrowserSettings.OBJECT);
                    TblColumn col = new TblColumn(colClone.getName(), colClone.getPosition(), colClone.getWidth(), colClone.isColoringActive());
                    this.m_predefinedTab.addColumn(col);
                    ++i;
                }
                for (String filter : this.m_filters.keySet()) {
                    EventFilter ef = this.m_filters.get(filter);
                    TblFilter tblFilter = new TblFilter(ef.getLabelOrName(), ef.getLabelOrName(), ef.m_column, ef.m_isActive, ef.m_isLocked, true, ef.m_Availability, ef.m_KPIs, ef.m_isNOT, ef.m_caseSensitive, ef.m_mode, ef.m_pattern);
                    this.m_predefinedTab.addFilter(tblFilter);
                }
            } else {
                this.m_predefinedTab.setViewID(this.m_viewID);
                this.m_predefinedTab.setName(this.m_tabName);
                this.m_predefinedTab.setType(this.m_browserType);
                this.m_predefinedTab.setShowActive(this.m_showActive);
                this.m_predefinedTab.setClosable(this.m_isCloseable);
                this.m_predefinedTab.setSortCol(this.m_col);
                this.m_predefinedTab.setSortDir(this.m_dir);
                for (TblColumn colClone : this.m_colSorted_clones) {
                    TblColumn col2Update = this.m_predefinedTab.getColumn(colClone.getName());
                    if (col2Update == null) continue;
                    col2Update.setName(colClone.getName());
                    col2Update.setPosition(colClone.getPosition());
                    col2Update.setWidth(colClone.getWidth());
                    col2Update.setColoringActive(colClone.isColoringActive());
                }
                this.m_predefinedTab.removeFilterAll();
                for (String filter : this.m_filters.keySet()) {
                    EventFilter ef = this.m_filters.get(filter);
                    TblFilter tblFilter = new TblFilter(ef.getLabelOrName(), ef.getLabelOrName(), ef.m_column, ef.m_isActive, ef.m_isLocked, true, ef.m_Availability, ef.m_KPIs, ef.m_isNOT, ef.m_caseSensitive, ef.m_mode, ef.m_pattern);
                    this.m_predefinedTab.addFilter(tblFilter);
                }
            }
            super.okPressed();
        } else if (buttonId == 1) {
            super.cancelPressed();
        }
        super.close();
    }

    private void checkApplyButtonStatus() {
        if (this.m_tabName.length() > 0) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public PredefinedTab getPredefinedTab() {
        return this.m_predefinedTab;
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void modifyText(ModifyEvent event) {
        Text t;
        String name;
        Object o = event.getSource();
        if (o instanceof Text && (name = (String)(t = (Text)o).getData()).equals(TAB_NAME)) {
            this.m_tabName = t.getText().trim();
            this.checkApplyButtonStatus();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof CCombo) {
            CCombo c = (CCombo)obj;
            String name = (String)c.getData();
            if (name.equals(VIEW_ID)) {
                this.m_viewID = c.getText();
            } else if (name.equals(BROWSER_TYPE)) {
                this.m_browserType = c.getText().equals("Normal") ? 0 : 1;
            } else if (name.equals(COL)) {
                this.m_col = c.getText();
            } else if (name.equals(DIR)) {
                this.m_dir = c.getText();
            }
        } else if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(SHOW_ACTIVE)) {
                this.m_showActive = btn.getSelection();
            } else if (name.equals(SHOW_CLOSED)) {
                this.m_showActive = !btn.getSelection();
            } else if (name.equals(CLOSABLE)) {
                this.m_isCloseable = btn.getSelection();
            } else if (name.equals(BTN_EDIT_COLSETTINGS)) {
                this.editTableItem();
                this.checkBtnStatus();
            } else if (name.equals(BTN_UP)) {
                this.moveTableItemUp();
                this.checkBtnStatus();
            } else if (name.equals(BTN_DOWN)) {
                this.moveTableItemDown();
                this.checkBtnStatus();
            } else if (name.equals(BTN_RELOAD)) {
                this.restore();
                this.checkBtnStatus();
            } else if (name.equals(BTN_EDIT_FILTER)) {
                PredefinedFilterDialog efd = new PredefinedFilterDialog(Repository.getEventsSummary(), this.m_filters, this.m_filterList);
                efd.open();
            }
        } else if (obj instanceof Table) {
            this.checkBtnStatus();
        }
        this.checkApplyButtonStatus();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Table) {
            this.editTableItem();
            this.checkBtnStatus();
        } else if (obj instanceof org.eclipse.swt.widgets.List) {
            PredefinedFilterDialog efd = new PredefinedFilterDialog(Repository.getEventsSummary(), this.m_filters, this.m_filterList);
            efd.open();
        }
    }
}

