/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.gui.settings.GenAttributeProps;

public class GenAttribute {
    private String m_label = null;
    private String m_type = null;
    private String m_value = null;

    public GenAttribute(String label, String type, String value) {
        this.setLabel(label);
        this.setType(type);
        this.setValue(value);
    }

    public void setLabel(String label) {
        if (label != null && label.length() > 0) {
            this.m_label = label;
        }
    }

    public void setType(String type) {
        if (type != null && type.length() > 0 && GenAttributeProps._dataTypes.contains(type.toLowerCase())) {
            this.m_type = type.toLowerCase();
        }
    }

    public void setValue(String value) {
        if (value != null && value.length() > 0 && this.m_type != null && GenAttributeProps._dataTypes.contains(this.m_type.toLowerCase())) {
            this.m_value = this.m_type.equals(GenAttributeProps.TYPE_BOOLEAN) ? "" + Boolean.parseBoolean(value) : value;
        }
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getType() {
        return this.m_type;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean isValid() {
        return this.m_label != null && this.m_type != null && this.m_value != null;
    }
}

