/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.gui.settings.GenAttribute;
import com.blixx.boom.gui.settings.GenAttributeProps;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.settings.UISettingsDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GenAttributesSettings
implements SelectionListener {
    private Composite m_parent = null;
    private GUIDisplayElements m_gui = null;
    private List<Object> m_UIElements = null;
    private Map<String, GenAttribute> m_generalAttributes = null;
    private Button m_btn_apply = null;
    private static String BTN_APPLY = "BTN_APPLY";
    private Button m_btn_restore = null;
    private static String BTN_RESTORE = "BTN_RESTORE";

    public GenAttributesSettings(UISettingsDialog dialog, Composite parent) {
        this.m_parent = parent;
        this.m_UIElements = new ArrayList<Object>();
        this.m_gui = new GUIDisplayElements();
        this.m_generalAttributes = UISettings.getInstance().getGenAttributes();
    }

    public void createSection(Composite parent) {
        Group grp_colSettings = new Group(parent, 4);
        grp_colSettings.setText("General Attributes");
        grp_colSettings.setLayout((Layout)new GridLayout(1, false));
        grp_colSettings.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.m_generalAttributes != null && this.m_generalAttributes.size() > 0) {
            for (String name : this.m_generalAttributes.keySet()) {
                GenAttribute genAttribute = this.m_generalAttributes.get(name);
                if (genAttribute == null) continue;
                String type = genAttribute.getType();
                String label = genAttribute.getLabel();
                boolean value = Boolean.parseBoolean(genAttribute.getValue());
                if (!type.equals(GenAttributeProps.TYPE_BOOLEAN)) continue;
                Button checkbox = this.m_gui.addCheckbox((Composite)grp_colSettings, name, label, value, 1, 1, 0, this);
                this.m_UIElements.add(checkbox);
            }
        }
        Composite compBtn2 = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compBtn2.setLayout((Layout)gl);
        compBtn2.setLayoutData((Object)new GridData(131072, 1024, true, true));
        this.m_btn_restore = this.m_gui.addButton(compBtn2, BTN_RESTORE, " Restore Defaults ", true, 80, 60, 0, this);
        this.m_btn_restore.setToolTipText("Restore Defaults");
        this.m_btn_restore.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.m_btn_apply = this.m_gui.addButton(compBtn2, BTN_APPLY, " Apply ", true, 80, 60, 0, this);
        this.m_btn_apply.setToolTipText("Apply Changes");
        this.m_btn_apply.setLayoutData((Object)new GridData(4, 1024, false, false));
        parent.layout(true);
    }

    public void restoreDefaults(Object object) {
        for (Object o : this.m_UIElements) {
            if (!(o instanceof Button)) continue;
            Button btn = (Button)o;
            String name = (String)btn.getData();
            Map<String, String> params = GenAttributeProps.m_general_attributes.get(name);
            boolean defaultValue = Boolean.parseBoolean(params.get(GenAttributeProps.VALUE));
            btn.setSelection(defaultValue);
            GenAttribute genAttribute = this.m_generalAttributes.get(name);
            if (genAttribute == null) continue;
            genAttribute.setValue("" + defaultValue);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            GenAttribute genAttr;
            Button btn = (Button)o;
            String name = (String)btn.getData();
            if (name.equals(BTN_RESTORE)) {
                this.restoreDefaults(name);
            } else if (name.equals(BTN_APPLY)) {
                UISettings.getInstance().storeAndReload();
            } else if (this.m_generalAttributes.containsKey(name) && (genAttr = this.m_generalAttributes.get(name)) != null) {
                genAttr.setValue("" + btn.getSelection());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

