/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.EventBrowserProvider;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventStorage;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.settings.DialogEditTableColSettings;
import com.blixx.boom.gui.settings.DialogEditTablePT;
import com.blixx.boom.gui.settings.DialogEditTablePV;
import com.blixx.boom.gui.settings.EnableDisableBGColoringAction;
import com.blixx.boom.gui.settings.PredefinedFilterDialog;
import com.blixx.boom.gui.settings.PredefinedTab;
import com.blixx.boom.gui.settings.PredefinedView;
import com.blixx.boom.gui.settings.SetColWidthAction;
import com.blixx.boom.gui.settings.TblColumn;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.settings.UISettingsDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.log.RTLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IndicationBrowserSettings
implements SelectionListener {
    private IndicationBrowserSettings m_instance = null;
    private Shell m_parentShell = null;
    private UISettingsDialog m_settingsDialog = null;
    private GUIDisplayElements m_gui = null;
    private Button m_btn_apply = null;
    private static String BTN_APPLY = "BTN_APPLY";
    private Button m_showIndiView2_chk = null;
    private Button m_canMoveTabs_chk = null;
    private Button m_canSort_chk = null;
    private Button m_canSwitch_chk = null;
    private Button m_canModifyFilters_chk = null;
    private String[] m_colList4Combo_sorted = null;
    private String m_sortCol = "Time";
    private String m_sortDir = UISettings.DOWN;
    private static String SORT_COL = "SORT_COL";
    private static String SORT_DIR = "SORT_DIR";
    private Table m_tbl_IB_CS = null;
    private Button m_btn_up_IB_CS = null;
    private Button m_btn_down_IB_CS = null;
    private Button m_btn_edit_IB_CS = null;
    private Button m_btn_restore_IB_CS = null;
    public static String TABLE_IB_CS = "TABLE_IB_CS";
    private static String BTN_UP_IB_CS = "BTN_UP_IB_CS";
    private static String BTN_DOWN_IB_CS = "BTN_DOWN_IB_CS";
    private static String BTN_EDIT_IB_CS = "BTN_EDIT_IB_CS";
    private static String BTN_RESTORE_IB = "BTN_RESTORE_IB";
    private static org.eclipse.swt.widgets.List m_list_IB_globalFilters = null;
    private Button m_btn_edit_globalFilter = null;
    private static String LIST_IB_GLOBAL_FILTER = "LIST_IB_GLOBAL_FILTER";
    private static String BTN_EDIT_IB_GLOBAL_FILTER = "BTN_EDIT_IB_GLOBAL_FILTER";
    private Table m_tbl_PV = null;
    private static String TABLE_PV = "TABLE_PV";
    private Button m_btn_edit_PV = null;
    private Button m_btn_restore_PV = null;
    private static String BTN_EDIT_PV = "BTN_EDIT_PV";
    private static String BTN_RESTORE_PV = "BTN_RESTORE_PV";
    private Table m_tbl_PT = null;
    private static String TABLE_PT = "TABLE_PT";
    private Button m_btn_add_PT = null;
    private Button m_btn_delete_PT = null;
    private Button m_btn_edit_PT = null;
    private Button m_btn_up_PT = null;
    private Button m_btn_down_PT = null;
    private static String BTN_ADD_PT = "BTN_ADD_PT";
    private static String BTN_DELETE_PT = "BTN_DELETE_PT";
    private static String BTN_EDIT_PT = "BTN_EDIT_PT";
    private static String BTN_UP_PT = "BTN_UP_PT";
    private static String BTN_DOWN_PT = "BTN_DOWN_PT";
    private Label m_ib_bgColor_active = null;
    private Label m_ib_bgColor_closed = null;
    private Label m_ob_bgColor_active = null;
    private Label m_ob_bgColor_closed = null;
    private static String BTN_IB_COLOR_ACTIVE = "BTN_IB_COLOR_ACTIVE";
    private static String BTN_IB_COLOR_CLOSED = "BTN_IB_COLOR_CLOSED";
    private static String BTN_OB_COLOR_ACTIVE = "BTN_OB_COLOR_ACTIVE";
    private static String BTN_OB_COLOR_CLOSED = "BTN_OB_COLOR_CLOSED";
    public static String POSITION = "Position";
    public static String OBJECT = "OBJECT";
    public static String NAME = "Name";
    private Map<String, Object> m_globalSettings = null;
    private Map<String, TblColumn> m_colSettings = null;
    private Map<String, EventFilter> m_globalFilters = null;
    private Map<String, Color> m_colorOptions = null;
    private Map<String, PredefinedView> m_predefViews = null;
    private List<PredefinedTab> m_predefTabs = null;

    public IndicationBrowserSettings(UISettingsDialog dialog, Composite parent) {
        this.m_settingsDialog = dialog;
        this.m_parentShell = parent.getShell();
        this.m_instance = this;
        this.m_gui = new GUIDisplayElements();
        this.m_colList4Combo_sorted = new String[EventStorageUtils.defaultColumnOrder.length];
        int[] defaultColOrder = EventStorageUtils.defaultColumnOrder;
        int i = 0;
        while (i < defaultColOrder.length) {
            int pos = i;
            int colID = defaultColOrder[i];
            for (String colName : EventStorageUtils.m_columnMap.keySet()) {
                int id = EventStorageUtils.m_columnMap.get(colName);
                if (colID != id) continue;
                this.m_colList4Combo_sorted[pos] = colName;
                break;
            }
            ++i;
        }
    }

    public void createGeneralSection(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_globalSettings = UISettings.getInstance().getIB_GlobalSettings();
        this.m_colSettings = UISettings.getInstance().getIB_GlobalColSettings();
        this.m_globalFilters = UISettings.getInstance().getIB_PredefinedGlobalFilters();
        this.m_colorOptions = UISettings.getInstance().getIB_Colors();
        boolean showIndiView2 = true;
        boolean canModifyFilters = true;
        boolean canSortTable = true;
        boolean canMoveView = true;
        boolean canSwitchTable = true;
        if (this.m_globalSettings != null) {
            showIndiView2 = Boolean.parseBoolean("" + this.m_globalSettings.get(UISettings.SHOW_INDI_VIEW2));
            canModifyFilters = Boolean.parseBoolean("" + this.m_globalSettings.get(UISettings.CAN_MODIFY_FILTERS));
            canSortTable = Boolean.parseBoolean("" + this.m_globalSettings.get(UISettings.CAN_SORT));
            canMoveView = Boolean.parseBoolean("" + this.m_globalSettings.get(UISettings.CAN_MOVE_TABS));
            canSwitchTable = Boolean.parseBoolean("" + this.m_globalSettings.get(UISettings.CAN_SWITCH));
            this.m_sortCol = "" + this.m_globalSettings.get(UISettings.GLOBAL_SORT_COL);
            this.m_sortDir = "" + this.m_globalSettings.get(UISettings.GLOBAL_SORT_DIR);
        }
        this.m_showIndiView2_chk = this.m_gui.addCheckbox(comp, UISettings.SHOW_INDI_VIEW2, "Show closed Indications on startup", showIndiView2, 1, 1, 0, this);
        this.m_canSwitch_chk = this.m_gui.addCheckbox(comp, UISettings.CAN_SWITCH, "Allow to switch between active/closed Indications", canSwitchTable, 1, 1, 0, this);
        this.m_canMoveTabs_chk = this.m_gui.addCheckbox(comp, UISettings.CAN_MOVE_TABS, "Allow to move Tabs", canMoveView, 1, 1, 0, this);
        this.m_canSort_chk = this.m_gui.addCheckbox(comp, UISettings.CAN_SORT, "Allow to sort Tables", canSortTable, 1, 1, 0, this);
        this.m_canModifyFilters_chk = this.m_gui.addCheckbox(comp, UISettings.CAN_MODIFY_FILTERS, "Allow to modify Filters", canModifyFilters, 1, 1, 0, this);
        Group sorting_grp = new Group(comp, 0);
        sorting_grp.setText("Global Table Sorting");
        sorting_grp.setLayout((Layout)new GridLayout(4, false));
        sorting_grp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_gui.addDropDown((Composite)sorting_grp, SORT_COL, "Column: ", this.m_colList4Combo_sorted, this.m_sortCol, "", 1, 1, 0, 0, this);
        this.m_gui.addDropDown((Composite)sorting_grp, SORT_DIR, null, new String[]{UISettings.UP, UISettings.DOWN}, this.m_sortDir, "", 1, 1, 0, 0, this);
        Group grp_colSettings = new Group(parent, 4);
        grp_colSettings.setText("Global Column Settings");
        grp_colSettings.setLayout((Layout)new GridLayout(2, false));
        grp_colSettings.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_tbl_IB_CS = new Table((Composite)grp_colSettings, 268503810);
        this.m_tbl_IB_CS.setHeaderVisible(true);
        this.m_tbl_IB_CS.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true, 1, 3);
        gd.widthHint = 300;
        gd.heightHint = 180;
        this.m_tbl_IB_CS.setLayoutData((Object)gd);
        this.m_tbl_IB_CS.setData((Object)TABLE_IB_CS);
        TableColumn col0 = new TableColumn(this.m_tbl_IB_CS, 0x1000000);
        col0.setText(POSITION);
        col0.setWidth(60);
        TableColumn col1 = new TableColumn(this.m_tbl_IB_CS, 16384);
        col1.setText("Name");
        col1.setWidth(170);
        TableColumn col2 = new TableColumn(this.m_tbl_IB_CS, 131072);
        col2.setText("Width");
        col2.setWidth(70);
        TableColumn col3 = new TableColumn(this.m_tbl_IB_CS, 0x1000000);
        col3.setText("Coloring");
        col3.setWidth(70);
        HashMap<Integer, TblColumn> tmpMap = new HashMap<Integer, TblColumn>();
        if (this.m_colSettings != null) {
            for (String colName : this.m_colSettings.keySet()) {
                TblColumn column = this.m_colSettings.get(colName);
                tmpMap.put(column.getPosition(), column);
            }
            ArrayList list = new ArrayList();
            list.addAll(tmpMap.keySet());
            Collections.sort(list);
            int i = 0;
            while (i < list.size()) {
                int pos = (Integer)list.get(i);
                TblColumn column = (TblColumn)tmpMap.get(pos);
                TableItem item = new TableItem(this.m_tbl_IB_CS, 0);
                item.setText(new String[]{"" + (i + 1), column.getName(), "" + column.getWidth(), "" + column.isColoringActive()});
                item.setData(POSITION, (Object)i);
                item.setData(OBJECT, (Object)column);
                ++i;
            }
        }
        this.m_tbl_IB_CS.addSelectionListener((SelectionListener)this);
        if (this.m_tbl_IB_CS.getItemCount() > 0) {
            this.m_tbl_IB_CS.setSelection(0);
        }
        TableViewer tv = new TableViewer(this.m_tbl_IB_CS);
        this.addContentMenu_IB_CS(tv);
        this.m_btn_up_IB_CS = this.m_gui.addButton((Composite)grp_colSettings, BTN_UP_IB_CS, "Up", false, 80, 60, 0, this);
        this.m_btn_up_IB_CS.setToolTipText("Move Column Up");
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 70;
        this.m_btn_up_IB_CS.setLayoutData((Object)gd);
        this.m_btn_down_IB_CS = this.m_gui.addButton((Composite)grp_colSettings, BTN_DOWN_IB_CS, "Down", true, 80, 60, 0, this);
        this.m_btn_down_IB_CS.setToolTipText("Move Column Down");
        this.m_btn_down_IB_CS.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_edit_IB_CS = this.m_gui.addButton((Composite)grp_colSettings, BTN_EDIT_IB_CS, " Edit... ", true, 80, 60, 0, this);
        this.m_btn_edit_IB_CS.setToolTipText("Edit Column Settings");
        this.m_btn_edit_IB_CS.setLayoutData((Object)new GridData(4, 128, false, false));
        Group grp_filters = new Group(parent, 4);
        grp_filters.setText("Global Filters");
        grp_filters.setLayout((Layout)new GridLayout(2, false));
        grp_filters.setLayoutData((Object)new GridData(4, 4, true, false));
        m_list_IB_globalFilters = new org.eclipse.swt.widgets.List((Composite)grp_filters, 2560);
        m_list_IB_globalFilters.setData((Object)LIST_IB_GLOBAL_FILTER);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        gd.heightHint = 90;
        m_list_IB_globalFilters.setLayoutData((Object)gd);
        m_list_IB_globalFilters.addSelectionListener((SelectionListener)this);
        if (this.m_globalFilters != null) {
            for (String filterName : this.m_globalFilters.keySet()) {
                EventFilter ef = this.m_globalFilters.get(filterName);
                m_list_IB_globalFilters.add(ef.getLabelOrName());
            }
        }
        this.m_btn_edit_globalFilter = this.m_gui.addButton((Composite)grp_filters, BTN_EDIT_IB_GLOBAL_FILTER, " Edit... ", true, 80, 60, 0, this);
        this.m_btn_edit_globalFilter.setToolTipText("Edit...");
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 70;
        this.m_btn_edit_globalFilter.setLayoutData((Object)gd);
        this.checkBtnStatus(LIST_IB_GLOBAL_FILTER);
        Group grp_colorOptions = new Group(parent, 4);
        grp_colorOptions.setText("Global Color Options");
        grp_colorOptions.setLayout((Layout)new GridLayout(3, false));
        grp_colorOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        Label l0 = new Label((Composite)grp_colorOptions, 0);
        l0.setText("Indication Browser");
        gd = new GridData();
        gd.horizontalSpan = 3;
        l0.setLayoutData((Object)gd);
        Label l1 = new Label((Composite)grp_colorOptions, 0);
        l1.setText("backround active Indications: ");
        gd = new GridData();
        gd.horizontalIndent = 10;
        l1.setLayoutData((Object)gd);
        this.m_ib_bgColor_active = new Label((Composite)grp_colorOptions, 0);
        this.m_ib_bgColor_active.setText("                         ");
        this.m_ib_bgColor_active.setBackground(this.m_colorOptions.get(UISettings.IB_COLOR_ACTIVE));
        this.m_gui.addButton((Composite)grp_colorOptions, BTN_IB_COLOR_ACTIVE, "Change Color...", true, this);
        Label l2 = new Label((Composite)grp_colorOptions, 0);
        l2.setText("backround closed Indications: ");
        gd = new GridData();
        gd.horizontalIndent = 10;
        l2.setLayoutData((Object)gd);
        this.m_ib_bgColor_closed = new Label((Composite)grp_colorOptions, 0);
        this.m_ib_bgColor_closed.setText("                         ");
        this.m_ib_bgColor_closed.setBackground(this.m_colorOptions.get(UISettings.IB_COLOR_CLOSED));
        this.m_gui.addButton((Composite)grp_colorOptions, BTN_IB_COLOR_CLOSED, "Change Color...", true, this);
        Label l00 = new Label((Composite)grp_colorOptions, 0);
        l00.setText("Maintenance Indications Browser");
        gd = new GridData();
        gd.horizontalSpan = 3;
        l00.setLayoutData((Object)gd);
        Label l3 = new Label((Composite)grp_colorOptions, 0);
        l3.setText("backround active Indications: ");
        gd = new GridData();
        gd.horizontalIndent = 10;
        l3.setLayoutData((Object)gd);
        this.m_ob_bgColor_active = new Label((Composite)grp_colorOptions, 0);
        this.m_ob_bgColor_active.setText("                         ");
        this.m_ob_bgColor_active.setBackground(this.m_colorOptions.get(UISettings.OB_COLOR_ACTIVE));
        this.m_gui.addButton((Composite)grp_colorOptions, BTN_OB_COLOR_ACTIVE, "Change Color...", true, this);
        Label l4 = new Label((Composite)grp_colorOptions, 0);
        l4.setText("backround closed Indications: ");
        gd = new GridData();
        gd.horizontalIndent = 10;
        l4.setLayoutData((Object)gd);
        this.m_ob_bgColor_closed = new Label((Composite)grp_colorOptions, 0);
        this.m_ob_bgColor_closed.setText("                         ");
        this.m_ob_bgColor_closed.setBackground(this.m_colorOptions.get(UISettings.OB_COLOR_CLOSED));
        this.m_gui.addButton((Composite)grp_colorOptions, BTN_OB_COLOR_CLOSED, "Change Color...", true, this);
        Composite compBtn = new Composite(parent, 0);
        gl = new GridLayout(2, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(131072, 1024, true, true));
        this.m_btn_restore_IB_CS = this.m_gui.addButton(compBtn, BTN_RESTORE_IB, " Restore Defaults ", true, 80, 60, 0, this);
        this.m_btn_restore_IB_CS.setToolTipText("Restore Defaults");
        this.m_btn_restore_IB_CS.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.m_btn_apply = this.m_gui.addButton(compBtn, BTN_APPLY, " Apply ", true, 80, 60, 0, this);
        this.m_btn_apply.setToolTipText("Apply Changes");
        this.m_btn_apply.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.m_settingsDialog.updateContentArea();
    }

    public void addContentMenu_IB_CS(TableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    TableItem[] selection = IndicationBrowserSettings.this.m_tbl_IB_CS.getSelection();
                    manager.add((IAction)new SetColWidthAction(IndicationBrowserSettings.this.m_parentShell, IndicationBrowserSettings.this.m_tbl_IB_CS, IndicationBrowserSettings.this.m_instance));
                    if (selection.length == 1) {
                        TblColumn col = (TblColumn)selection[0].getData(OBJECT);
                        if (col.isColoringActive()) {
                            manager.add((IAction)new EnableDisableBGColoringAction(false, IndicationBrowserSettings.this.m_tbl_IB_CS, IndicationBrowserSettings.this.m_instance));
                        } else {
                            manager.add((IAction)new EnableDisableBGColoringAction(true, IndicationBrowserSettings.this.m_tbl_IB_CS, IndicationBrowserSettings.this.m_instance));
                        }
                    } else if (selection.length > 1) {
                        manager.add((IAction)new EnableDisableBGColoringAction(true, IndicationBrowserSettings.this.m_tbl_IB_CS, IndicationBrowserSettings.this.m_instance));
                        manager.add((IAction)new EnableDisableBGColoringAction(false, IndicationBrowserSettings.this.m_tbl_IB_CS, IndicationBrowserSettings.this.m_instance));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public void createPredefinedViewSection(Composite parent) {
        this.m_predefViews = UISettings.getInstance().getIB_PredefinedViews();
        Composite compTbl = new Composite(parent, 0);
        compTbl.setLayout((Layout)new GridLayout(2, false));
        compTbl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tbl_PV = new Table(compTbl, 0x10010B00);
        this.m_tbl_PV.setHeaderVisible(true);
        this.m_tbl_PV.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 350;
        gd.heightHint = 140;
        this.m_tbl_PV.setLayoutData((Object)gd);
        this.m_tbl_PV.setData((Object)TABLE_PV);
        TableColumn col0 = new TableColumn(this.m_tbl_PV, 16384);
        col0.setText("ViewID");
        col0.setWidth(260);
        TableColumn col1 = new TableColumn(this.m_tbl_PV, 16384);
        col1.setText("Add Tab");
        col1.setWidth(70);
        col1.setToolTipText("Allow adding Indication Tabs");
        if (this.m_predefViews != null) {
            int count = 0;
            for (String viewID : this.m_predefViews.keySet()) {
                PredefinedView view = this.m_predefViews.get(viewID);
                TableItem item = new TableItem(this.m_tbl_PV, 0);
                item.setText(new String[]{viewID, "" + view.canAddTabs()});
                item.setData(POSITION, (Object)count);
                item.setData(OBJECT, (Object)view);
                ++count;
            }
        }
        this.m_tbl_PV.addSelectionListener((SelectionListener)this);
        if (this.m_tbl_PV.getItemCount() > 0) {
            this.m_tbl_PV.setSelection(0);
        }
        this.m_btn_edit_PV = this.m_gui.addButton(compTbl, BTN_EDIT_PV, "  Edit...  ", true, 80, 60, 0, this);
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 80;
        this.m_btn_edit_PV.setLayoutData((Object)gd);
        this.m_btn_edit_PV.setToolTipText("Edit Predefined View");
        Composite compBtn = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.m_btn_restore_PV = this.m_gui.addButton(compBtn, BTN_RESTORE_PV, " Restore Defaults ", true, 120, 60, 0, this);
        this.m_btn_restore_PV.setToolTipText("Restore Defaults");
        this.m_btn_restore_PV.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.m_btn_apply = this.m_gui.addButton(compBtn, BTN_APPLY, " Apply ", true, 120, 60, 0, this);
        this.m_btn_apply.setToolTipText("Apply Changes");
        this.m_btn_apply.setLayoutData((Object)new GridData(4, 1024, false, false));
        parent.layout(true);
    }

    public void createPredefinedTabSection(Composite parent) {
        this.m_predefTabs = UISettings.getInstance().getIB_PredefinedTabs();
        Composite compTbl = new Composite(parent, 0);
        compTbl.setLayout((Layout)new GridLayout(2, false));
        compTbl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tbl_PT = new Table(compTbl, 0x10010B00);
        this.m_tbl_PT.setHeaderVisible(true);
        this.m_tbl_PT.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true, 1, 5);
        this.m_tbl_PT.setLayoutData((Object)gd);
        this.m_tbl_PT.setData((Object)TABLE_PT);
        TableColumn col0 = new TableColumn(this.m_tbl_PT, 16384);
        col0.setText("ViewID");
        col0.setWidth(260);
        col0.setToolTipText("The ViewID in which the Tab will be opend");
        TableColumn col1 = new TableColumn(this.m_tbl_PT, 16384);
        col1.setText("Name");
        col1.setWidth(150);
        col1.setToolTipText("Predefined Tab name");
        TableColumn col2 = new TableColumn(this.m_tbl_PT, 16384);
        col2.setText("Active");
        col2.setWidth(45);
        col2.setToolTipText("Display active Indications");
        TableColumn col3 = new TableColumn(this.m_tbl_PT, 16384);
        col3.setText("Sorting");
        col3.setWidth(120);
        col3.setToolTipText("Table sorting 'columnName/sortDirection'");
        TableColumn col4 = new TableColumn(this.m_tbl_PT, 16384);
        col4.setText("Type");
        col4.setWidth(55);
        col4.setToolTipText("Indication Browser Type");
        TableColumn col5 = new TableColumn(this.m_tbl_PT, 16384);
        col5.setText("Active/NotActive Filters");
        col5.setWidth(120);
        col5.setToolTipText("Number of active/notActive Filters");
        TableColumn col6 = new TableColumn(this.m_tbl_PT, 16384);
        col6.setText("Visible/Hidden Columns");
        col6.setWidth(100);
        col6.setToolTipText("Number of visible/hidden Columns");
        this.predefinedTabs_refreshTable();
        this.m_tbl_PT.addSelectionListener((SelectionListener)this);
        if (this.m_tbl_PT.getItemCount() > 0) {
            this.m_tbl_PT.setSelection(0);
        }
        this.m_btn_up_PT = this.m_gui.addButton(compTbl, BTN_UP_PT, " Up ", true, 80, 60, 0, this);
        this.m_btn_up_PT.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_up_PT.setToolTipText("Move Up");
        this.m_btn_down_PT = this.m_gui.addButton(compTbl, BTN_DOWN_PT, " Down ", true, 80, 60, 0, this);
        this.m_btn_down_PT.setToolTipText("Move Down");
        this.m_btn_down_PT.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_add_PT = this.m_gui.addButton(compTbl, BTN_ADD_PT, "Add", true, 80, 60, 0, this);
        this.m_btn_add_PT.setToolTipText("Add Tab");
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 80;
        this.m_btn_add_PT.setLayoutData((Object)gd);
        this.m_btn_delete_PT = this.m_gui.addButton(compTbl, BTN_DELETE_PT, " Remove ", true, 80, 60, 0, this);
        this.m_btn_delete_PT.setToolTipText("Remove Tab");
        this.m_btn_delete_PT.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_edit_PT = this.m_gui.addButton(compTbl, BTN_EDIT_PT, "Edit...", false, 80, 60, 0, this);
        this.m_btn_edit_PT.setToolTipText("Edit Tab");
        this.m_btn_edit_PT.setLayoutData((Object)new GridData(4, 128, false, false));
        Composite compBtn = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 20;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(131072, 1024, true, false));
        Button btn = this.m_gui.addButton(compBtn, "", " Restore Defaults ", true, 120, 60, 0, this);
        btn.setLayoutData((Object)new GridData(4, 1024, false, false));
        btn.setVisible(false);
        this.m_btn_apply = this.m_gui.addButton(compBtn, BTN_APPLY, " Apply ", true, 120, 60, 0, this);
        this.m_btn_apply.setToolTipText("Apply Changes");
        this.m_btn_apply.setLayoutData((Object)new GridData(4, 1024, false, false));
        parent.layout(true);
        this.checkBtnStatus(TABLE_PT);
    }

    public void predefinedTabs_refreshTable() {
        this.m_tbl_PT.removeAll();
        if (this.m_predefTabs != null) {
            int index = 0;
            Iterator<PredefinedTab> it = this.m_predefTabs.iterator();
            while (it.hasNext()) {
                PredefinedTab tab = it.next();
                if (tab == null) {
                    it.remove();
                    continue;
                }
                int filterActive = tab.getActiveFilterCount();
                int filterNotActive = tab.getFilters().size() - filterActive;
                int colsVisible = tab.getVisibleColumnsCount();
                int colsHidden = tab.getColumns().size() - colsVisible;
                TableItem item = new TableItem(this.m_tbl_PT, 0);
                item.setText(new String[]{tab.getViewID(), tab.getName(), "" + tab.getShowActive(), tab.getSorting(), tab.getTypeStr(), filterActive + "|" + filterNotActive, colsVisible + "|" + colsHidden});
                item.setData(POSITION, (Object)index);
                item.setData(OBJECT, (Object)tab);
                ++index;
            }
        }
    }

    public void predefinedTabs_moveOneUp() {
        int index = this.m_tbl_PT.getSelectionIndex();
        if (index != 0 && index > 0) {
            PredefinedTab tab = this.m_predefTabs.remove(index);
            this.m_predefTabs.add(index - 1, tab);
            this.predefinedTabs_refreshTable();
            this.m_tbl_PT.select(index - 1);
            this.m_tbl_PT.setSelection(index - 1);
        }
    }

    public void predefinedTabs_moveOneDown() {
        int count;
        int index = this.m_tbl_PT.getSelectionIndex();
        if (index != (count = this.m_predefTabs.size()) - 1 && index > -1) {
            PredefinedTab tab = this.m_predefTabs.remove(index);
            this.m_predefTabs.add(index + 1, tab);
            this.predefinedTabs_refreshTable();
            this.m_tbl_PT.select(index + 1);
            this.m_tbl_PT.setSelection(index + 1);
        }
    }

    public void changeTable(String btnType) {
        if (btnType.equals(BTN_UP_IB_CS)) {
            this.moveTableItemUp(this.m_tbl_IB_CS);
            this.checkBtnStatus(TABLE_IB_CS);
        } else if (btnType.equals(BTN_DOWN_IB_CS)) {
            this.moveTableItemDown(this.m_tbl_IB_CS);
            this.checkBtnStatus(TABLE_IB_CS);
        } else if (btnType.equals(BTN_EDIT_IB_CS)) {
            this.editTableItem(this.m_tbl_IB_CS);
            this.checkBtnStatus(TABLE_IB_CS);
        } else if (btnType.equals(BTN_EDIT_PV)) {
            this.editTableItem(this.m_tbl_PV);
            this.checkBtnStatus(TABLE_PV);
        } else if (btnType.equals(BTN_EDIT_PT)) {
            this.editTableItem(this.m_tbl_PT);
            this.checkBtnStatus(TABLE_PT);
        } else if (btnType.equals(BTN_ADD_PT)) {
            this.addTableItem(this.m_tbl_PT);
            this.checkBtnStatus(TABLE_PT);
        } else if (btnType.equals(BTN_DELETE_PT)) {
            this.deleteTableItem(this.m_tbl_PT);
            this.checkBtnStatus(TABLE_PT);
        } else if (btnType.equals(BTN_UP_PT)) {
            this.predefinedTabs_moveOneUp();
            this.checkBtnStatus(TABLE_PT);
        } else if (btnType.equals(BTN_DOWN_PT)) {
            this.predefinedTabs_moveOneDown();
            this.checkBtnStatus(TABLE_PT);
        }
    }

    public void moveTableItemUp(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        int selIndex = table.getSelectionIndex();
        if (selIndex == 0) {
            return;
        }
        int newIndex = selIndex - 1;
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        if (tableType.equals(TABLE_IB_CS)) {
            TableItem ti1 = table.getItem(selIndex);
            TblColumn col1 = (TblColumn)ti1.getData(OBJECT);
            col1.setPosition(newIndex);
            TableItem ti2 = table.getItem(newIndex);
            TblColumn col2 = (TblColumn)ti2.getData(OBJECT);
            col2.setPosition(selIndex);
            this.refreshTable(table);
            table.setSelection(newIndex);
        }
    }

    public void moveTableItemDown(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        int selIndex = table.getSelectionIndex();
        if (selIndex == table.getItemCount() - 1) {
            return;
        }
        int newIndex = selIndex + 1;
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        if (tableType.equals(TABLE_IB_CS)) {
            TableItem ti1 = table.getItem(selIndex);
            TblColumn col1 = (TblColumn)ti1.getData(OBJECT);
            col1.setPosition(newIndex);
            TableItem ti2 = table.getItem(newIndex);
            TblColumn col2 = (TblColumn)ti2.getData(OBJECT);
            col2.setPosition(selIndex);
            this.refreshTable(table);
            table.setSelection(newIndex);
        }
    }

    public void addTableItem(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        if (tableType.equals(TABLE_PT)) {
            DialogEditTablePT dialog = new DialogEditTablePT(this.m_parentShell, null);
            dialog.setBlockOnOpen(true);
            int value = dialog.open();
            if (value == 0) {
                PredefinedTab newTab = dialog.getPredefinedTab();
                if (this.m_predefTabs != null) {
                    this.m_predefTabs.add(newTab);
                }
                int lineIndex = table.getItemCount();
                int filterActive = newTab.getActiveFilterCount();
                int filterNotActive = newTab.getFilters().size() - filterActive;
                int colsVisible = newTab.getVisibleColumnsCount();
                int colsHidden = newTab.getColumns().size() - colsVisible;
                TableItem item = new TableItem(table, 0, lineIndex);
                item.setText(new String[]{newTab.getViewID(), newTab.getName(), "" + newTab.getShowActive(), newTab.getSorting(), "" + newTab.getType(), filterActive + "|" + filterNotActive, colsVisible + "|" + colsHidden});
                item.setData(POSITION, (Object)lineIndex);
                item.setData(OBJECT, (Object)newTab);
                table.update();
                table.setSelection(lineIndex);
            }
        }
    }

    public void editTableItem(Table table) {
        Object o;
        if (table == null || table.isDisposed() || table.getSelectionCount() == 0) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        TableItem[] sel = table.getSelection();
        TableItem seletedItem = sel[0];
        if (tableType.equals(TABLE_IB_CS)) {
            TblColumn tblCol = (TblColumn)seletedItem.getData(OBJECT);
            DialogEditTableColSettings dialog = new DialogEditTableColSettings(this.m_parentShell, tblCol, TABLE_IB_CS);
            dialog.setBlockOnOpen(true);
            int value = dialog.open();
            if (value == 0) {
                this.updateTableItem(table, seletedItem, tblCol);
            }
        } else if (tableType.equals(TABLE_PV)) {
            PredefinedView view = (PredefinedView)seletedItem.getData(OBJECT);
            DialogEditTablePV dialog = new DialogEditTablePV(this.m_parentShell, view);
            dialog.setBlockOnOpen(true);
            int value = dialog.open();
            if (value == 0) {
                this.updateTableItem(table, seletedItem, view);
            }
        } else if (tableType.equals(TABLE_PT) && (o = seletedItem.getData(OBJECT)) instanceof PredefinedTab) {
            PredefinedTab selTab = (PredefinedTab)o;
            DialogEditTablePT dialog = new DialogEditTablePT(this.m_parentShell, selTab);
            dialog.setBlockOnOpen(true);
            int value = dialog.open();
            if (value == 0) {
                this.updateTableItem(table, seletedItem, selTab);
            }
        }
    }

    public void deleteTableItem(Table table) {
        int selIndex;
        if (table == null || table.isDisposed()) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        if (tableType.equals(TABLE_PT) && (selIndex = table.getSelectionIndex()) > -1) {
            table.remove(selIndex);
            if (selIndex >= table.getItemCount()) {
                selIndex = table.getItemCount() - 1;
            }
            table.setSelection(selIndex);
            this.updateObject(table);
        }
    }

    public void updateObject(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        if (tableType.equals(TABLE_PT) && this.m_predefTabs != null) {
            this.m_predefTabs.clear();
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem ti = items[i];
                PredefinedTab tab = (PredefinedTab)ti.getData(OBJECT);
                if (tab != null) {
                    this.m_predefTabs.add(tab);
                }
                ++i;
            }
        }
    }

    public void restoreDefaults(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            String type = (String)object;
            if (type == null || type.length() == 0) {
                return;
            }
            if (type.equals(BTN_RESTORE_IB)) {
                this.m_showIndiView2_chk.setSelection(true);
                this.m_canModifyFilters_chk.setSelection(true);
                this.m_canSort_chk.setSelection(true);
                this.m_canMoveTabs_chk.setSelection(true);
                this.m_canSwitch_chk.setSelection(true);
                this.m_globalSettings.put(UISettings.SHOW_INDI_VIEW2, "true");
                this.m_globalSettings.put(UISettings.CAN_MODIFY_FILTERS, "true");
                this.m_globalSettings.put(UISettings.CAN_SORT, "true");
                this.m_globalSettings.put(UISettings.CAN_MOVE_TABS, "true");
                this.m_globalSettings.put(UISettings.CAN_SWITCH, "true");
                this.m_colSettings.clear();
                for (String colName : EventStorageUtils.m_columnMap.keySet()) {
                    int colID = EventStorageUtils.m_columnMap.get(colName);
                    if (colID >= 33) continue;
                    int width = EventStorageUtils.defaultColumnWidth.get(colName);
                    int pos = 99;
                    int i = 0;
                    while (i < EventStorageUtils.defaultColumnOrder.length) {
                        if (colID == EventStorageUtils.defaultColumnOrder[i]) {
                            pos = i;
                            break;
                        }
                        ++i;
                    }
                    TblColumn column = new TblColumn(colName, pos, width, false);
                    this.m_colSettings.put(colName, column);
                }
                this.refreshTable(this.m_tbl_IB_CS);
            } else if (type.equals(BTN_RESTORE_PV)) {
                PredefinedView view1 = new PredefinedView(UISettings.MSG_VIEW1, true, true, true);
                PredefinedView view2 = new PredefinedView(UISettings.MSG_VIEW2, true, true, true);
                this.m_predefViews.clear();
                this.m_predefViews.put(UISettings.MSG_VIEW1, view1);
                this.m_predefViews.put(UISettings.MSG_VIEW2, view2);
                this.refreshTable(this.m_tbl_PV);
            }
        }
    }

    public void updateTableItem(Table table, TableItem selItem, Object obj) {
        if (table == null || table.isDisposed() || selItem == null || obj == null) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        int selIndex = table.getSelectionIndex();
        boolean doUpdate = false;
        if (tableType.equals(TABLE_IB_CS) && obj instanceof TblColumn) {
            TblColumn tblCol = (TblColumn)obj;
            selItem.setText(2, "" + tblCol.getWidth());
            selItem.setText(3, "" + tblCol.isColoringActive());
            doUpdate = true;
        } else if (tableType.equals(TABLE_PV) && obj instanceof PredefinedView) {
            PredefinedView view = (PredefinedView)obj;
            selItem.setText(new String[]{view.getViewID(), "" + view.canAddTabs(), "" + view.isClosable(), "" + view.isMoveable()});
            doUpdate = true;
        } else if (tableType.equals(TABLE_PT) && obj instanceof PredefinedTab) {
            PredefinedTab tab = (PredefinedTab)obj;
            int filterActive = tab.getActiveFilterCount();
            int filterNotActive = tab.getFilters().size() - filterActive;
            int colsVisible = tab.getVisibleColumnsCount();
            int colsHidden = tab.getColumns().size() - colsVisible;
            selItem.setText(new String[]{tab.getViewID(), tab.getName(), "" + tab.getShowActive(), tab.getSorting(), "" + tab.getType(), filterActive + "|" + filterNotActive, colsVisible + "|" + colsHidden});
            doUpdate = true;
        }
        if (doUpdate) {
            table.update();
            if (table.getItemCount() > selIndex) {
                table.setSelection(selIndex);
            } else if (table.getItemCount() > 0) {
                table.setSelection(0);
            }
        }
    }

    public void updateTableItem(Table table, TableItem[] selItems) {
        if (table == null || table.isDisposed() || selItems == null || selItems.length == 0) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        int selIndex = table.getSelectionIndex();
        if (tableType.equals(TABLE_IB_CS)) {
            int i = 0;
            while (i < selItems.length) {
                TableItem ti = selItems[i];
                TblColumn column = (TblColumn)ti.getData(OBJECT);
                if (column != null) {
                    ti.setText(new String[]{"" + (i + 1), column.getName(), "" + column.getWidth(), "" + column.isColoringActive()});
                }
                ++i;
            }
            table.update();
        } else if (tableType.equals(TABLE_PT)) {
            int i = 0;
            while (i < selItems.length) {
                TableItem ti = selItems[i];
                PredefinedTab tab = (PredefinedTab)ti.getData(OBJECT);
                if (tab != null) {
                    int filterActive = tab.getActiveFilterCount();
                    int filterNotActive = tab.getFilters().size() - filterActive;
                    int colsVisible = tab.getVisibleColumnsCount();
                    int colsHidden = tab.getColumns().size() - colsVisible;
                    ti.setText(new String[]{tab.getViewID(), tab.getName(), "" + tab.getShowActive(), tab.getSorting(), "" + tab.getType(), filterActive + "|" + filterNotActive, colsVisible + "|" + colsHidden});
                }
                ++i;
            }
            table.update();
        }
        if (table.getItemCount() > selIndex) {
            table.setSelection(selIndex);
        } else if (table.getItemCount() > 0) {
            table.setSelection(0);
        }
    }

    public void refreshTable(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        String tableType = (String)table.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        int selIndex = table.getSelectionIndex();
        if (tableType.equals(TABLE_IB_CS)) {
            if (this.m_colSettings != null) {
                HashMap<Integer, TblColumn> tmpMap = new HashMap<Integer, TblColumn>();
                for (String colName : this.m_colSettings.keySet()) {
                    TblColumn column = this.m_colSettings.get(colName);
                    tmpMap.put(column.getPosition(), column);
                }
                ArrayList list = new ArrayList();
                list.addAll(tmpMap.keySet());
                Collections.sort(list);
                table.removeAll();
                int i = 0;
                while (i < list.size()) {
                    int pos = (Integer)list.get(i);
                    TblColumn column = (TblColumn)tmpMap.get(pos);
                    TableItem item = new TableItem(table, 0);
                    item.setText(new String[]{"" + (i + 1), column.getName(), "" + column.getWidth(), "" + column.isColoringActive()});
                    item.setData(POSITION, (Object)i);
                    item.setData(OBJECT, (Object)column);
                    ++i;
                }
            }
        } else if (tableType.equals(TABLE_PV)) {
            if (this.m_predefViews != null) {
                int count = 0;
                table.removeAll();
                for (String viewID : this.m_predefViews.keySet()) {
                    PredefinedView view = this.m_predefViews.get(viewID);
                    TableItem item = new TableItem(table, 0);
                    item.setText(new String[]{view.getViewID(), "" + view.canAddTabs(), "" + view.isClosable(), "" + view.isMoveable()});
                    item.setData(POSITION, (Object)count);
                    item.setData(OBJECT, (Object)view);
                    ++count;
                }
            }
        } else if (tableType.equals(TABLE_PT) && this.m_predefTabs != null) {
            int index = 0;
            table.removeAll();
            for (PredefinedTab tab : this.m_predefTabs) {
                int filterActive = tab.getActiveFilterCount();
                int filterNotActive = tab.getFilters().size() - filterActive;
                int colsVisible = tab.getVisibleColumnsCount();
                int colsHidden = tab.getColumns().size() - colsVisible;
                TableItem item = new TableItem(table, 0);
                item.setText(new String[]{tab.getViewID(), tab.getName(), "" + tab.getShowActive(), tab.getSorting(), "" + tab.getType(), filterActive + "|" + filterNotActive, colsVisible + "|" + colsHidden});
                item.setData(POSITION, (Object)index);
                item.setData(OBJECT, (Object)tab);
                ++index;
            }
        }
        if (table.getItemCount() > selIndex) {
            table.setSelection(selIndex);
        } else if (table.getItemCount() > 0) {
            table.setSelection(0);
        }
    }

    public void checkBtnStatus(String type) {
        if (type == null || type.length() == 0) {
            return;
        }
        if (type.equals(TABLE_IB_CS)) {
            int[] sel = this.m_tbl_IB_CS.getSelectionIndices();
            if (sel.length <= 0) {
                this.m_btn_up_IB_CS.setEnabled(false);
                this.m_btn_down_IB_CS.setEnabled(false);
                this.m_btn_edit_IB_CS.setEnabled(false);
            } else if (sel.length == 1) {
                int index = sel[0];
                if (index == -1) {
                    this.m_btn_up_IB_CS.setEnabled(false);
                    this.m_btn_down_IB_CS.setEnabled(false);
                    this.m_btn_edit_IB_CS.setEnabled(false);
                } else if (index == 0) {
                    this.m_btn_up_IB_CS.setEnabled(false);
                    this.m_btn_down_IB_CS.setEnabled(true);
                    this.m_btn_edit_IB_CS.setEnabled(true);
                } else if (index == this.m_tbl_IB_CS.getItemCount() - 1) {
                    this.m_btn_up_IB_CS.setEnabled(true);
                    this.m_btn_down_IB_CS.setEnabled(false);
                    this.m_btn_edit_IB_CS.setEnabled(true);
                } else {
                    this.m_btn_up_IB_CS.setEnabled(true);
                    this.m_btn_down_IB_CS.setEnabled(true);
                    this.m_btn_edit_IB_CS.setEnabled(true);
                }
            } else {
                this.m_btn_up_IB_CS.setEnabled(false);
                this.m_btn_down_IB_CS.setEnabled(false);
                this.m_btn_edit_IB_CS.setEnabled(false);
            }
        } else if (type.equals(LIST_IB_GLOBAL_FILTER)) {
            this.m_gui.enableField(this.m_btn_edit_globalFilter, true);
        } else if (type.equals(TABLE_PV)) {
            int index = this.m_tbl_PV.getSelectionIndex();
            if (index == -1) {
                this.m_btn_edit_PV.setEnabled(false);
            } else {
                this.m_btn_edit_PV.setEnabled(true);
            }
        } else if (type.equals(TABLE_PT)) {
            int index = this.m_tbl_PT.getSelectionIndex();
            if (index == -1) {
                this.m_gui.enableField(this.m_btn_edit_PT, false);
                this.m_gui.enableField(this.m_btn_delete_PT, false);
                this.m_gui.enableField(this.m_btn_up_PT, false);
                this.m_gui.enableField(this.m_btn_down_PT, false);
            } else {
                this.m_gui.enableField(this.m_btn_edit_PT, true);
                this.m_gui.enableField(this.m_btn_delete_PT, true);
                if (index == 0) {
                    this.m_gui.enableField(this.m_btn_up_PT, false);
                    this.m_gui.enableField(this.m_btn_down_PT, true);
                } else if (index == this.m_predefTabs.size() - 1) {
                    this.m_gui.enableField(this.m_btn_up_PT, true);
                    this.m_gui.enableField(this.m_btn_down_PT, false);
                } else {
                    this.m_gui.enableField(this.m_btn_up_PT, true);
                    this.m_gui.enableField(this.m_btn_down_PT, true);
                }
            }
        }
    }

    public static List<TblColumn> getSetOfDefaultColumnsSorted() {
        HashMap<Integer, TblColumn> tmp = new HashMap<Integer, TblColumn>();
        ArrayList<TblColumn> defaultColsSorted = new ArrayList<TblColumn>();
        try {
            TblColumn column;
            int pos;
            for (String colName : EventStorageUtils.m_columnMap.keySet()) {
                int colID = EventStorageUtils.m_columnMap.get(colName);
                if (colID >= 33) continue;
                int width = EventStorageUtils.defaultColumnWidth.get(colName);
                pos = 99;
                int i = 0;
                while (i < EventStorageUtils.defaultColumnOrder.length) {
                    if (colID == EventStorageUtils.defaultColumnOrder[i]) {
                        pos = i;
                        break;
                    }
                    ++i;
                }
                column = new TblColumn(colName, pos, width, false);
                tmp.put(pos, column);
            }
            Set set = tmp.keySet();
            ArrayList sorted = new ArrayList();
            sorted.addAll(set);
            Collections.sort(sorted);
            int ii = 0;
            while (ii < sorted.size()) {
                pos = (Integer)sorted.get(ii);
                column = (TblColumn)tmp.get(pos);
                defaultColsSorted.add(column);
                ++ii;
            }
        }
        catch (Exception exception) {}
        return defaultColsSorted;
    }

    private Color selectColorDialog(Color color) {
        RGB rgb = null;
        if (color != null) {
            rgb = color.getRGB();
        }
        Color color_new = null;
        try {
            ColorDialog dlg = new ColorDialog(this.m_parentShell);
            dlg.setText("Choose a Color");
            dlg.setRGB(rgb);
            RGB rgb_new = dlg.open();
            if (rgb_new != null) {
                color_new = new Color((Device)Display.getCurrent(), rgb_new.red, rgb_new.green, rgb_new.blue);
            }
        }
        catch (Exception exception) {}
        return color_new;
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            Button chkBox = (Button)o;
            String type = (String)chkBox.getData();
            if (type == null) {
                return;
            }
            if (type.equals(UISettings.SHOW_INDI_VIEW2)) {
                this.m_globalSettings.put(UISettings.SHOW_INDI_VIEW2, chkBox.getSelection());
            } else if (type.equals(UISettings.CAN_MODIFY_FILTERS)) {
                this.m_globalSettings.put(UISettings.CAN_MODIFY_FILTERS, chkBox.getSelection());
            } else if (type.equals(UISettings.CAN_SORT)) {
                this.m_globalSettings.put(UISettings.CAN_SORT, "" + chkBox.getSelection());
            } else if (type.equals(UISettings.CAN_MOVE_TABS)) {
                this.m_globalSettings.put(UISettings.CAN_MOVE_TABS, "" + chkBox.getSelection());
            } else if (type.equals(UISettings.CAN_SWITCH)) {
                this.m_globalSettings.put(UISettings.CAN_SWITCH, "" + chkBox.getSelection());
            } else if (type.equals(BTN_RESTORE_IB)) {
                this.restoreDefaults(type);
                this.checkBtnStatus(TABLE_IB_CS);
            } else if (type.equals(BTN_RESTORE_PV)) {
                this.restoreDefaults(type);
                this.checkBtnStatus(TABLE_PV);
            } else if (type.equals(BTN_APPLY)) {
                UISettings.getInstance().storeAndReload();
                try {
                    MessageBrowserTab mbt = (MessageBrowserTab)MessagesView.getInstance().m_folder.getSelection();
                    mbt.getTableViewer().setInput(new EventBrowserProvider(EventStorage.getInstance()));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else if (type.equals(BTN_IB_COLOR_ACTIVE)) {
                Color color = this.m_colorOptions.get(UISettings.IB_COLOR_ACTIVE);
                Color newColor = this.selectColorDialog(color);
                if (newColor != null) {
                    this.m_ib_bgColor_active.setBackground(newColor);
                    this.m_colorOptions.put(UISettings.IB_COLOR_ACTIVE, newColor);
                }
            } else if (type.equals(BTN_IB_COLOR_CLOSED)) {
                Color color = this.m_colorOptions.get(UISettings.IB_COLOR_CLOSED);
                Color newColor = this.selectColorDialog(color);
                if (newColor != null) {
                    this.m_ib_bgColor_closed.setBackground(newColor);
                    this.m_colorOptions.put(UISettings.IB_COLOR_CLOSED, newColor);
                }
            } else if (type.equals(BTN_OB_COLOR_ACTIVE)) {
                Color color = this.m_colorOptions.get(UISettings.OB_COLOR_ACTIVE);
                Color newColor = this.selectColorDialog(color);
                if (newColor != null) {
                    this.m_ob_bgColor_active.setBackground(newColor);
                    this.m_colorOptions.put(UISettings.OB_COLOR_ACTIVE, newColor);
                }
            } else if (type.equals(BTN_OB_COLOR_CLOSED)) {
                Color color = this.m_colorOptions.get(UISettings.OB_COLOR_CLOSED);
                Color newColor = this.selectColorDialog(color);
                if (newColor != null) {
                    this.m_ob_bgColor_closed.setBackground(newColor);
                    this.m_colorOptions.put(UISettings.OB_COLOR_CLOSED, newColor);
                }
            } else if (type.equals(BTN_EDIT_IB_GLOBAL_FILTER)) {
                PredefinedFilterDialog efd = new PredefinedFilterDialog(Repository.getEventsSummary(), this.m_globalFilters, m_list_IB_globalFilters);
                efd.open();
            } else {
                this.changeTable(type);
            }
        } else if (o instanceof Table) {
            Table tbl = (Table)o;
            String tableType = (String)tbl.getData();
            if (tableType == null) {
                return;
            }
            if (tableType.equals(TABLE_IB_CS)) {
                this.checkBtnStatus(TABLE_IB_CS);
            } else if (tableType.equals(TABLE_PV)) {
                this.checkBtnStatus(TABLE_PV);
            } else if (tableType.equals(TABLE_PT)) {
                this.checkBtnStatus(TABLE_PT);
            }
        } else if (o instanceof Label) {
            Label l = (Label)o;
            String type = (String)l.getData();
            if (type == null) {
                return;
            }
        } else if (o instanceof CCombo) {
            CCombo c = (CCombo)o;
            String name = (String)c.getData();
            if (name.equals(SORT_COL)) {
                this.m_sortCol = c.getText();
                this.m_globalSettings.put(UISettings.GLOBAL_SORT_COL, this.m_sortCol);
            } else if (name.equals(SORT_DIR)) {
                this.m_sortDir = c.getText();
                this.m_globalSettings.put(UISettings.GLOBAL_SORT_DIR, this.m_sortDir);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Table) {
            Table tbl = (Table)o;
            String name = (String)tbl.getData();
            if (name.equals(TABLE_IB_CS)) {
                this.changeTable(BTN_EDIT_IB_CS);
            } else if (name.equals(TABLE_PV)) {
                this.changeTable(BTN_EDIT_PV);
            } else if (name.equals(TABLE_PT)) {
                this.changeTable(BTN_EDIT_PT);
            }
        } else if (o instanceof org.eclipse.swt.widgets.List) {
            PredefinedFilterDialog efd = new PredefinedFilterDialog(Repository.getEventsSummary(), this.m_globalFilters, m_list_IB_globalFilters);
            efd.open();
        }
    }
}

