/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.calendar.CalendarDialog;
import com.blixx.boom.gui.utils.calendar.SWTCalListener;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.HashMapArray;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PredefinedFilterDialog
implements SelectionListener,
ModifyListener,
ShellListener,
MouseListener {
    public PredefinedFilterDialog evDialog = null;
    public Shell m_shell = null;
    public EventFilter m_selectedFilter = null;
    public TableViewer m_filter_tv = null;
    public TreeViewer m_treeViewer = null;
    public PredefFilterTableProvider m_tableProvider = null;
    private FilterFactory m_filterFactory = null;
    public HashMap<String, EventFilter> m_historyFilters = null;
    public GUIDisplayElements m_gde = null;
    private int m_type_a = 0;
    private int m_type_k = 0;
    public Composite m_compMain = null;
    private Table m_fitler_table = null;
    public org.eclipse.swt.widgets.List m_history_list = null;
    public CCombo m_column_Combo = null;
    private CCombo m_condition_Combo = null;
    private CCombo m_match_combo = null;
    private Label m_textMatch_label = null;
    private Label m_filterName = null;
    private Text m_label = null;
    private Text m_match_field = null;
    private Button m_unknown_check = null;
    private Button m_normal_check = null;
    private Button m_warning_check = null;
    private Button m_minor_check = null;
    private Button m_major_check = null;
    private Button m_critical_check = null;
    private List<Object> m_sev_elems = null;
    private Text m_year_field = null;
    private Text m_month_field = null;
    private Text m_day_field = null;
    private Text m_hrs_field = null;
    private Text m_min_field = null;
    private Text m_sec_field = null;
    private Label m_date_label = null;
    private Label m_dateFormat_label = null;
    private Label m_time_label = null;
    private Label m_timeFormat_label = null;
    private Button m_isNot_check = null;
    private Button m_match_check = null;
    private Button m_caseSensitive_check = null;
    private Button m_typeA_check = null;
    private Button m_typeK_check = null;
    public Button m_addAsNew_button = null;
    public Button m_delFilter_button = null;
    public Button m_loadFromFile_button = null;
    public Button m_saveToFile_button = null;
    public Button m_moveToHistory_button = null;
    public Button m_moveToCurrent_button = null;
    private Button m_close_button = null;
    public Button m_cancel_button = null;
    public Button m_apply_button = null;
    private Group m_grp_condition = null;
    private Group m_grp_textMatch = null;
    public Group m_grp_severity = null;
    public Group m_grp_dateMatch = null;
    private Label m_calendar_icon = null;
    private static final String LABEL = "LABEL";
    public static final String NEW_FILTER = "*** New Filter ***";
    private static final String FILTER_TABLE = "FILTER_TABLE";
    private static final String HISTORY_LIST = "HISTOREY_LIST";
    private static final String COLUMN_COMBO = "COLUMNS_COMBO";
    private static final String CONDITION_COMBO = "CONDITION_COMBO";
    private static final String MATCH_COMBO = "MATCH_COMBO";
    private static final String MATCH_CHECK = "MATCH_CHECK";
    private static final String MATCH_FIELD = "MATCH_FIELD";
    private static final String CASE_SENSITIVE_CHECK = "CASE_SENSITIVE_CHECK";
    private static final String YEAR_FIELD = "YEAR_FIELD";
    private static final String MONTH_FIELD = "MONTH_FIELD";
    private static final String DAY_FIELD = "DAY_FIELD";
    private static final String HRS_FIELD = "HRS_FIELD";
    private static final String MIN_FIELD = "MIN_FIELD";
    private static final String SEC_FIELD = "SEC_FIELD";
    private static final String ISNOT = "ISNOT";
    private static final String TYPE_A = "TYPE_A";
    private static final String TYPE_K = "TYPE_K";
    public static final String ADD_AS_NEW = "ADD_AS_NEW";
    public static final String DEL_FILTER = "DEL_FILTER";
    public static final String LOAD_FROM_FILE = "LOAD_FROM_FILE";
    public static final String SAVE_TO_FILE = "SAVE_TO_FILE";
    private static final String MOVE_TO_HISTORY = "MOVE_TO_HISTORY";
    private static final String MOVE_TO_CURRENT = "ADD_TO_CURRENT";
    private static final String DEL_FROM_HISTORY = "DEL_FROM_HISTORY";
    public static final String APPLY = "APPLY";
    private static final String CLOSE = "CLOSE";
    private static final String CANCEL = "CANCEL";
    private static final String LESS = "<";
    private static final String BIGGER = ">";
    private static final String EXACTLY = "EXACTLY";
    private static final String ENDS_WITH = "ENDS WITH";
    private static final String STARTS_WITH = "STARTS WITH";
    private static final String CONTAINS = "CONTAINS";
    public static Map<String, Integer> m_colIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condTextIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condDupIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condSevIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_sevIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condTimeIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condOwnerIndices = new LinkedHashMap<String, Integer>();
    public static List<String> m_colList = null;
    private static List<String> m_condText_List = null;
    private static List<String> m_condDup_List = null;
    private static List<String> m_condSev_List = null;
    private static List<String> m_condTime_List = null;
    private static List<String> m_condOwner_List = null;
    private ArrayList<String> m_applications = null;
    private ArrayList<String> m_groups = null;
    private ArrayList<String> m_hosts = null;
    private ArrayList<String> m_objects = null;
    private ArrayList<String> m_agents = null;
    private ArrayList<String> m_owners = new ArrayList();
    public static final char SEPARATOR_DEFAULT = '\u25ba';
    private IEventsSummary m_eventStorageSummary = null;
    private Map<String, EventFilter> m_predefFilters_local = new HashMap<String, EventFilter>();
    private Map<String, EventFilter> m_predefFilters = new HashMap<String, EventFilter>();
    private org.eclipse.swt.widgets.List m_list_IB_PF = null;

    static {
        m_colIndices.put("Agent", 0);
        m_colIndices.put("Application", 1);
        m_colIndices.put("Duplicates", 2);
        m_colIndices.put("Group", 3);
        m_colIndices.put("Host", 4);
        m_colIndices.put("Object", 5);
        m_colIndices.put("Severity", 6);
        m_colIndices.put("Text", 7);
        m_colIndices.put("Time", 8);
        m_colIndices.put("SrvTime", 9);
        m_colIndices.put("Source", 10);
        m_colIndices.put("CA name", 11);
        m_colIndices.put("CA value", 12);
        m_colIndices.put("SlaveServerName", 13);
        m_colIndices.put("ID", 14);
        m_colIndices.put("Owned", 15);
        m_colIndices.put("Node group", 16);
        m_colIndices.put("AgentID", 17);
        m_colIndices.put("Node group [Hosts]", 18);
        m_condTextIndices.put(CONTAINS, 0);
        m_condTextIndices.put(STARTS_WITH, 1);
        m_condTextIndices.put(ENDS_WITH, 2);
        m_condTextIndices.put(EXACTLY, 3);
        m_condDupIndices.put(EXACTLY, 0);
        m_condDupIndices.put(LESS, 1);
        m_condDupIndices.put(BIGGER, 2);
        m_condOwnerIndices.put(EXACTLY, 0);
        m_condTimeIndices.put(LESS, 0);
        m_condTimeIndices.put(BIGGER, 1);
        m_condSevIndices.put(CONTAINS, 0);
        m_condSevIndices.put(EXACTLY, 1);
        m_sevIndices.put("unknown", 0);
        m_sevIndices.put("normal", 1);
        m_sevIndices.put("warning", 2);
        m_sevIndices.put("minor", 3);
        m_sevIndices.put("major", 4);
        m_sevIndices.put("critical", 5);
        m_colList = new ArrayList<String>(m_colIndices.keySet());
        m_condText_List = new ArrayList<String>(m_condTextIndices.keySet());
        m_condDup_List = new ArrayList<String>(m_condDupIndices.keySet());
        m_condSev_List = new ArrayList<String>(m_condSevIndices.keySet());
        m_condTime_List = new ArrayList<String>(m_condTimeIndices.keySet());
        m_condOwner_List = new ArrayList<String>(m_condOwnerIndices.keySet());
    }

    public PredefinedFilterDialog(IEventsSummary eventStorage, Map<String, EventFilter> predefFilters, org.eclipse.swt.widgets.List list_IB_PF) {
        this.m_eventStorageSummary = eventStorage;
        this.m_predefFilters = predefFilters;
        this.m_predefFilters_local.putAll(predefFilters);
        this.m_list_IB_PF = list_IB_PF;
        this.evDialog = this;
        this.m_historyFilters = new HashMap();
        this.m_filterFactory = new FilterFactory();
        this.m_owners.add("Me");
        this.m_owners.add("Me+Nobody");
        this.m_owners.add("Nobody");
        this.m_owners.add("Other");
        this.m_agents = new ArrayList();
        Collection<AgentCard> list = Repository.getInstance().getAgentCards();
        for (AgentCard ac : list) {
            this.m_agents.add(ac.getAgentHost());
        }
        Collections.sort(this.m_agents);
        int style = 1265;
        this.m_shell = new Shell(Display.getCurrent().getActiveShell(), style);
        this.m_shell.setLayout((Layout)new GridLayout(1, false));
        this.m_shell.setText("  Predefined Filter Dialog");
        this.setImage();
        this.m_shell.addShellListener((ShellListener)this);
    }

    public void setImage() {
        this.m_shell.setImage(BMUI.IMAGE_FILTERED);
    }

    protected void createContents(Composite parent) {
        this.m_gde = new GUIDisplayElements();
        this.m_compMain = new Composite(parent, 0);
        GridLayout gdl = new GridLayout(2, false);
        gdl.marginBottom = 2;
        gdl.marginTop = 2;
        gdl.marginLeft = 2;
        gdl.marginRight = 2;
        this.m_compMain.setLayout((Layout)gdl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite compLeft = new Composite(this.m_compMain, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        compLeft.setLayout((Layout)gl);
        compLeft.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createFilterListSection(compLeft);
        Composite compUpDownBtn = new Composite(compLeft, 0);
        gl = new GridLayout(3, true);
        gl.marginHeight = 0;
        compUpDownBtn.setLayout((Layout)gl);
        compUpDownBtn.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.m_moveToHistory_button = this.m_gde.addButton(compUpDownBtn, MOVE_TO_HISTORY, "", false, 120, 10, 1, 1028, this);
        this.m_moveToCurrent_button = this.m_gde.addButton(compUpDownBtn, MOVE_TO_CURRENT, "", false, 120, 10, 1, 132, this);
        ((GridData)this.m_moveToCurrent_button.getLayoutData()).horizontalIndent = 5;
        this.createHistoryList(compLeft);
        Composite compRight = new Composite(this.m_compMain, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        compRight.setLayout((Layout)gl);
        compRight.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.createFilterDetails(compRight);
        this.createButtonBar(compRight);
        this.loadHistory();
        this.updateHistoryList(null);
        this.updateFilterDetails();
    }

    public void createFilterListSection(Composite parent) {
        Group grp_filterList = new Group(parent, 32);
        grp_filterList.setText("Current Filters: ");
        grp_filterList.setLayout((Layout)new GridLayout(2, false));
        grp_filterList.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_fitler_table = new Table((Composite)grp_filterList, 268503842);
        this.m_fitler_table.setHeaderVisible(false);
        this.m_fitler_table.setLinesVisible(false);
        this.m_fitler_table.setData((Object)FILTER_TABLE);
        this.m_fitler_table.addMouseListener((MouseListener)this);
        GridData gdData = new GridData(1808);
        gdData.verticalSpan = 3;
        gdData.widthHint = 250;
        gdData.heightHint = 130;
        this.m_fitler_table.setLayoutData((Object)gdData);
        TableColumn col1 = new TableColumn(this.m_fitler_table, 0x1000000);
        col1.setWidth(20);
        TableColumn col2 = new TableColumn(this.m_fitler_table, 16384);
        col2.setWidth(248);
        this.m_filter_tv = new TableViewer(this.m_fitler_table);
        this.m_tableProvider = new PredefFilterTableProvider(this.m_filter_tv, this.evDialog, this.m_predefFilters_local);
        this.m_filter_tv.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_filter_tv.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_filter_tv.setInput((Object)this.m_tableProvider.getElements(null));
        this.m_filter_tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof TableViewer) {
                    TableItem[] itemList = PredefinedFilterDialog.this.m_filter_tv.getTable().getSelection();
                    if (itemList.length > 0) {
                        PredefinedFilterDialog.this.m_selectedFilter = (EventFilter)((Object)itemList[0].getData());
                        PredefinedFilterDialog.this.updateFilterDetails();
                    }
                    PredefinedFilterDialog.this.m_gde.enableField(PredefinedFilterDialog.this.m_moveToCurrent_button, false);
                    PredefinedFilterDialog.this.m_gde.enableField(PredefinedFilterDialog.this.m_moveToHistory_button, true);
                    PredefinedFilterDialog.this.m_history_list.deselectAll();
                }
            }
        });
        if (this.m_filter_tv.getTable().getItemCount() > 0) {
            this.m_filter_tv.getTable().select(0);
            this.m_selectedFilter = (EventFilter)((Object)this.m_filter_tv.getTable().getItem(0).getData());
        }
        this.m_delFilter_button = this.m_gde.addButton((Composite)grp_filterList, DEL_FILTER, " Delete ", true, 120, 10, 1, this);
        ((GridData)this.m_delFilter_button.getLayoutData()).grabExcessVerticalSpace = true;
        this.m_loadFromFile_button = this.m_gde.addButton((Composite)grp_filterList, LOAD_FROM_FILE, " Import ", true, 120, 10, 1, this);
        ((GridData)this.m_loadFromFile_button.getLayoutData()).horizontalAlignment = 1024;
        this.m_saveToFile_button = this.m_gde.addButton((Composite)grp_filterList, SAVE_TO_FILE, " Export ", true, 120, 10, 1, this);
        ((GridData)this.m_saveToFile_button.getLayoutData()).horizontalAlignment = 1024;
    }

    public void createHistoryList(Composite parent) {
        Group grp_history = new Group(parent, 32);
        grp_history.setText("Filter History: ");
        grp_history.setLayout((Layout)new GridLayout(2, false));
        grp_history.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_history_list = new org.eclipse.swt.widgets.List((Composite)grp_history, 2818);
        this.m_history_list.setData((Object)HISTORY_LIST);
        GridData gd = new GridData(250, 100);
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.m_history_list.setLayoutData((Object)gd);
        this.m_history_list.addSelectionListener((SelectionListener)this);
        this.m_gde.addButton((Composite)grp_history, DEL_FROM_HISTORY, " Delete ", true, 120, 10, 1, this);
    }

    public void createFilterDetails(Composite parent) {
        Group grp_filterDetails = new Group(parent, 32);
        grp_filterDetails.setText("Filter Details");
        grp_filterDetails.setLayout((Layout)new GridLayout(2, false));
        grp_filterDetails.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_filterName = this.m_gde.addTextField((Composite)grp_filterDetails, null, NEW_FILTER, 2, 1, 0, 0, BMUI.font_arial8_bold);
        ((GridData)this.m_filterName.getLayoutData()).widthHint = 40;
        ((GridData)this.m_filterName.getLayoutData()).horizontalAlignment = 4;
        this.m_filterName.setForeground(BMUI.color_critical);
        this.m_label = this.m_gde.addInputFieldSingle((Composite)grp_filterDetails, LABEL, "Label: ", "", 1, 1, 0, 0, 120, this);
        ((GridData)this.m_label.getLayoutData()).horizontalAlignment = 4;
        Group grpCol = new Group((Composite)grp_filterDetails, 32);
        grpCol.setText("Select Column");
        grpCol.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 5;
        grpCol.setLayoutData((Object)gd);
        this.m_column_Combo = this.m_gde.addDropDown((Composite)grpCol, COLUMN_COMBO, null, m_colList.toArray(new String[0]), m_colList.get(0), null, 2, 1, 1, 1, this);
        ((GridData)this.m_column_Combo.getLayoutData()).widthHint = 40;
        ((GridData)this.m_column_Combo.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_column_Combo.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_grp_condition = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_condition.setText("Select Condition");
        this.m_grp_condition.setLayout((Layout)new GridLayout(2, false));
        this.m_grp_condition.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_isNot_check = this.m_gde.addCheckbox((Composite)this.m_grp_condition, ISNOT, "NOT", false, 1, 1, 1, this);
        this.m_condition_Combo = this.m_gde.addDropDown((Composite)this.m_grp_condition, CONDITION_COMBO, null, m_condText_List.toArray(new String[0]), m_condText_List.get(0), null, 1, 1, 1, 1, this);
        ((GridData)this.m_condition_Combo.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_condition_Combo.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_grp_textMatch = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_textMatch.setText("Text Matching");
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        this.m_grp_textMatch.setLayout((Layout)gl);
        this.m_grp_textMatch.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_textMatch_label = this.m_gde.addTextField((Composite)this.m_grp_textMatch, null, "Existing values: ", 1, 1, 1, 1, null);
        this.m_match_combo = this.m_gde.addDropDown((Composite)this.m_grp_textMatch, MATCH_COMBO, null, new String[0], "", null, 1, 1, 1, 1, this);
        ((GridData)this.m_match_combo.getLayoutData()).widthHint = 40;
        ((GridData)this.m_match_combo.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_match_combo.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_match_combo.setVisibleItemCount(35);
        this.m_match_check = this.m_gde.addCheckbox((Composite)this.m_grp_textMatch, MATCH_CHECK, "Free Text:", false, 1, 1, 1, this);
        this.m_match_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_textMatch, MATCH_FIELD, null, "", 1, 1, 1, 1, 150, this);
        ((GridData)this.m_match_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_match_field.getLayoutData()).horizontalAlignment = 4;
        this.m_gde.enableField(this.m_match_field, false);
        this.m_gde.addTextField((Composite)this.m_grp_textMatch, null, "", 1, 1, 1, 1, null);
        this.m_caseSensitive_check = this.m_gde.addCheckbox((Composite)this.m_grp_textMatch, CASE_SENSITIVE_CHECK, "Case Sensitive", false, 1, 1, 1, this);
        this.m_sev_elems = new ArrayList<Object>();
        this.m_grp_severity = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_severity.setText("Severity");
        gl = new GridLayout(9, false);
        gl.verticalSpacing = 0;
        this.m_grp_severity.setLayout((Layout)gl);
        this.m_grp_severity.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_unknown_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        Label unknown_icon = new Label((Composite)this.m_grp_severity, 0);
        unknown_icon.setImage(BMUI.IMAGE_UNKNOWN);
        Label unknown_label = new Label((Composite)this.m_grp_severity, 0);
        unknown_label.setText("unknown");
        this.m_sev_elems.add(this.m_unknown_check);
        this.m_sev_elems.add(unknown_icon);
        this.m_sev_elems.add(unknown_label);
        this.m_normal_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_normal_check.getLayoutData()).horizontalIndent = 30;
        Label normal_icon = new Label((Composite)this.m_grp_severity, 0);
        normal_icon.setImage(BMUI.IMAGE_NORMAL);
        Label normal_label = new Label((Composite)this.m_grp_severity, 0);
        normal_label.setText("normal");
        this.m_sev_elems.add(this.m_normal_check);
        this.m_sev_elems.add(normal_icon);
        this.m_sev_elems.add(normal_label);
        this.m_warning_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_warning_check.getLayoutData()).horizontalIndent = 30;
        Label warning_icon = new Label((Composite)this.m_grp_severity, 0);
        warning_icon.setImage(BMUI.IMAGE_WARNING);
        Label warning_label = new Label((Composite)this.m_grp_severity, 0);
        warning_label.setText("warning");
        this.m_sev_elems.add(this.m_warning_check);
        this.m_sev_elems.add(warning_icon);
        this.m_sev_elems.add(warning_label);
        this.m_minor_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        Label minor_icon = new Label((Composite)this.m_grp_severity, 0);
        minor_icon.setImage(BMUI.IMAGE_MINOR);
        Label minor_label = new Label((Composite)this.m_grp_severity, 0);
        minor_label.setText("minor");
        this.m_sev_elems.add(this.m_minor_check);
        this.m_sev_elems.add(minor_icon);
        this.m_sev_elems.add(minor_label);
        this.m_major_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_major_check.getLayoutData()).horizontalIndent = 30;
        Label major_icon = new Label((Composite)this.m_grp_severity, 0);
        major_icon.setImage(BMUI.IMAGE_MAJOR);
        Label major_label = new Label((Composite)this.m_grp_severity, 0);
        major_label.setText("major");
        this.m_sev_elems.add(this.m_major_check);
        this.m_sev_elems.add(major_icon);
        this.m_sev_elems.add(major_label);
        this.m_critical_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_critical_check.getLayoutData()).horizontalIndent = 30;
        Label critical_icon = new Label((Composite)this.m_grp_severity, 0);
        critical_icon.setImage(BMUI.IMAGE_CRITICAL);
        Label critical_label = new Label((Composite)this.m_grp_severity, 0);
        critical_label.setText("critical");
        this.m_sev_elems.add(this.m_critical_check);
        this.m_sev_elems.add(critical_icon);
        this.m_sev_elems.add(critical_label);
        this.enableTextMatching(true, true, false, false);
        this.m_grp_dateMatch = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_dateMatch.setText("Time Matching");
        this.m_grp_dateMatch.setLayout((Layout)new GridLayout(12, false));
        this.m_grp_dateMatch.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_date_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "Date: ", 1, 1, 1, 1, null);
        ((GridData)this.m_date_label.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_year_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, YEAR_FIELD, null, "", 1, 1, 1, 1, 30, this);
        this.m_year_field.setTextLimit(4);
        this.m_month_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, MONTH_FIELD, null, "", 1, 1, 1, 1, 15, this);
        this.m_month_field.setTextLimit(2);
        this.m_day_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, DAY_FIELD, null, "", 1, 1, 1, 1, 15, this);
        this.m_day_field.setTextLimit(2);
        this.m_calendar_icon = new Label((Composite)this.m_grp_dateMatch, 0);
        this.m_calendar_icon.setImage(BMUI.IMAGE_CALENDAR);
        this.m_calendar_icon.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                CalendarDialog cd = new CalendarDialog(PredefinedFilterDialog.this.m_shell);
                SWTCalListener calendar2 = new SWTCalListener();
                cd.addDateChangedListener(calendar2);
                cd.setBlockOnOpen(true);
                cd.open();
                PredefinedFilterDialog.this.m_year_field.setText(calendar2.getYear());
                PredefinedFilterDialog.this.m_month_field.setText(calendar2.getMonth());
                PredefinedFilterDialog.this.m_day_field.setText(calendar2.getDay());
            }
        });
        this.m_dateFormat_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "yyyy/mm/dd  ", 1, 1, 1, 1, null);
        ((GridData)this.m_dateFormat_label.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_time_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "Time: ", 1, 1, 1, 20, null);
        ((GridData)this.m_time_label.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_hrs_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, HRS_FIELD, null, "", 1, 1, 1, 1, 15, this);
        this.m_hrs_field.setTextLimit(2);
        this.m_min_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, MIN_FIELD, null, "", 1, 1, 1, 1, 15, this);
        this.m_min_field.setTextLimit(2);
        this.m_sec_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, SEC_FIELD, null, "", 1, 1, 1, 1, 15, this);
        this.m_sec_field.setTextLimit(2);
        this.m_timeFormat_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "h/m/s", 1, 1, 1, 1, null);
        ((GridData)this.m_timeFormat_label.getLayoutData()).verticalAlignment = 0x1000000;
        Composite comp = new Composite((Composite)grp_filterDetails, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_typeA_check = this.m_gde.addCheckbox(comp, TYPE_A, "AND +Availability", false, 1, 1, 5, this);
        this.m_typeK_check = this.m_gde.addCheckbox(comp, TYPE_K, "AND +KPI", false, 1, 1, 5, this);
    }

    public void createButtonBar(Composite parent) {
        Composite compButton = new Composite(parent, 0);
        GridLayout gl = new GridLayout(4, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compButton.setLayout((Layout)gl);
        GridData gd = new GridData(131072, 128, true, true, 2, 1);
        gd.verticalIndent = 10;
        compButton.setLayoutData((Object)gd);
        this.m_addAsNew_button = this.m_gde.addButton(compButton, ADD_AS_NEW, " Add As New ", true, 120, 60, 1, this);
        this.m_addAsNew_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_apply_button = this.m_gde.addButton(compButton, APPLY, " Apply ", true, 120, 60, 1, this);
        this.m_apply_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_close_button = this.m_gde.addButton(compButton, CLOSE, " Close ", true, 120, 60, 1, this);
        this.m_close_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_cancel_button = this.m_gde.addButton(compButton, CANCEL, " Cancel ", true, 120, 60, 1, this);
        this.m_cancel_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
    }

    public void fillConditionCombo(String colType) {
        this.m_condition_Combo.removeAll();
        if (colType == null) {
            return;
        }
        if (colType.equals("Duplicates")) {
            this.m_condition_Combo.setItems(m_condDup_List.toArray(new String[0]));
        } else if (colType.equals("Severity")) {
            this.m_condition_Combo.setItems(m_condSev_List.toArray(new String[0]));
        } else if (colType.equals("Time") || colType.equals("SrvTime")) {
            this.m_condition_Combo.setItems(m_condTime_List.toArray(new String[0]));
        } else if (colType.equals("Owned")) {
            this.m_condition_Combo.setItems(m_condOwner_List.toArray(new String[0]));
        } else {
            this.m_condition_Combo.setItems(m_condText_List.toArray(new String[0]));
        }
        if (this.m_condition_Combo.getItemCount() > 0) {
            this.m_condition_Combo.select(0);
        }
    }

    public void fillTextMatchCombo(String colType) {
        Set keySet = null;
        if (colType == null) {
            this.m_match_combo.removeAll();
            this.enableTextMatching(true, false, true, false);
            this.enableTimeMatching(false);
            this.enableCondSection(true, true, true);
            return;
        }
        ArrayList<String> tmpList = null;
        if (colType.equals("Application")) {
            keySet = this.m_eventStorageSummary.getApplications().keySet();
            tmpList = this.m_applications;
        } else if (colType.equals("Group")) {
            keySet = this.m_eventStorageSummary.getMsgGrps().keySet();
            tmpList = this.m_groups;
        } else if (colType.equals("Host")) {
            keySet = this.m_eventStorageSummary.getHosts().keySet();
            tmpList = this.m_hosts;
        } else if (colType.equals("Object")) {
            keySet = this.m_eventStorageSummary.getObjects().keySet();
            tmpList = this.m_objects;
        } else if (colType.equals("Agent")) {
            tmpList = this.m_agents;
        } else if (colType.equals("Owned")) {
            tmpList = this.m_owners;
        }
        if (tmpList == null) {
            HashMap tmpMap = null;
            if (keySet != null) {
                ArrayList keys = new ArrayList(keySet);
                tmpMap = new HashMap();
                int i = 0;
                while (i < keys.size()) {
                    String keyStr = ((String)keys.get(i)).toString();
                    String[] split = keyStr.split("=");
                    if (split.length > 1) {
                        tmpMap.put(split[0], null);
                    } else {
                        split = keyStr.split("\\u25BA");
                        if (split.length > 1) {
                            tmpMap.put(split[0], null);
                        } else {
                            tmpMap.put(keyStr, null);
                        }
                    }
                    ++i;
                }
                tmpList = new ArrayList(tmpMap.keySet());
                Collections.sort(tmpList);
                if (colType.equals("Application")) {
                    this.m_applications = tmpList;
                } else if (colType.equals("Group")) {
                    this.m_groups = tmpList;
                } else if (colType.equals("Host")) {
                    this.m_hosts = tmpList;
                } else if (colType.equals("Object")) {
                    this.m_objects = tmpList;
                }
            }
        }
        if (tmpList != null) {
            this.m_match_combo.removeAll();
            this.m_match_combo.setItems(tmpList.toArray(new String[0]));
            this.m_match_combo.select(0);
            this.enableTextMatching(true, true, false, false);
            this.enableTimeMatching(false);
            this.enableCondSection(true, true, true);
        } else if (colType.equals("Time") || colType.equals("SrvTime")) {
            this.enableTimeMatching(true);
            this.enableTextMatching(false, false, false, false);
            this.enableCondSection(true, true, true);
        } else if (colType.equals("Severity")) {
            this.enableTextMatching(false, false, false, true);
            this.enableTimeMatching(false);
            this.enableCondSection(true, true, true);
            this.m_condition_Combo.setEditable(true);
        } else {
            this.m_match_combo.removeAll();
            this.enableTextMatching(true, false, true, false);
            this.enableTimeMatching(false);
            this.enableCondSection(true, true, true);
        }
    }

    public void updateHistoryList(List<String> selection) {
        if (this.m_history_list.getItemCount() > 0) {
            this.m_history_list.removeAll();
        }
        for (String fName : this.m_historyFilters.keySet()) {
            this.m_history_list.add(fName);
        }
        this.setHistoryListSelection(selection);
    }

    public void setHistoryListSelection(List<String> selection) {
        if (selection == null || selection.size() < 1) {
            return;
        }
        String[] items = new String[selection.size()];
        int i = 0;
        while (i < selection.size()) {
            items[i] = selection.get(i);
            ++i;
        }
        this.m_history_list.setSelection(items);
    }

    public void updateFilterDetails() {
        if (this.m_selectedFilter == null) {
            this.newFilterDetails();
            this.m_gde.enableField(this.m_apply_button, false);
            return;
        }
        EventFilter ef = this.m_selectedFilter;
        boolean columnFound = false;
        String[] values = this.m_column_Combo.getItems();
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(ef.m_column)) {
                this.m_column_Combo.select(i);
                columnFound = true;
                break;
            }
            ++i;
        }
        if (!columnFound) {
            this.m_column_Combo.select(0);
            this.fillTextMatchCombo(this.m_column_Combo.getText());
            this.fillConditionCombo(this.m_column_Combo.getText());
            this.m_gde.enableField(this.m_apply_button, false);
            return;
        }
        this.m_gde.enableField(this.m_apply_button, true);
        this.fillTextMatchCombo(ef.m_column);
        this.fillConditionCombo(ef.m_column);
        String efStr = ef.toString();
        this.m_filterName.setText(efStr);
        this.m_filterName.setForeground(BMUI.color_black);
        if (efStr.indexOf("|") != -1) {
            efStr = efStr.replaceAll("\\|", "\n");
        }
        this.m_filterName.setToolTipText(efStr);
        this.m_label.setText(ef.getLabel());
        if (ef.m_column.equals("Time") || ef.m_column.equals("SrvTime")) {
            this.enableCondSection(true, false, true);
            this.m_isNot_check.setSelection(ef.m_isNOT);
            this.m_condition_Combo.select(m_condTimeIndices.get(PredefinedFilterDialog.getCondition(ef.m_mode)).intValue());
        } else {
            boolean isNotEnabled = true;
            if (ef.m_column.equals("Duplicates")) {
                this.m_condition_Combo.select(m_condDupIndices.get(PredefinedFilterDialog.getCondition(ef.m_mode)).intValue());
            } else if (ef.m_column.equals("Severity")) {
                this.m_condition_Combo.select(m_condSevIndices.get(PredefinedFilterDialog.getCondition(ef.m_mode)).intValue());
            } else if (ef.m_column.equals("Owned")) {
                this.m_condition_Combo.select(m_condOwnerIndices.get(PredefinedFilterDialog.getCondition(ef.m_mode)).intValue());
                isNotEnabled = false;
            } else {
                this.m_condition_Combo.select(m_condTextIndices.get(PredefinedFilterDialog.getCondition(ef.m_mode)).intValue());
            }
            this.enableCondSection(true, isNotEnabled, true);
            this.m_isNot_check.setSelection(ef.m_isNOT);
        }
        if (ef.m_column.equals("Severity")) {
            try {
                String[] sList = ef.m_pattern.split("\\|");
                int i2 = 0;
                while (i2 < sList.length) {
                    if (sList[i2].equals("unknown")) {
                        this.m_unknown_check.setSelection(true);
                    } else if (sList[i2].equals("normal")) {
                        this.m_normal_check.setSelection(true);
                    } else if (sList[i2].equals("warning")) {
                        this.m_warning_check.setSelection(true);
                    } else if (sList[i2].equals("minor")) {
                        this.m_minor_check.setSelection(true);
                    } else if (sList[i2].equals("major")) {
                        this.m_major_check.setSelection(true);
                    } else if (sList[i2].equals("critical")) {
                        this.m_critical_check.setSelection(true);
                    }
                    ++i2;
                }
            }
            catch (PatternSyntaxException e) {
                RTLogger.print(1, "Error splitting filter severity pattern=" + ef.m_pattern + "  " + e.getMessage());
                RTLogger.print(2, "", e);
            }
        } else if (ef.m_column.equals("Time") || ef.m_column.equals("SrvTime")) {
            String[] list = ef.m_pattern.split(" ");
            String date = list[0];
            String time = list[1];
            String[] dateList = date.split("-");
            String[] timeLIst = time.split(":");
            this.m_year_field.setText(dateList[0]);
            this.m_month_field.setText(dateList[1]);
            this.m_day_field.setText(dateList[2]);
            this.m_hrs_field.setText(timeLIst[0]);
            this.m_min_field.setText(timeLIst[1]);
            this.m_sec_field.setText(timeLIst[2]);
        } else {
            String[] list = this.m_match_combo.getItems();
            if (list != null && list.length > 0 && ef.m_pattern != null && ef.m_pattern.length() > 0) {
                ArrayList<String> al = new ArrayList<String>(Arrays.asList(list));
                if (al.contains(ef.m_pattern)) {
                    this.m_gde.enableField(this.m_match_combo, true);
                    int i3 = 0;
                    while (i3 < list.length) {
                        if (list[i3].equals(ef.m_pattern)) {
                            this.m_match_combo.select(i3);
                        }
                        ++i3;
                    }
                } else {
                    this.enableTextMatching(true, false, true, false);
                    this.m_match_field.setText(ef.m_pattern);
                    this.m_caseSensitive_check.setSelection(ef.m_caseSensitive);
                }
            } else {
                this.enableTextMatching(true, false, true, false);
                this.m_match_field.setText(ef.m_pattern);
                this.m_caseSensitive_check.setSelection(ef.m_caseSensitive);
            }
        }
        this.m_typeA_check.setSelection(ef.m_Availability == 1);
        this.m_typeK_check.setSelection(ef.m_KPIs == 1);
        this.m_type_a = ef.m_Availability;
        this.m_type_k = ef.m_KPIs;
    }

    public void newFilterDetails() {
        this.m_selectedFilter = null;
        this.m_filterName.setText(NEW_FILTER);
        this.m_filterName.setForeground(BMUI.color_critical);
        this.m_label.setText("");
        this.m_column_Combo.select(0);
        this.m_isNot_check.setSelection(false);
        this.m_condition_Combo.select(0);
        this.m_gde.enableField(this.m_match_combo, true);
        this.m_match_combo.select(0);
        this.m_gde.enableField(this.m_match_check, true);
        this.m_match_check.setSelection(false);
        this.m_gde.enableField(this.m_caseSensitive_check, false);
        this.m_caseSensitive_check.setSelection(false);
        this.m_gde.enableField(this.m_match_field, true);
        this.m_match_field.setText("");
        this.m_typeA_check.setSelection(false);
        this.m_typeK_check.setSelection(false);
        this.fillTextMatchCombo(this.m_column_Combo.getItem(0));
        this.fillConditionCombo(this.m_column_Combo.getItem(0));
    }

    public void enableCondSection(boolean group, boolean checkbox, boolean combo) {
        if (!group) {
            combo = false;
            checkbox = false;
        }
        this.m_grp_condition.setEnabled(group);
        this.m_gde.enableField(this.m_isNot_check, checkbox);
        this.m_isNot_check.setSelection(false);
        this.m_gde.enableField(this.m_condition_Combo, combo);
    }

    public void enableTextMatching(boolean group, boolean combo, boolean text, boolean severity) {
        if (!group) {
            text = false;
            combo = false;
        }
        this.m_grp_textMatch.setEnabled(group);
        this.m_textMatch_label.setEnabled(combo);
        this.m_gde.enableField(this.m_match_combo, combo);
        this.m_gde.enableField(this.m_match_check, text);
        this.m_match_check.setSelection(text);
        this.m_gde.enableField(this.m_caseSensitive_check, text);
        if (!text) {
            this.m_match_field.setText("");
            this.m_caseSensitive_check.setSelection(false);
        }
        this.m_gde.enableField(this.m_match_field, text);
        if (group && !severity) {
            this.m_gde.enableField(this.m_match_check, true);
        }
        if (!this.m_grp_severity.isDisposed()) {
            this.m_grp_severity.setEnabled(severity);
            this.m_unknown_check.setSelection(false);
            this.m_normal_check.setSelection(false);
            this.m_warning_check.setSelection(false);
            this.m_minor_check.setSelection(false);
            this.m_major_check.setSelection(false);
            this.m_critical_check.setSelection(false);
            int i = 0;
            while (i < this.m_sev_elems.size()) {
                this.m_gde.enableField(this.m_sev_elems.get(i), severity);
                ++i;
            }
        }
    }

    public void enableTimeMatching(boolean group) {
        if (this.m_grp_dateMatch.isDisposed()) {
            return;
        }
        this.m_grp_dateMatch.setEnabled(group);
        if (!group) {
            this.m_year_field.setText("");
            this.m_month_field.setText("");
            this.m_day_field.setText("");
            this.m_hrs_field.setText("");
            this.m_min_field.setText("");
            this.m_sec_field.setText("");
        }
        this.m_date_label.setEnabled(group);
        this.m_calendar_icon.setEnabled(group);
        this.m_dateFormat_label.setEnabled(group);
        this.m_time_label.setEnabled(group);
        this.m_timeFormat_label.setEnabled(group);
        this.m_gde.enableField(this.m_year_field, group);
        this.m_gde.enableField(this.m_month_field, group);
        this.m_gde.enableField(this.m_day_field, group);
        this.m_gde.enableField(this.m_hrs_field, group);
        this.m_gde.enableField(this.m_min_field, group);
        this.m_gde.enableField(this.m_sec_field, group);
    }

    public void deleteFilter() {
        int selCount = this.m_filter_tv.getTable().getSelectionCount();
        if (selCount > 0) {
            TableItem[] itemList = this.m_filter_tv.getTable().getSelection();
            int i = 0;
            while (i < itemList.length) {
                TableItem item = itemList[i];
                EventFilter ef = (EventFilter)((Object)item.getData());
                this.m_predefFilters_local.remove(ef.toString());
                ++i;
            }
            this.m_tableProvider.updateTable(this.m_predefFilters_local);
            TableItem[] items = this.m_filter_tv.getTable().getItems();
            if (items.length > 0) {
                this.m_selectedFilter = (EventFilter)((Object)items[0].getData());
                this.m_filter_tv.getTable().setSelection(0);
            }
            this.updateFilterDetails();
            this.m_history_list.deselectAll();
        }
    }

    public void loadHistory() {
        File file = new File(String.valueOf(Repository.getUserDirectory()) + File.separator + "filterHistory.xml");
        if (file.exists() || file.canRead()) {
            HashMapArray<TableViewer, EventFilter> hma = this.m_filterFactory.loadFilter(file, null);
            this.m_historyFilters.clear();
            List<EventFilter> list = hma.getArray(null);
            for (EventFilter ef : list) {
                this.m_historyFilters.put(ef.toString(), ef);
            }
        } else {
            RTLogger.print(1, "Required file: " + file.getPath() + " not found. Exit.");
        }
    }

    public void moveToHistory() {
        ArrayList<String> list = new ArrayList<String>();
        TableItem[] itemList = this.m_filter_tv.getTable().getSelection();
        int i = 0;
        while (i < itemList.length) {
            EventFilter ef = (EventFilter)((Object)itemList[i].getData());
            String fName = ef.toString();
            if (!this.m_historyFilters.containsKey(fName)) {
                this.m_historyFilters.put(fName, ef);
                list.add(fName);
            }
            ++i;
        }
        this.saveHistory();
        this.updateHistoryList(list);
    }

    public void saveHistory() {
        boolean success = true;
        String path = String.valueOf(Repository.getUserDirectory()) + File.separator + "filterHistory.xml";
        try {
            File file = new File(path);
            if (file.exists()) {
                success = file.delete();
            }
            if (success) {
                Collection<EventFilter> c = this.m_historyFilters.values();
                this.m_filterFactory.storeFilter(file, c.iterator());
            } else {
                RTLogger.print(4, "File exists, error deleting file");
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error saving file" + path, e);
        }
    }

    public void deleteFromHistory() {
        String[] selection = this.m_history_list.getSelection();
        int i = 0;
        while (i < selection.length) {
            String fName = selection[i];
            if (this.m_historyFilters.containsKey(fName)) {
                this.m_historyFilters.remove(fName);
            }
            ++i;
        }
        this.saveHistory();
        this.updateHistoryList(null);
        if (this.m_history_list.getItemCount() > 0) {
            this.m_history_list.setSelection(0);
        }
    }

    public void moveToCurrent() {
        EventFilter selected = null;
        EventFilter ef = null;
        String[] selection = this.m_history_list.getSelection();
        int i = 0;
        while (i < selection.length) {
            String fName = selection[i];
            ef = this.m_historyFilters.get(fName);
            if (ef != null) {
                this.addFilter(ef);
                if (selected == null) {
                    selected = ef;
                }
            }
            ++i;
        }
        this.updateFilterDetails();
    }

    public EventFilter saveFilter(boolean addAsNew) {
        String matchText = null;
        String severityStr = null;
        String time1Str = null;
        if (this.m_column_Combo.getText() == null || this.m_column_Combo.getText().trim().length() <= 0) {
            return null;
        }
        if (this.m_grp_textMatch.isEnabled()) {
            if (this.m_match_check.getSelection()) {
                if (this.m_match_field.getText() == null || this.m_match_field.getText().trim().length() <= 0) {
                    return null;
                }
                matchText = this.m_match_field.getText().trim();
            } else if (!this.m_match_check.getSelection() && this.m_match_combo.isEnabled()) {
                if (this.m_match_combo.getText() == null || this.m_match_combo.getText().trim().length() <= 0) {
                    return null;
                }
                matchText = this.m_match_combo.getText();
            }
        } else if (!this.m_grp_severity.isDisposed() && this.m_grp_severity.isEnabled()) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.m_unknown_check.getSelection()) {
                list.add("unknown");
            }
            if (this.m_normal_check.getSelection()) {
                list.add("normal");
            }
            if (this.m_warning_check.getSelection()) {
                list.add("warning");
            }
            if (this.m_minor_check.getSelection()) {
                list.add("minor");
            }
            if (this.m_major_check.getSelection()) {
                list.add("major");
            }
            if (this.m_critical_check.getSelection()) {
                list.add("critical");
            }
            StringBuffer tmpStr = new StringBuffer();
            int i = 0;
            while (i < list.size()) {
                tmpStr.append((String)list.get(i)).append("|");
                ++i;
            }
            if (tmpStr.charAt(tmpStr.length() - 1) == '|') {
                severityStr = tmpStr.substring(0, tmpStr.length() - 1);
            }
        } else if (!this.m_grp_dateMatch.isDisposed() && this.m_grp_dateMatch.isEnabled()) {
            int sec;
            int min;
            int hrs;
            int day;
            int month;
            int year;
            block43: {
                block42: {
                    try {
                        year = Integer.parseInt(this.m_year_field.getText().trim().length() == 0 ? "0" : this.m_year_field.getText().trim());
                        month = Integer.parseInt(this.m_month_field.getText().trim().length() == 0 ? "0" : this.m_month_field.getText().trim());
                        day = Integer.parseInt(this.m_day_field.getText().trim().length() == 0 ? "0" : this.m_day_field.getText().trim());
                        hrs = Integer.parseInt(this.m_hrs_field.getText().trim().length() == 0 ? "0" : this.m_hrs_field.getText().trim());
                        min = Integer.parseInt(this.m_min_field.getText().trim().length() == 0 ? "0" : this.m_min_field.getText().trim());
                        sec = Integer.parseInt(this.m_sec_field.getText().trim().length() == 0 ? "0" : this.m_sec_field.getText().trim());
                        if (year >= 2000 && year <= 2099 && month >= 1 && month <= 12 && day >= 1 && day <= 31 && (month != 2 && month != 4 && month != 6 && month != 9 && month != 11 || day <= 30) && (month != 2 || !new GregorianCalendar().isLeapYear(year) || day <= 29) && (month != 2 || new GregorianCalendar().isLeapYear(year) || day <= 28)) break block42;
                        new ShowMessageBox("Date Validation", "   Invalid Date!            ", 1);
                        return null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
                if (hrs >= 0 && hrs <= 23 && min >= 0 && min <= 59 && sec >= 0 && sec <= 59) break block43;
                new ShowMessageBox("Time Validation", "   Invalid time!            ", 1);
                return null;
            }
            time1Str = String.valueOf(this.checkLeadingZeros(year)) + "-" + this.checkLeadingZeros(month) + "-" + this.checkLeadingZeros(day) + " " + this.checkLeadingZeros(hrs) + ":" + this.checkLeadingZeros(min) + ":" + this.checkLeadingZeros(sec) + ":000";
        }
        int mode = 0;
        boolean isNot = false;
        if (this.m_grp_condition.isEnabled()) {
            if (this.m_condition_Combo.isEnabled()) {
                String text = this.m_condition_Combo.getText();
                if (text.equals(CONTAINS)) {
                    mode = 3;
                } else if (text.equals(STARTS_WITH)) {
                    mode = 1;
                } else if (text.equals(ENDS_WITH)) {
                    mode = 2;
                } else if (text.equals(EXACTLY)) {
                    mode = 4;
                } else if (text.equals(BIGGER)) {
                    mode = 5;
                } else if (text.equals(LESS)) {
                    mode = 6;
                }
            }
            if (this.m_isNot_check.isEnabled()) {
                isNot = this.m_isNot_check.getSelection();
            }
        }
        if (!addAsNew) {
            this.m_predefFilters_local.remove(this.m_selectedFilter.toString());
        }
        EventFilter ef = null;
        if (!this.m_grp_dateMatch.isDisposed() && this.m_grp_dateMatch.isEnabled()) {
            if (time1Str != null) {
                ef = new EventFilter(this.m_label.getText(), this.m_column_Combo.getText(), time1Str, this.m_caseSensitive_check.getSelection(), mode, null, false, this.m_type_a, this.m_type_k, isNot);
            }
        } else {
            ef = !this.m_grp_severity.isDisposed() && this.m_grp_severity.isEnabled() ? new EventFilter(this.m_label.getText(), this.m_column_Combo.getText(), severityStr, this.m_caseSensitive_check.getSelection(), 3, null, false, this.m_type_a, this.m_type_k, isNot) : new EventFilter(this.m_label.getText(), this.m_column_Combo.getText(), matchText, this.m_caseSensitive_check.getSelection(), mode, null, false, this.m_type_a, this.m_type_k, isNot);
        }
        if (ef != null) {
            this.addFilter(ef);
            this.updateFilterDetails();
        }
        return ef;
    }

    public void addFilter(EventFilter ef) {
        if (this.m_predefFilters_local.containsKey(ef.toString())) {
            this.m_selectedFilter = this.m_predefFilters_local.get(ef.toString());
        } else {
            this.m_predefFilters_local.put(ef.toString(), ef);
            this.m_tableProvider.updateTable(this.m_predefFilters_local);
            this.m_selectedFilter = ef;
        }
        int ii = 0;
        while (ii < this.m_filter_tv.getTable().getItemCount()) {
            TableItem ti = this.m_filter_tv.getTable().getItem(ii);
            EventFilter filter = (EventFilter)((Object)ti.getData());
            if (filter != null && this.m_selectedFilter != null && filter.toString().equals(this.m_selectedFilter.toString())) {
                this.m_filter_tv.getTable().setSelection(ii);
                break;
            }
            ++ii;
        }
    }

    public String checkLeadingZeros(int value) {
        String newValue = null;
        newValue = "" + value;
        if (value < 10) {
            newValue = "0" + value;
        }
        return newValue;
    }

    public static String getCondition(int mode) {
        String condition = "";
        switch (mode) {
            case 1: {
                condition = STARTS_WITH;
                break;
            }
            case 2: {
                condition = ENDS_WITH;
                break;
            }
            case 3: {
                condition = CONTAINS;
                break;
            }
            case 4: {
                condition = EXACTLY;
                break;
            }
            case 5: {
                condition = BIGGER;
                break;
            }
            case 6: {
                condition = LESS;
                break;
            }
        }
        return condition;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof org.eclipse.swt.widgets.List) {
            this.moveToCurrent();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button button = (Button)obj;
            if (button.isDisposed()) {
                return;
            }
            String name = (String)button.getData();
            if (name.equals(TYPE_A)) {
                this.m_type_a = button.getSelection() ? 1 : 0;
            } else if (name.equals(TYPE_K)) {
                this.m_type_k = button.getSelection() ? 1 : 0;
            } else if (name.equals(MATCH_CHECK)) {
                if (this.m_column_Combo.getText().equals("Duplicates") || this.m_column_Combo.getText().equals("Text")) {
                    this.m_match_check.setSelection(true);
                }
                this.m_textMatch_label.setEnabled(!this.m_match_check.getSelection());
                this.m_gde.enableField(this.m_match_combo, !this.m_match_check.getSelection());
                this.m_gde.enableField(this.m_match_field, this.m_match_check.getSelection());
                this.m_gde.enableField(this.m_caseSensitive_check, this.m_match_check.getSelection());
            } else if (name.equals(ADD_AS_NEW)) {
                this.saveFilter(true);
            } else if (name.equals(APPLY)) {
                this.saveFilter(false);
            } else if (name.equals(DEL_FILTER)) {
                this.deleteFilter();
            } else if (name.equals(MOVE_TO_HISTORY)) {
                this.moveToHistory();
            } else if (name.equals(LOAD_FROM_FILE)) {
                Shell shell = new Shell(Display.getCurrent().getActiveShell());
                String fileName = null;
                try {
                    FileDialog fd = new FileDialog(shell, 4096);
                    fd.setText("Select File");
                    fileName = fd.open();
                    if (fileName != null) {
                        File file = new File(fileName);
                        if (file.exists() || file.canRead()) {
                            HashMapArray<TableViewer, EventFilter> m_filters = this.m_filterFactory.loadFilter(file, null);
                            EventFilter[] filters = m_filters.getArray(null).toArray(new EventFilter[0]);
                            if (filters != null && filters.length > 0) {
                                int i = 0;
                                while (i < filters.length) {
                                    EventFilter ef = filters[i];
                                    this.m_predefFilters_local.put(ef.toString(), ef);
                                    ++i;
                                }
                            }
                        } else {
                            RTLogger.print(1, "Required file: " + file.getPath() + " not found. Exit.");
                        }
                    }
                }
                catch (RuntimeException e1) {
                    RTLogger.print(4, "Error uploading file " + fileName, e1);
                }
                try {
                    shell.dispose();
                }
                catch (Exception exception) {}
                this.m_tableProvider.updateTable(this.m_predefFilters_local);
                this.m_filter_tv.getTable().setSelection(0);
                this.updateFilterDetails();
            } else if (name.equals(SAVE_TO_FILE)) {
                Shell shell = new Shell(Display.getCurrent().getActiveShell());
                String path = null;
                boolean success = true;
                try {
                    FileDialog fd = new FileDialog(shell, 8192);
                    fd.setText("  Export Filter");
                    path = fd.open();
                    if (path != null) {
                        File file = new File(path);
                        if (file.exists()) {
                            success = file.delete();
                        }
                        if (success) {
                            Iterator<EventFilter> it = this.m_predefFilters_local.values().iterator();
                            this.m_filterFactory.storeFilter(file, it);
                        } else {
                            RTLogger.print(4, "File exists, error deleting file");
                        }
                    }
                }
                catch (RuntimeException e1) {
                    RTLogger.print(5, "Error saving file" + path, e1);
                }
                try {
                    shell.dispose();
                }
                catch (Exception exception) {}
            } else if (name.equals(MOVE_TO_CURRENT)) {
                this.moveToCurrent();
            } else if (name.equals(DEL_FROM_HISTORY)) {
                this.deleteFromHistory();
            } else if (name.equals(CLOSE)) {
                this.close();
            } else if (name.endsWith(CANCEL)) {
                this.cancel();
            }
        } else if (obj instanceof CCombo) {
            CCombo combo = (CCombo)obj;
            String name = (String)combo.getData();
            String value = combo.getText();
            if (name.equals(COLUMN_COMBO)) {
                this.fillTextMatchCombo(value);
                this.fillConditionCombo(value);
            }
        } else if (obj instanceof org.eclipse.swt.widgets.List) {
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)obj;
            if (list.isDisposed()) {
                return;
            }
            String name = (String)list.getData();
            if (name.equals(HISTORY_LIST)) {
                String[] selection = this.m_history_list.getSelection();
                if (selection.length > 0) {
                    String fName = selection[0];
                    this.setFilterListSelection(selection);
                    if (this.m_historyFilters.containsKey(fName)) {
                        this.m_selectedFilter = this.m_historyFilters.get(fName);
                        this.updateFilterDetails();
                    }
                }
                if (selection.length > 0) {
                    this.m_gde.enableField(this.m_moveToCurrent_button, true);
                } else {
                    this.m_gde.enableField(this.m_moveToCurrent_button, false);
                }
                this.m_gde.enableField(this.m_moveToHistory_button, false);
                this.m_gde.enableField(this.m_apply_button, false);
            }
        }
    }

    public void setFilterListSelection(String[] selection) {
        if (selection != null && selection.length > 0) {
            String efName = selection[0];
            int ii = 0;
            while (ii < this.m_filter_tv.getTable().getItemCount()) {
                TableItem ti = this.m_filter_tv.getTable().getItem(ii);
                EventFilter ef = (EventFilter)((Object)ti.getData());
                if (ef.toString().equals(efName)) {
                    this.m_filter_tv.getTable().deselectAll();
                    this.m_filter_tv.getTable().setSelection(ii);
                    return;
                }
                ++ii;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text text = (Text)obj;
            String value = text.getText();
            if (text.getData().equals(YEAR_FIELD)) {
                this.m_year_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0 && value.length() < 4) {
                    this.m_year_field.setBackground(BMUI.color_critical);
                } else if (value.length() == 4) {
                    try {
                        Integer.parseInt(this.m_year_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_year_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (text.getData().equals(MONTH_FIELD)) {
                this.m_month_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_month_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_month_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (text.getData().equals(DAY_FIELD)) {
                this.m_day_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_day_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_day_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (text.getData().equals(HRS_FIELD)) {
                this.m_hrs_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_hrs_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_hrs_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (text.getData().equals(MIN_FIELD)) {
                this.m_min_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_min_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_min_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (text.getData().equals(SEC_FIELD)) {
                this.m_sec_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_sec_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_sec_field.setBackground(BMUI.color_critical);
                    }
                }
            }
        }
    }

    public void open() {
        this.m_shell.setSize(760, 460);
        this.createContents((Composite)this.m_shell);
        this.m_shell.open();
        this.m_shell.pack();
    }

    public void close() {
        this.m_list_IB_PF.removeAll();
        this.m_predefFilters.clear();
        if (this.m_predefFilters_local != null && this.m_predefFilters_local.size() > 0) {
            for (String filterName : this.m_predefFilters_local.keySet()) {
                EventFilter ef = this.m_predefFilters_local.get(filterName);
                this.m_list_IB_PF.add(ef.getLabelOrName());
                this.m_predefFilters.put(ef.toString(), ef);
            }
        }
        try {
            this.m_shell.dispose();
        }
        catch (Exception exception) {}
    }

    public void cancel() {
        try {
            this.m_shell.dispose();
        }
        catch (Exception exception) {}
    }

    public void shellClosed(ShellEvent e) {
        try {
            Control[] controls = this.m_compMain.getChildren();
            int i = 0;
            while (i < controls.length) {
                if (!controls[i].isDisposed()) {
                    controls[i].dispose();
                }
                ++i;
            }
            this.m_compMain.dispose();
            this.m_shell.dispose();
            this.m_shell = null;
        }
        catch (Throwable e1) {
            RTLogger.print(4, "", e1);
        }
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Table t;
        Object obj = e.getSource();
        if (obj instanceof Table && e.button == 1 && (t = (Table)obj).getData().equals(FILTER_TABLE)) {
            EventFilter ef = null;
            try {
                TableItem item = t.getItem(new Point(5, e.y));
                if (item != null) {
                    int h = item.getBounds().height;
                    int pos = e.y / h;
                    item = t.getItem(pos);
                    if (item == null) {
                        return;
                    }
                } else {
                    return;
                }
                ef = (EventFilter)((Object)item.getData());
                int columnIndex = this.getColumnIndex(e.x);
                if (columnIndex == 0) {
                    if (ef.m_isLocked) {
                        item.setChecked(!item.getChecked());
                        return;
                    }
                    ef.m_isActive = !ef.m_isActive;
                    item.setChecked(ef.m_isActive);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public int getColumnIndex(int position) {
        int colIndex = -1;
        int start = 0;
        int end = 0;
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        TableColumn[] colList = this.m_filter_tv.getTable().getColumns();
        int index = 0;
        while (index < this.m_filter_tv.getTable().getColumnCount()) {
            m.put(index, colList[index].getWidth());
            ++index;
        }
        index = 0;
        while (index < m.size()) {
            if (index > 0) {
                start += Integer.valueOf(((Integer)m.get(index - 1)).toString()).intValue();
            }
            end = start + Integer.valueOf(((Integer)m.get(index)).toString());
            if (position >= start && position <= end) {
                colIndex = index;
                break;
            }
            ++index;
        }
        return colIndex;
    }

    public class PredefFilterTableProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private List<EventFilter> m_elements = null;
        private TableViewer m_filter_tv = null;
        private PredefinedFilterDialog m_evDialog = null;

        public PredefFilterTableProvider(TableViewer filter_tv, PredefinedFilterDialog evDialog, Map<String, EventFilter> predefinedFilters) {
            this.m_filter_tv = filter_tv;
            this.m_elements = new ArrayList<EventFilter>();
            this.m_evDialog = evDialog;
            for (String filterName : predefinedFilters.keySet()) {
                EventFilter ef = predefinedFilters.get(filterName);
                this.m_elements.add(ef);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.m_elements.toArray();
        }

        public void updateTable(Map<String, EventFilter> predefinedFilters) {
            this.m_elements.clear();
            for (String filterName : predefinedFilters.keySet()) {
                EventFilter ef = predefinedFilters.get(filterName);
                this.m_elements.add(ef);
            }
            this.m_filter_tv.refresh(true);
        }

        public void removeFilter(EventFilter ef) {
            TableItem[] itemList = this.m_filter_tv.getTable().getItems();
            if (ef != null) {
                int i = 0;
                while (i < itemList.length) {
                    if (itemList[i].getText(1).equals(ef.toString())) {
                        this.m_filter_tv.getTable().remove(i);
                        this.m_elements.remove((Object)ef);
                    }
                    ++i;
                }
            }
        }

        public void addFilter(EventFilter ef) {
            this.m_evDialog.m_selectedFilter = ef;
            this.m_elements.add(ef);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EventFilter ef = (EventFilter)((Object)element);
            switch (columnIndex) {
                case 0: {
                    TableItem[] items = this.m_filter_tv.getTable().getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].getData() == ef) {
                            items[i].setChecked(ef.m_isActive);
                            break;
                        }
                        ++i;
                    }
                    return "";
                }
                case 1: {
                    return ef.getLabelOrName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

