/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.settings.TblColumn;
import com.blixx.boom.gui.settings.TblFilter;
import com.blixx.boom.gui.settings.UISettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PredefinedTab {
    private String m_viewID = UISettings.MSG_VIEW1;
    private String m_name = "NewTab";
    private int m_type = 0;
    private boolean m_showActive = true;
    private boolean m_isClosable = true;
    private String m_sortCol = UISettings.getInstance().getDefaultSortCol();
    private String m_sortDir = UISettings.getInstance().getDefaultSortDir();
    private Map<String, TblColumn> m_columns = new HashMap<String, TblColumn>();
    private Map<String, TblFilter> m_filters = new HashMap<String, TblFilter>();
    private Map<String, EventFilter> m_eventFilters = new HashMap<String, EventFilter>();
    private Map<String, ServiceDashBoard> m_services = new HashMap<String, ServiceDashBoard>();

    public PredefinedTab(String viewID, String name, int type, boolean showActive, boolean isClosable, String sortDir, String sortCol) {
        if (viewID != null && (viewID.equals(UISettings.MSG_VIEW1) || viewID.equals(UISettings.MSG_VIEW2))) {
            this.m_viewID = viewID;
        }
        if (name != null && name.length() > 0) {
            this.m_name = name;
        }
        if (type > 0) {
            this.m_type = type;
        }
        this.m_showActive = showActive;
        this.m_isClosable = isClosable;
        if (sortCol != null && EventStorageUtils.defaultColumnWidth.containsKey(sortCol)) {
            this.m_sortCol = sortCol;
        }
        if (sortDir != null && (sortDir.equalsIgnoreCase(UISettings.UP) || sortDir.equalsIgnoreCase(UISettings.DOWN))) {
            this.m_sortDir = sortDir;
        }
        this.m_columns.clear();
        this.m_filters.clear();
        this.m_eventFilters.clear();
        this.m_services.clear();
    }

    public boolean hasColumn(String name) {
        return this.m_columns.containsKey(name);
    }

    public void addColumn(TblColumn column) {
        if (this.m_columns.containsKey(column.getName())) {
            this.m_columns.remove(column.getName());
        }
        this.m_columns.put(column.getName(), column);
    }

    public void removeColumn(String name) {
        this.m_columns.remove(name);
    }

    public void removeColumnAll() {
        this.m_columns.clear();
    }

    public TblColumn getColumn(String name) {
        return this.m_columns.get(name);
    }

    public TblColumn getColumn(int position) {
        for (String name : this.m_columns.keySet()) {
            TblColumn col = this.m_columns.get(name);
            if (position != col.getPosition()) continue;
            return col;
        }
        return null;
    }

    public Map<String, TblColumn> getColumns() {
        return this.m_columns;
    }

    public List<TblColumn> getColumnsSorted() {
        HashMap<Integer, TblColumn> tmpMap = new HashMap<Integer, TblColumn>();
        for (String name : this.m_columns.keySet()) {
            TblColumn col = this.m_columns.get(name);
            tmpMap.put(col.getPosition(), col);
        }
        ArrayList list = new ArrayList();
        list.addAll(tmpMap.keySet());
        Collections.sort(list);
        ArrayList<TblColumn> columsSorted = new ArrayList<TblColumn>();
        int i = 0;
        while (i < list.size()) {
            int pos = (Integer)list.get(i);
            columsSorted.add((TblColumn)tmpMap.get(pos));
            ++i;
        }
        return columsSorted;
    }

    public void addFilter(TblFilter filter) {
        if (this.m_filters.containsValue(filter.getFilterName())) {
            this.m_filters.remove(filter.getFilterName());
        }
        this.m_filters.put(filter.getFilterName(), filter);
    }

    public void removeFilter(String name) {
        this.m_filters.remove(name);
    }

    public void removeFilterAll() {
        this.m_filters.clear();
    }

    public boolean hasFilter(String name) {
        return this.m_filters.containsKey(name);
    }

    public Map<String, TblFilter> getFilters() {
        return this.m_filters;
    }

    public void addService(ServiceDashBoard service) {
        String name = service.getName();
        if (this.m_services.containsValue(name)) {
            this.m_services.remove(name);
        }
        this.m_services.put(name, service);
    }

    public void removeService(String name) {
        this.m_services.remove(name);
    }

    public void removeSerivceAll() {
        this.m_services.clear();
    }

    public boolean hasService(String name) {
        return this.m_services.containsKey(name);
    }

    public Map<String, ServiceDashBoard> getSerivces() {
        return this.m_services;
    }

    public void setViewID(String viewID) {
        this.m_viewID = viewID;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setShowActive(boolean showActive) {
        this.m_showActive = showActive;
    }

    public void setClosable(boolean isClosable) {
        this.m_isClosable = isClosable;
    }

    public void setSortCol(String sortcol) {
        this.m_sortCol = sortcol;
    }

    public void setSortDir(String sortDir) {
        this.m_sortDir = sortDir;
    }

    public String getViewID() {
        return this.m_viewID;
    }

    public String getName() {
        return this.m_name;
    }

    public Integer getType() {
        return this.m_type;
    }

    public String getTypeStr() {
        if (this.m_type == 0) {
            return "normal";
        }
        return "outage";
    }

    public boolean getShowActive() {
        return this.m_showActive;
    }

    public boolean getClosable() {
        return this.m_isClosable;
    }

    public String getSorting() {
        return String.valueOf(this.m_sortCol) + "|" + this.m_sortDir;
    }

    public String getSortCol() {
        return this.m_sortCol;
    }

    public String getSortDir() {
        return this.m_sortDir;
    }

    public int getSortDir_AsInt() {
        int sortDir = 1024;
        if (this.m_sortDir.equals(UISettings.UP)) {
            sortDir = 128;
        }
        return sortDir;
    }

    public Integer getActiveFilterCount() {
        int count = 0;
        for (TblFilter filter : this.m_filters.values()) {
            if (!filter.isActive()) continue;
            ++count;
        }
        return count;
    }

    public Integer getActiveSerivceCount() {
        int count = 0;
        for (ServiceDashBoard filter : this.m_services.values()) {
            if (!filter.m_isActive) continue;
            ++count;
        }
        return count;
    }

    public Integer getVisibleColumnsCount() {
        int count = 0;
        for (TblColumn column : this.m_columns.values()) {
            if (column.getWidth() <= 0) continue;
            ++count;
        }
        return count;
    }
}

