/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.settings.DialogEditTablePT;
import com.blixx.boom.gui.settings.IndicationBrowserSettings;
import com.blixx.boom.gui.settings.TblColumn;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SetColWidthAction
extends Action {
    private Shell m_parentShell = null;
    private Table m_table = null;
    private IndicationBrowserSettings m_IBSettings = null;
    private DialogEditTablePT m_dialogEditPT = null;
    private TableItem[] m_items = null;

    public SetColWidthAction(Shell parentShell, Table table, Object object) {
        super("setcolwidthforselected");
        this.setId("setcolwidthforselected");
        this.setText("Set Column Width");
        this.m_parentShell = parentShell;
        this.m_table = table;
        if (this.m_parentShell == null || this.m_table == null || this.m_table.getSelectionCount() <= 0 || object == null) {
            this.setEnabled(false);
            return;
        }
        this.m_items = this.m_table.getSelection();
        if (object instanceof IndicationBrowserSettings) {
            this.m_IBSettings = (IndicationBrowserSettings)object;
        } else if (object instanceof DialogEditTablePT) {
            this.m_dialogEditPT = (DialogEditTablePT)((Object)object);
        } else {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        InputDialog dialog;
        int res;
        if (!this.isEnabled()) {
            return;
        }
        int colWidth = -1;
        if (this.m_items.length == 1) {
            try {
                colWidth = Integer.parseInt(this.m_items[0].getText(2));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((res = (dialog = new InputDialog(Display.getCurrent().getActiveShell(), colWidth)).open()) == 0) {
            int width = dialog.getWidth();
            if (width < 0) {
                return;
            }
            int i = 0;
            while (i < this.m_items.length) {
                TableItem ti = this.m_items[i];
                TblColumn col = (TblColumn)ti.getData(IndicationBrowserSettings.OBJECT);
                col.setWidth(width);
                ++i;
            }
            if (this.m_IBSettings != null) {
                this.m_IBSettings.updateTableItem(this.m_table, this.m_items);
            } else if (this.m_dialogEditPT != null) {
                this.m_dialogEditPT.updateTableItem(this.m_table, this.m_items);
            }
        }
    }

    class InputDialog
    extends StatusDialog {
        private Composite m_comp;
        private int m_width;

        public InputDialog(Shell shell, int width) {
            super(shell);
            this.m_comp = null;
            this.m_width = -1;
            this.setShellStyle(this.getShellStyle());
            this.setTitle(" Column Width");
            this.m_width = width;
        }

        protected Control createDialogArea(Composite parent) {
            GUIDisplayElements gui = new GUIDisplayElements();
            this.m_comp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.marginTop = 5;
            gl.marginLeft = 5;
            gl.marginRight = 5;
            this.m_comp.setLayout((Layout)gl);
            this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true));
            Text t = gui.addInputFieldSingle(this.m_comp, null, "Column Width: ", this.m_width < 0 ? "" : "" + this.m_width, 1, 1, 0, 0, 80, null);
            t.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    int value = -1;
                    Text field = (Text)e.getSource();
                    String text = field.getText().trim();
                    try {
                        value = Integer.parseInt(text);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (value == -1) {
                        field.setBackground(BMUI.color_critical);
                        InputDialog.this.getButton(0).setEnabled(false);
                    } else {
                        field.setBackground(BMUI.defaultBackground);
                        InputDialog.this.getButton(0).setEnabled(true);
                        InputDialog.this.m_width = value;
                    }
                }
            });
            return parent;
        }

        protected Control createButtonBar(Composite parent) {
            Composite comp = (Composite)super.createButtonBar(parent);
            return comp;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "OK", true);
            this.getButton(0).setEnabled(false);
            this.createButton(parent, 1, "Cancel", false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                super.okPressed();
            } else if (buttonId == 1) {
                super.cancelPressed();
            }
        }

        public int getWidth() {
            return this.m_width;
        }
    }
}

