/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventBrowserProvider;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.settings.ActionSettings;
import com.blixx.boom.gui.settings.GenAttribute;
import com.blixx.boom.gui.settings.GenAttributeProps;
import com.blixx.boom.gui.settings.PredefinedTab;
import com.blixx.boom.gui.settings.PredefinedView;
import com.blixx.boom.gui.settings.TblColumn;
import com.blixx.boom.gui.settings.TblFilter;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.boom.gui.views.BrowserView;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.MessagesViewFolder;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.ctrl.sc.IRunnableExt;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UISettings {
    private static UISettings m_UISettings = null;
    public static String NO_PROFILE = "NO_PROFILE";
    public static String LOCAL_PROFILE = "LOCAL_PROFILE";
    public static String SERVER_PROFILE = "SERVER_PROFILE";
    private static boolean m_useServerProfile = false;
    private static String m_profileType = NO_PROFILE;
    public static String GUIConfigFile = String.valueOf(Repository.getUserDirectory()) + File.separator + "profile.xml";
    private static Document m_doc;
    private static GroupTreeObject m_tree;
    public static String MSG_VIEW1;
    public static String MSG_VIEW2;
    public static String LABEL;
    public static String VALUE;
    public static String TYPE;
    public static String DOWN;
    public static String UP;
    public static String TEXT;
    public static String VIEW;
    public static String VIEW_ID;
    public static String TAB;
    public static String SHOW_ACTIVE;
    public static String SORT_COL;
    public static String SORT_DIR;
    public static final String TBLCOLUMNS = "TBLCOLUMNS";
    public static final String COLUMN = "COLUMN";
    public static final String NAME = "NAME";
    public static final String POSITION = "POSITION";
    public static final String WIDTH = "WIDTH";
    public static final String COLORING = "COLORING";
    public static String CLOSABLE;
    public static String MOVEABLE;
    public static String FILTER_LIST;
    public static String FILTER;
    public static String SERVICE;
    public static String SERVICE_NAME;
    public static String GROUP;
    public static String GROUP_NAME;
    public static String ACTIVE;
    public static final String _IB_GENERAL = "GENERAL";
    public static String IB_GLOBAL;
    public static String CAN_MODIFY_FILTERS;
    public static String CAN_MOVE_TABS;
    public static String CAN_SORT;
    public static String CAN_SWITCH;
    public static String SHOW_INDI_VIEW2;
    public static String IB_COL_SETTINGS;
    public static String IB_COLOR_OPTIONS;
    public static String COLORS_INDI_BROWSER;
    public static String COLORS_OUT_BROWSER;
    public static String IB_COLOR_ACTIVE;
    public static String IB_COLOR_CLOSED;
    public static String OB_COLOR_ACTIVE;
    public static String OB_COLOR_CLOSED;
    public static String ADD_NEW_TABS;
    public static String GLOBAL_SORT_COL;
    public static String GLOBAL_SORT_DIR;
    public static String IB_PREDEFINED_FILTERS;
    public static final String WB_INTEGRATED = "WB_INTEGRATED";
    public static final String WB_PREDEFINED_TABS = "WB_PREDEFINED_TABS";
    public static String URL;
    public static final String ACTIONS = "ACTIONS";
    public static String SORTING;
    public static final String _SETTINGS = "SETTINGS";
    public static final String _GENERAL_ATTRIBUTES = "GENERAL_ATTRIBUTES";
    public static final String _INDICATION_BROWSER = "INDICATION_BROWSER";
    public static final String _IB_PREDEFINED_VIEWS = "PREDEFINED_VIEWS";
    public static final String _IB_PREDEFINED_TABS = "PREDEFINED_TABS";
    public static final String _IB_USER_TABS = "USER_TABS";
    public static final String _WEB_BROWSER = "WEB_BROWSER";
    public static final String _WB_PREDEFINED_TABS = "WB_PREDEFINED_TABS";
    public static final String _WB_USER_TABS = "WB_USER_TABS";
    public static final String _ACTIONS = "ACTIONS";
    public static final String _ACTION_FAVORITES = "FAVORITES";
    private static Map<String, GenAttribute> _GeneralAttributes;
    private static Map<String, Object> _IBGlobalSettings;
    private static Map<String, TblColumn> _IBGlobalColSettings;
    private static Map<String, Color> _IBGlobalColors;
    private static Map<String, PredefinedView> _IBPredefinedViews;
    private static List<PredefinedTab> _IBPredefinedTabs;
    private static List<PredefinedTab> _IBUserTabs;
    private static Map<String, EventFilter> _IBPredefinedGlobalFilters;
    private static Map<String, Object> _WebBrowserSettings;
    private static List<String> _ActionSettings;
    private AtomicBoolean m_shutdown = new AtomicBoolean(false);
    private boolean m_resetSettings = false;

    static {
        m_tree = null;
        MSG_VIEW1 = "com.blixx.boom.gui.views.msgview";
        MSG_VIEW2 = "com.blixx.boom.gui.views.msgview:MsgView2";
        LABEL = "LABEL";
        VALUE = "VALUE";
        TYPE = "TYPE";
        DOWN = "down";
        UP = "up";
        TEXT = "TEXT";
        VIEW = "VIEW";
        VIEW_ID = "VIEW_ID";
        TAB = "TAB";
        SHOW_ACTIVE = "SHOW_ACTIVE";
        SORT_COL = "SORT_COL";
        SORT_DIR = "SORT_DIR";
        CLOSABLE = "CLOSABLE";
        MOVEABLE = "MOVEABLE";
        FILTER_LIST = "FILTER_LIST";
        FILTER = "FILTER";
        SERVICE = "SERVICE";
        SERVICE_NAME = "SERVICE_NAME";
        GROUP = "GROUP";
        GROUP_NAME = "GROUP_NAME";
        ACTIVE = "ACTIVE";
        IB_GLOBAL = "IB_GLOBAL";
        CAN_MODIFY_FILTERS = "CAN_MODIFY_FILTERS";
        CAN_MOVE_TABS = "CAN_MOVE_TABS";
        CAN_SORT = "CAN_SORT";
        CAN_SWITCH = "CAN_SWITCH";
        SHOW_INDI_VIEW2 = "SHOW_INDI_VIEW2";
        IB_COL_SETTINGS = "IB_COL_SETTINGS";
        IB_COLOR_OPTIONS = "IB_COLOR_OPTIONS";
        COLORS_INDI_BROWSER = "COLORS_INDI_BROWSER";
        COLORS_OUT_BROWSER = "COLORS_OUT_BROWSER";
        IB_COLOR_ACTIVE = "IB_COLOR_ACTIVE";
        IB_COLOR_CLOSED = "IB_COLOR_CLOSED";
        OB_COLOR_ACTIVE = "OB_COLOR_ACTIVE";
        OB_COLOR_CLOSED = "OB_COLOR_CLOSED";
        ADD_NEW_TABS = "ADD_NEW_TABS";
        GLOBAL_SORT_COL = "GLOBAL_SORT_COL";
        GLOBAL_SORT_DIR = "GLOBAL_SORT_DIR";
        IB_PREDEFINED_FILTERS = "IB_PREDEFINED_FILTERS";
        URL = "URL";
        SORTING = "SORTING";
        _GeneralAttributes = null;
        _IBGlobalSettings = null;
        _IBGlobalColSettings = null;
        _IBGlobalColors = null;
        _IBPredefinedViews = null;
        _IBPredefinedTabs = null;
        _IBUserTabs = null;
        _IBPredefinedGlobalFilters = null;
        _WebBrowserSettings = null;
        _ActionSettings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UISettings getInstance() {
        if (m_UISettings != null) return m_UISettings;
        Class<UISettings> clazz = UISettings.class;
        synchronized (UISettings.class) {
            if (m_UISettings != null) return m_UISettings;
            m_UISettings = new UISettings();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_UISettings;
        }
    }

    public UISettings() {
        _GeneralAttributes = new HashMap<String, GenAttribute>();
        _IBGlobalSettings = new HashMap<String, Object>();
        _IBGlobalColSettings = new HashMap<String, TblColumn>();
        _IBGlobalColors = new HashMap<String, Color>();
        _IBPredefinedViews = new HashMap<String, PredefinedView>();
        _IBPredefinedTabs = new ArrayList<PredefinedTab>();
        _IBUserTabs = new ArrayList<PredefinedTab>();
        _IBPredefinedGlobalFilters = new HashMap<String, EventFilter>();
        _WebBrowserSettings = new HashMap<String, Object>();
        _ActionSettings = new ArrayList<String>();
    }

    public void reload() {
        if (m_doc != null && !this.m_shutdown.get()) {
            this.loadSettings();
            this.createTree();
        }
    }

    public void load(File srvProfile) {
        if (this.m_shutdown.get()) {
            return;
        }
        this.initDefault();
        Document doc = null;
        if (srvProfile == null) {
            m_useServerProfile = false;
            m_profileType = LOCAL_PROFILE;
            srvProfile = UISettings.getSettingsFile();
            if (!srvProfile.exists() || srvProfile.length() == 0L) {
                if (UISettings.getBackupFile().exists() && UISettings.getBackupFile().length() > 0L) {
                    srvProfile = UISettings.getBackupFile();
                    doc = this.loadDocument(srvProfile);
                    if (doc == null) {
                        RTLogger.print(5, "Failed to load backup user profile.");
                        StringBuffer sb = new StringBuffer();
                        sb.append("Error processing User Profile, ").append(String.valueOf(UISettings.getSettingsFile().getPath()) + " does not exist or empty\n").append("Backup file: ").append(String.valueOf(UISettings.getBackupFile().getPath()) + " can't be loaded!").append("\nThe default Settings will be used!");
                        new ShowMessageBox("User Profile", sb.toString(), 8);
                    }
                } else {
                    srvProfile = null;
                    if (UISettings.getSettingsFile().exists() && UISettings.getSettingsFile().length() == 0L) {
                        RTLogger.print(5, "Error processing UI Config file, file might be corrupt!");
                        StringBuffer sb = new StringBuffer();
                        sb.append("Error processing User Profile, ").append(String.valueOf(UISettings.getSettingsFile().getPath()) + " might be corrupt! ").append("\nThe default Settings will be used!");
                        new ShowMessageBox("User Profile", sb.toString(), 8);
                    }
                }
            } else {
                doc = this.loadDocument(srvProfile);
                if (doc == null && (doc = this.loadDocument(UISettings.getBackupFile())) == null) {
                    RTLogger.print(5, "Failed to load backup user profile.");
                    StringBuffer sb = new StringBuffer();
                    sb.append("Error processing User Profile, ").append(String.valueOf(UISettings.getSettingsFile().getPath()) + " might be corrupt!\n").append("Backup file: ").append(String.valueOf(UISettings.getBackupFile().getPath()) + " can't be loaded!").append("\nThe default Settings will be used!");
                    new ShowMessageBox("User Profile", sb.toString(), 8);
                }
            }
        } else {
            m_useServerProfile = true;
            m_profileType = SERVER_PROFILE;
            doc = this.loadDocument(srvProfile);
            if (doc == null) {
                RTLogger.print(5, "Failed to load SERVER user profile. " + srvProfile.getPath());
                StringBuffer sb = new StringBuffer();
                sb.append("Error processing User Profile, ").append(String.valueOf(srvProfile.getPath()) + " might be corrupt!\n").append("\nThe default Settings will be used!");
                new ShowMessageBox("User Profile", sb.toString(), 8);
            }
        }
        if (doc != null) {
            m_doc = doc;
            this.checkIfOldVersion();
            this.loadSettings();
            this.createTree();
        } else {
            m_profileType = NO_PROFILE;
        }
    }

    public static File getSettingsFile() {
        UISettings.checkConfigFilePath();
        File file = new File(GUIConfigFile);
        return file;
    }

    private void checkIfOldVersion() {
        block10: {
            try {
                Element top = m_doc.getDocumentElement();
                if (top == null) break block10;
                NodeList nl_1 = top.getElementsByTagName("VIEW_LIST");
                NodeList nl_2 = top.getElementsByTagName("TAB_LIST");
                if ((nl_1 == null || nl_1.getLength() <= 0) && (nl_2 == null || nl_2.getLength() <= 0)) break block10;
                try {
                    NodeList openTabsNL = top.getElementsByTagName("TAB_LIST");
                    int i = 0;
                    while (i < openTabsNL.getLength()) {
                        this.load_IBPredefinedTabs((Element)openTabsNL.item(i), _IB_PREDEFINED_TABS);
                        ++i;
                    }
                    m_doc = this.createDocument(true, null, null);
                    Element userTabs = null;
                    Element ib = null;
                    NodeList ibl = m_doc.getElementsByTagName(_INDICATION_BROWSER);
                    if (ibl == null || ibl.getLength() == 0) {
                        ib = m_doc.createElement(_INDICATION_BROWSER);
                        m_doc.appendChild(ib);
                    } else {
                        ib = (Element)ibl.item(0);
                    }
                    NodeList nl = m_doc.getElementsByTagName(_IB_PREDEFINED_TABS);
                    if (nl == null || nl.getLength() == 0) {
                        userTabs = m_doc.createElement(_IB_PREDEFINED_TABS);
                        ib.appendChild(userTabs);
                    } else {
                        userTabs = (Element)nl.item(0);
                    }
                    for (PredefinedTab tab : _IBPredefinedTabs) {
                        if (tab == null) continue;
                        Element tabEl = this.createTabElement(m_doc, tab);
                        userTabs.appendChild(tabEl);
                    }
                    StoreJob sj = new StoreJob("oldProfileConverter");
                    sj.run();
                    this.reload();
                }
                catch (Throwable e) {
                    RTLogger.print(3, "Error converting profile", e);
                    this.initDefault();
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    private void loadSettings() {
        boolean success;
        block31: {
            _GeneralAttributes.clear();
            _IBPredefinedTabs.clear();
            _IBUserTabs.clear();
            _IBPredefinedViews.clear();
            _IBGlobalSettings.clear();
            _IBGlobalColSettings.clear();
            _IBPredefinedGlobalFilters.clear();
            _IBGlobalColors.clear();
            _WebBrowserSettings.clear();
            _ActionSettings.clear();
            success = true;
            try {
                Element root = m_doc.getDocumentElement();
                if (root != null) {
                    NodeList nl = root.getChildNodes();
                    if (nl != null) {
                        int length = nl.getLength();
                        boolean genAttributes_proccessed = false;
                        int c1 = 0;
                        while (c1 < length) {
                            Node item = nl.item(c1);
                            if (item != null && item instanceof Element) {
                                Element elem;
                                String name;
                                Node node;
                                int i;
                                NodeList nodes;
                                Element element = (Element)item;
                                String elemName = element.getNodeName();
                                if (elemName.equals(_GENERAL_ATTRIBUTES)) {
                                    nodes = element.getChildNodes();
                                    this.load_GeneralAttributes(nodes);
                                    genAttributes_proccessed = true;
                                } else if (elemName.equals(_INDICATION_BROWSER)) {
                                    nodes = element.getChildNodes();
                                    i = 0;
                                    while (i < nodes.getLength()) {
                                        node = nodes.item(i);
                                        if (node != null && node instanceof Element && (name = (elem = (Element)node).getNodeName()) != null) {
                                            if (name.equals(_IB_GENERAL)) {
                                                this.load_IBGeneral(elem);
                                            } else if (name.equals(_IB_PREDEFINED_VIEWS)) {
                                                this.load_IBPredefinedViews(elem);
                                            } else if (name.equals(_IB_PREDEFINED_TABS)) {
                                                this.load_IBPredefinedTabs(elem, _IB_PREDEFINED_TABS);
                                            } else if (name.equals(_IB_USER_TABS)) {
                                                this.load_IBPredefinedTabs(elem, _IB_USER_TABS);
                                            }
                                        }
                                        ++i;
                                    }
                                } else if (elemName.equals(_WEB_BROWSER)) {
                                    nodes = element.getChildNodes();
                                    i = 0;
                                    while (i < nodes.getLength()) {
                                        node = nodes.item(i);
                                        if (node != null && node instanceof Element && (name = (elem = (Element)node).getNodeName()) != null) {
                                            if (name.equals(WB_INTEGRATED)) {
                                                Element integrated = (Element)node;
                                                boolean isIntegrated = Boolean.valueOf(integrated.getAttribute(ACTIVE));
                                                _WebBrowserSettings.put(WB_INTEGRATED, isIntegrated);
                                            } else if (name.equals("WB_PREDEFINED_TABS")) {
                                                this.load_WBPredefinedTabs(elem, "WB_PREDEFINED_TABS");
                                            }
                                        }
                                        ++i;
                                    }
                                } else if (elemName.equals("ACTIONS")) {
                                    nodes = element.getChildNodes();
                                    i = 0;
                                    while (i < nodes.getLength()) {
                                        String favorites;
                                        node = nodes.item(i);
                                        if (node != null && node instanceof Element && (favorites = (elem = (Element)node).getNodeName()) != null && favorites.equals(_ACTION_FAVORITES)) {
                                            this.load_actionFvorites(elem);
                                        }
                                        ++i;
                                    }
                                }
                            }
                            ++c1;
                        }
                        if (!genAttributes_proccessed) {
                            this.load_GeneralAttributes(null);
                        }
                        break block31;
                    }
                    success = false;
                    break block31;
                }
                success = false;
            }
            catch (Exception exception) {
                success = false;
            }
        }
        if (!success) {
            RTLogger.print(5, "Error processing UI Config file, file might be corrupt!");
            StringBuffer sb = new StringBuffer();
            sb.append("User Profile might be corrupt! ").append("\nThe default Settings will be used!");
            new ShowMessageBox("User Profile", sb.toString(), 2);
            m_profileType = NO_PROFILE;
            this.initDefault();
        }
    }

    private void load_GeneralAttributes(NodeList nodeList) {
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element elem;
                String attributeName;
                Node node = nodeList.item(i);
                if (node != null && node instanceof Element && (attributeName = (elem = (Element)node).getNodeName()) != null) {
                    Map<String, String> map;
                    String value;
                    String type;
                    String label = elem.getAttribute(LABEL);
                    GenAttribute genAttribute = new GenAttribute(label, type = elem.getAttribute(TYPE), value = elem.getAttribute(VALUE));
                    if (genAttribute.isValid()) {
                        _GeneralAttributes.put(attributeName, genAttribute);
                    } else if (GenAttributeProps.defaultValuesExist(attributeName) && (genAttribute = new GenAttribute((map = GenAttributeProps.getDefaultValues(attributeName)).get(LABEL), map.get(TYPE), map.get(VALUE))).isValid()) {
                        _GeneralAttributes.put(attributeName, genAttribute);
                    }
                }
                ++i;
            }
        } else {
            for (String name : GenAttributeProps.m_general_attributes.keySet()) {
                Map<String, String> map = GenAttributeProps.m_general_attributes.get(name);
                GenAttribute genAttribute = new GenAttribute(map.get(LABEL), map.get(TYPE), map.get(VALUE));
                if (!genAttribute.isValid()) continue;
                _GeneralAttributes.put(name, genAttribute);
            }
        }
    }

    private void load_IBGeneral(Element element) {
        _IBGlobalColors.put(IB_COLOR_ACTIVE, BMUI.indiBrowserBkgrActive);
        _IBGlobalColors.put(IB_COLOR_CLOSED, BMUI.indiBrowserBkgrClose);
        _IBGlobalColors.put(OB_COLOR_ACTIVE, BMUI.outageBkgrActive);
        _IBGlobalColors.put(OB_COLOR_CLOSED, BMUI.outageBkgrClose);
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node != null) {
                String nodeName = nodeList.item(i).getNodeName();
                if (node instanceof Element) {
                    Element elem;
                    String type;
                    if (nodeName.equals(IB_GLOBAL)) {
                        Element global = (Element)node;
                        boolean canMove = true;
                        boolean canSwitchActiveClosed = true;
                        boolean canSortTable = true;
                        boolean canModifyFilters = true;
                        boolean showIndiView2 = true;
                        try {
                            int canModifyFilters_int = Integer.parseInt(global.getAttribute(CAN_MODIFY_FILTERS));
                            if (canModifyFilters_int == 0) {
                                canModifyFilters = false;
                            }
                        }
                        catch (Throwable throwable) {
                            canModifyFilters = Boolean.parseBoolean(global.getAttribute(CAN_MODIFY_FILTERS));
                        }
                        try {
                            int canMove_int = Integer.parseInt(global.getAttribute(CAN_MOVE_TABS));
                            if (canMove_int == 0) {
                                canMove = false;
                            }
                        }
                        catch (Throwable throwable) {
                            canMove = Boolean.parseBoolean(global.getAttribute(CAN_MOVE_TABS));
                        }
                        try {
                            int canSortTable_int = Integer.parseInt(global.getAttribute(CAN_SORT));
                            if (canSortTable_int == 0) {
                                canSortTable = false;
                            }
                        }
                        catch (Throwable throwable) {
                            canSortTable = Boolean.parseBoolean(global.getAttribute(CAN_SORT));
                        }
                        try {
                            int canSwitchActiveClosed_int = Integer.parseInt(global.getAttribute(CAN_SWITCH));
                            if (canSwitchActiveClosed_int == 0) {
                                canSwitchActiveClosed = false;
                            }
                        }
                        catch (Throwable throwable) {
                            canSwitchActiveClosed = Boolean.parseBoolean(global.getAttribute(CAN_SWITCH));
                        }
                        try {
                            int showIndiView2_int = Integer.parseInt(global.getAttribute(SHOW_INDI_VIEW2));
                            if (showIndiView2_int == 0) {
                                showIndiView2 = false;
                            }
                        }
                        catch (Throwable throwable) {
                            showIndiView2 = Boolean.parseBoolean(global.getAttribute(SHOW_INDI_VIEW2));
                        }
                        String sortCol = this.getDefaultSortCol();
                        String sortDir = this.getDefaultSortDir();
                        if (global.hasAttribute(SORTING)) {
                            String[] sort = global.getAttribute(SORTING).split("\\|");
                            if (sort.length == 2) {
                                if (sort[0] != null && sort[0].length() > 0 && EventStorageUtils.defaultColumnWidth.containsKey(sort[0])) {
                                    sortCol = sort[0];
                                }
                                if (sort[1] != null && sort[1].length() > 0) {
                                    sortDir = sort[1].equalsIgnoreCase("up") ? UP : DOWN;
                                }
                            }
                        } else {
                            sortCol = this.validateSortCol(global.getAttribute(GLOBAL_SORT_COL));
                            sortDir = this.validateSortDir(global.getAttribute(GLOBAL_SORT_DIR));
                        }
                        _IBGlobalSettings.put(CAN_MOVE_TABS, canMove);
                        _IBGlobalSettings.put(CAN_SORT, canSortTable);
                        _IBGlobalSettings.put(CAN_SWITCH, canSwitchActiveClosed);
                        _IBGlobalSettings.put(CAN_MODIFY_FILTERS, canModifyFilters);
                        _IBGlobalSettings.put(SHOW_INDI_VIEW2, showIndiView2);
                        _IBGlobalSettings.put(GLOBAL_SORT_COL, sortCol);
                        _IBGlobalSettings.put(GLOBAL_SORT_DIR, sortDir);
                    } else if (nodeName.equals(IB_COL_SETTINGS)) {
                        HashMap<Integer, TblColumn> validColumns = new HashMap<Integer, TblColumn>();
                        Element colOrder = (Element)node;
                        NodeList columns = colOrder.getChildNodes();
                        int count = 0;
                        while (count < columns.getLength()) {
                            Element col;
                            String colName;
                            String nName = columns.item(count).getNodeName();
                            if (nName.equals(COLUMN) && EventStorageUtils.defaultColumnWidth.containsKey(colName = (col = (Element)columns.item(count)).getAttribute(NAME))) {
                                String position = col.getAttribute(POSITION);
                                int p = 0;
                                try {
                                    p = Integer.valueOf(position);
                                }
                                catch (NumberFormatException numberFormatException) {}
                                String width = col.getAttribute(WIDTH);
                                int w = 20;
                                try {
                                    w = Integer.valueOf(width);
                                }
                                catch (NumberFormatException numberFormatException) {}
                                String coloring = col.getAttribute(COLORING);
                                boolean bgColorActive = false;
                                try {
                                    bgColorActive = Boolean.parseBoolean(coloring);
                                }
                                catch (Exception exception) {}
                                TblColumn tblColumn = new TblColumn(colName, p, w, bgColorActive);
                                validColumns.put(p, tblColumn);
                            }
                            ++count;
                        }
                        ArrayList sortedList = new ArrayList();
                        sortedList.addAll(validColumns.keySet());
                        Collections.sort(sortedList);
                        int pos = 0;
                        while (pos < sortedList.size()) {
                            TblColumn tblColumn = (TblColumn)validColumns.get(sortedList.get(pos));
                            tblColumn.setPosition(pos);
                            _IBGlobalColSettings.put(tblColumn.getName(), tblColumn);
                            ++pos;
                        }
                        for (String colName : EventStorageUtils.defaultColumnWidth.keySet()) {
                            if (_IBGlobalColSettings.containsKey(colName)) continue;
                            int w = EventStorageUtils.defaultColumnWidth.get(colName);
                            TblColumn tblColumn = new TblColumn(colName, _IBGlobalColSettings.size(), w, false);
                            _IBGlobalColSettings.put(tblColumn.getName(), tblColumn);
                        }
                    } else if (nodeName.equals(IB_PREDEFINED_FILTERS)) {
                        Element filterList = (Element)node;
                        NodeList filters = filterList.getChildNodes();
                        int count = 0;
                        while (count < filters.getLength()) {
                            type = filters.item(count).getNodeName();
                            if (type.equals(FILTER)) {
                                try {
                                    elem = (Element)filters.item(count);
                                    String label = elem.getAttribute(FilterFactory.LABEL);
                                    String isActive = elem.getAttribute(ACTIVE);
                                    String columnName = elem.getAttribute(FilterFactory.COLUMN_NAME);
                                    String condIsNot = elem.getAttribute(FilterFactory.ISNOT);
                                    String pattern = elem.getAttribute(FilterFactory.PATTERN);
                                    String caseSensitive = elem.getAttribute(FilterFactory.CASE_SENSITIVE);
                                    String mode = elem.getAttribute(FilterFactory.MODE);
                                    String isLocked = elem.getAttribute(FilterFactory.IS_LOCKED);
                                    String typeA = elem.getAttribute(FilterFactory.AVAILABILITY);
                                    String typeK = elem.getAttribute(FilterFactory.KPI);
                                    EventFilter ef = new EventFilter(label, columnName, pattern, Boolean.valueOf(caseSensitive), Integer.valueOf(mode), null, Boolean.valueOf(isLocked), Integer.valueOf(typeA), Integer.valueOf(typeK));
                                    ef.m_isNOT = Boolean.valueOf(condIsNot);
                                    ef.m_isActive = Boolean.valueOf(isActive);
                                    _IBPredefinedGlobalFilters.put(ef.toString(), ef);
                                }
                                catch (Throwable throwable) {}
                            }
                            ++count;
                        }
                    } else if (nodeName.equals(IB_COLOR_OPTIONS)) {
                        Element colorOptions = (Element)node;
                        NodeList options = colorOptions.getChildNodes();
                        int count = 0;
                        while (count < options.getLength()) {
                            Color bgClosed;
                            Color bgActive;
                            type = options.item(count).getNodeName();
                            if (type.equals(COLORS_INDI_BROWSER)) {
                                elem = (Element)options.item(count);
                                bgActive = this.parseColor(elem.getAttribute(IB_COLOR_ACTIVE));
                                if (bgActive == null) {
                                    bgActive = BMUI.indiBrowserBkgrActive;
                                }
                                if ((bgClosed = this.parseColor(elem.getAttribute(IB_COLOR_CLOSED))) == null) {
                                    bgClosed = BMUI.indiBrowserBkgrClose;
                                }
                                _IBGlobalColors.put(IB_COLOR_ACTIVE, bgActive);
                                _IBGlobalColors.put(IB_COLOR_CLOSED, bgClosed);
                            } else if (type.equals(COLORS_OUT_BROWSER)) {
                                elem = (Element)options.item(count);
                                bgActive = this.parseColor(elem.getAttribute(OB_COLOR_ACTIVE));
                                if (bgActive == null) {
                                    bgActive = BMUI.outageBkgrActive;
                                }
                                if ((bgClosed = this.parseColor(elem.getAttribute(OB_COLOR_CLOSED))) == null) {
                                    bgClosed = BMUI.outageBkgrClose;
                                }
                                _IBGlobalColors.put(OB_COLOR_ACTIVE, bgActive);
                                _IBGlobalColors.put(OB_COLOR_CLOSED, bgClosed);
                            }
                            ++count;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void load_IBPredefinedViews(Element element) {
        NodeList viewList = element.getChildNodes();
        int i = 0;
        while (i < viewList.getLength()) {
            Element elem;
            String viewID;
            Node n;
            String nodeName = viewList.item(i).getNodeName();
            if (nodeName.equals(VIEW) && (n = viewList.item(i)) instanceof Element && ((viewID = (elem = (Element)n).getAttribute(VIEW_ID)).equals(MSG_VIEW1) || viewID.equals(MSG_VIEW2))) {
                boolean addTabs = true;
                try {
                    int addTabs_int = Integer.parseInt(elem.getAttribute(ADD_NEW_TABS));
                    if (addTabs_int == 0) {
                        addTabs = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    addTabs = Boolean.parseBoolean(elem.getAttribute(ADD_NEW_TABS));
                }
                boolean closable = true;
                try {
                    int closable_int = Integer.parseInt(elem.getAttribute(CLOSABLE));
                    if (closable_int == 0) {
                        closable = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    closable = Boolean.parseBoolean(elem.getAttribute(CLOSABLE));
                }
                boolean moveable = true;
                try {
                    int moveable_int = Integer.parseInt(elem.getAttribute(MOVEABLE));
                    if (moveable_int == 0) {
                        moveable = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    moveable = Boolean.parseBoolean(elem.getAttribute(MOVEABLE));
                }
                PredefinedView view = new PredefinedView(viewID, closable, moveable, addTabs);
                _IBPredefinedViews.put(viewID, view);
            }
            ++i;
        }
        if (!_IBPredefinedViews.containsKey(MSG_VIEW1)) {
            PredefinedView view = new PredefinedView(MSG_VIEW1, false, true, true);
            _IBPredefinedViews.put(MSG_VIEW1, view);
        }
        if (!_IBPredefinedViews.containsKey(MSG_VIEW2)) {
            PredefinedView view = new PredefinedView(MSG_VIEW2, false, true, true);
            _IBPredefinedViews.put(MSG_VIEW2, view);
        }
    }

    private void load_WBPredefinedTabs(Element element, String type) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String[]> predTab = new ArrayList<String[]>();
        String separator = "#####";
        NodeList tabList = element.getChildNodes();
        int i = 0;
        while (i < tabList.getLength()) {
            Element node;
            String nodeName;
            Node o = tabList.item(i);
            if (o instanceof Element && (nodeName = (node = (Element)o).getNodeName()).equals(TAB)) {
                String url = node.getAttribute(URL);
                String position = node.getAttribute(POSITION);
                int p = 0;
                try {
                    p = Integer.valueOf(position);
                }
                catch (NumberFormatException numberFormatException) {}
                if (url != null && url.length() > 0 && position != null && position.length() > 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(p).append(separator).append(url);
                    list.add(sb.toString());
                }
            }
            ++i;
        }
        Collections.sort(list);
        i = 0;
        while (i < list.size()) {
            String elem = (String)list.get(i);
            String[] split = elem.split(separator);
            String url = split[1];
            predTab.add(new String[]{"" + i, url});
            ++i;
        }
        if (type.equals("WB_PREDEFINED_TABS")) {
            _WebBrowserSettings.put(type, predTab);
        } else if (type.equals(_WB_USER_TABS)) {
            _WebBrowserSettings.put(type, predTab);
        }
    }

    private void load_IBPredefinedTabs(Element element, String type) {
        NodeList tabList = element.getChildNodes();
        int i = 0;
        while (i < tabList.getLength()) {
            Element node1;
            String nodeName;
            Node o = tabList.item(i);
            if (o instanceof Element && ((nodeName = (node1 = (Element)o).getNodeName()).equals(TAB) || nodeName.equals("INDICATION_TAB"))) {
                String oldname;
                String viewID = node1.getAttribute(VIEW_ID);
                String name = node1.getAttribute(NAME);
                if ((name == null || name.length() == 0) && (oldname = node1.getAttribute("TAB_NAME")) != null && oldname.length() > 0) {
                    name = oldname;
                }
                boolean showActive = Boolean.parseBoolean(node1.getAttribute(SHOW_ACTIVE));
                boolean isClosable = Boolean.TRUE;
                String closable = node1.getAttribute(CLOSABLE);
                if (closable != null && closable.length() > 0) {
                    isClosable = Boolean.parseBoolean(closable);
                }
                String sortCol = this.getDefaultSortCol();
                String sortDir = this.getDefaultSortDir();
                if (node1.hasAttribute(SORTING) || node1.hasAttribute("DEFAULT_SORTING")) {
                    String[] sort = node1.getAttribute(SORTING).split("\\|");
                    if (node1.hasAttribute("DEFAULT_SORTING")) {
                        sort = node1.getAttribute("DEFAULT_SORTING").split("\\|");
                    }
                    if (sort.length == 2) {
                        if (sort[0] != null && sort[0].length() > 0 && EventStorageUtils.defaultColumnWidth.containsKey(sort[0])) {
                            sortCol = sort[0];
                        }
                        if (sort[1] != null && sort[1].length() > 0) {
                            sortDir = sort[1].equalsIgnoreCase("up") ? UP : DOWN;
                        }
                    }
                } else {
                    sortCol = node1.getAttribute(SORT_COL);
                    sortDir = node1.getAttribute(SORT_DIR);
                }
                int typeInt = 0;
                try {
                    typeInt = Integer.parseInt(node1.getAttribute(TYPE));
                }
                catch (NumberFormatException numberFormatException) {}
                PredefinedTab predTab = new PredefinedTab(viewID, name, typeInt, showActive, isClosable, sortDir, sortCol);
                NodeList nodeList = node1.getChildNodes();
                int ii = 0;
                while (ii < nodeList.getLength()) {
                    Node node = nodeList.item(ii);
                    if (node instanceof Element) {
                        Element elem = (Element)node;
                        if (elem.getNodeName().equals(TBLCOLUMNS)) {
                            Element colList = (Element)node;
                            NodeList columns = colList.getChildNodes();
                            int count = 0;
                            while (count < columns.getLength()) {
                                String nName = columns.item(count).getNodeName();
                                if (nName.equals(COLUMN)) {
                                    Element col = (Element)columns.item(count);
                                    String colName = col.getAttribute(NAME);
                                    int position = 0;
                                    try {
                                        position = Integer.valueOf(col.getAttribute(POSITION));
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                    int width = 20;
                                    try {
                                        width = Integer.valueOf(col.getAttribute(WIDTH));
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                    boolean coloringActive = this.IB_isBGColoringActive(colName);
                                    TblColumn tblColumn = new TblColumn(colName, position, width, coloringActive);
                                    predTab.addColumn(tblColumn);
                                }
                                ++count;
                            }
                        } else if (elem.getNodeName().equals(FILTER_LIST)) {
                            Element filterList = (Element)node;
                            NodeList nList = filterList.getChildNodes();
                            int iii = 0;
                            while (iii < nList.getLength()) {
                                Node n = nList.item(iii);
                                if (n instanceof Element) {
                                    Element el = (Element)n;
                                    if (el.getNodeName().equals(FILTER)) {
                                        Element filter = (Element)n;
                                        int availability = 0;
                                        try {
                                            availability = Integer.parseInt(filter.getAttribute(FilterFactory.AVAILABILITY));
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                        int KPIs = 0;
                                        try {
                                            KPIs = Integer.parseInt(filter.getAttribute(FilterFactory.KPI));
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                        int mode = 0;
                                        try {
                                            mode = Integer.parseInt(filter.getAttribute(FilterFactory.MODE));
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                        boolean isFilterEnabled = true;
                                        if (filter.hasAttribute(ACTIVE)) {
                                            isFilterEnabled = Boolean.parseBoolean(filter.getAttribute(ACTIVE));
                                        }
                                        boolean isShowActiveBrowser = true;
                                        if (filter.hasAttribute(SHOW_ACTIVE)) {
                                            isShowActiveBrowser = Boolean.parseBoolean(filter.getAttribute(SHOW_ACTIVE));
                                        }
                                        TblFilter tblFilter = new TblFilter(filter.getAttribute(FilterFactory.LABEL), filter.getAttribute(FilterFactory.FILTER_NAME), filter.getAttribute(FilterFactory.COLUMN_NAME), isFilterEnabled, Boolean.parseBoolean(filter.getAttribute(FilterFactory.IS_LOCKED)), isShowActiveBrowser, availability, KPIs, Boolean.parseBoolean(filter.getAttribute(FilterFactory.ISNOT)), Boolean.parseBoolean(filter.getAttribute(FilterFactory.CASE_SENSITIVE)), mode, filter.getAttribute(FilterFactory.PATTERN));
                                        predTab.addFilter(tblFilter);
                                    } else if (el.getNodeName().equals(SERVICE)) {
                                        Element srvElem = (Element)n;
                                        String srvName = srvElem.getAttribute(SERVICE_NAME);
                                        ServiceDashBoard service = new ServiceDashBoard(srvName, Repository.getEventProvider());
                                        service.setMode(2);
                                        NodeList groupList = srvElem.getChildNodes();
                                        int z = 0;
                                        while (z < groupList.getLength()) {
                                            Node n1 = groupList.item(z);
                                            if (n1 instanceof Element) {
                                                Element grpElem = (Element)n1;
                                                String grpName = grpElem.getAttribute(GROUP_NAME);
                                                EventFilterGroup efg = new EventFilterGroup(grpName);
                                                NodeList srvFilterList = grpElem.getChildNodes();
                                                int zz = 0;
                                                while (zz < srvFilterList.getLength()) {
                                                    Node n2 = srvFilterList.item(zz);
                                                    if (n2 instanceof Element) {
                                                        Element filter = (Element)n2;
                                                        int availability = 0;
                                                        try {
                                                            availability = Integer.parseInt(filter.getAttribute(FilterFactory.AVAILABILITY));
                                                        }
                                                        catch (NumberFormatException numberFormatException) {}
                                                        int KPIs = 0;
                                                        try {
                                                            KPIs = Integer.parseInt(filter.getAttribute(FilterFactory.KPI));
                                                        }
                                                        catch (NumberFormatException numberFormatException) {}
                                                        int mode = 0;
                                                        try {
                                                            mode = Integer.parseInt(filter.getAttribute(FilterFactory.MODE));
                                                        }
                                                        catch (NumberFormatException numberFormatException) {}
                                                        EventFilter ef = new EventFilter(filter.getAttribute(FilterFactory.LABEL), filter.getAttribute(FilterFactory.COLUMN_NAME), filter.getAttribute(FilterFactory.PATTERN), Boolean.parseBoolean(filter.getAttribute(FilterFactory.CASE_SENSITIVE)), mode, null, Boolean.parseBoolean(filter.getAttribute(FilterFactory.IS_LOCKED)), availability, KPIs, Boolean.parseBoolean(filter.getAttribute(FilterFactory.ISNOT)));
                                                        efg.addFilter(ef);
                                                    }
                                                    ++zz;
                                                }
                                                service.addFilters(efg);
                                            }
                                            ++z;
                                        }
                                        predTab.addService(service);
                                    }
                                }
                                ++iii;
                            }
                        }
                    }
                    ++ii;
                }
                if (type.equals(_IB_PREDEFINED_TABS)) {
                    _IBPredefinedTabs.add(predTab);
                } else if (type.equals(_IB_USER_TABS)) {
                    _IBUserTabs.add(predTab);
                }
            }
            ++i;
        }
    }

    private void load_actionFvorites(Element favorites) {
        NodeList nodeList = favorites.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element node;
            String id;
            Node n;
            String actionTag = nodeList.item(i).getNodeName();
            if (actionTag.equals("ACTIONS") && (n = nodeList.item(i)) instanceof Element && !(id = (node = (Element)n).getAttribute("ID")).isEmpty() && !_ActionSettings.contains(id)) {
                _ActionSettings.add(id);
            }
            ++i;
        }
    }

    public void createPredefinedAndUserWBTabs(BrowserView browserView, CTabFolder folder) {
        if (m_doc == null) {
            return;
        }
        List predList = (List)_WebBrowserSettings.get("WB_PREDEFINED_TABS");
        ArrayList tabList = new ArrayList();
        if (predList != null && predList.size() > 0) {
            tabList.addAll(predList);
        }
        if (tabList != null) {
            int i = 0;
            while (i < tabList.size()) {
                String[] tab = (String[])tabList.get(i);
                String url = tab[1];
                int pos = -1;
                try {
                    pos = Integer.valueOf(tab[0]);
                }
                catch (NumberFormatException numberFormatException) {}
                BrowserView.openBrowser(url, pos);
                ++i;
            }
        }
    }

    public void createPredifinedIBTabs(MessagesView msgView, MessagesViewFolder folder, String viewID) {
        if (m_doc == null) {
            return;
        }
        String currViewID = viewID;
        int i = 0;
        while (i < _IBPredefinedTabs.size()) {
            PredefinedTab tab = _IBPredefinedTabs.get(i);
            if (currViewID.equals(tab.getViewID())) {
                this.processIB_predefinedTab(msgView, folder, tab, MessageBrowserTab.PREDEFINED_TAB, this.IB_canModifyFilters());
            }
            ++i;
        }
    }

    public void createUserIBTabs(MessagesView msgView, MessagesViewFolder folder, String viewID) {
        if (m_doc == null) {
            return;
        }
        String currViewID = viewID;
        int i = 0;
        while (i < _IBUserTabs.size()) {
            PredefinedTab tab = _IBUserTabs.get(i);
            if (currViewID.equals(tab.getViewID())) {
                this.processIB_predefinedTab(msgView, folder, tab, MessageBrowserTab.USER_TAB, this.IB_canModifyFilters());
            }
            ++i;
        }
    }

    private void processIB_predefinedTab(MessagesView msgView, MessagesViewFolder folder, PredefinedTab tab, String tabType, boolean globalCanModifyFilters) {
        boolean showActive = tab.getShowActive();
        String tabName = this.validateTabName(tab.getName(), showActive);
        tab.setName(tabName);
        int tabStyle = 64;
        if (!tab.getClosable()) {
            tabStyle = 0;
        }
        IEventProvider eProvider = Repository.getEventProvider();
        IEventsSummary eSummary = Repository.getEventsSummary();
        if (1 == tab.getType()) {
            eProvider = Repository.getOuEventProvider();
            eSummary = Repository.getOuEventsSummary();
        }
        MessageBrowserTab mtb = null;
        if (tab.getSerivces().size() > 0) {
            ServiceDashBoard service = null;
            Map<String, ServiceDashBoard> services = tab.getSerivces();
            Iterator<ServiceDashBoard> it = services.values().iterator();
            if (it.hasNext()) {
                service = it.next();
            }
            mtb = new MessageBrowserTab(msgView.getSite(), folder, tabStyle, folder.getItemCount(), service.getName(), true, new EventBrowserProvider(eProvider), eSummary, tabType, tab);
            service.m_isLocked = true;
            if (service.m_tv == null) {
                service.m_tv = mtb.tableViewer;
            }
            ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, service);
        } else {
            mtb = new MessageBrowserTab(msgView.getSite(), folder, tabStyle, folder.getItemCount(), tabName, showActive, new EventBrowserProvider(eProvider), eSummary, tabType, tab);
        }
        this.processIB_predefinedTab_ColSettings(tab, mtb);
        this.processIB_predefinedTab_Filters(tab, mtb, globalCanModifyFilters);
    }

    private void processIB_predefinedTab_ColSettings(PredefinedTab tab, MessageBrowserTab mbt) {
        String sortCol = tab.getSortCol();
        int sortDir = 1024;
        if (tab.getSortDir().equalsIgnoreCase(UP)) {
            sortDir = 128;
        }
        mbt.getEventSorter().setConfig(sortCol, sortDir);
        ViewFilterAction.addSorter(mbt.tableViewer, mbt.getEventSorter());
        try {
            Table mtb_table = mbt.tableViewer.getTable();
            int createdColumns = mtb_table.getColumnCount();
            Map<String, TblColumn> predefinedCols = tab.getColumns();
            int predefinedColumns = predefinedCols.size();
            if (predefinedColumns != createdColumns) {
                RTLogger.print(3, "Cannot load predefined Tabs because the number of columns is not correct in the user profile file!");
                return;
            }
            int[] currColOrder = mtb_table.getColumnOrder();
            int pos = 0;
            while (pos < currColOrder.length) {
                int colIndex_orig = currColOrder[pos];
                String colName = EventStorageUtils.getColumnNameByID(colIndex_orig);
                TableColumn column = this.getIB_ColByName(mtb_table, colName);
                Integer width = predefinedCols.get(colName).getWidth();
                column.setWidth(width.intValue());
                ++pos;
            }
            LinkedHashMap<Integer, String> incomingOrder = new LinkedHashMap<Integer, String>();
            for (TblColumn col : predefinedCols.values()) {
                incomingOrder.put(col.getPosition(), col.getName());
            }
            Set set = incomingOrder.keySet();
            ArrayList incomingOrder_sorted = new ArrayList();
            incomingOrder_sorted.addAll(set);
            Collections.sort(incomingOrder_sorted);
            int[] newColumnOderByID = new int[incomingOrder_sorted.size()];
            int ii = 0;
            while (ii < incomingOrder_sorted.size()) {
                int colID;
                int newPos = (Integer)incomingOrder_sorted.get(ii);
                String colName = (String)incomingOrder.get(newPos);
                newColumnOderByID[ii] = colID = EventStorageUtils.getColumnPosition(colName);
                ++ii;
            }
            mbt.tableViewer.getTable().setColumnOrder(newColumnOderByID);
        }
        catch (Throwable throwable) {}
    }

    private void processIB_predefinedTab_Filters(PredefinedTab tab, MessageBrowserTab mtb, boolean globalCanModifyFilters) {
        try {
            Map<String, TblFilter> filters = tab.getFilters();
            for (TblFilter filter : filters.values()) {
                EventFilter ef = new EventFilter(filter.getLabel(), filter.getColumnName(), filter.getPattern(), filter.caseSensitive(), filter.getMode(), mtb.tableViewer, filter.isLocked(), filter.getAvailability(), filter.getKPIs(), filter.isNot());
                ef.m_isActive = filter.isActive();
                if (!globalCanModifyFilters) {
                    ef.m_isLocked = true;
                }
                ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setShutdown(boolean active) {
        this.m_shutdown.set(active);
    }

    public void initDefault() {
        this.createXML(true);
        this.reload();
    }

    public void storeAndReload() {
        if (!this.m_shutdown.get()) {
            this.createXML(false);
            this.writeXmlJob(1000L);
            this.reload();
        }
    }

    public void shutdown() {
        this.setShutdown(true);
        if (!this.m_resetSettings) {
            UISettings.backupSettings();
            this.createXML(false);
            StoreJob sj = new StoreJob("busS1");
            sj.run();
            if (sj.m_isOK) {
                UISettings.deleteBackup();
            }
        } else {
            UISettings.deleteBackup();
        }
    }

    public void createXML(boolean saveDefault) {
        if (this.doesServerProfileExist()) {
            return;
        }
        try {
            if (Activator.getDefault().getWorkbench().isClosing() || Activator.getDefault().getWorkbench().isStarting()) {
                return;
            }
        }
        catch (Exception exception) {}
        MessagesView msgView1 = MessagesView.getInstance();
        MessagesView msgView2 = null;
        IViewReference viewRef = null;
        try {
            viewRef = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("com.blixx.boom.gui.views.msgview", "MsgView2");
            if (viewRef != null) {
                msgView2 = (MessagesView)viewRef.getView(false);
            }
        }
        catch (Throwable throwable) {}
        try {
            Document doc;
            m_doc = doc = this.createDocument(saveDefault, msgView1, msgView2);
            if (m_profileType.equals(NO_PROFILE)) {
                m_profileType = LOCAL_PROFILE;
            }
        }
        catch (ParserConfigurationException e) {
            RTLogger.print(5, "Cannot store GUI settings: error creating org.w3c.dom.Document", e);
        }
    }

    private Document createDocument(boolean saveDefault, MessagesView msgView1, MessagesView msgView2) throws ParserConfigurationException {
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element settings = doc.createElement(_SETTINGS);
        Element gen = doc.createElement(_GENERAL_ATTRIBUTES);
        Element ib = doc.createElement(_INDICATION_BROWSER);
        Element wb = doc.createElement(_WEB_BROWSER);
        Element actions = doc.createElement("ACTIONS");
        this.createXML_GeneralAttributes(doc, gen, saveDefault);
        this.createXML_IndicationBrowser(doc, ib, msgView1, msgView2, saveDefault);
        this.createXML_WebBrowser(doc, wb, saveDefault);
        this.createXML_Actions(doc, actions, saveDefault);
        settings.appendChild(gen);
        settings.appendChild(ib);
        settings.appendChild(wb);
        settings.appendChild(actions);
        doc.appendChild(settings);
        return doc;
    }

    private void createXML_GeneralAttributes(Document doc, Element gen, boolean saveDefault) {
        if (!saveDefault && _GeneralAttributes != null && _GeneralAttributes.size() > 0) {
            for (String name : _GeneralAttributes.keySet()) {
                GenAttribute genAttribute = _GeneralAttributes.get(name);
                if (genAttribute == null) continue;
                Element attribute = doc.createElement(name);
                attribute.setAttribute(LABEL, genAttribute.getLabel());
                attribute.setAttribute(TYPE, genAttribute.getType());
                attribute.setAttribute(VALUE, genAttribute.getValue());
                gen.appendChild(attribute);
            }
        } else {
            for (String name : GenAttributeProps.m_general_attributes.keySet()) {
                Map<String, String> defaultValues = GenAttributeProps.m_general_attributes.get(name);
                Element attribute = doc.createElement(name);
                attribute.setAttribute(LABEL, defaultValues.get(LABEL));
                attribute.setAttribute(TYPE, defaultValues.get(TYPE));
                attribute.setAttribute(VALUE, defaultValues.get(VALUE));
                gen.appendChild(attribute);
            }
        }
    }

    private void createXML_IndicationBrowser(Document doc, Element ib, MessagesView msgView1, MessagesView msgView2, boolean saveDefault) {
        Element general = doc.createElement(_IB_GENERAL);
        this.createXML_IBGENERAL(doc, general, saveDefault);
        Element predefinedViews = doc.createElement(_IB_PREDEFINED_VIEWS);
        this.createXML_IBPredefinedViews(doc, predefinedViews, saveDefault);
        Element predefinedTabs = doc.createElement(_IB_PREDEFINED_TABS);
        this.createXML_IBPredefinedTabs(doc, predefinedTabs, saveDefault);
        Element userTabs = doc.createElement(_IB_USER_TABS);
        this.createXML_IBUserTabs(doc, userTabs, msgView1, saveDefault);
        this.createXML_IBUserTabs(doc, userTabs, msgView2, saveDefault);
        ib.appendChild(general);
        ib.appendChild(predefinedViews);
        if (predefinedTabs != null) {
            ib.appendChild(predefinedTabs);
        }
        if (userTabs != null) {
            ib.appendChild(userTabs);
        }
    }

    private void createXML_WebBrowser(Document doc, Element wb, boolean saveDefault) {
        boolean isActive = Boolean.valueOf("" + _WebBrowserSettings.get(WB_INTEGRATED));
        Element integrated = doc.createElement(WB_INTEGRATED);
        integrated.setAttribute(ACTIVE, isActive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        wb.appendChild(integrated);
        ArrayList<String> tmp = new ArrayList<String>();
        Element WB_PredefinedTabs_ELEM = doc.createElement("WB_PREDEFINED_TABS");
        List predtabs = (List)_WebBrowserSettings.get("WB_PREDEFINED_TABS");
        if (!saveDefault && predtabs != null && predtabs.size() > 0) {
            int i = 0;
            while (i < predtabs.size()) {
                String[] tab = (String[])predtabs.get(i);
                tmp.add(tab[1]);
                Element tab_ELEM = doc.createElement(TAB);
                tab_ELEM.setAttribute(URL, tab[1]);
                tab_ELEM.setAttribute(POSITION, tab[0]);
                WB_PredefinedTabs_ELEM.appendChild(tab_ELEM);
                ++i;
            }
        }
        if (predtabs != null && predtabs.size() > 0) {
            wb.appendChild(WB_PredefinedTabs_ELEM);
        }
    }

    private void createXML_Actions(Document doc, Element actions, boolean saveDefault) {
        Element favorites = doc.createElement(_ACTION_FAVORITES);
        Iterator<String> it = _ActionSettings.iterator();
        while (it.hasNext()) {
            String id = it.next();
            Action action = ActionSettings.getActionFromRepo(id);
            if (action == null) {
                it.remove();
                continue;
            }
            Element elem = doc.createElement("ACTIONS");
            elem.setAttribute("ID", action.m_ID);
            favorites.appendChild(elem);
        }
        actions.appendChild(favorites);
    }

    private void createXML_IBGENERAL(Document doc, Element general, boolean saveDefault) {
        Element global = doc.createElement(IB_GLOBAL);
        if (!saveDefault && _IBGlobalSettings != null && _IBGlobalSettings.size() > 0) {
            global.setAttribute(CAN_MOVE_TABS, "" + Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_MOVE_TABS)));
            global.setAttribute(CAN_SWITCH, "" + Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_SWITCH)));
            global.setAttribute(CAN_SORT, "" + Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_SORT)));
            global.setAttribute(CAN_MODIFY_FILTERS, "" + Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_MODIFY_FILTERS)));
            global.setAttribute(SHOW_INDI_VIEW2, "" + Boolean.parseBoolean("" + _IBGlobalSettings.get(SHOW_INDI_VIEW2)));
            global.setAttribute(GLOBAL_SORT_COL, "" + _IBGlobalSettings.get(GLOBAL_SORT_COL));
            global.setAttribute(GLOBAL_SORT_DIR, "" + _IBGlobalSettings.get(GLOBAL_SORT_DIR));
        } else {
            global.setAttribute(CAN_MOVE_TABS, Boolean.TRUE.toString());
            global.setAttribute(CAN_SWITCH, Boolean.TRUE.toString());
            global.setAttribute(CAN_SORT, Boolean.TRUE.toString());
            global.setAttribute(CAN_MODIFY_FILTERS, Boolean.TRUE.toString());
            global.setAttribute(SHOW_INDI_VIEW2, Boolean.TRUE.toString());
            global.setAttribute(GLOBAL_SORT_COL, this.getDefaultSortCol());
            global.setAttribute(GLOBAL_SORT_DIR, this.getDefaultSortDir());
        }
        general.appendChild(global);
        Element columnSettings = doc.createElement(IB_COL_SETTINGS);
        if (!saveDefault && _IBGlobalColSettings != null && _IBGlobalColSettings.size() > 0) {
            for (String colName : _IBGlobalColSettings.keySet()) {
                TblColumn column = _IBGlobalColSettings.get(colName);
                Element col = doc.createElement(COLUMN);
                col.setAttribute(NAME, column.getName());
                col.setAttribute(POSITION, "" + column.getPosition());
                col.setAttribute(WIDTH, "" + column.getWidth());
                col.setAttribute(COLORING, column.isColoringActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                columnSettings.appendChild(col);
            }
        } else {
            this.createXML_DefaultColumnSettings(doc, columnSettings);
        }
        general.appendChild(columnSettings);
        Element filterList = doc.createElement(IB_PREDEFINED_FILTERS);
        if (!saveDefault && _IBPredefinedGlobalFilters != null && _IBPredefinedGlobalFilters.size() > 0) {
            for (String filterName : _IBPredefinedGlobalFilters.keySet()) {
                EventFilter ef = _IBPredefinedGlobalFilters.get(filterName);
                Element filter = doc.createElement(FILTER);
                filter.setAttribute(ACTIVE, "" + ef.m_isActive);
                filter.setAttribute(FilterFactory.LABEL, ef.getLabel());
                filter.setAttribute(FilterFactory.FILTER_NAME, ef.toString());
                filter.setAttribute(FilterFactory.COLUMN_NAME, ef.m_column);
                filter.setAttribute(FilterFactory.ISNOT, ef.m_isNOT ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                filter.setAttribute(FilterFactory.PATTERN, ef.m_pattern);
                filter.setAttribute(FilterFactory.CASE_SENSITIVE, ef.m_caseSensitive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                filter.setAttribute(FilterFactory.MODE, "" + ef.m_mode);
                filter.setAttribute(FilterFactory.IS_LOCKED, Boolean.FALSE.toString());
                filter.setAttribute(FilterFactory.AVAILABILITY, "" + ef.m_Availability);
                filter.setAttribute(FilterFactory.KPI, "" + ef.m_KPIs);
                filterList.appendChild(filter);
            }
        }
        general.appendChild(filterList);
        Element colorOptions = doc.createElement(IB_COLOR_OPTIONS);
        if (!saveDefault && _IBGlobalColors != null && _IBGlobalColors.size() > 0) {
            Color obColorClosed;
            Color obColorActive;
            Color ibColorClosed;
            Color ibColorActive = _IBGlobalColors.get(IB_COLOR_ACTIVE);
            if (ibColorActive == null) {
                ibColorActive = BMUI.indiBrowserBkgrActive;
            }
            if ((ibColorClosed = _IBGlobalColors.get(IB_COLOR_CLOSED)) == null) {
                ibColorClosed = BMUI.indiBrowserBkgrClose;
            }
            if ((obColorActive = _IBGlobalColors.get(OB_COLOR_ACTIVE)) == null) {
                obColorActive = BMUI.outageBkgrActive;
            }
            if ((obColorClosed = _IBGlobalColors.get(OB_COLOR_CLOSED)) == null) {
                obColorClosed = BMUI.outageBkgrClose;
            }
            Element indi_browser = doc.createElement(COLORS_INDI_BROWSER);
            indi_browser.setAttribute(IB_COLOR_ACTIVE, ibColorActive.toString());
            indi_browser.setAttribute(IB_COLOR_CLOSED, ibColorClosed.toString());
            Element outage_browser = doc.createElement(COLORS_OUT_BROWSER);
            outage_browser.setAttribute(OB_COLOR_ACTIVE, obColorActive.toString());
            outage_browser.setAttribute(OB_COLOR_CLOSED, obColorClosed.toString());
            colorOptions.appendChild(indi_browser);
            colorOptions.appendChild(outage_browser);
        } else {
            String activeBkgr = "Color {255, 255, 255}";
            String closedBkgr = "Color {228, 228, 228}";
            String outage_activeBkgr = "Color {219, 218, 200}";
            String outage_closedBkgr = "Color {192, 200, 192}";
            try {
                activeBkgr = BMUI.indiBrowserBkgrActive.toString();
                outage_closedBkgr = BMUI.outageBkgrClose.toString();
                closedBkgr = BMUI.indiBrowserBkgrClose.toString();
                outage_activeBkgr = BMUI.outageBkgrActive.toString();
            }
            catch (Throwable throwable) {}
            Element indi_browser = doc.createElement(COLORS_INDI_BROWSER);
            indi_browser.setAttribute(IB_COLOR_ACTIVE, activeBkgr);
            indi_browser.setAttribute(IB_COLOR_CLOSED, closedBkgr);
            Element outage_browser = doc.createElement(COLORS_OUT_BROWSER);
            outage_browser.setAttribute(OB_COLOR_ACTIVE, outage_activeBkgr);
            outage_browser.setAttribute(OB_COLOR_CLOSED, outage_closedBkgr);
            colorOptions.appendChild(indi_browser);
            colorOptions.appendChild(outage_browser);
        }
        general.appendChild(colorOptions);
    }

    private void createXML_DefaultColumnSettings(Document doc, Element parentElement) {
        int totalNumOfVisibleCols = EventStorageUtils.defaultColumnOrder.length;
        TreeMap<Integer, String> reverseMap = new TreeMap<Integer, String>();
        for (Map.Entry<String, Integer> en : EventStorageUtils.m_columnMap.entrySet()) {
            if (reverseMap.containsKey(en.getValue())) {
                int pos = EventStorageUtils.m_columnMap.size();
                while (reverseMap.containsKey(pos)) {
                    ++pos;
                }
                reverseMap.put(pos, en.getKey());
                continue;
            }
            reverseMap.put(en.getValue(), en.getKey());
        }
        for (Map.Entry en : reverseMap.entrySet()) {
            Integer columnID = (Integer)en.getKey();
            String colName = (String)en.getValue();
            if (columnID > totalNumOfVisibleCols) continue;
            int width = 80;
            try {
                width = EventStorageUtils.defaultColumnWidth.get(colName);
            }
            catch (Exception exception) {}
            Element col = doc.createElement(COLUMN);
            col.setAttribute(NAME, colName);
            col.setAttribute(POSITION, "" + columnID);
            col.setAttribute(WIDTH, "" + width);
            col.setAttribute(COLORING, Boolean.FALSE.toString());
            parentElement.appendChild(col);
        }
    }

    private void createXML_IBPredefinedViews(Document doc, Element viewList, boolean saveDefault) {
        boolean proccessedView1 = false;
        boolean proccessedView2 = false;
        if (!saveDefault && _IBPredefinedViews != null && _IBPredefinedViews.size() > 0) {
            for (String viewID : _IBPredefinedViews.keySet()) {
                PredefinedView view = _IBPredefinedViews.get(viewID);
                if (view == null) continue;
                if (viewID.equals(MSG_VIEW1) || viewID.equals(MSG_VIEW2)) {
                    view.setClosable(false);
                }
                Element defaultView = doc.createElement(VIEW);
                defaultView.setAttribute(VIEW_ID, viewID);
                defaultView.setAttribute(CLOSABLE, view.isClosable() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                defaultView.setAttribute(MOVEABLE, view.isMoveable() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                defaultView.setAttribute(ADD_NEW_TABS, view.canAddTabs() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                viewList.appendChild(defaultView);
                if (viewID.equals(MSG_VIEW1)) {
                    proccessedView1 = true;
                    continue;
                }
                if (!viewID.equals(MSG_VIEW2)) continue;
                proccessedView2 = true;
            }
        }
        if (!proccessedView1) {
            Element defaultView1 = doc.createElement(VIEW);
            defaultView1.setAttribute(VIEW_ID, MSG_VIEW1);
            defaultView1.setAttribute(CLOSABLE, Boolean.FALSE.toString());
            defaultView1.setAttribute(MOVEABLE, Boolean.TRUE.toString());
            defaultView1.setAttribute(ADD_NEW_TABS, Boolean.TRUE.toString());
            viewList.appendChild(defaultView1);
        }
        if (!proccessedView2) {
            Element defaultView2 = doc.createElement(VIEW);
            defaultView2.setAttribute(VIEW_ID, MSG_VIEW2);
            defaultView2.setAttribute(CLOSABLE, Boolean.FALSE.toString());
            defaultView2.setAttribute(MOVEABLE, Boolean.TRUE.toString());
            defaultView2.setAttribute(ADD_NEW_TABS, Boolean.TRUE.toString());
            viewList.appendChild(defaultView2);
        }
    }

    private Element createXML_IBPredefinedTabs(Document doc, Element tabList, boolean saveDefault) {
        if (saveDefault) {
            return null;
        }
        if (_IBPredefinedTabs != null && _IBPredefinedTabs.size() > 0) {
            int i = 0;
            while (i < _IBPredefinedTabs.size()) {
                PredefinedTab predefinedTab = _IBPredefinedTabs.get(i);
                if (predefinedTab != null) {
                    Element tab = this.createTabElement(doc, predefinedTab);
                    tabList.appendChild(tab);
                }
                ++i;
            }
        }
        return tabList;
    }

    protected Element createTabElement(Document doc, PredefinedTab predefinedTab) {
        Element tab = doc.createElement(TAB);
        tab.setAttribute(NAME, predefinedTab.getName());
        tab.setAttribute(VIEW_ID, predefinedTab.getViewID());
        tab.setAttribute(SHOW_ACTIVE, predefinedTab.getShowActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        tab.setAttribute(CLOSABLE, predefinedTab.getClosable() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        tab.setAttribute(SORT_COL, predefinedTab.getSortCol());
        tab.setAttribute(SORT_DIR, predefinedTab.getSortDir());
        tab.setAttribute(TYPE, "" + predefinedTab.getType());
        Element filterList = doc.createElement(FILTER_LIST);
        Map<String, TblFilter> filters = predefinedTab.getFilters();
        for (String fName : filters.keySet()) {
            TblFilter filter = filters.get(fName);
            this.createXML_IBFilter(doc, filterList, filter);
        }
        tab.appendChild(filterList);
        Element table_elem = doc.createElement(TBLCOLUMNS);
        Map<String, TblColumn> columns = predefinedTab.getColumns();
        if (columns != null && columns.size() > 0) {
            for (String colName : columns.keySet()) {
                TblColumn col = columns.get(colName);
                this.createXML_IBColumns(doc, table_elem, col);
            }
        } else {
            this.createXML_DefaultColumnSettings(doc, table_elem);
        }
        tab.appendChild(table_elem);
        return tab;
    }

    private Element createXML_IBUserTabs(Document doc, Element userTab, MessagesView msgView, boolean saveDefault) {
        if (msgView == null || msgView.m_folder == null || saveDefault) {
            return null;
        }
        boolean activeProcessed = false;
        boolean closedProcessed = false;
        String msgViewID = MSG_VIEW1;
        if (msgView.getSecondaryID() != null) {
            msgViewID = MSG_VIEW2;
        }
        CTabItem[] items = msgView.m_folder.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof MessageBrowserTab) {
                MessageBrowserTab mbt = (MessageBrowserTab)items[i];
                if (msgViewID.equals(MSG_VIEW1) && !activeProcessed && this.isDefaultTab(mbt, msgViewID)) {
                    activeProcessed = true;
                } else if (msgViewID.equals(MSG_VIEW2) && !closedProcessed && this.isDefaultTab(mbt, msgViewID)) {
                    closedProcessed = true;
                } else if (!mbt.isPredefinedTab()) {
                    try {
                        String sortCol = this.getDefaultSortCol();
                        String sortDir = this.getDefaultSortDir();
                        String currSorting = mbt.getEventSorter().getCurrentSorting();
                        String[] sort = currSorting.split("\\|");
                        if (sort.length == 2) {
                            sortCol = sort[0];
                            sortDir = sort[1];
                        }
                        Element tab = doc.createElement(TAB);
                        tab.setAttribute(NAME, mbt.getText());
                        tab.setAttribute(VIEW_ID, msgViewID);
                        tab.setAttribute(SHOW_ACTIVE, mbt.getEventProvider().isShowActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                        tab.setAttribute(CLOSABLE, mbt.getStyle() == 64 ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                        tab.setAttribute(SORT_COL, sortCol);
                        tab.setAttribute(SORT_DIR, sortDir);
                        tab.setAttribute(TYPE, "" + mbt.getEventProvider().getType());
                        Iterator<EventFilter> filterIT = ViewFilterAction.getActiveFiltersIterator(mbt.tableViewer);
                        if (filterIT != null) {
                            Element filterList = doc.createElement(FILTER_LIST);
                            while (filterIT.hasNext()) {
                                EventFilter filter;
                                EventFilter ef = filter = filterIT.next();
                                this.createXML_IBFilter(doc, filterList, ef);
                            }
                            tab.appendChild(filterList);
                        }
                        Element table_elem = doc.createElement(TBLCOLUMNS);
                        Table table = mbt.tableViewer.getTable();
                        int[] currColOrder = table.getColumnOrder();
                        int pos = 0;
                        while (pos < currColOrder.length) {
                            int colIndex_orig = currColOrder[pos];
                            String colName = EventStorageUtils.getColumnNameByID(colIndex_orig);
                            TableColumn column = this.getIB_ColByName(table, colName);
                            this.createXML_IBColumns(doc, table_elem, column, pos);
                            ++pos;
                        }
                        tab.appendChild(table_elem);
                        userTab.appendChild(tab);
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "", e);
                    }
                }
            }
            ++i;
        }
        return userTab;
    }

    public TableColumn getIB_ColByName(Table table, String colName) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            TableColumn col = columns[i];
            String colDefaultName = (String)col.getData(MessageBrowserTab.COL_DEFAULT_NAME);
            if (colDefaultName != null && colDefaultName.equals(colName)) {
                return col;
            }
            ++i;
        }
        return null;
    }

    private void createXML_IBFilter(Document doc, Element filterList, EventFilter ef) {
        if (ef instanceof ServiceDashBoard) {
            Element service = doc.createElement(SERVICE);
            service.setAttribute(SERVICE_NAME, ef.toString());
            ServiceDashBoard sdb = (ServiceDashBoard)ef;
            for (EventFilterGroup efg : sdb.getFilters().values()) {
                Element group = doc.createElement(GROUP);
                group.setAttribute(GROUP_NAME, efg.getName());
                List<EventFilter> filters = efg.getFilters();
                int i = 0;
                while (i < filters.size()) {
                    EventFilter f = filters.get(i);
                    Element filter = doc.createElement(FILTER);
                    filter.setAttribute(FilterFactory.LABEL, f.getLabel());
                    filter.setAttribute(FilterFactory.FILTER_NAME, f.toString());
                    filter.setAttribute(FilterFactory.COLUMN_NAME, f.m_column);
                    filter.setAttribute(FilterFactory.ISNOT, f.m_isNOT ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    filter.setAttribute(FilterFactory.PATTERN, f.m_pattern);
                    filter.setAttribute(FilterFactory.CASE_SENSITIVE, f.m_caseSensitive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    filter.setAttribute(FilterFactory.MODE, "" + f.m_mode);
                    filter.setAttribute(FilterFactory.AVAILABILITY, "" + f.m_Availability);
                    filter.setAttribute(FilterFactory.KPI, "" + f.m_KPIs);
                    filter.setAttribute(FilterFactory.IS_LOCKED, Boolean.TRUE.toString());
                    filter.setAttribute(ACTIVE, f.m_isActive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    group.appendChild(filter);
                    ++i;
                }
                service.appendChild(group);
            }
            filterList.appendChild(service);
        } else {
            Element filter = doc.createElement(FILTER);
            filter.setAttribute(FilterFactory.LABEL, ef.getLabel());
            filter.setAttribute(FilterFactory.FILTER_NAME, ef.toString());
            filter.setAttribute(FilterFactory.COLUMN_NAME, ef.m_column);
            filter.setAttribute(FilterFactory.ISNOT, ef.m_isNOT ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            filter.setAttribute(FilterFactory.PATTERN, ef.m_pattern);
            filter.setAttribute(FilterFactory.CASE_SENSITIVE, ef.m_caseSensitive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            filter.setAttribute(FilterFactory.MODE, "" + ef.m_mode);
            filter.setAttribute(FilterFactory.AVAILABILITY, "" + ef.m_Availability);
            filter.setAttribute(FilterFactory.KPI, "" + ef.m_KPIs);
            filter.setAttribute(FilterFactory.IS_LOCKED, Boolean.FALSE.toString());
            filter.setAttribute(ACTIVE, ef.m_isActive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            filterList.appendChild(filter);
        }
    }

    private void createXML_IBFilter(Document doc, Element filterList, TblFilter tf) {
        Element filter = doc.createElement(FILTER);
        filter.setAttribute(FilterFactory.LABEL, tf.getLabel());
        filter.setAttribute(FilterFactory.FILTER_NAME, tf.getFilterName());
        filter.setAttribute(FilterFactory.COLUMN_NAME, tf.getColumnName());
        filter.setAttribute(FilterFactory.ISNOT, tf.isNot() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        filter.setAttribute(FilterFactory.PATTERN, tf.getPattern());
        filter.setAttribute(FilterFactory.CASE_SENSITIVE, tf.caseSensitive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        filter.setAttribute(FilterFactory.MODE, "" + tf.getMode());
        filter.setAttribute(FilterFactory.AVAILABILITY, "" + tf.getAvailability());
        filter.setAttribute(FilterFactory.KPI, "" + tf.getKPIs());
        filter.setAttribute(FilterFactory.IS_LOCKED, Boolean.FALSE.toString());
        filter.setAttribute(ACTIVE, tf.isActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        filterList.appendChild(filter);
    }

    private void createXML_IBColumns(Document doc, Element tblColumnList, TableColumn column, int position) {
        if (column == null) {
            return;
        }
        String colName = (String)column.getData(MessageBrowserTab.COL_DEFAULT_NAME);
        Element tblcol = doc.createElement(COLUMN);
        tblcol.setAttribute(NAME, colName);
        tblcol.setAttribute(POSITION, "" + position);
        tblcol.setAttribute(WIDTH, "" + column.getWidth());
        TblColumn col = _IBGlobalColSettings.get(colName);
        boolean isColoringActive = col.isColoringActive();
        tblcol.setAttribute(COLORING, isColoringActive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        tblColumnList.appendChild(tblcol);
    }

    private void createXML_IBColumns(Document doc, Element tblColumnList, TblColumn column) {
        if (column == null) {
            return;
        }
        Element tblcol = doc.createElement(COLUMN);
        tblcol.setAttribute(NAME, column.getName());
        tblcol.setAttribute(POSITION, "" + column.getPosition());
        tblcol.setAttribute(WIDTH, "" + column.getWidth());
        tblcol.setAttribute(COLORING, column.isColoringActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        tblColumnList.appendChild(tblcol);
    }

    private boolean isDefaultTab(MessageBrowserTab mbt, String viewID) {
        boolean isDefault = false;
        if (mbt != null && !mbt.isDisposed()) {
            if (viewID.equals(MSG_VIEW1) && mbt.getText().equals("[Active]")) {
                isDefault = true;
            } else if (viewID.equals(MSG_VIEW2) && mbt.getText().equals("[Closed]")) {
                isDefault = true;
            }
        }
        return isDefault;
    }

    private boolean writeXmlJob(long ms) {
        StoreJob sj = new StoreJob("busS1");
        if (ms == 0L) {
            Repository.getJobManager().schedule(sj);
        } else {
            Repository.getJobManager().schedule(sj, ms);
        }
        return true;
    }

    private Document loadDocument(File file) {
        Document doc = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fis);
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            RTLogger.print(1, "Error loading file " + file.getPath());
        }
        catch (SAXException sAXException) {
            RTLogger.print(1, "SAX Error " + file.getPath());
        }
        catch (IOException iOException) {
            RTLogger.print(1, "IO Error " + file.getPath());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            RTLogger.print(1, "Error parsing xml " + file.getPath());
        }
        return doc;
    }

    private String validateTabName(String name, boolean showActive) {
        name = name.replace("[Active]", "");
        name = name.replace("[Closed]", "");
        name = showActive ? String.valueOf(name) + "[Active]" : String.valueOf(name) + "[Closed]";
        return name;
    }

    private Color parseColor(String color_str) {
        if (color_str == null || color_str.trim().length() == 0) {
            return null;
        }
        String colorSTR = null;
        colorSTR = (color_str = color_str.trim()).startsWith("Color {") && color_str.endsWith("}") ? color_str.substring(7, color_str.length() - 1) : color_str;
        String[] split = colorSTR.split(",");
        if (split.length == 3) {
            int red = -1;
            try {
                red = Integer.parseInt(split[0].trim());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            int green = -1;
            try {
                green = Integer.parseInt(split[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            int blue = -1;
            try {
                blue = Integer.parseInt(split[2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            try {
                Color color = new Color((Device)Display.getCurrent(), red, green, blue);
                return color;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    public void reset() {
        if (this.doesServerProfileExist()) {
            return;
        }
        RTLogger.print(4, "Reset UI Settings");
        try {
            File file = UISettings.getSettingsFile();
            if (file.exists()) {
                boolean success = file.delete();
                if (success) {
                    RTLogger.print(4, "deleted user profile: " + GUIConfigFile);
                    this.m_resetSettings = true;
                } else {
                    RTLogger.print(4, "Cannot delete user profile: " + GUIConfigFile);
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(5, "Cannot delete user profile " + GUIConfigFile, e);
        }
    }

    public boolean doesServerProfileExist() {
        return m_useServerProfile;
    }

    public String getProfileType() {
        return m_profileType;
    }

    public boolean IB_showIndicationView2() {
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        return Boolean.parseBoolean("" + _IBGlobalSettings.get(SHOW_INDI_VIEW2));
    }

    public boolean IB_canMoveTab() {
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        return Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_MOVE_TABS));
    }

    public boolean IB_canSwitchTable() {
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        return Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_SWITCH));
    }

    public boolean IB_canSortTable() {
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        return Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_SORT));
    }

    public boolean IB_canModifyFilters() {
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        return Boolean.parseBoolean("" + _IBGlobalSettings.get(CAN_MODIFY_FILTERS));
    }

    public boolean IB_isViewConfigured(String viewID) {
        if (m_profileType.equals(NO_PROFILE)) {
            return false;
        }
        return viewID != null && viewID.length() > 0 && _IBPredefinedViews != null && _IBPredefinedViews.containsKey(viewID);
    }

    public boolean IB_canCloseView(String viewID) {
        PredefinedView view;
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        if (viewID != null && viewID.length() > 0 && _IBPredefinedViews != null && (view = _IBPredefinedViews.get(viewID)) != null) {
            return view.isClosable();
        }
        return true;
    }

    public boolean IB_canMoveView(String viewID) {
        PredefinedView view;
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        if (viewID != null && viewID.length() > 0 && _IBPredefinedViews != null && (view = _IBPredefinedViews.get(viewID)) != null) {
            return view.isMoveable();
        }
        return true;
    }

    public boolean IB_canAddNewTab(String viewID) {
        PredefinedView view;
        if (m_profileType.equals(NO_PROFILE)) {
            return true;
        }
        if (viewID != null && viewID.length() > 0 && _IBPredefinedViews != null && (view = _IBPredefinedViews.get(viewID)) != null) {
            return view.canAddTabs();
        }
        return true;
    }

    public String getDefaultSortCol() {
        return "SrvTime";
    }

    public String getDefaultSortDir() {
        return DOWN;
    }

    public boolean IB_isBGColoringActive(String colName) {
        boolean isBGColorActive = false;
        if (_IBGlobalColSettings == null) {
            return false;
        }
        for (String name : _IBGlobalColSettings.keySet()) {
            if (!name.equals(colName)) continue;
            TblColumn col = _IBGlobalColSettings.get(name);
            isBGColorActive = col.isColoringActive();
        }
        return isBGColorActive;
    }

    public Map<String, TblColumn> getIB_GlobalColSettings() {
        return _IBGlobalColSettings;
    }

    public Color getIB_BackgroundColors(int type, boolean displayActive) {
        Color color = null;
        if (_IBGlobalColors != null && !_IBGlobalColors.isEmpty()) {
            if (type == 0) {
                color = displayActive ? _IBGlobalColors.get(IB_COLOR_ACTIVE) : _IBGlobalColors.get(IB_COLOR_CLOSED);
            } else if (type == 1) {
                color = displayActive ? _IBGlobalColors.get(OB_COLOR_ACTIVE) : _IBGlobalColors.get(OB_COLOR_CLOSED);
            }
            if (color != null) {
                return color;
            }
        }
        if (type == 0) {
            color = displayActive ? BMUI.indiBrowserBkgrActive : BMUI.indiBrowserBkgrClose;
        } else if (type == 1) {
            color = displayActive ? BMUI.outageBkgrActive : BMUI.outageBkgrClose;
        }
        if (color != null) {
            return color;
        }
        return color;
    }

    public Map<String, Integer> getIB_GlobalColWidth() {
        HashMap<String, Integer> colWidthGLOBAL = new HashMap<String, Integer>();
        for (String name : EventStorageUtils.defaultColumnWidth.keySet()) {
            colWidthGLOBAL.put(name, EventStorageUtils.defaultColumnWidth.get(name));
        }
        if (_IBGlobalColSettings != null) {
            for (String colName : _IBGlobalColSettings.keySet()) {
                TblColumn col = _IBGlobalColSettings.get(colName);
                if (col == null || !colWidthGLOBAL.containsKey(colName)) continue;
                colWidthGLOBAL.put(colName, col.getWidth());
            }
        }
        return colWidthGLOBAL;
    }

    public int[] getIB_GlobalColOrder() {
        int[] columnOrder = null;
        if (_IBGlobalColSettings != null) {
            try {
                LinkedHashMap<Integer, String> incoming = new LinkedHashMap<Integer, String>();
                for (String colName : _IBGlobalColSettings.keySet()) {
                    TblColumn col = _IBGlobalColSettings.get(colName);
                    if (col == null) continue;
                    incoming.put(col.getPosition(), colName);
                }
                Set set = incoming.keySet();
                ArrayList incomingOrder_sorted = new ArrayList();
                incomingOrder_sorted.addAll(set);
                Collections.sort(incomingOrder_sorted);
                columnOrder = new int[incomingOrder_sorted.size()];
                int i = 0;
                while (i < incomingOrder_sorted.size()) {
                    int pos = (Integer)incomingOrder_sorted.get(i);
                    String colName = (String)incoming.get(pos);
                    int colID = EventStorageUtils.getColumnPosition(colName);
                    if (colID <= -1) {
                        throw new Exception("Stored order is not compatible with current version");
                    }
                    columnOrder[i] = colID;
                    ++i;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return columnOrder;
    }

    public Map<String, Object> getIB_GlobalSettings() {
        return _IBGlobalSettings;
    }

    public Map<String, Color> getIB_Colors() {
        return _IBGlobalColors;
    }

    public Map<String, PredefinedView> getIB_PredefinedViews() {
        return _IBPredefinedViews;
    }

    public List<PredefinedTab> getIB_PredefinedTabs() {
        return _IBPredefinedTabs;
    }

    public Map<String, EventFilter> getIB_PredefinedGlobalFilters() {
        return _IBPredefinedGlobalFilters;
    }

    public Map<String, GenAttribute> getGenAttributes() {
        return _GeneralAttributes;
    }

    public Map<String, Object> getWebBrowserSettings() {
        return _WebBrowserSettings;
    }

    public List<String> getActionSettings() {
        return _ActionSettings;
    }

    public boolean isExternalWebBrowser() {
        boolean wbIntegrated = Boolean.parseBoolean("" + _WebBrowserSettings.get(WB_INTEGRATED));
        return !wbIntegrated;
    }

    public String getIB_GlobalSortDir() {
        return "" + _IBGlobalSettings.get(GLOBAL_SORT_DIR);
    }

    public String getIB_GlobalSortCol() {
        return "" + _IBGlobalSettings.get(GLOBAL_SORT_COL);
    }

    public void addIBPredefinedTabs(PredefinedTab predTab) {
        _IBPredefinedTabs.add(predTab);
        this.storeAndReload();
    }

    private String validateSortCol(String colName) {
        if (!EventStorageUtils.m_columnMap.containsKey(colName)) {
            colName = "Time";
        }
        return colName;
    }

    private String validateSortDir(String sortDir) {
        if (!sortDir.equals(UP) && !sortDir.equals(DOWN)) {
            sortDir = DOWN;
        }
        return sortDir;
    }

    private void createTree() {
        m_tree = new GroupTreeObject(new TreeObject("root", null, null));
        GroupTreeObject gen = new GroupTreeObject(new TreeObject("1. General Attributes", null, _GENERAL_ATTRIBUTES));
        GroupTreeObject ib = new GroupTreeObject(new TreeObject("2. Indication Browser", null, _IB_GENERAL));
        GroupTreeObject predefViews = new GroupTreeObject(new TreeObject("Predefined Views", null, _IB_PREDEFINED_VIEWS));
        GroupTreeObject predefTabs = new GroupTreeObject(new TreeObject("Predefined Tabs", null, _IB_PREDEFINED_TABS));
        ib.addElementNoSorting(predefViews);
        ib.addElementNoSorting(predefTabs);
        GroupTreeObject wb = new GroupTreeObject(new TreeObject("3. Web Browser", null, WB_INTEGRATED));
        GroupTreeObject wb_predefTabs = new GroupTreeObject(new TreeObject("Browser Tabs", null, "WB_PREDEFINED_TABS"));
        wb.addElementNoSorting(wb_predefTabs);
        GroupTreeObject actions = new GroupTreeObject(new TreeObject("4. Actions", null, "ACTIONS"));
        m_tree.addElement(gen);
        m_tree.addElement(ib);
        m_tree.addElement(wb);
        m_tree.addElement(actions);
    }

    public GroupTreeObject getTree() {
        return m_tree;
    }

    private static void checkConfigFilePath() {
        GUIConfigFile = String.valueOf(Repository.getUserDirectory()) + File.separator + "profile.xml";
    }

    public static boolean backupSettings() {
        boolean isbkpOK = false;
        File file = UISettings.getBackupFile();
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            isbkpOK = false;
        } else {
            File fileOrig = UISettings.getSettingsFile();
            if (fileOrig.exists()) {
                if (fileOrig.length() > 0L) {
                    isbkpOK = fileOrig.renameTo(file);
                } else {
                    fileOrig.delete();
                    isbkpOK = false;
                }
            } else {
                isbkpOK = true;
            }
        }
        return isbkpOK;
    }

    public static boolean deleteBackup() {
        File file = UISettings.getBackupFile();
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static File getBackupFile() {
        File file = new File(String.valueOf(GUIConfigFile) + ".bkp");
        return file;
    }

    public static class StoreJob
    implements IRunnableExt {
        public boolean m_isOK = false;
        public AtomicBoolean m_finished = new AtomicBoolean(false);
        String m_id = "";

        public StoreJob(String id) {
            this.m_id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = GUIConfigFile;
            synchronized (string) {
                try {
                    File file = UISettings.getSettingsFile();
                    try {
                        XMLFactory.writeXml(m_doc, file);
                        this.m_isOK = true;
                        RTLogger.print(5, "UISettings stored");
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "Error writing profile: " + file.getAbsolutePath(), e);
                    }
                }
                finally {
                    this.m_finished.set(true);
                }
            }
        }

        @Override
        public boolean isFinished() {
            return this.m_finished.get();
        }

        @Override
        public void start() {
            Thread tr = new Thread(this);
            tr.setName(this.m_id);
            tr.start();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof StoreJob) {
                String id2 = ((StoreJob)obj).m_id;
                return this.m_id.equals(id2);
            }
            return false;
        }

        public int hashCode() {
            return this.m_id == null ? 0 : this.m_id.hashCode();
        }
    }
}

