/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.settings.ActionSettings;
import com.blixx.boom.gui.settings.GenAttributesSettings;
import com.blixx.boom.gui.settings.IndicationBrowserSettings;
import com.blixx.boom.gui.settings.TreeLabelProvider;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.settings.WebBrowserSettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class UISettingsDialog
extends StatusDialog
implements DisposeListener,
IDoubleClickListener,
SelectionListener {
    private GUIDisplayElements m_gui = null;
    private SashForm m_sash = null;
    private Composite m_compLeft = null;
    private ScrolledComposite m_compRight = null;
    private Composite m_compSettings = null;
    private TreeViewer m_treeViewer = null;
    private Text m_filterField = null;
    private Text m_title = null;
    private String m_currentDisplayed = null;
    private GenAttributesSettings content_GeneralAttributes = null;
    private IndicationBrowserSettings content_IndicationBrowser = null;
    private WebBrowserSettings contentWebBrowser = null;
    private ActionSettings actionSettings = null;
    public static final String FILTER = "FILTER";
    public static final String RESTORE_DEFAULTS_TXT = " Restore Defaults ";
    public static final String APPLY_TXT = " Apply ";

    public UISettingsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.setTitle(" GUI Settings");
        this.m_gui = new GUIDisplayElements();
    }

    protected Control createDialogArea(Composite parent) {
        this.m_sash = new SashForm(parent, 256);
        GridLayout gl = new GridLayout(2, false);
        this.m_sash.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 700;
        gd.heightHint = 500;
        this.m_sash.setLayoutData((Object)gd);
        this.createTree((Composite)this.m_sash);
        this.createContentArea((Composite)this.m_sash);
        this.m_sash.setWeights(new int[]{25, 75});
        this.m_filterField.setSelection(0, this.m_filterField.getText().trim().length());
        this.display_GenAttributesSettings();
        if (this.m_treeViewer != null && this.m_treeViewer.getTree() != null && this.m_treeViewer.getTree().getItemCount() > 0) {
            this.m_treeViewer.getTree().setSelection(this.m_treeViewer.getTree().getItem(0));
        }
        Label horizontalLine = new Label(parent, 266);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false));
        return parent;
    }

    private void createTree(Composite parent) {
        this.m_compLeft = new Composite(parent, 0);
        this.m_compLeft.setBackground(BMUI.color_white);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 10;
        this.m_compLeft.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, false, true);
        this.m_compLeft.setLayoutData((Object)gd);
        this.m_filterField = new Text(this.m_compLeft, 0x800800);
        gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 10;
        gd.verticalIndent = 7;
        gd.horizontalIndent = 7;
        this.m_filterField.setLayoutData((Object)gd);
        this.m_filterField.setData((Object)FILTER);
        this.m_filterField.setText("filter text ...");
        this.m_filterField.setForeground(BMUI.color_darkGrey2);
        Label horizontalLine = new Label(this.m_compLeft, 522);
        horizontalLine.setLayoutData((Object)new GridData(131072, 4, false, true, 1, 2));
        this.m_treeViewer = new STreeViewer(this.m_compLeft, 268436226);
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        gl = new GridLayout(2, false);
        gl.marginTop = 5;
        this.m_treeViewer.getTree().setLayout((Layout)gl);
        gd = new GridData(4, 4, true, true);
        this.m_treeViewer.getTree().setLayoutData((Object)gd);
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.m_treeViewer.setInput((Object)UISettings.getInstance().getTree());
        this.m_treeViewer.expandToLevel(2);
        this.m_treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        Tree tree = this.m_treeViewer.getTree();
        tree.addSelectionListener((SelectionListener)this);
    }

    private void createContentArea(Composite parent) {
        Composite compInSash = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compInSash.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false);
        compInSash.setLayoutData((Object)gd);
        Composite compHeader = new Composite(compInSash, 0);
        compHeader.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 128, true, false);
        compHeader.setLayoutData((Object)gd);
        this.m_title = this.m_gui.addTextReadOnlyNoBorder(compHeader, null, "", 1, 1, 2, 2, BMUI.font_arial9_bold);
        GridData ggd = (GridData)this.m_title.getLayoutData();
        ggd.grabExcessHorizontalSpace = true;
        ggd.horizontalAlignment = 4;
        Label horizontalLine = new Label(compInSash, 266);
        gd = new GridData(4, 128, true, false);
        horizontalLine.setLayoutData((Object)gd);
        this.m_compRight = new ScrolledComposite(compInSash, 768);
        this.m_compRight.setAlwaysShowScrollBars(false);
        this.m_compRight.setExpandHorizontal(true);
        this.m_compRight.setExpandVertical(true);
        this.m_compRight.setLayout((Layout)gl);
        this.m_compRight.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compRight.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ScrollBar sbX;
                ScrollBar sbY = UISettingsDialog.this.m_compRight.getVerticalBar();
                if (sbY != null) {
                    sbY.setPageIncrement((int)((double)((UISettingsDialog)UISettingsDialog.this).m_compRight.getSize().y * 0.8));
                    sbY.setIncrement(20);
                }
                if ((sbX = UISettingsDialog.this.m_compRight.getHorizontalBar()) != null) {
                    sbX.setPageIncrement((int)((double)((UISettingsDialog)UISettingsDialog.this).m_compRight.getSize().x * 0.8));
                    sbX.setIncrement(100);
                }
            }
        });
        this.m_compSettings = new Composite((Composite)this.m_compRight, 0);
        this.m_compSettings.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, true, true);
        this.m_compSettings.setLayoutData((Object)gd);
        this.m_compRight.setContent((Control)this.m_compSettings);
        this.m_compRight.setMinSize(this.m_compSettings.computeSize(-1, -1, true));
    }

    public void updateContentArea() {
        this.m_compSettings.layout(true);
        this.m_compRight.setContent((Control)this.m_compSettings);
        this.m_compRight.setMinSize(this.m_compSettings.computeSize(-1, -1, true));
    }

    private void display_GenAttributesSettings() {
        if (this.m_currentDisplayed != null && this.m_currentDisplayed.equals("GENERAL_ATTRIBUTES")) {
            return;
        }
        this.m_title.setText("General Attributes");
        this.clearComposite();
        if (this.content_GeneralAttributes == null) {
            this.content_GeneralAttributes = new GenAttributesSettings(this, this.m_compSettings);
        }
        this.content_GeneralAttributes.createSection(this.m_compSettings);
        this.m_currentDisplayed = "GENERAL_ATTRIBUTES";
    }

    private void display_IBGeneralSettings() {
        if (this.m_currentDisplayed != null && this.m_currentDisplayed.equals("GENERAL")) {
            return;
        }
        this.m_title.setText("Indication Browser");
        this.clearComposite();
        if (this.content_IndicationBrowser == null) {
            this.content_IndicationBrowser = new IndicationBrowserSettings(this, this.m_compSettings);
        }
        this.content_IndicationBrowser.createGeneralSection(this.m_compSettings);
        this.m_currentDisplayed = "GENERAL";
    }

    private void display_IBPredefinedViewsSettings() {
        if (this.m_currentDisplayed != null && this.m_currentDisplayed.equals("PREDEFINED_VIEWS")) {
            return;
        }
        this.m_title.setText("Predefined Views");
        this.clearComposite();
        if (this.content_IndicationBrowser == null) {
            this.content_IndicationBrowser = new IndicationBrowserSettings(this, this.m_compSettings);
        }
        this.content_IndicationBrowser.createPredefinedViewSection(this.m_compSettings);
        this.m_currentDisplayed = "PREDEFINED_VIEWS";
    }

    private void display_IBPredefinedTabsSettings() {
        if (this.m_currentDisplayed != null && this.m_currentDisplayed.equals("PREDEFINED_TABS")) {
            return;
        }
        this.m_title.setText("Predefined Tabs");
        this.clearComposite();
        if (this.content_IndicationBrowser == null) {
            this.content_IndicationBrowser = new IndicationBrowserSettings(this, this.m_compSettings);
        }
        this.content_IndicationBrowser.createPredefinedTabSection(this.m_compSettings);
        this.m_currentDisplayed = "PREDEFINED_TABS";
    }

    private void display_WBGeneralSettings() {
        if (this.m_currentDisplayed != null && this.m_currentDisplayed.equals("WB_INTEGRATED")) {
            return;
        }
        this.m_title.setText("Web Browser");
        this.clearComposite();
        if (this.contentWebBrowser == null) {
            this.contentWebBrowser = new WebBrowserSettings(this.m_compSettings);
        }
        this.contentWebBrowser.createGeneralSection(this.m_compSettings);
        this.m_currentDisplayed = "WB_INTEGRATED";
    }

    private void display_WBPredefinedTabsSettings(String type) {
        if (this.m_currentDisplayed != null && this.m_currentDisplayed.equals(type)) {
            return;
        }
        this.m_title.setText("Web Browser Tabs");
        this.clearComposite();
        if (this.contentWebBrowser == null) {
            this.contentWebBrowser = new WebBrowserSettings(this.m_compSettings);
        }
        this.contentWebBrowser.createWBPredefinedTabSection(this.m_compSettings);
        this.m_currentDisplayed = type;
    }

    private void display_ActionSettings() {
        if (this.m_currentDisplayed != null && this.m_currentDisplayed.equals("ACTIONS")) {
            return;
        }
        this.m_title.setText("Actions");
        this.clearComposite();
        if (this.actionSettings == null) {
            this.actionSettings = new ActionSettings();
        }
        this.actionSettings.createSection(this.m_compSettings);
        this.m_currentDisplayed = "ACTIONS";
    }

    private void clearComposite() {
        if (this.m_compSettings == null || this.m_compSettings.isDisposed()) {
            return;
        }
        Control[] controls = this.m_compSettings.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        this.m_compRight.setMinSize(this.m_compSettings.computeSize(-1, -1, true));
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    protected Control createButtonBar(Composite parent) {
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Composite comp = (Composite)super.createButtonBar(parent);
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(131072, 4, false, false));
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", false);
        this.getButton(0).setFocus();
        this.createButton(parent, 1, "Cancel", false);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 12;
        gl.marginRight = 8;
        parent.setLayout((Layout)gl);
        parent.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            UISettings.getInstance().storeAndReload();
            super.okPressed();
        } else if (buttonId == 1) {
            UISettings.getInstance().reload();
            super.cancelPressed();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_sash.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void doubleClick(DoubleClickEvent event) {
        Object obj;
        IStructuredSelection ssel = (IStructuredSelection)event.getViewer().getSelection();
        if (ssel.size() == 1 && !((obj = ssel.getFirstElement()) instanceof GroupTreeObjectLast) && obj instanceof GroupTreeObject) {
            this.m_treeViewer.setExpandedState((Object)((GroupTreeObject)obj), !this.m_treeViewer.getExpandedState(obj));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        block26: {
            String type;
            GroupTreeObject gto;
            Object obj;
            Object source = e.getSource();
            if (!(source instanceof Tree)) break block26;
            StructuredSelection ssel = (StructuredSelection)this.m_treeViewer.getSelection();
            if (ssel.isEmpty() || ssel.size() > 1) {
                return;
            }
            Object o = ssel.getFirstElement();
            if (!(o instanceof GroupTreeObject) || (obj = (gto = (GroupTreeObject)o).getTreeObject().getObject()) == null || !(obj instanceof String)) break block26;
            switch (type = (String)obj) {
                case "GENERAL_ATTRIBUTES": {
                    this.display_GenAttributesSettings();
                    break;
                }
                case "GENERAL": {
                    this.display_IBGeneralSettings();
                    break;
                }
                case "PREDEFINED_VIEWS": {
                    this.display_IBPredefinedViewsSettings();
                    break;
                }
                case "PREDEFINED_TABS": {
                    this.display_IBPredefinedTabsSettings();
                    break;
                }
                case "WB_INTEGRATED": {
                    this.display_WBGeneralSettings();
                    break;
                }
                case "WB_PREDEFINED_TABS": {
                    this.display_WBPredefinedTabsSettings(type);
                    break;
                }
                case "ACTIONS": {
                    this.display_ActionSettings();
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

