/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.settings;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class WebBrowserSettings
implements SelectionListener {
    private Shell m_parentShell = null;
    private GUIDisplayElements m_gui = null;
    private Button m_btn_apply = null;
    private static String BTN_APPLY = "BTN_APPLY";
    private Button m_useIntegratedWB_radio = null;
    private Button m_useExternalWB_radio = null;
    private static String USE_INTEGRATED_WB = "USE_INTEGRATED_WB";
    private static String USE_EXTERNAL_WB = "USE_EXTERNAL_WB";
    private Table m_tbl_PT = null;
    private Button m_btn_up = null;
    private Button m_btn_down = null;
    private Button m_btn_add = null;
    private Button m_btn_delete = null;
    private Button m_btn_edit = null;
    private Button m_btn_restore_WB = null;
    private static String TABLE_BT = "TABLE_BT";
    private static String POSITION = "Position";
    private static String OBJECT = "OBJECT";
    private static String BTN_UP = "BTN_UP";
    private static String BTN_DOWN = "BTN_DOWN";
    private static String BTN_ADD_PT = "BTN_ADD_PT";
    private static String BTN_DELETE_PT = "BTN_DELETE_PT";
    private static String BTN_EDIT_PT = "BTN_EDIT_PT";
    private static String BTN_RESTORE_WB = "BTN_RESTORE_WB";
    private Map<String, Object> m_WebBrowserSettings = null;
    private List<String[]> m_predefinedTabs = null;

    public WebBrowserSettings(Composite parent) {
        this.m_parentShell = parent.getShell();
        this.m_gui = new GUIDisplayElements();
    }

    public void createGeneralSection(Composite parent) {
        this.m_WebBrowserSettings = UISettings.getInstance().getWebBrowserSettings();
        Group grp_colSettings = new Group(parent, 4);
        grp_colSettings.setText("Open a URL");
        grp_colSettings.setLayout((Layout)new GridLayout(2, false));
        grp_colSettings.setLayoutData((Object)new GridData(4, 4, true, false));
        boolean wbIntegrated = Boolean.parseBoolean("" + this.m_WebBrowserSettings.get("WB_INTEGRATED"));
        this.m_useIntegratedWB_radio = this.m_gui.addRadioButton((Composite)grp_colSettings, USE_INTEGRATED_WB, "Use the integrated WebBrowser", wbIntegrated, 1, 1, 0, 0, this);
        this.m_useExternalWB_radio = this.m_gui.addRadioButton((Composite)grp_colSettings, USE_EXTERNAL_WB, "Use an external WebBrowser", !wbIntegrated, 1, 1, 0, 0, this);
        Composite compBtn2 = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compBtn2.setLayout((Layout)gl);
        compBtn2.setLayoutData((Object)new GridData(131072, 1024, true, true));
        this.m_btn_restore_WB = this.m_gui.addButton(compBtn2, BTN_RESTORE_WB, " Restore Defaults ", true, 80, 60, 0, this);
        this.m_btn_restore_WB.setToolTipText("Restore Defaults");
        this.m_btn_restore_WB.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.m_btn_apply = this.m_gui.addButton(compBtn2, BTN_APPLY, " Apply ", true, 80, 60, 0, this);
        this.m_btn_apply.setToolTipText("Apply Changes");
        this.m_btn_apply.setLayoutData((Object)new GridData(4, 1024, false, false));
        parent.layout(true);
    }

    public void createWBPredefinedTabSection(Composite parent) {
        this.m_WebBrowserSettings = UISettings.getInstance().getWebBrowserSettings();
        this.m_predefinedTabs = (List)this.m_WebBrowserSettings.get("WB_PREDEFINED_TABS");
        if (this.m_predefinedTabs == null) {
            this.m_predefinedTabs = new ArrayList<String[]>();
            this.m_WebBrowserSettings.put("WB_PREDEFINED_TABS", this.m_predefinedTabs);
        }
        Composite compTbl = new Composite(parent, 0);
        compTbl.setLayout((Layout)new GridLayout(2, false));
        compTbl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tbl_PT = new Table(compTbl, 0x10010B00);
        this.m_tbl_PT.setData((Object)TABLE_BT);
        this.m_tbl_PT.setHeaderVisible(true);
        this.m_tbl_PT.setLinesVisible(true);
        this.m_tbl_PT.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.m_tbl_PT.addSelectionListener((SelectionListener)this);
        TableColumn col0 = new TableColumn(this.m_tbl_PT, 131072);
        col0.setText("Position");
        col0.setWidth(60);
        col0.setToolTipText("Position");
        TableColumn col1 = new TableColumn(this.m_tbl_PT, 16384);
        col1.setText("URL / Web Addresss");
        col1.setWidth(340);
        col1.setToolTipText("URL");
        HashMap<String, String[]> tmpMap = new HashMap<String, String[]>();
        if (this.m_predefinedTabs != null && this.m_predefinedTabs.size() > 0) {
            Iterator<String[]> it = this.m_predefinedTabs.iterator();
            while (it.hasNext()) {
                String[] tab = it.next();
                if (tab == null) {
                    it.remove();
                    continue;
                }
                String pos = tab[0];
                tmpMap.put(pos, tab);
            }
            ArrayList list = new ArrayList();
            list.addAll(tmpMap.keySet());
            Collections.sort(list);
            int i = 0;
            while (i < list.size()) {
                String pos = (String)list.get(i);
                String[] tab = (String[])tmpMap.get(pos);
                String url = tab[1];
                TableItem item = new TableItem(this.m_tbl_PT, 0);
                item.setText(new String[]{"" + (i + 1), url});
                item.setData(POSITION, (Object)i);
                item.setData(OBJECT, (Object)tab);
                ++i;
            }
        }
        if (this.m_tbl_PT.getItemCount() > 0) {
            this.m_tbl_PT.setSelection(0);
        }
        this.m_btn_up = this.m_gui.addButton(compTbl, BTN_UP, "Up", true, 80, 60, 0, this);
        this.m_btn_up.setToolTipText("Move one line up");
        this.m_btn_up.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_down = this.m_gui.addButton(compTbl, BTN_DOWN, "Down", true, 80, 60, 0, this);
        this.m_btn_down.setToolTipText("Move one line down");
        this.m_btn_down.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_add = this.m_gui.addButton(compTbl, BTN_ADD_PT, "Add", true, 80, 60, 0, this);
        this.m_btn_add.setToolTipText("Add Tab");
        GridData gd = new GridData(4, 128, false, false);
        gd.widthHint = 80;
        this.m_btn_add.setLayoutData((Object)gd);
        this.m_btn_delete = this.m_gui.addButton(compTbl, BTN_DELETE_PT, " Remove ", true, 80, 60, 0, this);
        this.m_btn_delete.setToolTipText("Remove Tab");
        this.m_btn_delete.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_btn_edit = this.m_gui.addButton(compTbl, BTN_EDIT_PT, "Edit...", false, 80, 60, 0, this);
        this.m_btn_edit.setToolTipText("Edit Tab");
        this.m_btn_edit.setLayoutData((Object)new GridData(4, 128, false, false));
        Composite compBtn = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 20;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(131072, 1024, true, false));
        Button btn = this.m_gui.addButton(compBtn, "", " Restore Defaults ", true, 120, 60, 0, this);
        btn.setLayoutData((Object)new GridData(4, 1024, false, false));
        btn.setVisible(false);
        this.m_btn_apply = this.m_gui.addButton(compBtn, BTN_APPLY, " Apply ", true, 120, 60, 0, this);
        this.m_btn_apply.setToolTipText("Apply Changes");
        this.m_btn_apply.setLayoutData((Object)new GridData(4, 1024, false, false));
        parent.layout(true);
        this.checkBtnStatus();
    }

    public void moveTableItemUp() {
        if (this.m_tbl_PT == null || this.m_tbl_PT.isDisposed() || this.m_tbl_PT.getItemCount() < 1) {
            return;
        }
        int selIndex = this.m_tbl_PT.getSelectionIndex();
        if (selIndex == 0) {
            return;
        }
        int newIndex = selIndex - 1;
        TableItem ti1 = this.m_tbl_PT.getItem(selIndex);
        String[] tab1 = (String[])ti1.getData(OBJECT);
        tab1[0] = "" + newIndex;
        ti1.setData(OBJECT, (Object)tab1);
        ti1.setData(POSITION, (Object)newIndex);
        ti1.setText(tab1);
        TableItem ti2 = this.m_tbl_PT.getItem(newIndex);
        String[] tab2 = (String[])ti2.getData(OBJECT);
        tab2[0] = "" + selIndex;
        ti2.setData(OBJECT, (Object)tab2);
        ti2.setData(POSITION, (Object)selIndex);
        ti2.setText(tab2);
        this.refreshTable();
        this.m_tbl_PT.setSelection(newIndex);
        this.checkBtnStatus();
    }

    public void moveTableItemDown() {
        if (this.m_tbl_PT == null || this.m_tbl_PT.isDisposed() || this.m_tbl_PT.getItemCount() < 1) {
            return;
        }
        int selIndex = this.m_tbl_PT.getSelectionIndex();
        if (selIndex == this.m_tbl_PT.getItemCount() - 1) {
            return;
        }
        int newIndex = selIndex + 1;
        TableItem ti1 = this.m_tbl_PT.getItem(selIndex);
        String[] tab1 = (String[])ti1.getData(OBJECT);
        tab1[0] = "" + newIndex;
        ti1.setData(OBJECT, (Object)tab1);
        ti1.setData(POSITION, (Object)newIndex);
        ti1.setText(tab1);
        TableItem ti2 = this.m_tbl_PT.getItem(newIndex);
        String[] tab2 = (String[])ti2.getData(OBJECT);
        tab2[0] = "" + selIndex;
        ti2.setData(OBJECT, (Object)tab2);
        ti2.setData(POSITION, (Object)selIndex);
        ti2.setText(tab2);
        this.refreshTable();
        this.m_tbl_PT.setSelection(newIndex);
        this.checkBtnStatus();
    }

    public void editTableItem() {
        if (this.m_tbl_PT == null || this.m_tbl_PT.isDisposed() || this.m_tbl_PT.getSelectionCount() == 0) {
            return;
        }
        TableItem[] sel = this.m_tbl_PT.getSelection();
        TableItem seletedItem = sel[0];
        Object o = seletedItem.getData(OBJECT);
        if (o instanceof String[]) {
            String[] selTab = (String[])o;
            int pos = -1;
            try {
                pos = Integer.parseInt(selTab[0]);
            }
            catch (NumberFormatException numberFormatException) {}
            String url = selTab[1];
            DialogEditTablePT_WB dialog = new DialogEditTablePT_WB(this.m_parentShell, pos + 1, url, false);
            dialog.setBlockOnOpen(true);
            int value = dialog.open();
            if (value == 0) {
                selTab[1] = dialog.getURL();
                seletedItem.setText(selTab);
                seletedItem.setData(OBJECT, (Object)selTab);
                this.m_tbl_PT.update();
            }
        }
        this.checkBtnStatus();
    }

    public void addTableItem() {
        if (this.m_tbl_PT == null || this.m_tbl_PT.isDisposed()) {
            return;
        }
        String tableType = (String)this.m_tbl_PT.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        int newPosition = this.m_tbl_PT.getItemCount() + 1;
        DialogEditTablePT_WB dialog = new DialogEditTablePT_WB(this.m_parentShell, newPosition, "", true);
        dialog.setBlockOnOpen(true);
        int value = dialog.open();
        if (value == 0) {
            String[] newTab = new String[]{"" + newPosition, dialog.getURL()};
            if (this.m_predefinedTabs != null) {
                this.m_predefinedTabs.add(newTab);
            }
            int lineIndex = this.m_tbl_PT.getItemCount();
            TableItem item = new TableItem(this.m_tbl_PT, 0, lineIndex);
            item.setText(newTab);
            item.setData(POSITION, (Object)lineIndex);
            item.setData(OBJECT, (Object)newTab);
            this.m_tbl_PT.update();
            this.m_tbl_PT.setSelection(lineIndex);
        }
        this.checkBtnStatus();
    }

    private void deleteTableItem() {
        if (this.m_tbl_PT == null || this.m_tbl_PT.isDisposed()) {
            return;
        }
        String tableType = (String)this.m_tbl_PT.getData();
        if (tableType == null || tableType.length() == 0) {
            return;
        }
        int selIndex = this.m_tbl_PT.getSelectionIndex();
        if (selIndex > -1) {
            this.m_tbl_PT.remove(selIndex);
            if (selIndex >= this.m_tbl_PT.getItemCount()) {
                selIndex = this.m_tbl_PT.getItemCount() - 1;
            }
            this.m_tbl_PT.setSelection(selIndex);
            if (this.m_predefinedTabs != null) {
                this.m_predefinedTabs.clear();
                TableItem[] items = this.m_tbl_PT.getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem ti = items[i];
                    String[] tab = (String[])ti.getData(OBJECT);
                    if (tab != null) {
                        this.m_predefinedTabs.add(tab);
                    }
                    ++i;
                }
            }
        }
        this.checkBtnStatus();
    }

    public void refreshTable() {
        if (this.m_tbl_PT == null || this.m_tbl_PT.isDisposed()) {
            return;
        }
        this.m_tbl_PT.removeAll();
        HashMap<String, String[]> tmpMap = new HashMap<String, String[]>();
        if (this.m_predefinedTabs != null && this.m_predefinedTabs.size() > 0) {
            Iterator<String[]> it = this.m_predefinedTabs.iterator();
            while (it.hasNext()) {
                String[] tab = it.next();
                if (tab == null) {
                    it.remove();
                    continue;
                }
                String pos = tab[0];
                tmpMap.put(pos, tab);
            }
            ArrayList list = new ArrayList();
            list.addAll(tmpMap.keySet());
            Collections.sort(list);
            int i = 0;
            while (i < list.size()) {
                String pos = (String)list.get(i);
                String[] tab = (String[])tmpMap.get(pos);
                String url = tab[1];
                TableItem item = new TableItem(this.m_tbl_PT, 0);
                item.setText(new String[]{"" + (i + 1), url});
                item.setData(POSITION, (Object)i);
                item.setData(OBJECT, (Object)tab);
                ++i;
            }
        }
    }

    public void checkBtnStatus() {
        int selIndex = this.m_tbl_PT.getSelectionIndex();
        if (selIndex == -1) {
            this.m_gui.enableField(this.m_btn_edit, false);
            this.m_gui.enableField(this.m_btn_delete, false);
            this.m_gui.enableField(this.m_btn_up, false);
            this.m_gui.enableField(this.m_btn_down, false);
        } else {
            this.m_gui.enableField(this.m_btn_edit, true);
            this.m_gui.enableField(this.m_btn_delete, true);
            if (selIndex == 0) {
                this.m_gui.enableField(this.m_btn_up, false);
                this.m_gui.enableField(this.m_btn_down, true);
            } else if (selIndex == this.m_tbl_PT.getItemCount() - 1) {
                this.m_gui.enableField(this.m_btn_up, true);
                this.m_gui.enableField(this.m_btn_down, false);
            } else {
                this.m_gui.enableField(this.m_btn_up, true);
                this.m_gui.enableField(this.m_btn_down, true);
            }
        }
    }

    public void restoreDefaults(Object object) {
        this.m_useIntegratedWB_radio.setSelection(true);
        this.m_useExternalWB_radio.setSelection(false);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            Button chkBox = (Button)o;
            String type = (String)chkBox.getData();
            if (type == null) {
                return;
            }
            if (type.equals(USE_INTEGRATED_WB)) {
                this.m_WebBrowserSettings.put("WB_INTEGRATED", "" + chkBox.getSelection());
            } else if (!type.equals(USE_EXTERNAL_WB)) {
                if (type.equals(BTN_RESTORE_WB)) {
                    this.restoreDefaults(type);
                } else if (type.equals(BTN_UP)) {
                    this.moveTableItemUp();
                } else if (type.equals(BTN_DOWN)) {
                    this.moveTableItemDown();
                } else if (type.equals(BTN_APPLY)) {
                    UISettings.getInstance().storeAndReload();
                } else if (type.equals(BTN_EDIT_PT)) {
                    this.editTableItem();
                } else if (type.equals(BTN_ADD_PT)) {
                    this.addTableItem();
                } else if (type.equals(BTN_DELETE_PT)) {
                    this.deleteTableItem();
                }
            }
        } else if (o instanceof Table) {
            Table tbl = (Table)o;
            String tableType = (String)tbl.getData();
            if (tableType == null) {
                return;
            }
            this.checkBtnStatus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Table) {
            this.editTableItem();
        }
    }

    public class DialogEditTablePT_WB
    extends StatusDialog
    implements DisposeListener,
    ModifyListener {
        private Composite m_comp;
        private int m_pos;
        private String m_url;
        private String URL;

        public DialogEditTablePT_WB(Shell parentShell, int position, String url, boolean isNew) {
            super(parentShell);
            this.m_comp = null;
            this.m_pos = -1;
            this.m_url = "";
            this.URL = "URL";
            this.setShellStyle(this.getShellStyle() | 0x10);
            if (isNew) {
                this.setTitle(" Add Browser Tab");
            } else {
                this.setTitle(" Edit Browser Tab");
            }
            this.m_pos = position;
            this.m_url = url;
        }

        protected Control createDialogArea(Composite parent) {
            GUIDisplayElements gui = new GUIDisplayElements();
            this.m_comp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.horizontalSpacing = 10;
            gl.marginTop = 5;
            gl.marginLeft = 5;
            gl.marginRight = 5;
            this.m_comp.setLayout((Layout)gl);
            this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_comp.addDisposeListener((DisposeListener)this);
            gui.addTextReadOnlyNoBorder(this.m_comp, "Position:", "" + this.m_pos, 1, 1, 0, 0, BMUI.font_arial8_bold);
            gui.addInputFieldSingle(this.m_comp, this.URL, "Url: ", this.m_url, 1, 1, 0, 0, 300, this);
            return parent;
        }

        public String[] getPredefinedTab() {
            String[] predTab = new String[]{this.m_url, "" + this.m_pos};
            return predTab;
        }

        public String getURL() {
            return this.m_url;
        }

        public void widgetDisposed(DisposeEvent e) {
            try {
                this.m_comp.dispose();
            }
            catch (Throwable throwable) {}
        }

        public void modifyText(ModifyEvent event) {
            Object o = event.getSource();
            if (o instanceof Text) {
                Text t = (Text)o;
                String name = (String)t.getData();
                if (name.equals(this.URL)) {
                    this.m_url = t.getText().trim();
                }
                this.checkApplyButtonStatus();
            }
        }

        protected Control createButtonBar(Composite parent) {
            Composite comp = (Composite)super.createButtonBar(parent);
            return comp;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Apply", true);
            Button ok = this.getButton(0);
            ok.setEnabled(false);
            this.createButton(parent, 1, "Cancel", false);
            Button cancel = this.getButton(1);
            cancel.setFocus();
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                super.okPressed();
            } else if (buttonId == 1) {
                super.cancelPressed();
            }
            super.close();
        }

        private void checkApplyButtonStatus() {
            if (this.m_url.length() > 0) {
                this.getButton(0).setEnabled(true);
            } else {
                this.getButton(0).setEnabled(false);
            }
        }
    }
}

