/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ActionTreeFilter
extends ViewerFilter {
    List<GroupTreeObjectLast> m_elements = null;
    WeakHashMap<GroupTreeObject, Object> m_cache = new WeakHashMap();
    public static String DISPLAY_AGENT_ACTIONS = "DISPLAY_AGENT_ACTIONS";
    public static String DISPLAY_SERVER_ACTIONS = "DISPLAY_SERVER_ACTIONS";
    public static String DISPLAY_ALL_ACTIONS = "DISPLAY_ALL_ACTIONS";
    private String m_type = DISPLAY_ALL_ACTIONS;

    public ActionTreeFilter(String type) {
        this.m_elements = new ArrayList<GroupTreeObjectLast>();
        if (type != null && type.length() > 0) {
            this.m_type = type;
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
            boolean isServerAction = false;
            try {
                Object o = gtol.getTreeObject().getObject();
                if (o != null && o instanceof Action) {
                    isServerAction = ((Action)o).m_serverAction;
                }
            }
            catch (Throwable throwable) {}
            if (DISPLAY_AGENT_ACTIONS.equals(this.m_type)) {
                if (!isServerAction) {
                    this.m_elements.add((GroupTreeObjectLast)element);
                    return true;
                }
            } else if (DISPLAY_SERVER_ACTIONS.equals(this.m_type)) {
                if (isServerAction) {
                    this.m_elements.add((GroupTreeObjectLast)element);
                    return true;
                }
            } else {
                this.m_elements.add((GroupTreeObjectLast)element);
                return true;
            }
            return false;
        }
        if (this.m_cache.containsKey(element)) {
            return true;
        }
        GroupTreeObject gto = (GroupTreeObject)element;
        if (gto.getParent() != null && gto.getParent().getName().equals("root")) {
            this.m_cache.put(gto, "");
            return true;
        }
        for (GroupTreeObject child : gto.getElements()) {
            boolean hasChildMatched = this.select(viewer, gto, child);
            if (!hasChildMatched) continue;
            this.m_cache.put(gto, "");
            return true;
        }
        return false;
    }

    public List<GroupTreeObjectLast> getFilteredElements() {
        return this.m_elements;
    }

    public Collection<GroupTreeObject> getFilteredFolders() {
        return this.m_cache.keySet();
    }
}

