/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.AgentOverviewTab;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AgentOverview_FilterOnComposite
implements MouseListener,
SelectionListener {
    private AgentOverviewTab m_agtOverviewTab = null;
    private Composite m_parent = null;
    private Composite m_mainComp = null;
    private Text m_searchText = null;
    private Label m_searchIcon = null;
    private Button m_name_chk = null;
    private Button m_ip_chk = null;
    private Button m_host_chk = null;
    private Button m_agentID_chk = null;
    private Button m_BOOMSever_chk = null;
    private static String LABEL = "Label";
    private static String IP = "IP";
    private static String HOST = "Host";
    private static String AGENT_ID = "AgentID";
    private static String BOOMServer = "BOOMServer";
    protected static final String APPLY_FILTER = "APPLY_FILTER";
    protected static final String REMOVE_FILTER = "REMOVE_FILTER";

    public AgentOverview_FilterOnComposite(Composite parent, AgentOverviewTab agtOverviewTab) {
        this.m_parent = parent;
        this.m_agtOverviewTab = agtOverviewTab;
        this.createComposite();
    }

    public void createComposite() {
        GUIDisplayElements gui = new GUIDisplayElements();
        this.m_mainComp = new Composite(this.m_parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite chk_comp = new Composite(this.m_mainComp, 0);
        gl = new GridLayout(5, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 5;
        chk_comp.setLayout((Layout)gl);
        chk_comp.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.m_name_chk = gui.addCheckbox(chk_comp, LABEL, LABEL, true, 1, 1, 1, this);
        this.m_ip_chk = gui.addCheckbox(chk_comp, IP, IP, true, 1, 1, 1, this);
        this.m_host_chk = gui.addCheckbox(chk_comp, HOST, HOST, true, 1, 1, 1, this);
        this.m_agentID_chk = gui.addCheckbox(chk_comp, AGENT_ID, AGENT_ID, true, 1, 1, 1, this);
        this.m_BOOMSever_chk = gui.addCheckbox(chk_comp, BOOMServer, BOOMServer, true, 1, 1, 1, this);
        Composite filter_comp = new Composite(this.m_mainComp, 0);
        gl = new GridLayout(4, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        filter_comp.setLayout((Layout)gl);
        filter_comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_searchIcon = new Label(filter_comp, 0);
        this.m_searchIcon.setImage(BMUI.IMAGE_FILTERED_14x14);
        this.m_searchIcon.setEnabled(false);
        this.m_searchText = new Text(filter_comp, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 10;
        this.m_searchText.setLayoutData((Object)gd);
        gui.addDefaultTextContentMenu(this.m_searchText, true);
        this.m_searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof Text && (e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 0x1000050)) {
                    AgentOverview_FilterOnComposite.this.applyFilter();
                }
            }
        });
        Label runFilterIcon = new Label(filter_comp, 0);
        runFilterIcon.setImage(BMUI.IMAGE_RUN);
        runFilterIcon.setData((Object)APPLY_FILTER);
        runFilterIcon.addMouseListener((MouseListener)this);
        Label delFilterIcon = new Label(filter_comp, 0);
        delFilterIcon.setImage(BMUI.IMAGE_DEL_14x14);
        delFilterIcon.setData((Object)REMOVE_FILTER);
        delFilterIcon.addMouseListener((MouseListener)this);
    }

    public void setCompositeLayoutData(GridData gridData) {
        this.m_mainComp.setLayoutData((Object)gridData);
        this.m_mainComp.layout(true);
    }

    public void setTextMinWidth(int minWidth) {
        ((GridData)this.m_searchText.getLayoutData()).minimumWidth = minWidth;
    }

    public void setFilter(String text) {
        try {
            this.m_searchText.setText(text);
        }
        catch (Throwable throwable) {}
    }

    public String getFilter() {
        try {
            return this.m_searchText.getText();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void applyFilter() {
        if (this.m_searchText.getText().trim().length() > 0) {
            this.setFilter();
        } else {
            this.removeFilter();
        }
    }

    public void setFilter() {
        String searchText_trimmed = this.m_searchText.getText().trim();
        this.activateSearchIcon(true);
        if (this.m_searchText.getText().length() > searchText_trimmed.length()) {
            this.m_searchText.setText(searchText_trimmed);
        }
        this.m_agtOverviewTab.filterTable(searchText_trimmed, this.m_name_chk.getSelection(), this.m_ip_chk.getSelection(), this.m_host_chk.getSelection(), this.m_agentID_chk.getSelection(), this.m_BOOMSever_chk.getSelection());
    }

    public void removeFilter() {
        this.activateSearchIcon(false);
        this.clearSearchText();
        this.m_agtOverviewTab.filterTable(null, false, false, false, false, false);
    }

    public void clearSearchText() {
        if (this.m_searchText.getText().length() > 0) {
            this.m_searchText.setText("");
        }
    }

    public void setSearchText(String text) {
        if (text != null && text.length() > 0) {
            this.m_searchText.setText(text);
        }
    }

    public void activateSearchIcon(boolean activate) {
        this.m_searchIcon.setEnabled(activate);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof Label) {
            Label l = (Label)o;
            String name = (String)l.getData();
            if (APPLY_FILTER.equals(name)) {
                this.applyFilter();
            } else if (REMOVE_FILTER.equals(name)) {
                this.removeFilter();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            Button chk = (Button)o;
            if (!(this.m_name_chk.getSelection() || this.m_ip_chk.getSelection() || this.m_host_chk.getSelection() || this.m_agentID_chk.getSelection() || this.m_BOOMSever_chk.getSelection())) {
                chk.setSelection(true);
            }
        }
    }
}

