/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.AgentCard;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class AgentTableFilter
extends ViewerFilter {
    private String m_searchText = null;
    private boolean m_byLabel = true;
    private boolean m_byIP = true;
    private boolean m_byHost = true;
    private boolean m_byAgentID = true;
    private boolean m_byBOOMServer = true;
    private Pattern m_pattern = null;

    public AgentTableFilter(String text, boolean byName, boolean byIP, boolean byHost, boolean byAgentID, boolean byBOOMServer) {
        this.m_searchText = text.toLowerCase();
        if (this.m_searchText.contains("*")) {
            try {
                this.m_pattern = Pattern.compile(this.m_searchText.replace("*", ".*"));
            }
            catch (Throwable throwable) {}
        }
        this.m_byLabel = byName;
        this.m_byIP = byIP;
        this.m_byHost = byHost;
        this.m_byAgentID = byAgentID;
        this.m_byBOOMServer = byBOOMServer;
    }

    public boolean select(Viewer arg0, Object arg1, Object arg2) {
        AgentCard ac = (AgentCard)arg2;
        if (ac == null) {
            return false;
        }
        boolean isVisible = false;
        if (this.m_pattern != null) {
            Matcher m;
            if (this.m_byLabel && ac.getComparableName() != null && (m = this.m_pattern.matcher(ac.getComparableName().toLowerCase())).find()) {
                return true;
            }
            if (this.m_byIP && ac.getAgentIP() != null && (m = this.m_pattern.matcher(ac.getAgentIP().toLowerCase())).find()) {
                return true;
            }
            if (this.m_byHost && ac.getAgentHost() != null && (m = this.m_pattern.matcher(ac.getAgentHost().toLowerCase())).find()) {
                return true;
            }
            if (this.m_byAgentID && ac.getAgentID() != null && (m = this.m_pattern.matcher(ac.getAgentID().toLowerCase())).find()) {
                return true;
            }
            if (this.m_byBOOMServer && ac.getRelatedServer() != null && (m = this.m_pattern.matcher(ac.getRelatedServer().toLowerCase())).find()) {
                return true;
            }
        } else if (this.m_searchText != null && this.m_searchText.length() > 0 && (this.m_byLabel && ac.getComparableName() != null && ac.getComparableName().trim().toLowerCase().contains(this.m_searchText) || this.m_byIP && ac.getAgentIP() != null && ac.getAgentIP().contains(this.m_searchText) || this.m_byHost && ac.getAgentHost() != null && ac.getAgentHost().toLowerCase().contains(this.m_searchText) || this.m_byAgentID && ac.getAgentID() != null && ac.getAgentID().toLowerCase().contains(this.m_searchText) || this.m_byBOOMServer && ac.getRelatedServer() != null && ac.getRelatedServer().toLowerCase().contains(this.m_searchText))) {
            isVisible = true;
        }
        return isVisible;
    }
}

