/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.gui.views.AgentOverviewTableProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class AgentTableFilterOnStatus
extends ViewerFilter {
    public static final int ALL = 0;
    public static final int ONLINE = 1;
    public static final int OFFLINE = 2;
    public static final int DISABLED = 3;
    public static final int MAINTENANCED = 4;
    public static final int NOTAPPROVED = 5;
    public static final int FIREWALLED = 6;
    public static final int NOT_FIREWALLED = 7;
    public int m_mode = 0;

    public AgentTableFilterOnStatus(int status) {
        this.m_mode = status;
    }

    public boolean select(Viewer arg0, Object arg1, Object arg2) {
        AgentCard ac = (AgentCard)arg2;
        if (ac == null) {
            return false;
        }
        boolean isVisible = false;
        switch (this.m_mode) {
            case 0: {
                isVisible = true;
                break;
            }
            case 1: {
                isVisible = AgentOverviewTableProvider.isAgentOnline(ac) && ac.isApproved();
                break;
            }
            case 2: {
                isVisible = !AgentOverviewTableProvider.isAgentOnline(ac) && ac.isApproved();
                break;
            }
            case 3: {
                isVisible = ac.isDisabled();
                break;
            }
            case 4: {
                isVisible = ac.getAgentOutage();
                break;
            }
            case 5: {
                isVisible = !ac.isApproved();
                break;
            }
            case 6: {
                isVisible = ac.isFirewalled() && ac.isApproved();
                break;
            }
            case 7: {
                isVisible = !ac.isFirewalled() && ac.isApproved();
                break;
            }
            default: {
                isVisible = true;
            }
        }
        return isVisible;
    }
}

