/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.AgentCard;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class AgentTreeFilter
extends ViewerFilter {
    String m_text = null;
    Pattern m_pattern = null;
    List<String> m_textList = null;
    List<GroupTreeObjectLast> m_elements = null;
    WeakHashMap<GroupTreeObject, Object> m_cache = new WeakHashMap();

    public AgentTreeFilter(String text) {
        this.m_elements = new ArrayList<GroupTreeObjectLast>();
        if (text != null && text.length() > 0) {
            this.m_text = text.toLowerCase();
            if (this.m_text.contains("*")) {
                try {
                    this.m_pattern = Pattern.compile(this.m_text.replace("*", ".*"));
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public AgentTreeFilter(List<String> textList) {
        this.m_elements = new ArrayList<GroupTreeObjectLast>();
        if (textList != null) {
            this.m_textList = new ArrayList<String>(textList);
            for (String filter : textList) {
                this.m_textList.add(filter.toLowerCase());
            }
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.m_pattern == null && this.m_text == null && this.m_textList == null) {
            return true;
        }
        if (element instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
            Object obj = gtol.getTreeObject().getObject();
            if (obj != null && obj instanceof AgentCard) {
                AgentCard ac = (AgentCard)obj;
                StringBuffer sb = new StringBuffer();
                String label = ac.getLabel();
                String host = ac.getAgentHost();
                String ip = ac.getAgentIP();
                if (label != null && label.length() > 0) {
                    sb.append(label);
                } else if (host != null && host.length() > 0 && !host.equals(ip)) {
                    sb.append(host);
                }
                sb.append(" (").append(ip).append(")");
                String agentLabel = sb.toString();
                if (this.m_pattern != null) {
                    Matcher m = this.m_pattern.matcher(agentLabel.toLowerCase());
                    if (m.find()) {
                        return true;
                    }
                } else if (this.m_text != null) {
                    if (agentLabel.toLowerCase().contains(this.m_text)) {
                        this.m_elements.add((GroupTreeObjectLast)element);
                        return true;
                    }
                } else if (this.m_textList != null) {
                    int i = 0;
                    while (i < this.m_textList.size()) {
                        String agtName = this.m_textList.get(i);
                        if (agentLabel.toLowerCase().contains(agtName)) {
                            this.m_elements.add((GroupTreeObjectLast)element);
                            return true;
                        }
                        ++i;
                    }
                }
            }
            return false;
        }
        if (this.m_cache.containsKey(element)) {
            return true;
        }
        GroupTreeObject gto = (GroupTreeObject)element;
        if (gto.getParent() != null && gto.getParent().getName().equals("root")) {
            this.m_cache.put(gto, "");
            return true;
        }
        for (GroupTreeObject child : gto.getElements()) {
            boolean hasChildMatched = this.select(viewer, gto, child);
            if (!hasChildMatched) continue;
            this.m_cache.put(gto, "");
            return true;
        }
        return false;
    }

    public List<GroupTreeObjectLast> getFilteredElements() {
        return this.m_elements;
    }

    public Collection<GroupTreeObject> getFilteredFolders() {
        return this.m_cache.keySet();
    }
}

