/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.shared.space.Node;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class BGridLayout
extends AbstractLayoutAlgorithm {
    private static final double PADDING_PERCENTAGE = 0.95;
    protected int rowPadding = 0;
    int rows;
    int cols;
    int numChildren;
    double colWidth;
    double rowHeight;
    double offsetX;
    double offsetY;
    int totalProgress;
    double h;
    double w;
    Graph m_graph = null;

    public void setLayoutArea(double x, double y, double width, double height) {
        throw new RuntimeException("Operation not implemented");
    }

    public BGridLayout(Graph g, int styles) {
        super(styles);
        this.m_graph = g;
        this.rows = 3;
        int max = (Integer)this.m_graph.getData("N_USERS");
        max = Math.max(max, (Integer)this.m_graph.getData("N_FILTERS"));
        this.cols = max = Math.max(max, (Integer)this.m_graph.getData("N_POLICIES"));
        this.rowPadding = 20;
        this.w = 45.0;
        this.h = 18.0;
    }

    protected int getCurrentLayoutStep() {
        return 0;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return this.totalProgress;
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        double next1 = 20.0;
        double next2 = 40.0;
        double next3 = 20.0;
        int nnn = 0;
        while (nnn < entitiesToLayout.length) {
            InternalNode sn = entitiesToLayout[nnn];
            LayoutEntity en = sn.getLayoutEntity();
            Object o = en.getGraphData();
            if (o instanceof GraphNode) {
                GraphNode gn = (GraphNode)((Object)o);
                Node node = (Node)gn.getData();
                double x = 0.0;
                double y = node.gety() * 50.0 - 20.0;
                double shift = sn.getWidthInLayout() + (double)this.rowPadding;
                switch ((int)node.gety()) {
                    case 1: {
                        x = next1;
                        next1 += shift;
                        break;
                    }
                    case 2: {
                        x = next2;
                        next2 += shift;
                        break;
                    }
                    case 3: {
                        x = next3;
                        next3 += shift;
                    }
                }
                sn.setInternalLocation(x, y);
            }
            ++nnn;
        }
        double level1scale = 1.0;
        double level2scale = 1.0;
        double level3scale = 1.0;
        this.updateLayoutLocations(entitiesToLayout, level1scale, level2scale, level3scale);
        this.fireProgressEvent(this.totalProgress, this.totalProgress);
    }

    protected void updateLayoutLocations(InternalNode[] nodes, double level1scale, double level2scale, double level3scale) {
        int i = 0;
        while (i < nodes.length) {
            InternalNode node = nodes[i];
            if (!node.hasPreferredLocation()) {
                node.setLocation(node.getInternalX() * level1scale, node.getInternalY());
                if ((this.layout_styles & 1) != 1) {
                    node.setSize(node.getInternalWidth(), node.getInternalHeight());
                }
            }
            ++i;
        }
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    public void setRowPadding(int rowPadding) {
        if (rowPadding < 0) {
            return;
        }
        this.rowPadding = rowPadding;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continueous) {
        if (asynchronous && continueous) {
            return false;
        }
        if (asynchronous && !continueous) {
            return true;
        }
        if (!asynchronous && continueous) {
            return false;
        }
        return !asynchronous && !continueous;
    }
}

