/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class BLabel2
extends Canvas {
    private static final int INDENT = 0;
    private int align = 16384;
    private int hIndent = 0;
    private int vIndent = 0;
    private String text;
    private String appToolTipText;
    private List<Integer> severities;
    private String application = null;
    private String group = null;
    private boolean vertical = false;
    private boolean packed = false;
    private static int DRAW_FLAGS = 15;

    public BLabel2(Composite parent, int style) {
        super(parent, BLabel2.checkStyle(style));
        if ((style & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BLabel2.this.onPaint(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BLabel2.this.onDispose(event);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 128) {
                    BLabel2.this.onMnemonic(event);
                }
            }
        });
        this.initAccessible();
    }

    public void setVertical(boolean v) {
        this.vertical = v;
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style |= 4;
        }
        int mask = 100663340;
        style &= mask;
        return style |= 0x20080000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.severities);
        e.x = wHint == -1 ? (e.x += 2 * this.hIndent) : wHint;
        e.y = hHint == -1 ? (e.y += 2 * this.vIndent) : hHint;
        return e;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public int getAlignment() {
        return this.align;
    }

    private Point getTotalSize(List<Integer> sev) {
        Point size = new Point(0, 0);
        GC gc = new GC((Drawable)this);
        if (this.vertical) {
            int i = 1;
            while (i < sev.size()) {
                Integer count = sev.get(i);
                if (count == null) {
                    count = 0;
                }
                this.text = "" + count;
                if (this.text != null && this.text.length() > 0) {
                    Point e = gc.textExtent(this.text, DRAW_FLAGS);
                    size.x = Math.max(size.x, e.x);
                    size.y += e.y;
                } else {
                    size.x = 0;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < sev.size()) {
                Integer count = sev.get(i);
                if (count == null) {
                    count = 0;
                }
                this.text = "" + count;
                if (this.text != null && this.text.length() > 0) {
                    Point e = gc.textExtent(this.text, DRAW_FLAGS);
                    size.x += e.x;
                    size.y = Math.max(size.y, e.y);
                } else {
                    size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
                }
                ++i;
            }
        }
        gc.dispose();
        return size;
    }

    public int getStyle() {
        int style = super.getStyle();
        switch (this.align) {
            case 131072: {
                style |= 0x20000;
                break;
            }
            case 0x1000000: {
                style |= 0x1000000;
                break;
            }
            case 16384: {
                style |= 0x4000;
            }
        }
        return style;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    public List<Integer> getSeverities() {
        return this.severities;
    }

    public String getAppliaction() {
        return this.application;
    }

    public String getGroup() {
        return this.group;
    }

    public Boolean isVertical() {
        return this.vertical;
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BLabel2.this.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = BLabel2.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic = BLabel2.this._findMnemonic(BLabel2.this.text);
                if (mnemonic != '\u0000') {
                    e.result = "Alt+" + mnemonic;
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = BLabel2.this.getDisplay().map((Control)BLabel2.this.getParent(), null, BLabel2.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    void onDispose(DisposeEvent event) {
        this.text = null;
        this.appToolTipText = null;
        this.severities = null;
        this.application = null;
        this.group = null;
    }

    void onMnemonic(TraverseEvent event) {
        char mnemonic = this._findMnemonic(this.text);
        if (mnemonic == '\u0000') {
            return;
        }
        if (Character.toLowerCase(event.character) != mnemonic) {
            return;
        }
        Composite control = this.getParent();
        while (control != null) {
            Control[] children = control.getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                event.doit = true;
                event.detail = 0;
            }
            control = control.getParent();
        }
    }

    void onPaint(PaintEvent event) {
        int textWidth;
        int lineHeight;
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Point extent = this.getTotalSize(this.severities);
        GC gc = event.gc;
        gc.setBackground(this.getBackground());
        gc.fillRectangle(rect);
        Rectangle imgBounds = null;
        imgBounds = this.vertical ? new Rectangle(0, 0, rect.width, rect.height / 5 - 1) : new Rectangle(0, 0, rect.width / 5 - 1, rect.height);
        Image img = new Image((Device)Display.getDefault(), imgBounds);
        GC gcTemp = new GC((Drawable)img);
        super.setToolTipText(this.appToolTipText);
        int x = rect.x + this.hIndent;
        if (this.align == 0x1000000) {
            x = (rect.width - extent.x) / 2;
        } else if (this.align == 131072) {
            x = rect.width - this.hIndent - extent.x;
        }
        int style = this.getStyle();
        if ((style & 4) != 0 || (style & 8) != 0) {
            this.paintBorder(gc, rect);
        }
        int lineX = 2;
        int lineY = 0;
        if (this.vertical) {
            lineHeight = rect.height / 5;
            textWidth = rect.width;
        } else {
            lineHeight = gc.getFontMetrics().getHeight();
            lineY = Math.max(this.vIndent, rect.y + (rect.height - lineHeight) / 2);
            textWidth = rect.width / 5;
        }
        int i = 1;
        while (i < this.severities.size()) {
            int lineWidth;
            int count = this.severities.get(i);
            if (this.align == 0x1000000) {
                lineWidth = gc.textExtent((String)new StringBuilder().append((Object)this.severities.get((int)i)).toString(), (int)BLabel2.DRAW_FLAGS).x;
                lineX = x + Math.max(0, (extent.x - lineWidth) / 2);
            } else if (this.align == 131072) {
                lineWidth = gc.textExtent((String)new StringBuilder().append((Object)this.severities.get((int)i)).toString(), (int)BLabel2.DRAW_FLAGS).x;
                lineX = Math.max(x, rect.x + rect.width - this.hIndent - lineWidth);
            }
            if (i >= 3) {
                gcTemp.setBackground(BMUI.color_darkGrey);
            } else {
                gcTemp.setBackground(this.getBackground());
            }
            gcTemp.fillRectangle(rect);
            gcTemp.setForeground(BMUI.color_darkGrey2);
            gcTemp.drawRectangle(rect);
            if (this.packed) {
                gcTemp.setFont(BMUI.font_arial7_bold);
            } else {
                gcTemp.setFont(BMUI.font_arial8_bold);
            }
            if (count > 0) {
                gcTemp.setForeground(BMUI.getColor(i));
            } else {
                gcTemp.setForeground(gc.getBackground());
            }
            if (this.vertical) {
                gcTemp.drawText("" + count, lineX, 2, DRAW_FLAGS);
                gc.drawImage(img, 0, lineY);
                lineY += lineHeight;
            } else {
                gcTemp.drawText("" + count, 2, 0, DRAW_FLAGS);
                gc.drawImage(img, lineX, lineY);
                lineX += textWidth;
            }
            ++i;
        }
        img.dispose();
        gcTemp.dispose();
    }

    private void paintBorder(GC gc, Rectangle r) {
        Display disp = this.getDisplay();
        Color c1 = null;
        Color c2 = null;
        int style = this.getStyle();
        if ((style & 4) != 0) {
            c1 = disp.getSystemColor(18);
            c2 = disp.getSystemColor(20);
        }
        if ((style & 8) != 0) {
            c1 = disp.getSystemColor(19);
            c2 = disp.getSystemColor(18);
        }
        if (c1 != null && c2 != null) {
            gc.setLineWidth(1);
            this.drawBevelRect(gc, r.x, r.y, r.width - 1, r.height - 1, c1, c2);
        }
    }

    public void setAlignment(int align) {
        this.checkWidget();
        if (align != 16384 && align != 131072 && align != 0x1000000) {
            SWT.error((int)5);
        }
        if (this.align != align) {
            this.align = align;
            this.redraw();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.text)) {
            this.text = text;
            this.redraw();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public void setSeverities(List<Integer> sev) {
        this.severities = sev;
    }

    public void setApplication(String name) {
        this.application = name;
    }

    public void setGroup(String name) {
        this.group = name;
    }

    public void setPacked(boolean isPacked) {
        this.packed = isPacked;
    }

    protected String shortenText(GC gc, String t, int width) {
        return t;
    }

    int validateOffset(TextLayout layout, int offset) {
        int nextOffset = layout.getNextOffset(offset, 2);
        if (nextOffset != offset) {
            return layout.getPreviousOffset(nextOffset, 2);
        }
        return offset;
    }
}

