/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.utils.BLabelServiceController;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class BLabelServiceOverview
extends Canvas
implements BLabelServiceController {
    private static final String ELLIPSIS = "...";
    private static final int GAP = 2;
    private static final int INDENT = 0;
    private int align = 16384;
    private int hIndent = 0;
    private int vIndent = 0;
    private ServiceDashBoard service = null;
    private Rectangle m_rect = null;
    private GC m_gc = null;
    private GC m_gcTemp = null;
    private Image m_img = null;
    private Image image = null;
    private String toolTipText;
    private static int DRAW_FLAGS = 15;
    public static float m_scale = 1.0f;

    public BLabelServiceOverview(Composite parent, int style, ServiceDashBoard service) {
        super(parent, BLabelServiceOverview.checkStyle(style));
        if ((style & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
        this.service = service;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BLabelServiceOverview.this.onPaint(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BLabelServiceOverview.this.onDispose(event);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 128) {
                    BLabelServiceOverview.this.onMnemonic(event);
                }
            }
        });
        this.initAccessible();
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style |= 4;
        }
        int mask = 100663340;
        style &= mask;
        return style |= 0x20080000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.image, this.service.getName());
        e.x = wHint == -1 ? (e.x += 2 * this.hIndent) : wHint;
        e.y = hHint == -1 ? (e.y += 2 * this.vIndent) : hHint;
        e.y = 100;
        e.x = 248;
        return e;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public int getAlignment() {
        return this.align;
    }

    public Image getImage() {
        return this.image;
    }

    private Point getTotalSize(Image image, String text) {
        Point size = new Point(0, 0);
        GC gc = new GC((Drawable)this);
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text, DRAW_FLAGS);
            size.x += e.x;
            size.y = Math.max(size.y, e.y);
            if (image != null) {
                size.x += 2;
            }
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }

    public int getStyle() {
        int style = super.getStyle();
        switch (this.align) {
            case 131072: {
                style |= 0x20000;
                break;
            }
            case 0x1000000: {
                style |= 0x1000000;
                break;
            }
            case 16384: {
                style |= 0x4000;
            }
        }
        return style;
    }

    public String getText() {
        return this.service.getName();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public Rectangle getBounds() {
        if (this.m_img == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.m_img.getBounds();
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BLabelServiceOverview.this.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = BLabelServiceOverview.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic = BLabelServiceOverview.this._findMnemonic(BLabelServiceOverview.this.getText());
                if (mnemonic != '\u0000') {
                    e.result = "Alt+" + mnemonic;
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = BLabelServiceOverview.this.getDisplay().map((Control)BLabelServiceOverview.this.getParent(), null, BLabelServiceOverview.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    void onDispose(DisposeEvent event) {
        this.service = null;
        this.image = null;
        this.toolTipText = null;
    }

    void onMnemonic(TraverseEvent event) {
        char mnemonic = this._findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return;
        }
        if (Character.toLowerCase(event.character) != mnemonic) {
            return;
        }
        Composite control = this.getParent();
        while (control != null) {
            Control[] children = control.getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                event.doit = true;
                event.detail = 0;
            }
            control = control.getParent();
        }
    }

    void onPaint(PaintEvent event) {
        this.m_rect = this.getClientArea();
        if (m_scale != 1.0f) {
            this.m_rect = new Rectangle(0, 0, (int)((float)this.m_rect.width / m_scale), (int)((float)this.m_rect.height / m_scale));
        }
        if (this.m_rect.width == 0 || this.m_rect.height == 0) {
            return;
        }
        this.m_gc = event.gc;
        Rectangle imgBounds = new Rectangle(0, 0, this.m_rect.width, this.m_rect.height);
        this.m_img = new Image((Device)Display.getDefault(), imgBounds);
        this.m_gcTemp = new GC((Drawable)this.m_img);
        this.m_gcTemp.setLineWidth(2);
        if (!this.service.isSelected()) {
            this.m_gcTemp.setBackground(BMUI.color_white);
        } else {
            this.m_gcTemp.setBackground(BMUI.color_selected);
        }
        this.m_gcTemp.fillRoundRectangle(0, 0, 248, 100, 15, 15);
        try {
            this.m_gcTemp.setAntialias(1);
        }
        catch (Throwable throwable) {}
        this.setAvailablityColor();
        this.m_gcTemp.setLineWidth(2);
        this.m_gcTemp.fillRoundRectangle(3, 3, 242, 94, 15, 15);
        this.m_gcTemp.setBackground(BMUI.color_white);
        this.m_gcTemp.fillRoundRectangle(25, 25, 218, 46, 0, 15);
        this.m_gcTemp.fillRoundRectangle(25, 65, 20, 30, 0, 0);
        this.m_gcTemp.fillRoundRectangle(25, 65, 218, 30, 15, 15);
        this.drawServiceName();
        this.drawAvailability();
        this.drawTotal();
        this.drawKPI();
        this.drawDetails();
        if (m_scale != 1.0f) {
            ImageData idscaled = this.m_img.getImageData().scaledTo((int)((float)this.m_rect.width * m_scale), (int)((float)this.m_rect.height * m_scale));
            this.m_img = new Image((Device)Display.getDefault(), idscaled);
        }
        this.m_gc.drawImage(this.m_img, 0, 0);
        this.m_img.dispose();
        this.m_gcTemp.dispose();
    }

    private void setAvailablityColor() {
        int statusAV = this.service.getStatusAV();
        switch (statusAV) {
            case 0: 
            case 1: {
                this.m_gcTemp.setForeground(BMUI.color_white);
                this.m_gcTemp.setBackground(BMUI.color_green);
                break;
            }
            case 2: {
                this.m_gcTemp.setForeground(BMUI.color_white);
                this.m_gcTemp.setBackground(BMUI.color_warning);
                break;
            }
            case 3: {
                this.m_gcTemp.setForeground(BMUI.color_black);
                this.m_gcTemp.setBackground(BMUI.color_minor);
                break;
            }
            case 4: {
                this.m_gcTemp.setForeground(BMUI.color_white);
                this.m_gcTemp.setBackground(BMUI.color_major);
                break;
            }
            case 5: {
                this.m_gcTemp.setForeground(BMUI.color_white);
                this.m_gcTemp.setBackground(BMUI.color_critical);
                break;
            }
            default: {
                this.m_gcTemp.setForeground(BMUI.color_black);
                this.m_gcTemp.setBackground(BMUI.color_grey);
            }
        }
    }

    public void drawServiceName() {
        this.m_gcTemp.setFont(BMUI.font_arial8_bold);
        if (Display.getCurrent().getDPI().x >= 130) {
            this.m_gcTemp.setFont(BMUI.font_arial6_bold);
        }
        this.m_gcTemp.setForeground(BMUI.color_white);
        String text = this.shortenText(this.m_gcTemp, this.service.getName(), 220);
        int i = 6 - BLabelServiceOverview.calculateScaleSize() / 6;
        if (i < 0) {
            i = 1;
        }
        this.m_gcTemp.drawText(text, 25, i, DRAW_FLAGS);
        if (!this.service.isGlobalOnly()) {
            this.m_gcTemp.setLineWidth(1);
            this.m_gcTemp.drawRoundRectangle(7, 7, 15, 15, 4, 4);
            this.m_gcTemp.setLineWidth(2);
            this.m_gcTemp.drawLine(12, 10, 12, 19);
            this.m_gcTemp.drawLine(12, 19, 18, 19);
        }
    }

    public void drawTotal() {
        int total = this.service.getAVTotal() + this.service.getKPITotal() + this.service.getcrit() + this.service.getmaj() + this.service.getmin() + this.service.getnormal() + this.service.getwarn();
        this.m_gcTemp.setForeground(BMUI.color_black);
        this.m_gcTemp.setBackground(BMUI.color_white);
        this.m_gcTemp.setFont(BMUI.font_arial12_bold);
        int factor = 0;
        if (total > 9999) {
            factor = 21;
        } else if (total > 999) {
            factor = 17;
        } else if (total > 99) {
            factor = 13;
        } else if (total > 9) {
            factor = 6;
        }
        this.m_gcTemp.drawText((total > 99999 ? 99999 : total) + (total > 99999 ? "+" : ""), 192 - factor, 38);
        this.m_gcTemp.setFont(BMUI.font_arial6);
        this.m_gcTemp.drawText("Total", 186, 27);
        super.setToolTipText(String.valueOf(this.service.getName()) + " - Total: " + total);
    }

    public void drawAvailability() {
        this.setAvailablityColor();
        this.m_gcTemp.setFont(BMUI.font_arial8);
        if (Display.getCurrent().getDPI().x >= 130) {
            this.m_gcTemp.setFont(BMUI.font_arial6);
        } else if (Display.getCurrent().getDPI().x >= 110) {
            this.m_gcTemp.setFont(BMUI.font_arial7);
        }
        Transform tr = new Transform((Device)Display.getCurrent());
        tr.rotate(-90.0f);
        this.m_gcTemp.setTransform(tr);
        this.m_gcTemp.drawText("Availibility", -90, 5);
        tr.rotate(90.0f);
        this.m_gcTemp.setTransform(tr);
        tr.dispose();
        this.m_gcTemp.setFont(this.getFont());
        this.m_gcTemp.setForeground(this.getForeground());
        this.m_gcTemp.setBackground(this.getBackground());
    }

    public void drawKPI() {
        this.m_gcTemp.setFont(BMUI.font_arial8_bold);
        this.m_gcTemp.drawText("KPI", 30, 30 + (BLabelServiceOverview.calculateScaleSize() / 25 == 0 ? 5 : BLabelServiceOverview.calculateScaleSize() / 25), DRAW_FLAGS);
        this.m_gcTemp.setFont(this.getFont());
        this.m_gcTemp.drawImage(BMUI.IMAGE_KPI_SDB, 0, 0, 96, 48, 70, 32, 48, 24);
        this.m_gcTemp.setForeground(this.getForeground());
        this.m_gcTemp.setBackground(this.getBackground());
        int startKPIy = 32;
        int shiftX = 70;
        int radius = 24;
        double angle = 180.0 * this.service.getKpiWAverage();
        double radians = Math.toRadians(angle);
        int xF = 0 + shiftX + radius;
        int yF = startKPIy + radius;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        double rad1 = Math.toRadians(angle - 15.0);
        double rad2 = Math.toRadians(angle + 15.0);
        if (angle < 90.0) {
            x1 = xF - (int)((double)radius * Math.cos(radians)) - 2;
            y1 = yF - (int)((double)radius * Math.sin(radians)) - 2;
            x2 = xF - (int)(10.0 * Math.cos(rad1));
            y2 = yF - (int)(10.0 * Math.sin(rad1));
            x3 = xF - (int)(10.0 * Math.cos(rad2));
            y3 = yF - (int)(10.0 * Math.sin(rad2));
        } else if (angle > 90.0) {
            angle = 180.0 - angle;
            radians = Math.toRadians(angle);
            rad1 = Math.toRadians(angle - 15.0);
            rad2 = Math.toRadians(angle + 15.0);
            x1 = xF + (int)((double)radius * Math.cos(radians));
            y1 = yF - (int)((double)radius * Math.sin(radians));
            x2 = xF + (int)(10.0 * Math.cos(rad1));
            y2 = yF - (int)(10.0 * Math.sin(rad1));
            x3 = xF + (int)(10.0 * Math.cos(rad2));
            y3 = yF - (int)(10.0 * Math.sin(rad2));
        } else {
            x1 = 0 + shiftX + radius;
            y1 = startKPIy;
            rad1 = Math.toRadians(15.0);
            double cos = Math.cos(rad1);
            double sin = Math.sin(rad1);
            x2 = xF - (int)(10.0 * sin);
            y2 = yF - (int)(10.0 * cos);
            x3 = xF + (int)(10.0 * sin);
            y3 = yF - (int)(10.0 * cos);
        }
        int[] points = new int[]{x1, y1, x2, y2, xF, yF, x3, y3};
        this.m_gcTemp.setForeground(BMUI.color_white);
        this.m_gcTemp.setBackground(BMUI.color_black);
        this.m_gcTemp.drawPolygon(points);
        this.m_gcTemp.fillPolygon(points);
        this.m_gcTemp.setForeground(BMUI.color_black);
        this.m_gcTemp.fillOval(xF - 4, yF - 4, 8, 8);
        this.m_gcTemp.setForeground(this.getForeground());
        this.m_gcTemp.setBackground(this.getBackground());
    }

    public void drawDetails() {
        int norm;
        int warn;
        int min;
        int maj;
        this.m_gcTemp.setFont(BMUI.font_arial7);
        if (Display.getCurrent().getDPI().x >= 130) {
            this.m_gcTemp.setFont(BMUI.font_arial6);
        }
        this.m_gcTemp.setBackground(BMUI.color_white);
        int crit = this.service.getcrit() + this.service.getAVcrit() + this.service.getKPIcrit();
        if (crit > 9999) {
            crit = 9999;
        }
        if ((maj = this.service.getmaj() + this.service.getAVmaj() + this.service.getKPImaj()) > 9999) {
            maj = 9999;
        }
        if ((min = this.service.getmin() + this.service.getAVmin() + this.service.getKPImin()) > 9999) {
            min = 9999;
        }
        if ((warn = this.service.getwarn() + this.service.getAVwarn() + this.service.getKPIwarn()) > 9999) {
            warn = 9999;
        }
        if ((norm = this.service.getnormal() + this.service.getAVnormal() + this.service.getKPInormal()) > 9999) {
            norm = 9999;
        }
        this.m_gcTemp.drawText(crit + (crit >= 9999 ? "+" : ""), 215 - this.calcTextPosFactor(crit), 70 - BLabelServiceOverview.calculateScaleSize() / 16);
        this.m_gcTemp.drawText(maj + (maj >= 9999 ? "+" : ""), 172 - this.calcTextPosFactor(maj), 70 - BLabelServiceOverview.calculateScaleSize() / 16);
        this.m_gcTemp.drawText(min + (min >= 9999 ? "+" : ""), 129 - this.calcTextPosFactor(min), 70 - BLabelServiceOverview.calculateScaleSize() / 16);
        this.m_gcTemp.drawText(warn + (warn >= 9999 ? "+" : ""), 89 - this.calcTextPosFactor(warn), 70 - BLabelServiceOverview.calculateScaleSize() / 16);
        this.m_gcTemp.drawText(norm + (norm >= 9999 ? "+" : ""), 46 - this.calcTextPosFactor(norm), 70 - BLabelServiceOverview.calculateScaleSize() / 16);
        this.m_gcTemp.setBackground(BMUI.color_normal);
        this.m_gcTemp.fillRectangle(30, 85, 40, 5);
        this.m_gcTemp.setBackground(BMUI.color_warning);
        this.m_gcTemp.fillRectangle(72, 85, 40, 5);
        this.m_gcTemp.setBackground(BMUI.color_minor);
        this.m_gcTemp.fillRectangle(114, 85, 40, 5);
        this.m_gcTemp.setBackground(BMUI.color_major);
        this.m_gcTemp.fillRectangle(156, 85, 40, 5);
        this.m_gcTemp.setBackground(BMUI.color_critical);
        this.m_gcTemp.fillRectangle(198, 85, 40, 5);
        this.m_gcTemp.setForeground(BMUI.color_darkGrey);
        this.m_gcTemp.drawLine(30, 70, 238, 70);
        this.m_gcTemp.setFont(this.getFont());
    }

    private int calcTextPosFactor(int inputVal) {
        int factor = 0;
        if (inputVal > 9990) {
            factor = 16;
        } else if (inputVal > 999) {
            factor = 12;
        } else if (inputVal > 99) {
            factor = 8;
        } else if (inputVal > 9) {
            factor = 4;
        }
        return factor;
    }

    public void setAlignment(int align) {
        this.checkWidget();
        if (align != 16384 && align != 131072 && align != 0x1000000) {
            SWT.error((int)5);
        }
        if (this.align != align) {
            this.align = align;
            this.redraw();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.toolTipText = super.getToolTipText();
    }

    public void setService(ServiceDashBoard service) {
        this.service = service;
    }

    private String shortenText(GC gc, String t, int width) {
        if (t == null) {
            return null;
        }
        int size = gc.textExtent((String)t, (int)BLabelServiceOverview.DRAW_FLAGS).x;
        if (size <= width) {
            return t;
        }
        int l = t.length();
        if (l <= 0) {
            return t;
        }
        int dots = gc.textExtent((String)ELLIPSIS, (int)BLabelServiceOverview.DRAW_FLAGS).x;
        while (size + dots > width) {
            t = t.substring(0, t.length() - 1);
            size = gc.textExtent((String)t, (int)BLabelServiceOverview.DRAW_FLAGS).x;
        }
        return String.valueOf(t) + ELLIPSIS;
    }

    @Override
    public ServiceDashBoard getService() {
        return this.service;
    }

    public static int calculateScaleSize() {
        int x = Display.getCurrent().getDPI().x;
        int appendSize = 0;
        if (x > 100 && x < 130) {
            appendSize = 25;
        } else if (x >= 130) {
            appendSize = 50;
        }
        return appendSize;
    }
}

