/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventSorter;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.gui.dialogs.IDateRangeChangeListener;
import com.blixx.boom.gui.utils.BPoint;
import com.blixx.boom.gui.utils.PointComparator;
import com.blixx.boom.gui.utils.StandardDeviation;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tracker;

public class Chart
extends Canvas
implements MouseListener,
MouseMoveListener {
    public SimpleDateFormat m_sdf = new SimpleDateFormat("MM-dd HH:mm");
    List<SEvent> events = null;
    List<String> keyForSeries = null;
    private int margin;
    private int textSpaceLeft = 50;
    private int textSpaceButton = 70;
    private Map<Double, Integer> m_severities = null;
    boolean m_maximum = false;
    public static final Color COLOR_NORMAL = BMUI.color_light_green;
    public static final Color COLOR_WARNING = new Color((Device)Display.getDefault(), 214, 220, 232);
    public static final Color COLOR_MINOR = BMUI.color_light_yellow;
    public static final Color COLOR_MAJOR = new Color((Device)Display.getDefault(), 249, 234, 214);
    public static final Color COLOR_RED = new Color((Device)Display.getDefault(), 255, 207, 206);
    private double scaleX;
    private double scaleY;
    private double min;
    private double max;
    private long start;
    private long finish;
    private int m_typeOfGraph = 0;
    private List<IDateRangeChangeListener> m_listeners = new ArrayList<IDateRangeChangeListener>();
    int mouseStartX = -1;
    int mouseStartY = -1;
    Tracker tr = null;

    public Chart(Composite parent, int style, List<SEvent> evnts, Map<Double, Integer> severities, boolean maximum, int type) {
        super(parent, style);
        this.m_typeOfGraph = type;
        this.m_maximum = maximum;
        EventSorter comparator = new EventSorter("SrvTime", 1024);
        Collections.sort(evnts, comparator);
        this.events = evnts;
        this.m_severities = severities;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Chart.this.onPaint(event);
            }
        });
        this.margin = 5;
        this.init();
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
    }

    public void addDateRangeChangeListener(IDateRangeChangeListener l) {
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    public List<String> getKeys() {
        return this.keyForSeries;
    }

    public Color getColor(int pos) {
        Color foreground = null;
        switch (pos) {
            case 0: {
                foreground = BMUI.color_blue;
                break;
            }
            case 1: {
                foreground = BMUI.color_critical;
                break;
            }
            case 2: {
                foreground = BMUI.color_green;
                break;
            }
            case 3: {
                foreground = BMUI.color_black;
                break;
            }
            default: {
                foreground = Display.getDefault().getSystemColor(14);
            }
        }
        return foreground;
    }

    private void init() {
        this.keyForSeries = new ArrayList<String>();
        this.start = System.currentTimeMillis() + 1000L;
        this.finish = 0L;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        Iterator<SEvent> it = this.events.iterator();
        while (it.hasNext()) {
            SEventFwd sef;
            SEvent se = it.next();
            String key = EventStorageUtils.getEventKey(se);
            if (!this.keyForSeries.contains(key)) {
                if (this.keyForSeries.size() > 4) {
                    it.remove();
                    continue;
                }
                this.keyForSeries.add(key);
            }
            if (se.getFirstTime() < this.start) {
                this.start = se.getFirstTime();
            }
            if (se.getTime() > this.finish) {
                this.finish = se.getTime();
            }
            if ("".equals(se.getMonitor())) {
                int sev = se.getSeverityInt();
                if (sev < 0) {
                    sev += 6;
                }
                if ((double)sev < this.min) {
                    this.min = sev;
                }
                if ((double)sev > this.max) {
                    this.max = sev;
                }
            } else {
                if (se.getValue() < this.min) {
                    this.min = se.getValue();
                }
                if (se.getValue() > this.max) {
                    this.max = se.getValue();
                }
            }
            if (!(se instanceof SEventFwd) || (sef = (SEventFwd)se).getTFA() <= 0L) continue;
            if (sef.getTFA() > this.finish) {
                this.finish = sef.getTFA();
            }
            if (sef.getVFA() < this.min) {
                this.min = sef.getVFA();
            }
            if (!(sef.getVFA() > this.max)) continue;
            this.max = sef.getVFA();
        }
        if (this.keyForSeries.size() == 1) {
            this.keyForSeries = null;
        }
        if (Math.abs(this.max - this.min) < 1.0E-7 && Math.abs(this.max - 0.0) < 1.0E-7) {
            this.min = -1.0;
            this.max = 1.0;
        } else {
            this.normalizeMaxMin();
        }
        long d1 = this.finish - this.start;
        this.start = (long)((double)this.start - (double)d1 * 0.1);
        this.finish = (long)((double)this.finish + (double)d1 * 0.1);
        this.normTime();
    }

    private void normTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(this.start));
        cal.add(11, -1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.start = cal.getTimeInMillis();
        cal = Calendar.getInstance();
        cal.setTime(new Date(this.finish));
        cal.add(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.finish = cal.getTimeInMillis();
    }

    private void normalizeMaxMin() {
        String str;
        int l;
        double delta = this.max - this.min;
        if (delta == 0.0) {
            delta = 10.0;
        }
        if ((l = (str = ("" + this.max).split("\\.")[0]).length() - 2) > 0) {
            int maxFloor = (int)Math.floor(delta);
            int len = ("" + maxFloor).length() - 1;
            long di2 = (long)Math.pow(10.0, len);
            this.max = Math.ceil(this.max) + (double)di2;
        } else if (l == 0) {
            l = str.length() - 1;
            long di = (long)Math.pow(10.0, l);
            this.max = Math.ceil((this.max + delta * 0.2) / (double)di) * (double)di;
        } else {
            this.max = Math.ceil(this.max * 1.2);
        }
        this.min -= delta * 0.2;
    }

    public long getStart() {
        return this.start;
    }

    public long getFinish() {
        return this.finish;
    }

    void onPaint(PaintEvent event) {
        org.eclipse.swt.graphics.Rectangle imgBounds = this.getClientArea();
        org.eclipse.swt.graphics.Rectangle bounds1 = new org.eclipse.swt.graphics.Rectangle(imgBounds.x + this.margin, imgBounds.y + this.margin, imgBounds.width - this.margin * 2, imgBounds.height - this.margin * 2);
        Image img = new Image((Device)Display.getDefault(), bounds1);
        GC gc = new GC((Drawable)img);
        gc.setBackground(BMUI.color_white);
        gc.setLineWidth(1);
        gc.setLineJoin(2);
        gc.setLineStyle(1);
        SWTGraphics gcTemp = new SWTGraphics(gc);
        int width = img.getBounds().width - this.textSpaceLeft;
        int height = img.getBounds().height - this.textSpaceButton;
        this.scaleX = (double)width / Math.abs((double)this.finish - (double)this.start);
        this.scaleY = (double)height / (this.max - this.min);
        gcTemp.setLineStyle(3);
        int fontShift = gcTemp.getFontMetrics().getHeight() / 2;
        this.drawConditions(gcTemp, width, height);
        this.drawYLabels(gcTemp, width, height, fontShift);
        this.drawXLabels(gc, gcTemp, height, fontShift);
        if (this.keyForSeries == null || this.keyForSeries.size() == 0) {
            ArrayList<BPoint> points = this.prepareSerie(height, null);
            gcTemp.setClip(new Rectangle(this.textSpaceLeft, 0, width, height));
            Collections.sort(points, new PointComparator());
            this.drawDeviation(img, gcTemp, width, height, points);
            this.drawSerie(gcTemp, width, points, BMUI.color_black);
        } else {
            int color = 0;
            for (String key : this.keyForSeries) {
                ArrayList<BPoint> points = this.prepareSerie(height, key);
                gcTemp.setClip(new Rectangle(this.textSpaceLeft, 0, width, height));
                Collections.sort(points, new PointComparator());
                Color foreground = this.getColor(color);
                this.drawSerie(gcTemp, width, points, foreground);
                ++color;
            }
        }
        gcTemp.setClip(new Rectangle(this.textSpaceLeft, 0, width, height + 1));
        gcTemp.setForegroundColor(BMUI.color_darkGrey);
        gcTemp.drawRectangle(this.textSpaceLeft, 0, width - 1, height);
        event.gc.drawImage(img, this.margin, this.margin);
        img.dispose();
        gcTemp.dispose();
    }

    private void drawSerie(SWTGraphics gcTemp, int width, ArrayList<BPoint> points, Color color) {
        BPoint lastPoint = points.get(points.size() - 1);
        BPoint bp = new BPoint(lastPoint.x + 1000, lastPoint.y);
        bp.setTime(System.currentTimeMillis());
        points.add(bp);
        PointList finalPointList = new PointList();
        BPoint bps_prev = null;
        int i = 0;
        while (i < points.size()) {
            BPoint bps = points.get(i);
            if (this.m_typeOfGraph > 0 && bps_prev != null) {
                BPoint stepBps = new BPoint(bps.x, bps_prev.y);
                stepBps.setTime(bps.getTime());
                finalPointList.addPoint((Point)stepBps);
            }
            if (bps.x > 0) {
                if (finalPointList.size() == 0 && bps_prev != null) {
                    finalPointList.addPoint((Point)bps_prev);
                }
                finalPointList.addPoint((Point)bps);
                if (bps.x > width + this.textSpaceLeft) break;
            }
            bps_prev = bps;
            ++i;
        }
        gcTemp.setForegroundColor(color);
        gcTemp.setLineStyle(1);
        gcTemp.drawPolyline(finalPointList);
    }

    private void drawDeviation(Image img, SWTGraphics gcTemp, int width, int height, ArrayList<BPoint> points) {
        PointList pltrend = new PointList();
        List<BPoint> trend = this.drawDeviation(img, gcTemp, height, points);
        BPoint bpprev = null;
        int i = 0;
        while (i < trend.size()) {
            BPoint bp = trend.get(i);
            if (bp.x > 0) {
                if (pltrend.size() == 0 && bpprev != null) {
                    pltrend.addPoint((Point)bpprev);
                }
                pltrend.addPoint((Point)bp);
                if (bp.x > width + this.textSpaceLeft) break;
            }
            bpprev = bp;
            ++i;
        }
        gcTemp.setForegroundColor(BMUI.color_blue);
        gcTemp.setLineWidth(2);
        gcTemp.setLineCap(2);
        gcTemp.setLineJoin(2);
        gcTemp.setLineStyle(2);
        gcTemp.drawPolyline(pltrend);
        gcTemp.setLineWidth(1);
        gcTemp.setForegroundColor(BMUI.color_black);
    }

    private ArrayList<BPoint> prepareSerie(int height, String serieKey) {
        ArrayList<BPoint> points = new ArrayList<BPoint>(this.events.size());
        int y = 0;
        int negativ = 0;
        int i = 0;
        while (i < this.events.size()) {
            block7: {
                SEventFwd sef;
                int x;
                SEvent se;
                block8: {
                    se = this.events.get(i);
                    if (serieKey != null && !serieKey.equals(EventStorageUtils.getEventKey(se))) break block7;
                    x = (int)(((double)se.getFirstTime() - (double)this.start) * this.scaleX);
                    if (x >= 0) break block8;
                    if (negativ != 0) break block7;
                    negativ = x;
                }
                double value = se.getValue();
                if ("".equals(se.getMonitor()) && (value = (double)se.getSeverityInt()) < 0.0) {
                    value += 6.0;
                }
                y = (int)((value - this.min) * this.scaleY);
                x = this.textSpaceLeft + x;
                y = height - y;
                BPoint bp = new BPoint(x, y);
                bp.setTime(se.getFirstTime());
                bp.setValue(value);
                points.add(bp);
                if (se.getDuplicates() > 0) {
                    x = (int)(((double)se.getTime() - (double)this.start) * this.scaleX);
                    y = (int)((value - this.min) * this.scaleY);
                    x = this.textSpaceLeft + x;
                    y = height - y;
                    bp = new BPoint(x, y);
                    bp.setTime(se.getTime());
                    bp.setValue(value);
                    points.add(bp);
                }
                if (se instanceof SEventFwd && (sef = (SEventFwd)se).getTFA() > 0L) {
                    x = (int)(((double)sef.getTFA() - 1000.0 - (double)this.start) * this.scaleX);
                    y = (int)((sef.getValue() - this.min) * this.scaleY);
                    x = this.textSpaceLeft + x;
                    y = height - y;
                    bp = new BPoint(x, y);
                    bp.setTime(sef.getTFA() - 1000L);
                    bp.setValue(value);
                    points.add(bp);
                    x = (int)(((double)sef.getTFA() - (double)this.start) * this.scaleX);
                    y = (int)((sef.getVFA() - this.min) * this.scaleY);
                    x = this.textSpaceLeft + x;
                    y = height - y;
                    bp = new BPoint(x, y);
                    bp.setTime(sef.getTFA());
                    bp.setValue(sef.getVFA());
                    points.add(bp);
                }
            }
            ++i;
        }
        return points;
    }

    private List<BPoint> drawDeviation(Image img, SWTGraphics gcTemp, int height, ArrayList<BPoint> values) {
        ArrayList<BPoint> trend = new ArrayList<BPoint>();
        if (values.size() < 3) {
            return trend;
        }
        double avrg = StandardDeviation.getAverage(values, this.start, this.min, this.scaleX, this.scaleY, this.textSpaceLeft, height, trend);
        double std = StandardDeviation.getStandardDeviation(values, avrg);
        double topStd = avrg + std;
        double botStd = avrg - std;
        gcTemp.setForegroundColor(BMUI.color_blue);
        gcTemp.setLineWidth(1);
        int std1y = height - (int)((topStd - this.min) * this.scaleY);
        gcTemp.drawLine(this.textSpaceLeft, std1y, img.getBounds().width, std1y);
        DecimalFormat df = new DecimalFormat("##########.###");
        String std_str = df.format(std);
        gcTemp.drawText("(+" + std_str + ")", this.textSpaceLeft + 2, std1y);
        gcTemp.setLineWidth(2);
        int std2y = height - (int)((avrg - this.min) * this.scaleY);
        gcTemp.drawLine(this.textSpaceLeft, std2y, img.getBounds().width, std2y);
        String avrg_str = df.format(avrg);
        gcTemp.drawText("AVRG: " + avrg_str, this.textSpaceLeft + 2, std2y);
        gcTemp.setLineWidth(1);
        int std3y = height - (int)((botStd - this.min) * this.scaleY);
        gcTemp.drawLine(this.textSpaceLeft, std3y, img.getBounds().width, std3y);
        gcTemp.drawText("(-" + std_str + ")", this.textSpaceLeft + 2, std3y);
        gcTemp.setForegroundColor(BMUI.color_black);
        gcTemp.setLineWidth(1);
        return trend;
    }

    private void drawXLabels(GC gc, SWTGraphics gcTemp, int height, int fontShift) {
        gc.setLineStyle(1);
        gc.setForeground(BMUI.color_black);
        gc.setBackground(BMUI.color_white);
        double stepXvalue = 1.0 * (double)(this.finish - this.start) / 30.0;
        int i = 0;
        while (i < 31) {
            long time = this.start + (long)i * (long)stepXvalue;
            Date date2 = new Date(time);
            String date = this.m_sdf.format(date2);
            int x = (int)((double)(time - this.start) * this.scaleX);
            gcTemp.setForegroundColor(BMUI.color_black);
            this.drawVerticalText(date, gc, gcTemp, this.textSpaceLeft + x - fontShift, height);
            ++i;
        }
    }

    private void drawYLabels(SWTGraphics gcTemp, int width, int height, int fontShift) {
        gcTemp.setLineStyle(3);
        double stepYvalue = 1.0;
        double delta = this.max - this.min;
        stepYvalue = delta > 14.0 ? (delta < 100.0 ? 10.0 : delta / 10.0) : (delta < 1.5 ? 0.1 : 0.5);
        double res = this.max;
        int i = 0;
        while (res > this.min + stepYvalue) {
            res = this.max - (double)i * stepYvalue;
            DecimalFormat df = new DecimalFormat("##########.##");
            String dblstr = df.format(res);
            int y = (int)((res - this.min) * this.scaleY);
            gcTemp.setForegroundColor(BMUI.color_black);
            gcTemp.drawText(dblstr, new Point(this.margin, height - y - fontShift));
            gcTemp.setForegroundColor(BMUI.color_darkGrey);
            gcTemp.drawLine(this.textSpaceLeft - fontShift, height - y, this.textSpaceLeft + width, height - y);
            ++i;
        }
    }

    private void drawConditions(SWTGraphics gcTemp, int width, int height) {
        gcTemp.setClip(new Rectangle(this.textSpaceLeft, 0, width, height));
        gcTemp.setLineStyle(1);
        gcTemp.setForegroundColor(BMUI.color_darkGrey);
        ArrayList<Double> sevs = new ArrayList<Double>(this.m_severities.keySet());
        Double prev = null;
        prev = this.m_maximum ? Double.valueOf(this.max) : Double.valueOf(this.min);
        for (Double val : sevs) {
            int y;
            int prevY;
            Integer sev = this.m_severities.get(val);
            this.setBackgroundForSeverity(gcTemp, sev);
            int startMarker = 0;
            int height2 = 0;
            if (this.m_maximum) {
                prevY = (int)((this.max - prev) * this.scaleY);
                y = (int)((this.max - val) * this.scaleY);
                if (y < 0) {
                    y = 0;
                } else if (y > height) {
                    y = height;
                }
                startMarker = y;
                height2 = prevY - y;
                if (startMarker < 0) {
                    startMarker = 0;
                    height2 = height - prevY;
                }
            } else {
                prevY = (int)((prev - this.min) * this.scaleY);
                y = (int)((val - this.min) * this.scaleY);
                if (y < 0) {
                    y = 0;
                } else if (y > height) {
                    y = height;
                }
                startMarker = height - y;
                height2 = y - prevY;
                if (startMarker < 0) {
                    startMarker = 0;
                    height2 = height - prevY;
                }
            }
            if (startMarker < height || height2 <= 0) {
                gcTemp.fillRectangle(this.textSpaceLeft, startMarker + 1, this.textSpaceLeft + width, height2);
                gcTemp.drawLine(this.textSpaceLeft, startMarker + 1, this.textSpaceLeft + width, startMarker + 1);
            }
            prev = val;
        }
        gcTemp.setClip(new Rectangle(0, 0, width + this.textSpaceLeft, height + this.textSpaceButton));
    }

    private void setBackgroundForSeverity(SWTGraphics gcTemp, Integer sev) {
        switch (sev) {
            case 5: {
                gcTemp.setBackgroundColor(COLOR_RED);
                break;
            }
            case 4: {
                gcTemp.setBackgroundColor(COLOR_MAJOR);
                break;
            }
            case 3: {
                gcTemp.setBackgroundColor(COLOR_MINOR);
                break;
            }
            case 2: {
                gcTemp.setBackgroundColor(COLOR_WARNING);
                break;
            }
            case 1: {
                gcTemp.setBackgroundColor(COLOR_NORMAL);
                break;
            }
            default: {
                gcTemp.setBackgroundColor(BMUI.color_white);
            }
        }
    }

    public void drawVerticalText(String text, GC gc, SWTGraphics gcTemp, int x, int y) {
        org.eclipse.swt.graphics.Point p = gc.textExtent(text);
        Image img = new Image((Device)Display.getDefault(), p.x, p.y);
        GC gcText = new GC((Drawable)img);
        gcText.drawText(text, 0, 0);
        ImageData id1 = img.getImageData();
        ImageData id2 = new ImageData(id1.height, id1.width, id1.depth, id1.palette);
        boolean up = true;
        int sx = 0;
        while (sx < id1.width) {
            int sy = 0;
            while (sy < id1.height) {
                int dx = up ? sy : id1.height - sy - 1;
                int dy = up ? id1.width - sx - 1 : sx;
                id2.setPixel(dx, dy, id1.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        Image vertical = new Image((Device)Display.getDefault(), id2);
        gcTemp.drawImage(vertical, x, y);
        gcText.dispose();
        img.dispose();
        vertical.dispose();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.init();
        this.redraw();
        this.notifyListeners();
    }

    public void mouseDown(MouseEvent e) {
        this.mouseStartX = e.x;
        this.mouseStartY = e.y;
    }

    public void mouseUp(MouseEvent e) {
        this.mouseStartX = -1;
        this.mouseStartY = -1;
        if (this.tr != null) {
            this.tr.close();
            this.tr.dispose();
            this.tr = null;
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.mouseStartX > 0) {
            org.eclipse.swt.graphics.Rectangle r = new org.eclipse.swt.graphics.Rectangle(this.mouseStartX, this.mouseStartY, e.x - this.mouseStartX, e.y - this.mouseStartY);
            if (this.tr == null) {
                this.tr = new Tracker((Composite)this, 16);
                this.tr.setRectangles(new org.eclipse.swt.graphics.Rectangle[]{r});
                this.tr.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.type == 4) {
                            Chart.this.tr.close();
                            Chart.this.tr.dispose();
                            Chart.this.tr = null;
                        }
                    }
                });
                this.tr.open();
                org.eclipse.swt.graphics.Rectangle[] rarr = this.tr.getRectangles();
                if (rarr != null) {
                    int finishX;
                    int startX = rarr[0].x - this.textSpaceLeft;
                    if (startX < 0) {
                        startX = 0;
                    }
                    if ((finishX = rarr[0].x - this.textSpaceLeft + rarr[0].width) < 0) {
                        finishX = 0;
                    }
                    double widthC = this.getBounds().width - this.textSpaceLeft - this.margin * 2;
                    long deltaX = this.finish - this.start;
                    long startTX = (long)((double)this.start + (double)deltaX * ((double)startX / widthC));
                    long finishTX = (long)((double)this.start + (double)deltaX * ((double)finishX / widthC));
                    this.start = startTX;
                    this.finish = finishTX;
                    double heightC = this.getBounds().height - this.textSpaceButton - this.margin * 2;
                    int maxY = rarr[0].y;
                    int minY = rarr[0].y + rarr[0].height;
                    double deltaY = this.max - this.min;
                    double highL = deltaY * ((double)maxY / heightC);
                    if (highL < 0.0) {
                        highL = 0.0;
                    }
                    double maxTY = this.max - highL;
                    double lowL = deltaY * ((heightC - (double)minY) / heightC);
                    if (lowL < 0.0) {
                        lowL = 0.0;
                    }
                    double minTY = this.min + lowL;
                    this.max = maxTY;
                    this.min = minTY;
                    this.normalizeMaxMin();
                    this.normTime();
                    this.redraw();
                }
                this.tr.dispose();
                this.tr = null;
                this.mouseStartX = -1;
                this.mouseStartY = -1;
                this.notifyListeners();
            } else {
                this.tr.setRectangles(new org.eclipse.swt.graphics.Rectangle[]{r});
            }
        }
    }

    private void notifyListeners() {
        int i = 0;
        while (i < this.m_listeners.size()) {
            this.m_listeners.get(i).changed(this.start, this.finish);
            ++i;
        }
    }
}

