/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.BinaryTreeDialog;
import com.blixx.boom.gui.dialogs.PolicyTreeDialog;
import com.blixx.boom.gui.dialogs.RemoteActionDialog;
import com.blixx.boom.gui.utils.AgentTreeFilter;
import com.blixx.boom.gui.utils.DashBoardTableFilter;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PolicyTableFilter;
import com.blixx.boom.gui.utils.PolicyTreeFilter;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeFilter;
import com.blixx.boom.gui.views.ActionsListView;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.boom.gui.views.DashBoardView2;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.PolicyOverviewTab;
import com.blixx.boom.gui.views.outages.AgentAdhocMaintenanceOverviewTab;
import com.blixx.boom.gui.views.outages.ScheduledMaintenanceOverviewTab;
import com.blixx.boom.gui.views.outages.ServerPolicyOverviewTab;
import com.blixx.boom.gui.views.outages.ServerPolicyTextFilter;
import com.blixx.boom.gui.views.outages.StatusViewFilter;
import com.blixx.boom.snmp.MIBBrowser;
import java.util.LinkedList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilterComposite
implements MouseListener {
    private Object m_object = null;
    private Composite m_parent = null;
    private Composite m_searchComp = null;
    private Text m_searchText = null;
    private Label m_searchIcon = null;
    protected static final String APPLY_FILTER = "APPLY_FILTER";
    protected static final String REMOVE_FILTER = "REMOVE_FILTER";

    public FilterComposite(Composite parent, Object object) {
        this.m_parent = parent;
        this.m_object = object;
        this.createComposite();
    }

    public void setObject(Object object) {
        this.m_object = object;
    }

    public void createComposite() {
        this.m_searchComp = new Composite(this.m_parent, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        this.m_searchComp.setLayout((Layout)gl);
        this.m_searchComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_searchIcon = new Label(this.m_searchComp, 0);
        this.m_searchIcon.setImage(BMUI.IMAGE_FILTERED_14x14);
        this.m_searchIcon.setEnabled(false);
        this.m_searchText = new Text(this.m_searchComp, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 10;
        this.m_searchText.setLayoutData((Object)gd);
        GUIDisplayElements gui = new GUIDisplayElements();
        gui.addDefaultTextContentMenu(this.m_searchText, true);
        this.m_searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof Text && (e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 0x1000050)) {
                    FilterComposite.this.applyFilter();
                }
            }
        });
        Label runFilterIcon = new Label(this.m_searchComp, 0);
        runFilterIcon.setImage(BMUI.IMAGE_RUN);
        runFilterIcon.setData((Object)APPLY_FILTER);
        runFilterIcon.addMouseListener((MouseListener)this);
        runFilterIcon.setToolTipText("Run Filter");
        Label delFilterIcon = new Label(this.m_searchComp, 0);
        delFilterIcon.setImage(BMUI.IMAGE_DEL_14x14);
        delFilterIcon.setData((Object)REMOVE_FILTER);
        delFilterIcon.addMouseListener((MouseListener)this);
        delFilterIcon.setToolTipText("Remove Filter");
    }

    public void setCompositeLayoutData(GridData gridData) {
        this.m_searchComp.setLayoutData((Object)gridData);
        this.m_searchComp.layout(true);
    }

    public void setTextMinWidth(int minWidth) {
        ((GridData)this.m_searchText.getLayoutData()).minimumWidth = minWidth;
    }

    public void setFilter(String text) {
        try {
            this.m_searchText.setText(text);
            this.applyFilter();
        }
        catch (Throwable throwable) {}
    }

    public String getFilter() {
        try {
            return this.m_searchText.getText();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void applyFilter() {
        if (this.m_searchText.getText().trim().length() > 0) {
            this.setFilter();
        } else {
            this.removeFilter();
        }
    }

    public void setFilter() {
        String searchText_trimmed = this.m_searchText.getText().trim();
        this.activateSearchIcon(true);
        if (this.m_searchText.getText().length() > searchText_trimmed.length()) {
            this.m_searchText.setText(searchText_trimmed);
        }
        if (this.m_object instanceof NodeListView) {
            STreeViewer treeViewer = ((NodeListView)((Object)this.m_object)).getTreeViewer();
            AgentTreeFilter atf = new AgentTreeFilter(searchText_trimmed);
            treeViewer.setFilters(new ViewerFilter[]{atf});
            treeViewer.setExpandedElements(atf.getFilteredFolders().toArray());
        } else if (this.m_object instanceof PolicyListView) {
            TreeViewer treeViewer = ((PolicyListView)((Object)this.m_object)).getTreeViewer();
            PolicyTreeFilter ptf = new PolicyTreeFilter(searchText_trimmed);
            treeViewer.setFilters(new ViewerFilter[]{ptf});
            treeViewer.setExpandedElements(ptf.getFilteredFolders().toArray());
        } else if (this.m_object instanceof BinariesListView) {
            TreeViewer treeViewer = ((BinariesListView)((Object)this.m_object)).getTreeViewer();
            TreeFilter ptf = new TreeFilter(searchText_trimmed, TreeFilter.SEARCH_ALL);
            treeViewer.setFilters(new ViewerFilter[]{ptf});
            treeViewer.expandToLevel(3);
            treeViewer.setExpandedElements(ptf.getFilteredFolders().toArray());
        } else if (this.m_object instanceof AssignmentListView) {
            TreeViewer treeViewer = ((AssignmentListView)((Object)this.m_object)).getTreeViewer();
            TreeFilter ptf = new TreeFilter(searchText_trimmed, TreeFilter.SEARCH_ALL);
            treeViewer.setFilters(new ViewerFilter[]{ptf});
            treeViewer.expandToLevel(2);
            treeViewer.setExpandedElements(ptf.getFilteredFolders().toArray());
        } else if (this.m_object instanceof ActionsListView) {
            TreeViewer treeViewer = ((ActionsListView)((Object)this.m_object)).getTreeViewer();
            TreeFilter ptf = new TreeFilter(searchText_trimmed, TreeFilter.SEARCH_GTOL);
            treeViewer.setFilters(new ViewerFilter[]{ptf});
            treeViewer.setExpandedElements(ptf.getFilteredFolders().toArray());
        } else if (this.m_object instanceof PolicyOverviewTab) {
            PolicyOverviewTab polOverviewTab = (PolicyOverviewTab)((Object)this.m_object);
            TableViewer tableViewer = polOverviewTab.getTableViewer();
            PolicyTableFilter tf = new PolicyTableFilter(searchText_trimmed);
            tableViewer.setFilters(new ViewerFilter[]{tf});
            polOverviewTab.reloadTable();
        } else if (this.m_object instanceof MIBBrowser) {
            MIBBrowser mibBrowser = (MIBBrowser)this.m_object;
            mibBrowser.filterTreeByName(searchText_trimmed);
        } else if (this.m_object instanceof RemoteActionDialog) {
            RemoteActionDialog agentRemoteAction = (RemoteActionDialog)this.m_object;
            agentRemoteAction.setFilter(searchText_trimmed);
        } else if (this.m_object instanceof DashBoardView2) {
            DashBoardView2 dashBoard = (DashBoardView2)this.m_object;
            TableViewer tableViewer = dashBoard.getTableViewer();
            DashBoardTableFilter tf = new DashBoardTableFilter(searchText_trimmed);
            tableViewer.setFilters(new ViewerFilter[]{tf});
            dashBoard.displayAll(false);
        } else if (this.m_object instanceof AgentAdhocMaintenanceOverviewTab) {
            AgentAdhocMaintenanceOverviewTab aot = (AgentAdhocMaintenanceOverviewTab)this.m_object;
            LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = aot.getTableViewer().getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter vf = viewerFilterArray[n2];
                if (vf instanceof StatusViewFilter) {
                    toAdd.add(vf);
                }
                ++n2;
            }
            toAdd.add(new ServerPolicyTextFilter(searchText_trimmed));
            aot.getTableViewer().setFilters(toAdd.toArray(new ViewerFilter[0]));
        } else if (this.m_object instanceof ServerPolicyOverviewTab) {
            ServerPolicyOverviewTab aot = (ServerPolicyOverviewTab)this.m_object;
            LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = aot.getTableViewer().getFilters();
            int n = viewerFilterArray.length;
            int n3 = 0;
            while (n3 < n) {
                ViewerFilter vf = viewerFilterArray[n3];
                if (vf instanceof StatusViewFilter) {
                    toAdd.add(vf);
                }
                ++n3;
            }
            toAdd.add(new ServerPolicyTextFilter(searchText_trimmed));
            aot.getTableViewer().setFilters(toAdd.toArray(new ViewerFilter[0]));
        } else if (this.m_object instanceof ScheduledMaintenanceOverviewTab) {
            ScheduledMaintenanceOverviewTab aot = (ScheduledMaintenanceOverviewTab)this.m_object;
            LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = aot.getTableViewer().getFilters();
            int n = viewerFilterArray.length;
            int n4 = 0;
            while (n4 < n) {
                ViewerFilter vf = viewerFilterArray[n4];
                if (vf instanceof StatusViewFilter) {
                    toAdd.add(vf);
                }
                ++n4;
            }
            toAdd.add(new ServerPolicyTextFilter(searchText_trimmed));
            aot.getTableViewer().setFilters(toAdd.toArray(new ViewerFilter[0]));
        } else if (this.m_object instanceof PolicyTreeDialog) {
            TreeViewer treeViewer = ((PolicyTreeDialog)((Object)this.m_object)).getTreeViewer();
            PolicyTreeFilter ptf = new PolicyTreeFilter(searchText_trimmed);
            treeViewer.setFilters(new ViewerFilter[]{ptf});
            treeViewer.setExpandedElements(ptf.getFilteredFolders().toArray());
        } else if (this.m_object instanceof BinaryTreeDialog) {
            TreeViewer treeViewer = ((BinaryTreeDialog)((Object)this.m_object)).getTreeViewer();
            TreeFilter ptf = new TreeFilter(searchText_trimmed, TreeFilter.SEARCH_ALL);
            treeViewer.setFilters(new ViewerFilter[]{ptf});
            treeViewer.expandToLevel(3);
            treeViewer.setExpandedElements(ptf.getFilteredFolders().toArray());
        }
    }

    public void removeFilter() {
        this.activateSearchIcon(false);
        this.clearSearchText();
        if (this.m_object instanceof NodeListView) {
            STreeViewer treeViewer = ((NodeListView)((Object)this.m_object)).getTreeViewer();
            treeViewer.setFilters(new ViewerFilter[0]);
        } else if (this.m_object instanceof PolicyListView) {
            TreeViewer treeViewer = ((PolicyListView)((Object)this.m_object)).getTreeViewer();
            treeViewer.setFilters(new ViewerFilter[0]);
        } else if (this.m_object instanceof BinariesListView) {
            TreeViewer treeViewer = ((BinariesListView)((Object)this.m_object)).getTreeViewer();
            treeViewer.setFilters(new ViewerFilter[0]);
        } else if (this.m_object instanceof AssignmentListView) {
            TreeViewer treeViewer = ((AssignmentListView)((Object)this.m_object)).getTreeViewer();
            treeViewer.setFilters(new ViewerFilter[0]);
        } else if (this.m_object instanceof ActionsListView) {
            TreeViewer treeViewer = ((ActionsListView)((Object)this.m_object)).getTreeViewer();
            treeViewer.setFilters(new ViewerFilter[0]);
        } else if (this.m_object instanceof PolicyOverviewTab) {
            PolicyOverviewTab polOverviewTab = (PolicyOverviewTab)((Object)this.m_object);
            TableViewer tableViewer = polOverviewTab.getTableViewer();
            tableViewer.setFilters(new ViewerFilter[0]);
            polOverviewTab.reloadTable();
        } else if (this.m_object instanceof MIBBrowser) {
            MIBBrowser mibBrowser = (MIBBrowser)this.m_object;
            mibBrowser.filterTreeByName(null);
        } else if (this.m_object instanceof RemoteActionDialog) {
            RemoteActionDialog agentRemoteAction = (RemoteActionDialog)this.m_object;
            agentRemoteAction.removeFilter();
        } else if (this.m_object instanceof DashBoardView2) {
            DashBoardView2 dashBoard = (DashBoardView2)this.m_object;
            TableViewer tableViewer = dashBoard.getTableViewer();
            tableViewer.setFilters(new ViewerFilter[0]);
            dashBoard.displayAll(true);
        } else if (this.m_object instanceof AgentAdhocMaintenanceOverviewTab) {
            AgentAdhocMaintenanceOverviewTab aot = (AgentAdhocMaintenanceOverviewTab)this.m_object;
            LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = aot.getTableViewer().getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter vf = viewerFilterArray[n2];
                if (vf instanceof StatusViewFilter) {
                    toAdd.add(vf);
                }
                ++n2;
            }
            aot.getTableViewer().setFilters(toAdd.toArray(new ViewerFilter[0]));
        } else if (this.m_object instanceof ServerPolicyOverviewTab) {
            ServerPolicyOverviewTab aot = (ServerPolicyOverviewTab)this.m_object;
            LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = aot.getTableViewer().getFilters();
            int n = viewerFilterArray.length;
            int n3 = 0;
            while (n3 < n) {
                ViewerFilter vf = viewerFilterArray[n3];
                if (vf instanceof StatusViewFilter) {
                    toAdd.add(vf);
                }
                ++n3;
            }
            aot.getTableViewer().setFilters(toAdd.toArray(new ViewerFilter[0]));
        } else if (this.m_object instanceof ScheduledMaintenanceOverviewTab) {
            ScheduledMaintenanceOverviewTab aot = (ScheduledMaintenanceOverviewTab)this.m_object;
            LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = aot.getTableViewer().getFilters();
            int n = viewerFilterArray.length;
            int n4 = 0;
            while (n4 < n) {
                ViewerFilter vf = viewerFilterArray[n4];
                if (vf instanceof StatusViewFilter) {
                    toAdd.add(vf);
                }
                ++n4;
            }
            aot.getTableViewer().setFilters(toAdd.toArray(new ViewerFilter[0]));
        } else if (this.m_object instanceof PolicyTreeDialog) {
            TreeViewer treeViewer = ((PolicyTreeDialog)((Object)this.m_object)).getTreeViewer();
            treeViewer.setFilters(new ViewerFilter[0]);
        } else if (this.m_object instanceof BinaryTreeDialog) {
            TreeViewer treeViewer = ((BinaryTreeDialog)((Object)this.m_object)).getTreeViewer();
            treeViewer.setFilters(new ViewerFilter[0]);
        }
    }

    public void clearSearchText() {
        if (this.m_searchText.getText().length() > 0) {
            this.m_searchText.setText("");
        }
    }

    public void setSearchText(String text) {
        if (text != null && text.length() > 0) {
            this.m_searchText.setText(text);
        }
    }

    public void activateSearchIcon(boolean activate) {
        this.m_searchIcon.setEnabled(activate);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof Label) {
            Label l = (Label)o;
            String name = (String)l.getData();
            if (APPLY_FILTER.equals(name)) {
                this.applyFilter();
            } else if (REMOVE_FILTER.equals(name)) {
                this.removeFilter();
            }
        }
    }
}

