/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.boom.gui.views.actions.SelectUsersAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilterComposite_ServerFilterUserTab
implements SelectionListener,
MouseListener,
KeyListener {
    private ServerFilterUsersTab m_sFilterUserTab = null;
    private Composite m_parent = null;
    private Composite m_mainComp = null;
    private Text m_userRoles_text = null;
    private Label m_icon = null;
    private GUIDisplayElements m_gui = null;
    private static String SELECT_USER_BTN = "SELECT_USER_BTN";
    protected static final String APPLY_FILTER = "APPLY_FILTER";
    protected static final String REMOVE_FILTER = "REMOVE_FILTER";

    public FilterComposite_ServerFilterUserTab(Composite parent, ServerFilterUsersTab sFilterUserTab) {
        this.m_parent = parent;
        this.m_sFilterUserTab = sFilterUserTab;
        this.m_gui = new GUIDisplayElements();
        this.createComposite();
    }

    public void createComposite() {
        this.m_mainComp = new Composite(this.m_parent, 0);
        GridLayout gl = new GridLayout(5, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 2;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_icon = new Label(this.m_mainComp, 0);
        this.m_icon.setImage(BMUI.IMAGE_FILTERED_14x14);
        this.m_icon.setEnabled(false);
        this.m_userRoles_text = new Text(this.m_mainComp, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 10;
        this.m_userRoles_text.setLayoutData((Object)gd);
        this.m_gui.addDefaultTextContentMenu(this.m_userRoles_text, true);
        this.m_userRoles_text.addKeyListener((KeyListener)this);
        Button selectUserGroup_btn = this.m_gui.addButton(this.m_mainComp, SELECT_USER_BTN, " Select User Roles ", true, 90, 30, 0, this);
        ((GridData)selectUserGroup_btn.getLayoutData()).horizontalIndent = 1;
        Label runFilterIcon = new Label(this.m_mainComp, 0);
        runFilterIcon.setImage(BMUI.IMAGE_RUN);
        runFilterIcon.setData((Object)APPLY_FILTER);
        runFilterIcon.addMouseListener((MouseListener)this);
        Label delFilterIcon = new Label(this.m_mainComp, 0);
        delFilterIcon.setImage(BMUI.IMAGE_DEL_14x14);
        delFilterIcon.setData((Object)REMOVE_FILTER);
        delFilterIcon.addMouseListener((MouseListener)this);
        this.m_gui.addTextField(this.m_mainComp, null, "    ", 1, 1, 1, 0, null);
        Label l = new Label(this.m_mainComp, 0);
        l.setFont(BMUI.font_arial7);
        l.setText("[UserRole1],[UserRole2]");
    }

    public void setCompositeLayoutData(GridData gridData) {
        this.m_mainComp.setLayoutData((Object)gridData);
        this.m_mainComp.layout(true);
    }

    public void setTextMinWidth(int minWidth) {
        ((GridData)this.m_userRoles_text.getLayoutData()).minimumWidth = minWidth;
    }

    private void applyFilter() {
        if (this.m_userRoles_text.getText().trim().length() > 0) {
            this.setFilter();
        } else {
            this.removeFilter();
        }
    }

    public void setFilter() {
        String userRoles = this.m_userRoles_text.getText().trim();
        this.activateSearchIcon(true);
        if (this.m_userRoles_text.getText().length() > userRoles.length()) {
            this.m_userRoles_text.setText(userRoles);
        }
        this.m_sFilterUserTab.filterByUserRole(userRoles);
    }

    public void removeFilter() {
        this.activateSearchIcon(false);
        this.clearSearchText();
        this.m_sFilterUserTab.filterByUserRole(null);
    }

    public void clearSearchText() {
        if (this.m_userRoles_text.getText().length() > 0) {
            this.m_userRoles_text.setText("");
        }
    }

    public void setSearchText(String text) {
        if (text != null && text.length() > 0) {
            this.m_userRoles_text.setText(text);
        }
    }

    public void activateSearchIcon(boolean activate) {
        this.m_icon.setEnabled(activate);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.widget instanceof Text && (e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 0x1000050)) {
            this.applyFilter();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof Label) {
            Label l = (Label)o;
            String name = (String)l.getData();
            if (APPLY_FILTER.equals(name)) {
                this.applyFilter();
            } else if (REMOVE_FILTER.equals(name)) {
                this.removeFilter();
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Button btn;
        String name;
        Object o = e.getSource();
        if (o instanceof Button && (name = (String)(btn = (Button)o).getData()).equals(SELECT_USER_BTN)) {
            SelectUsersAction selectUserAction = new SelectUsersAction(this.m_sFilterUserTab.getParent().getShell(), this.m_userRoles_text.getText());
            selectUserAction.run();
            if (selectUserAction.getSelectedUsers() != null) {
                String selectedUserRoles = selectUserAction.getSelectedUsers();
                selectedUserRoles = ServerFilterView.getSimplifiedUserString(selectedUserRoles);
                this.m_userRoles_text.setText(selectedUserRoles);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

