/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.UserManagementTreeFilter;
import com.blixx.boom.gui.views.actions.RefreshUserRoleTabAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilterComposite_UserManagement
implements MouseListener,
SelectionListener {
    private TreeViewer m_treeViewer = null;
    private Composite m_mainComp = null;
    private Text m_searchText = null;
    private Label m_searchIcon = null;
    private Button m_online_btn = null;
    private Button m_refresh_btn = null;
    private static String ONLINE = "online";
    private static String REFRESH = "refresh";
    protected static final String APPLY_FILTER = "APPLY_FILTER";
    protected static final String REMOVE_FILTER = "REMOVE_FILTER";

    public FilterComposite_UserManagement(Composite parent) {
        this.createComposite(parent);
    }

    public void setTreeViewer(TreeViewer tv) {
        this.m_treeViewer = tv;
    }

    public void createComposite(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        this.m_mainComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(6, false);
        gl.marginHeight = 0;
        gl.horizontalSpacing = 3;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_searchIcon = new Label(this.m_mainComp, 0);
        this.m_searchIcon.setImage(BMUI.IMAGE_FILTERED_14x14);
        this.m_searchIcon.setEnabled(false);
        this.m_searchText = new Text(this.m_mainComp, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 10;
        this.m_searchText.setLayoutData((Object)gd);
        gui.addDefaultTextContentMenu(this.m_searchText, true);
        this.m_searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof Text && (e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 0x1000050)) {
                    FilterComposite_UserManagement.this.applyFilter();
                }
            }
        });
        Label runIcon = new Label(this.m_mainComp, 0);
        runIcon.setImage(BMUI.IMAGE_RUN);
        runIcon.setData((Object)APPLY_FILTER);
        runIcon.addMouseListener((MouseListener)this);
        runIcon.setToolTipText("Run Filter");
        Label delIcon = new Label(this.m_mainComp, 0);
        delIcon.setImage(BMUI.IMAGE_DEL_14x14);
        delIcon.setData((Object)REMOVE_FILTER);
        delIcon.addMouseListener((MouseListener)this);
        delIcon.setToolTipText("Remove Filter");
        this.m_online_btn = gui.addButton(this.m_mainComp, ONLINE, "", true, 60, 10, 1, 2, this);
        this.m_online_btn.setImage(BMUI.IMAGE_USER_ON);
        this.m_online_btn.setSelection(false);
        this.m_online_btn.setToolTipText("Display online users only.");
        this.m_refresh_btn = gui.addButton(this.m_mainComp, REFRESH, "", true, 60, 0, 0, this);
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH_14x14);
        this.m_refresh_btn.setSelection(false);
        this.m_refresh_btn.setToolTipText("Refresh Tree");
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalAlignment = 4;
    }

    public void setCompositeLayoutData(GridData gridData) {
        this.m_mainComp.setLayoutData((Object)gridData);
        this.m_mainComp.layout(true);
    }

    public void setTextMinWidth(int minWidth) {
        ((GridData)this.m_searchText.getLayoutData()).minimumWidth = minWidth;
    }

    public void setFilter(String text) {
        try {
            this.m_searchText.setText(text);
        }
        catch (Throwable throwable) {}
    }

    public String getFilter() {
        try {
            return this.m_searchText.getText();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void applyFilter() {
        if (this.m_searchText.getText().trim().length() > 0 || this.m_online_btn.getSelection()) {
            this.setFilter();
        } else {
            this.removeFilter();
        }
    }

    private void setFilter() {
        String searchText_trimmed = this.m_searchText.getText().trim();
        this.activateSearchIcon(searchText_trimmed.length() > 0);
        if (this.m_searchText.getText().length() > searchText_trimmed.length()) {
            this.m_searchText.setText(searchText_trimmed);
        }
        UserManagementTreeFilter treeFilter = new UserManagementTreeFilter(searchText_trimmed, this.m_online_btn.getSelection());
        this.m_treeViewer.setFilters(new ViewerFilter[]{treeFilter});
        this.m_treeViewer.setExpandedElements(treeFilter.getFilteredFolders().toArray());
    }

    private void removeFilter() {
        this.activateSearchIcon(false);
        this.clearSearchText();
        this.m_treeViewer.setFilters(new ViewerFilter[0]);
        this.m_treeViewer.expandAll();
    }

    public void clearSearchText() {
        if (this.m_searchText.getText().length() > 0) {
            this.m_searchText.setText("");
        }
    }

    public void setSearchText(String text) {
        if (text != null && text.length() > 0) {
            this.m_searchText.setText(text);
        }
    }

    public void activateSearchIcon(boolean activate) {
        this.m_searchIcon.setEnabled(activate);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof Label) {
            Label l = (Label)o;
            String name = (String)l.getData();
            if (REMOVE_FILTER.equals(name)) {
                this.activateSearchIcon(false);
                this.clearSearchText();
            }
            this.applyFilter();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            Button btn = (Button)o;
            String name = (String)btn.getData();
            if (name.equals(ONLINE)) {
                if (btn.getSelection()) {
                    btn.setToolTipText("Display all users.");
                } else {
                    btn.setToolTipText("Display online users only.");
                }
                this.applyFilter();
            } else if (name.equals(REFRESH)) {
                RefreshUserRoleTabAction refresh = new RefreshUserRoleTabAction();
                refresh.run();
            }
        }
    }
}

