/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.EventFilter;
import com.blixx.log.RTLogger;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.HashMapArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.TableViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FilterFactory {
    public static String FILTER_LIST = "FILTER_LIST";
    public static String FILTER = "FILTER";
    public static String FILTER_NAME = "FILTER_NAME";
    public static String LABEL = "LABEL";
    public static String IS_LOCKED = "IS_LOCKED";
    public static String AVAILABILITY = "AVAILABILITY";
    public static String KPI = "KPI";
    public static String COLUMN_NAME = "COLUMN_NAME";
    public static String ISNOT = "ISNOT";
    public static String PATTERN = "PATTERN";
    public static String CASE_SENSITIVE = "CASE_SENSITIVE";
    public static String MODE = "MODE";

    public HashMapArray<TableViewer, EventFilter> loadFilter(File file, TableViewer tv) {
        HashMapArray<TableViewer, EventFilter> filters = null;
        try {
            FileInputStream fio = new FileInputStream(file);
            filters = this.parseXML(fio, tv);
            try {
                fio.close();
            }
            catch (Throwable throwable) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            RTLogger.print(1, "Error loading file " + file.getPath());
        }
        return filters;
    }

    public HashMapArray<TableViewer, EventFilter> parseXML(InputStream io, TableViewer tv) {
        HashMapArray<TableViewer, EventFilter> mapfilters = new HashMapArray<TableViewer, EventFilter>();
        ArrayList<Object> filterList = new ArrayList();
        try {
            Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
            Element top = doc.getDocumentElement();
            filterList = this.processElement(top, tv);
            mapfilters.put(tv, filterList);
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error parsing xml file: " + e.getMessage());
            RTLogger.print(2, "", e);
        }
        return mapfilters;
    }

    protected ArrayList<EventFilter> processElement(Element top, TableViewer tv) {
        ArrayList<EventFilter> filterList = new ArrayList<EventFilter>();
        NodeList nl = top.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            String node = nl.item(i).getNodeName();
            if (node.equals(FILTER)) {
                String label = ((Element)nl.item(i)).getAttribute(LABEL);
                String columnName = ((Element)nl.item(i)).getAttribute(COLUMN_NAME);
                String condIsNot = ((Element)nl.item(i)).getAttribute(ISNOT);
                String pattern = ((Element)nl.item(i)).getAttribute(PATTERN);
                String caseSensitive = ((Element)nl.item(i)).getAttribute(CASE_SENSITIVE);
                String mode = ((Element)nl.item(i)).getAttribute(MODE);
                String isLocked = ((Element)nl.item(i)).getAttribute(IS_LOCKED);
                String typeA = ((Element)nl.item(i)).getAttribute(AVAILABILITY);
                String typeK = ((Element)nl.item(i)).getAttribute(KPI);
                EventFilter eventFilter = new EventFilter(label, columnName, pattern, Boolean.valueOf(caseSensitive), Integer.valueOf(mode), tv, Boolean.valueOf(isLocked), Integer.valueOf(typeA), Integer.valueOf(typeK));
                eventFilter.m_isNOT = Boolean.valueOf(condIsNot);
                filterList.add(eventFilter);
            }
            ++i;
        }
        return filterList;
    }

    public void storeFilter(File file, Iterator<EventFilter> it) {
        Document doc = FilterFactory.createXML(it);
        this.writeXml(doc, file);
    }

    public static Document createXML(Iterator<EventFilter> iter) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(FILTER_LIST);
            while (iter.hasNext()) {
                EventFilter ef = iter.next();
                FilterFactory.addFilter(doc, root, ef);
            }
            doc.appendChild(root);
        }
        catch (Throwable e) {
            RTLogger.print(2, "", e);
        }
        return doc;
    }

    public static void addFilter(Document doc, Element root, EventFilter ef) {
        Element filter = doc.createElement(FILTER);
        filter.setAttribute(FILTER_NAME, ef.toString());
        filter.setAttribute(LABEL, ef.getLabel());
        filter.setAttribute(COLUMN_NAME, ef.m_column);
        filter.setAttribute(ISNOT, "" + ef.m_isNOT);
        filter.setAttribute(PATTERN, ef.m_pattern);
        filter.setAttribute(CASE_SENSITIVE, "" + ef.m_caseSensitive);
        filter.setAttribute(MODE, "" + ef.m_mode);
        filter.setAttribute(IS_LOCKED, "false");
        filter.setAttribute(AVAILABILITY, "" + ef.m_Availability);
        filter.setAttribute(KPI, "" + ef.m_KPIs);
        root.appendChild(filter);
    }

    protected boolean writeXml(Document doc, File file) {
        return XMLFactory.writeXml(doc, file);
    }
}

