/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class HotSpotChart
extends Canvas {
    private static final String ELLIPSIS = "...";
    private LinkedHashMap<String, List<Integer>> m_data = null;
    private int margin = 5;
    private int textSpaceLeft = 100;
    private int textSpaceTop = 15;
    private int maxMsgs = 0;
    public static final Color COLOR_WARNING = new Color((Device)Display.getDefault(), 139, 163, 199);
    public static final Color COLOR_MINOR = new Color((Device)Display.getDefault(), 249, 249, 50);
    public static final Color COLOR_MAJOR = new Color((Device)Display.getDefault(), 237, 125, 44);
    public static final Color COLOR_RED = new Color((Device)Display.getDefault(), 255, 11, 11);
    private static int DRAW_FLAGS = 15;

    public HotSpotChart(Composite parent, int style, LinkedHashMap<String, List<Integer>> data) {
        super(parent, style);
        this.m_data = data;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                HotSpotChart.this.onPaint(event);
            }
        });
    }

    void onPaint(PaintEvent event) {
        Rectangle imgBounds = this.getClientArea();
        Rectangle bounds1 = new Rectangle(imgBounds.x, imgBounds.y, imgBounds.width, imgBounds.height);
        Image img = new Image((Device)Display.getDefault(), bounds1);
        GC gc = new GC((Drawable)img);
        Iterator<String> it = this.m_data.keySet().iterator();
        int max = -1;
        int maxBarLength = img.getBounds().width - this.textSpaceLeft;
        int fontHeight = gc.getFontMetrics().getHeight();
        int shiftY = fontHeight - 1;
        int y = this.textSpaceTop + 1;
        while (it.hasNext()) {
            int x = this.textSpaceLeft + 1;
            String host = it.next();
            List<Integer> sevs = this.m_data.get(host);
            if (max == -1) {
                max = this.getTotal(sevs);
                if ((max = (int)((double)max * 1.2)) < 10) {
                    max = 120;
                }
                int value = 0;
                this.drawYLabel(gc, max, maxBarLength, fontHeight, value);
                String str = "" + max;
                int l = str.length() - 1;
                int rounded = (int)Math.pow(10.0, l);
                int middle = max / rounded * rounded;
                int rounded0 = middle /= 4;
                int i = 1;
                while (this.drawYLabel(gc, max, maxBarLength, fontHeight, rounded0)) {
                    rounded0 = middle * i;
                    ++i;
                }
            }
            gc.setBackground(BMUI.color_white);
            gc.setForeground(BMUI.color_darkGrey);
            gc.drawLine(0, bounds1.height - 1, bounds1.width, bounds1.height - 1);
            gc.setForeground(BMUI.color_black);
            gc.drawText(this.shortenText(gc, host, this.textSpaceLeft), 0, y);
            int i = 2;
            while (i < sevs.size()) {
                Integer val = sevs.get(i);
                int width = (int)((double)maxBarLength * ((double)val.intValue() / (double)max));
                gc.setBackground(HotSpotChart.getColor(i));
                gc.fillRectangle(x, y, width, shiftY);
                x += width;
                ++i;
            }
            y += shiftY + 3;
        }
        event.gc.drawImage(img, 0, 0);
        gc.dispose();
        img.dispose();
    }

    private boolean drawYLabel(GC gc, int max, int maxBarLength, int fontHeight, int value) {
        boolean isNextPossible = false;
        String label = "" + value;
        int xt = (int)((double)maxBarLength * ((double)value / (double)max));
        int textW = gc.textExtent((String)label).x / 2;
        int x = this.textSpaceLeft + xt - textW;
        gc.setForeground(BMUI.color_black);
        gc.drawText(label, x, 0);
        gc.setForeground(BMUI.color_darkGrey);
        gc.drawLine(this.textSpaceLeft + xt, fontHeight - 1, this.textSpaceLeft + xt, 100);
        if ((double)x / (double)(maxBarLength + this.textSpaceLeft) < 0.8) {
            isNextPossible = true;
        }
        return isNextPossible;
    }

    public int getTotal(List<Integer> values) {
        int res = 0;
        for (Integer val : values) {
            res += val.intValue();
        }
        return res;
    }

    public static Color getColor(int severity) {
        Color res = BMUI.color_white;
        switch (severity) {
            case 2: {
                res = COLOR_WARNING;
                break;
            }
            case 3: {
                res = COLOR_MINOR;
                break;
            }
            case 4: {
                res = COLOR_MAJOR;
                break;
            }
            case 5: {
                res = COLOR_RED;
                break;
            }
        }
        return res;
    }

    protected String shortenText(GC gc, String t, int width) {
        if (t == null) {
            return null;
        }
        int size = gc.textExtent((String)t, (int)HotSpotChart.DRAW_FLAGS).x;
        if (size <= width) {
            return t;
        }
        int l = t.length();
        if (l <= 0) {
            return t;
        }
        int dots = gc.textExtent((String)ELLIPSIS, (int)HotSpotChart.DRAW_FLAGS).x;
        while (size + dots > width) {
            t = t.substring(0, t.length() - 1);
            size = gc.textExtent((String)t, (int)HotSpotChart.DRAW_FLAGS).x;
        }
        return String.valueOf(t) + ELLIPSIS;
    }
}

