/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

public class InputValidator {
    public static InputValidator m_instance = null;
    private static int m_integer = 0;
    private static long m_long = 0L;
    public static String MIN = "MIN";
    public static String MAX = "MAX";

    private InputValidator() {
    }

    public static InputValidator getInstance() {
        if (m_instance == null) {
            m_instance = new InputValidator();
        }
        return m_instance;
    }

    public static boolean validateInteger(String value) {
        try {
            m_integer = Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean validateInteger_MIN(String value, int minValue) {
        return InputValidator.validateInteger(value) && m_integer >= minValue;
    }

    public static boolean validateInteger_MAX(String value, int maxValue) {
        return InputValidator.validateInteger(value) && m_integer <= maxValue;
    }

    public static boolean validateInteger_MINMAX(String value, int minValue, int maxValue) {
        return InputValidator.validateInteger(value) && m_integer >= minValue && m_integer <= maxValue;
    }

    public static boolean validateLong(String value) {
        try {
            m_long = Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean validateLong_MIN(String value, long minValue) {
        return InputValidator.validateLong(value) && m_long >= minValue;
    }

    public static boolean validateLong_MAX(String value, long maxValue) {
        return InputValidator.validateLong(value) && m_long <= maxValue;
    }

    public static boolean validateLong_MINMAX(String value, long minValue, long maxValue) {
        return InputValidator.validateLong(value) && m_long >= minValue && m_long <= maxValue;
    }
}

