/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.gui.utils.MIBBrowserTreeFilterAbstract;
import com.blixx.boom.snmp.MibTreeObject;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;

public class MIBBrowserTreeFilterName
extends MIBBrowserTreeFilterAbstract {
    WeakHashMap<GroupTreeObject, Object> m_cache = null;
    List<GroupTreeObject> m_elements = new LinkedList<GroupTreeObject>();
    String m_text = null;
    String m_path = null;

    public MIBBrowserTreeFilterName(String text) {
        if (text != null && text.length() > 0) {
            this.m_text = text.toLowerCase();
            if (Pattern.matches("[\\.0-9]+", this.m_text)) {
                this.m_path = this.m_text.trim();
                if (!this.m_path.startsWith(".")) {
                    this.m_path = "." + this.m_path;
                }
                this.m_path = this.m_path.replace('.', '/');
            }
        }
    }

    public WeakHashMap<GroupTreeObject, Object> getCache(GroupTreeObject element) {
        if (this.m_cache == null || this.m_cache.size() == 0) {
            try {
                this.m_cache = new WeakHashMap();
                GroupTreeObject root = element.getRoot();
                this.m_cache.put(root, null);
                for (GroupTreeObject mto : root.getAllElements()) {
                    String label2 = mto.getName().toLowerCase();
                    if (mto instanceof MibTreeObject) {
                        label2 = ((MibTreeObject)mto).getLabel2().toLowerCase();
                    }
                    if (!label2.contains(this.m_text) && (this.m_path == null || !mto.getPath().contains(this.m_path))) continue;
                    this.addToCache(mto);
                    this.m_elements.add(mto);
                    for (GroupTreeObject groupTreeObject : mto.getAllElements()) {
                        this.addToCache(groupTreeObject);
                    }
                    while (mto.getParent() != null) {
                        this.addToCache(mto.getParent());
                        mto = mto.getParent();
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return this.m_cache;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.getCache((GroupTreeObject)element).containsKey(element);
    }

    public void addToCache(GroupTreeObject mto) {
        if (!this.m_cache.containsKey(mto)) {
            this.m_cache.put(mto, "");
        }
    }

    public List<GroupTreeObject> getFilteredElements() {
        return this.m_elements;
    }

    @Override
    public void cleanCache() {
        this.m_cache = null;
    }
}

