/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.gui.utils.MIBBrowserTreeFilterAbstract;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.Viewer;

public class MIBBrowserTreeFilterType
extends MIBBrowserTreeFilterAbstract {
    private WeakHashMap<String, Object> m_cache = null;
    private String m_type = null;

    public MIBBrowserTreeFilterType(String type) {
        if (type != null && type.length() > 0) {
            this.m_type = type.toUpperCase();
        }
    }

    public WeakHashMap<String, Object> getCache(GroupTreeObject element) {
        if (this.m_cache == null || this.m_cache.size() == 0) {
            try {
                GroupTreeObject root = element.getRoot();
                List<GroupTreeObject> allElements = root.findElementsByType(this.m_type);
                this.m_cache = new WeakHashMap(allElements.size() * 3, 0.9f);
                this.m_cache.put(root.getPath(), null);
                for (GroupTreeObject mto : allElements) {
                    this.addToCache(mto.getPath());
                    GroupTreeObject mtoParent = mto.getParent();
                    while (mtoParent != null && !this.m_cache.containsKey(mtoParent.getPath())) {
                        this.addToCache(mtoParent.getPath());
                        mtoParent = mtoParent.getParent();
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return this.m_cache;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        GroupTreeObject gto = (GroupTreeObject)element;
        return this.getCache(gto).containsKey(gto.getPath());
    }

    public void addToCache(String mtoPath) {
        this.m_cache.put(mtoPath, null);
    }

    @Override
    public void cleanCache() {
        this.m_cache = null;
    }
}

