/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.gui.views.BTableViewer;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.shared.SEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.TableColumn;

public class MessageBrowserTableFilter
extends ViewerFilter {
    private String m_searchText_lowercase = null;
    private BTableViewer m_tableViewer = null;
    private Set<Integer> m_columns = new TreeSet<Integer>();
    private Map<Object, Boolean> m_cache = new WeakHashMap<Object, Boolean>();
    public int m_filtered = 0;
    public int m_inactiveUnknown = 0;
    public int m_inactiveNormal = 0;
    public int m_inactiveWarning = 0;
    public int m_inactiveMinor = 0;
    public int m_inactiveMajor = 0;
    public int m_inactiveCritical = 0;

    public MessageBrowserTableFilter(MessageBrowserTab tab, String searchText) {
        if (searchText != null && searchText.length() > 0) {
            this.m_tableViewer = tab.getTableViewer();
            this.m_searchText_lowercase = searchText.toLowerCase();
        }
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        this.cleanCounters();
        this.m_columns.clear();
        TableColumn[] tableColumnArray = this.m_tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            if (this.isColumnVisible(col) && !this.ignoreColumn(col)) {
                this.m_columns.add(EventStorageUtils.getColumnPosition(col.getText()));
            }
            ++n2;
        }
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object element = elements[i];
            Boolean isMatched = this.m_cache.get(element);
            if (isMatched == null) {
                isMatched = this.select(viewer, parent, element);
                this.m_cache.put(element, isMatched);
            }
            if (isMatched.booleanValue()) {
                out.add(element);
            } else {
                this.countInvisible(element);
            }
            ++i;
        }
        this.m_filtered = elements.length - out.size();
        return out.toArray();
    }

    public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
        Object[] arr = this.filter(viewer, parentPath.getLastSegment(), elements);
        return arr;
    }

    public boolean select(Viewer arg0, Object arg1, Object arg2) {
        if (this.m_searchText_lowercase == null) {
            return true;
        }
        if (arg2 instanceof SEvent) {
            SEvent se = (SEvent)arg2;
            boolean matchCached = this.doMatch(se);
            return matchCached;
        }
        return false;
    }

    private boolean doMatch(SEvent se) {
        for (Integer colNum : this.m_columns) {
            String text = EventStorageUtils.getText(se, colNum);
            if (!text.toLowerCase().contains(this.m_searchText_lowercase)) continue;
            return true;
        }
        return false;
    }

    private boolean isColumnVisible(TableColumn col) {
        return col.getWidth() > 0;
    }

    private boolean ignoreColumn(TableColumn col) {
        return col.getText().equals("Severity") || col.getText().equals("Duplicates") || col.getText().equals("J") || col.getText().equals("AA") || col.getText().equals("!AV") || col.getText().equals("^KPI") || col.getText().equals("Owned") || col.getText().equals("Notifications");
    }

    private void countInvisible(Object element) {
        int sev = ((SEvent)element).getSeverityInt();
        if (sev < 0) {
            sev += 6;
        }
        switch (sev) {
            case 0: {
                ++this.m_inactiveUnknown;
                break;
            }
            case 1: {
                ++this.m_inactiveNormal;
                break;
            }
            case 2: {
                ++this.m_inactiveWarning;
                break;
            }
            case 3: {
                ++this.m_inactiveMinor;
                break;
            }
            case 4: {
                ++this.m_inactiveMajor;
                break;
            }
            case 5: {
                ++this.m_inactiveCritical;
                break;
            }
        }
    }

    private void cleanCounters() {
        this.m_inactiveUnknown = 0;
        this.m_inactiveNormal = 0;
        this.m_inactiveWarning = 0;
        this.m_inactiveMinor = 0;
        this.m_inactiveMajor = 0;
        this.m_inactiveCritical = 0;
        this.m_filtered = 0;
    }
}

