/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.PVDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PatternValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PatternComposite
extends Composite
implements ModifyListener,
SelectionListener,
MouseListener {
    private PVDialog m_pvd = null;
    private String m_type = PatternValidator.SIMPLIFIED;
    private String m_pattern = null;
    private PatternValidator m_patternValidator = null;
    private boolean m_isValid = false;
    private boolean m_isActive = false;
    private GUIDisplayElements m_gui = null;
    private StyledText m_patternInput_field = null;
    private Button m_activate_btn = null;
    private Label m_del_label = null;
    private static String ACTIVATE = "ACTIVATE";
    private static String DELETE = "DELETE";

    public PatternComposite(Composite parent, PVDialog pvd, PatternValidator patternValidator) {
        super(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(4, 4, true, false));
        this.m_pvd = pvd;
        this.m_patternValidator = patternValidator;
        this.m_gui = new GUIDisplayElements();
        this.m_activate_btn = this.m_gui.addRadioButton(this, ACTIVATE, "", false, 1, 1, 1, 1, this);
        ((GridData)this.m_activate_btn.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_patternInput_field = new StyledText((Composite)this, 2052);
        this.m_patternInput_field.setText("");
        this.m_patternInput_field.setEditable(true);
        this.m_patternInput_field.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_patternInput_field.addModifyListener((ModifyListener)this);
        this.m_del_label = new Label((Composite)this, 0);
        this.m_del_label.setImage(BMUI.IMAGE_DEL_14x14);
        this.m_del_label.setData((Object)DELETE);
        this.m_del_label.addMouseListener((MouseListener)this);
    }

    public void setPattern(String pattern, String type) {
        this.m_type = type;
        this.m_pattern = pattern;
        if (this.m_pattern == null || this.m_pattern.equals("")) {
            if (this.m_type.equals(PatternValidator.SIMPLIFIED)) {
                this.m_pattern = "<*>";
            } else if (this.m_type.equals(PatternValidator.JAVA)) {
                this.m_pattern = ".*";
            }
        }
        this.m_patternInput_field.setText(this.m_pattern);
        this.validatePattern();
    }

    public void setActive(boolean activate, boolean init) {
        this.m_isActive = activate;
        if (this.m_isActive) {
            if (!this.m_activate_btn.getSelection()) {
                this.m_activate_btn.setSelection(true);
            }
            this.validatePattern();
        } else if (!this.m_isActive) {
            this.m_activate_btn.setSelection(false);
        }
    }

    public boolean validatePattern() {
        this.m_isValid = this.m_patternValidator.validatePattern(this.m_type, this.m_patternInput_field);
        this.m_pvd.m_pattern = this.m_pattern = this.m_patternValidator.getPatternStr();
        this.m_pvd.m_patternObj = this.m_patternValidator.getPatternObj();
        this.m_pvd.cleanImages();
        return this.m_isValid;
    }

    public String getPattern() {
        return this.m_pattern.trim();
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public void disableDelBtn() {
        this.m_del_label.setEnabled(false);
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() instanceof StyledText) {
            try {
                if (this.m_pvd.m_isRunning) {
                    this.m_pvd.m_isCanceled = true;
                }
                if (this.m_pvd.m_tableViewer != null) {
                    this.m_pvd.m_tableViewer.getTable().deselectAll();
                    this.m_pvd.m_result_field.setText("");
                }
                this.m_isValid = this.validatePattern();
                this.m_pvd.checkButtonStatus();
                if (this.m_pvd.m_save_Button != null && !this.m_pvd.m_save_Button.isDisposed()) {
                    if (this.m_isValid) {
                        this.m_gui.enableField(this.m_pvd.m_save_Button, true);
                    } else {
                        this.m_gui.enableField(this.m_pvd.m_save_Button, false);
                    }
                }
                this.setActive(true, false);
                this.m_pvd.setActivePattern(this);
            }
            catch (Throwable throwable) {}
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button btn;
        String name;
        Object obj = e.getSource();
        if (obj instanceof Button && (name = (String)(btn = (Button)obj).getData()).equals(ACTIVATE)) {
            this.setActive(true, false);
            this.m_pvd.setActivePattern(this);
        }
    }

    public void mouseUp(MouseEvent e) {
        Label l;
        String name;
        Object o = e.getSource();
        if (o instanceof Label && (name = (String)(l = (Label)o).getData()).equals(DELETE)) {
            if (this.m_pvd.m_patternFields.size() > 1) {
                this.m_pvd.deletePatternField(this);
            } else if (this.m_pvd.m_patternFields.size() == 1) {
                new ShowMessageBox("   Delete Pattern", "Cannot delete last Pattern!", 2);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }
}

