/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.MultilineInputDialog;
import com.blixx.boom.gui.dialogs.PVDialog;
import com.blixx.boom.gui.dialogs.PatternValidationDialog;
import com.blixx.boom.gui.dialogs.PolicySearchTextTestingDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.log.RTLogger;
import com.blixx.shared.PatternB;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PatternMatching
implements IStructuredContentProvider,
ITableLabelProvider {
    public TableViewer m_tableViewer = null;
    private Table m_table = null;
    public HashMap<String, Image> m_imageList = new HashMap();
    public static String MATCH_TRUE = "match_true";
    public static String MATCH_FALSE = "match_false";
    public static String SINGLE_LINE = "single_line";
    public static String ALL_LINES = "all_lines";
    public static String JAVA = "JAVA";
    public static String OVO = "SIMPLIFIED";
    private PVDialog m_pvDialog = null;
    private PatternValidationDialog m_patternVDialog = null;
    private PolicySearchTextTestingDialog m_policySearchTextTestingDialog = null;
    public boolean m_isClear = true;
    public static int COLUMN_STATUS = 0;
    public static int COLUMN_PROCESSING_TIME = 1;
    public static int COLUMN_TEXT = 2;
    public final Action pasteAction = new Action("&Paste"){

        public void run() {
            block14: {
                boolean hasLimit = PatternMatching.this.hasLimeLimit();
                int lineLimit = PatternMatching.this.getLineLimit();
                if (hasLimit && PatternMatching.this.m_table.getItemCount() >= lineLimit) {
                    new ShowMessageBox("Paste", "The line limit is set to " + lineLimit + " lines!\nCurrent displayed lines are " + PatternMatching.this.m_table.getItemCount() + ".", 2);
                    PatternMatching.this.updateBtnAndLineCountStatus();
                    return;
                }
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                String contents = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                clipboard.dispose();
                if (contents != null) {
                    StringReader buf = new StringReader(contents);
                    BufferedReader reader = new BufferedReader(buf);
                    try {
                        try {
                            String line;
                            int count = 0;
                            int lastIndex = 0;
                            while ((line = reader.readLine()) != null) {
                                lastIndex = PatternMatching.this.m_table.getItemCount();
                                PatternMatching.this.addLine(line, null, lastIndex);
                                if (!hasLimit || PatternMatching.this.m_table.getItemCount() < lineLimit && ++count != lineLimit) continue;
                                new ShowMessageBox("Paste", "The line limit is set to " + lineLimit + " lines!\nAll remaining lines will be ignored!", 2);
                                break;
                            }
                            PatternMatching.this.m_table.setSelection(lastIndex);
                            PatternMatching.this.m_table.showItem(PatternMatching.this.m_table.getItem(lastIndex));
                            PatternMatching.this.m_table.getColumn(COLUMN_TEXT).pack();
                        }
                        catch (IOException iOException) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {}
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            PatternMatching.this.updateBtnAndLineCountStatus();
        }
    };
    public final Action patternExampleAction = new Action("&Pattern Example     ALT+Click"){

        public void run() {
            String text;
            TableItem[] selItem;
            if (PatternMatching.this.m_pvDialog != null && ((PatternMatching)PatternMatching.this).m_pvDialog.m_patternExample != null && (selItem = PatternMatching.this.m_table.getSelection()) != null && selItem.length == 1 && (text = selItem[0].getText(COLUMN_TEXT)) != null && text.length() > 0) {
                ((PatternMatching)PatternMatching.this).m_pvDialog.m_patternExample.setText(PatternMatching.this.m_pvDialog.getSuggestion(text));
            }
        }
    };

    public PatternMatching(TableViewer tableViewer, Object dialog) {
        this.m_tableViewer = tableViewer;
        this.m_table = tableViewer.getTable();
        this.loadImages();
        MenuManager viewerMenuManager = new MenuManager();
        viewerMenuManager.add((IAction)this.pasteAction);
        if (dialog != null && dialog instanceof PVDialog) {
            this.m_pvDialog = (PVDialog)dialog;
            this.patternExampleAction.setActionDefinitionId("PatternExample");
            if (this.m_pvDialog.m_patternExample != null) {
                viewerMenuManager.add((IAction)this.patternExampleAction);
            }
            this.pasteAction.setActionDefinitionId("PVDPaste");
        } else if (dialog != null && dialog instanceof PatternValidationDialog) {
            this.m_patternVDialog = (PatternValidationDialog)dialog;
        } else if (dialog != null && dialog instanceof PolicySearchTextTestingDialog) {
            this.m_policySearchTextTestingDialog = (PolicySearchTextTestingDialog)dialog;
        }
        Menu menu = viewerMenuManager.createContextMenu((Control)this.m_table);
        this.m_table.setMenu(menu);
        this.m_table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                boolean enabled = true;
                if (PatternMatching.this.m_patternVDialog != null && ((PatternMatching)PatternMatching.this).m_patternVDialog.m_isRunning) {
                    enabled = false;
                } else if (PatternMatching.this.m_pvDialog != null && ((PatternMatching)PatternMatching.this).m_pvDialog.m_isRunning) {
                    enabled = false;
                } else if (PatternMatching.this.m_policySearchTextTestingDialog != null && ((PatternMatching)PatternMatching.this).m_policySearchTextTestingDialog.m_isRunning) {
                    enabled = false;
                }
                PatternMatching.this.pasteAction.setEnabled(enabled);
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public boolean validatePattern(String patternStr, String patternType) {
        boolean isValid = false;
        try {
            if (patternType.equals(OVO)) {
                new PatternB(patternStr);
                isValid = true;
            } else if (patternType.equals(JAVA)) {
                Pattern.compile(patternStr, 32);
                isValid = true;
            }
            this.clearStatus();
        }
        catch (RuntimeException runtimeException) {}
        return isValid;
    }

    public void clearStatus() {
        if (this.m_isClear) {
            return;
        }
        TableItem[] items = this.m_table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getImage(COLUMN_STATUS) != null) {
                items[i].setImage(COLUMN_STATUS, null);
            }
            items[i].setText(1, "");
            ++i;
        }
        this.setStatus(true);
    }

    public TableItem addNewLine() {
        TableItem tableItem = null;
        Shell parent = Display.getCurrent().getActiveShell();
        MultilineInputDialog id = new MultilineInputDialog(parent, "Add Line", "Add Line: ", "", null);
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            int lastIndex = this.m_table.getItemCount();
            tableItem = this.addLine(id.getValue(), null, lastIndex);
            this.m_table.setSelection(lastIndex);
            this.m_table.getColumn(COLUMN_TEXT).pack();
        }
        return tableItem;
    }

    public TableItem addNewLine(String text) {
        TableItem tableItem = null;
        int lastIndex = this.m_table.getItemCount();
        tableItem = this.addLine(text, null, lastIndex);
        this.m_table.setSelection(lastIndex);
        this.m_table.getColumn(COLUMN_TEXT).pack();
        return tableItem;
    }

    public void removeLines() {
        int[] indices = this.m_table.getSelectionIndices();
        if (indices.length == 0) {
            return;
        }
        if (this.m_table.getSelectionCount() == this.m_table.getItemCount()) {
            this.m_table.removeAll();
        } else {
            this.m_table.setRedraw(false);
            this.m_table.remove(indices);
            this.m_table.setRedraw(true);
            if (this.m_table.getItemCount() > 0) {
                this.m_table.deselectAll();
                this.m_table.setSelection(0);
            }
        }
    }

    public TableItem editLine() {
        TableItem tableItem = null;
        if (this.m_table.getSelectionCount() > 0) {
            String newText;
            int[] indices = this.m_table.getSelectionIndices();
            int index = indices[0];
            TableItem item = this.m_table.getItem(index);
            String selection = item.getText(COLUMN_TEXT);
            Shell parent = Display.getCurrent().getActiveShell();
            MultilineInputDialog id = new MultilineInputDialog(parent, "Edit", "Edit Line: ", selection, null);
            id.setBlockOnOpen(true);
            int res = id.open();
            if (res == 0 && (newText = id.getValue()) != null && !newText.equals(selection)) {
                this.m_table.remove(index);
                tableItem = this.addLine(id.getValue(), null, index);
                this.m_table.update();
                this.m_table.deselectAll();
                this.m_table.setSelection(index);
                this.m_table.getColumn(COLUMN_TEXT).pack();
            }
        }
        return tableItem;
    }

    public TableItem editSTLine() {
        TableItem tableItem = null;
        if (this.m_table.getSelectionCount() > 0) {
            int[] indices = this.m_table.getSelectionIndices();
            int index = indices[0];
            TableItem item = this.m_table.getItem(index);
            String selection = item.getText(COLUMN_PROCESSING_TIME);
            Shell parent = Display.getCurrent().getActiveShell();
            MultilineInputDialog id = new MultilineInputDialog(parent, "Close", "Edit Line: ", selection, null);
            id.setBlockOnOpen(true);
            int res = id.open();
            if (res == 0) {
                String newText = id.getValue();
                String condNo = item.getText(COLUMN_STATUS);
                if (newText != null && !newText.equals(selection)) {
                    this.m_table.remove(index);
                    tableItem = this.addSTLine(condNo, id.getValue(), null, index);
                    this.m_table.update();
                    this.m_table.deselectAll();
                    this.m_table.setSelection(index);
                    this.m_table.getColumn(COLUMN_PROCESSING_TIME).pack();
                }
            }
        }
        return tableItem;
    }

    public void loadFromFile(boolean append) {
        UIJob load = new UIJob("" + append){

            /*
             * Loose catch block
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                block40: {
                    String fileName = null;
                    InputStreamReader fr = null;
                    BufferedReader br = null;
                    boolean hasLimit = PatternMatching.this.hasLimeLimit();
                    int lineLimit = PatternMatching.this.getLineLimit();
                    String mgsBoxTitle = "Load From File";
                    if (this.getName().startsWith("true")) {
                        mgsBoxTitle = "Append From File";
                    }
                    if (hasLimit && PatternMatching.this.m_table.getItemCount() >= lineLimit) {
                        new ShowMessageBox(mgsBoxTitle, "The line limit is set to " + lineLimit + " lines!\nCurrent displayed lines are " + PatternMatching.this.m_table.getItemCount() + ".", 2);
                        PatternMatching.this.updateBtnAndLineCountStatus();
                        return Status.OK_STATUS;
                    }
                    try {
                        FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                        fd.setText("Select File");
                        fileName = fd.open();
                        if (fileName != null) {
                            File file = new File(fileName);
                            if (file.canRead()) {
                                if (!this.getName().startsWith("true")) {
                                    PatternMatching.this.m_table.removeAll();
                                }
                                fr = new FileReader(file);
                                br = new BufferedReader(fr);
                                boolean eof = false;
                                int lines = 1000;
                                int count = 0;
                                while (!eof) {
                                    String line = br.readLine();
                                    TableItem item = null;
                                    if (line == null) {
                                        eof = true;
                                    } else {
                                        item = PatternMatching.this.appendLine(line, null);
                                        if (--lines <= 0) {
                                            PatternMatching.this.m_table.showItem(item);
                                            PatternMatching.this.m_table.update();
                                            lines = 1000;
                                        }
                                        ++count;
                                    }
                                    if (!hasLimit || PatternMatching.this.m_table.getItemCount() < lineLimit && count != lineLimit) continue;
                                    new ShowMessageBox(mgsBoxTitle, "The line limit is set to " + lineLimit + " lines!\nAll remaining lines will be ignored!", 2);
                                    eof = true;
                                }
                                if (PatternMatching.this.m_table.getItemCount() > 0) {
                                    int selection = 0;
                                    if (this.getName().startsWith("true")) {
                                        selection = PatternMatching.this.m_table.getItemCount() - 1;
                                    }
                                    PatternMatching.this.m_table.setSelection(selection);
                                    PatternMatching.this.m_table.showItem(PatternMatching.this.m_table.getItem(selection));
                                    PatternMatching.this.m_table.getColumn(COLUMN_TEXT).pack();
                                }
                            } else {
                                RTLogger.print(4, "cannot read file " + fileName);
                            }
                        }
                        PatternMatching.this.updateBtnAndLineCountStatus();
                    }
                    catch (RuntimeException e) {
                        RTLogger.print(4, "Error loading file " + fileName, e);
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable) {}
                        break block40;
                    }
                    catch (FileNotFoundException e) {
                        RTLogger.print(4, "file not found " + fileName, e);
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable) {}
                        break block40;
                    }
                    catch (IOException e) {
                        RTLogger.print(4, "IO error loading file " + fileName, e);
                        {
                            catch (Throwable throwable) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable2) {}
                                try {
                                    fr.close();
                                }
                                catch (Throwable throwable3) {}
                                throw throwable;
                            }
                        }
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable) {}
                        break block40;
                    }
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fr.close();
                    }
                    catch (Throwable throwable) {}
                }
                return Status.OK_STATUS;
            }
        };
        Repository.getUIJobManager().schedule(load);
    }

    public void saveToFile() {
        block13: {
            String path = null;
            boolean success = true;
            try {
                FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                fd.setText("Save To File");
                path = fd.open();
                if (path == null) break block13;
                File file = new File(path);
                if (file.exists()) {
                    success = file.delete();
                }
                if (success) {
                    File newFile = new File(path);
                    BufferedWriter out = new BufferedWriter(new FileWriter(newFile));
                    try {
                        TableItem[] tableItem = this.m_table.getItems();
                        int n = 0;
                        while (n < tableItem.length) {
                            out.write(String.valueOf(tableItem[n].getText(COLUMN_TEXT)) + "\n");
                            ++n;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {}
                        throw throwable;
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {}
                    break block13;
                }
                RTLogger.print(4, "error deleting file " + path);
            }
            catch (RuntimeException e) {
                RTLogger.print(5, "Error saving file: " + path, e);
            }
            catch (FileNotFoundException e) {
                RTLogger.print(5, "File does not exist: " + path, e);
            }
            catch (IOException e) {
                RTLogger.print(5, "Error saving pattern to file: " + path, e);
            }
        }
    }

    public void loadImages() {
        try {
            Image image1 = BMUI.IMAGE_ACCEPT_GREEN;
            Image image2 = BMUI.IMAGE_CANCEL_ROUND;
            this.m_imageList.put(MATCH_TRUE, image1);
            this.m_imageList.put(MATCH_FALSE, image2);
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error loading image", e);
        }
    }

    public TableItem addLine(String pattern, String type, int index) {
        TableItem item = new TableItem(this.m_table, 0, index);
        item.setText(new String[]{"", "", pattern});
        if (type != null) {
            item.setImage(COLUMN_STATUS, this.getImage(type));
        }
        return item;
    }

    public TableItem addSTLine(String condno, String pattern, String type, int index) {
        TableItem item = new TableItem(this.m_table, 0, index);
        item.setText(new String[]{condno, pattern});
        return item;
    }

    public TableItem appendLine(String pattern, String type) {
        TableItem item = new TableItem(this.m_table, 0);
        item.setText(new String[]{"", "", pattern});
        if (type != null) {
            item.setImage(COLUMN_STATUS, this.getImage(type));
        }
        return item;
    }

    public boolean hasLimeLimit() {
        boolean hasLimit = true;
        if (this.m_pvDialog != null) {
            hasLimit = this.m_pvDialog.hasLineLimitActive();
        } else if (this.m_patternVDialog != null) {
            hasLimit = this.m_patternVDialog.hasLineLimitActive();
        }
        return hasLimit;
    }

    public int getLineLimit() {
        int limit = -1;
        if (this.m_pvDialog != null && this.m_pvDialog.hasLineLimitActive()) {
            limit = this.m_pvDialog.getLineLimit();
        } else if (this.m_patternVDialog != null) {
            limit = this.m_patternVDialog.getLineLimit();
        } else if (this.m_policySearchTextTestingDialog != null) {
            limit = this.m_policySearchTextTestingDialog.getLineLimit();
        }
        return limit;
    }

    public void updateBtnAndLineCountStatus() {
        if (this.m_patternVDialog != null) {
            this.m_patternVDialog.updateLineCount();
            this.m_patternVDialog.checkButtonStatus();
        } else if (this.m_pvDialog != null) {
            this.m_pvDialog.updateLineCount();
            this.m_pvDialog.checkButtonStatus();
        } else if (this.m_policySearchTextTestingDialog != null) {
            this.m_policySearchTextTestingDialog.updateLineCount();
            this.m_policySearchTextTestingDialog.checkButtonStatus();
        }
    }

    public void setStatus(boolean isClear) {
        this.m_isClear = isClear;
    }

    public Image getImage(String type) {
        return this.m_imageList.get(type);
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void paste() {
        this.pasteAction.run();
        this.m_table.getColumn(COLUMN_TEXT).pack();
    }
}

