/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;

public class PolicyRenamingValidation
implements IStructuredContentProvider,
ITableLabelProvider {
    private TableViewer m_tableViewer = null;
    private HashMap<String, GroupTreeObjectLast> m_policies = null;
    private HashMap<String, GroupTreeObjectLast> m_policies_orig = null;
    private HashMap<String, GroupTreeObjectLast> m_conflicts = null;
    public HashMap<String, Image> m_imageList = new HashMap();
    public static String MON = "mon";
    public static String MSG = "msg";
    public static String MATCH_TRUE = "match_true";
    public static String MATCH_FALSE = "match_false";
    public static String INIT = "INIT";
    public static String UPDATE = "UPDATE";

    public PolicyRenamingValidation(TableViewer tableViewer, HashMap<String, GroupTreeObjectLast> hashMap1, HashMap<String, GroupTreeObjectLast> hashMap2) {
        this.m_tableViewer = tableViewer;
        this.m_policies_orig = hashMap1;
        this.m_policies = hashMap2;
        this.loadImages();
    }

    public void initTable() {
        this.refreshTable(INIT);
    }

    public void resetTable() {
        this.refreshTable(INIT);
    }

    public void updateTable() {
        this.refreshTable(UPDATE);
    }

    public void refreshTable(String type) {
        this.m_tableViewer.getTable().removeAll();
        Set<String> keys = this.m_policies.keySet();
        for (String name : keys) {
            GroupTreeObjectLast gtol = this.m_policies.get(name);
            if (type.equals(INIT)) {
                this.appendLine(gtol.getName(), gtol.getPath(), gtol.getTreeObject().getType(), null);
                continue;
            }
            if (!type.equals(UPDATE)) continue;
            this.appendLine(name, gtol.getPath(), gtol.getTreeObject().getType(), null);
        }
    }

    public int preview(String string1, String string2, String type) {
        HashMap<String, String> hm = new HashMap<String, String>();
        this.m_conflicts = new HashMap();
        String name_new = null;
        int numOfConflicts = 0;
        this.m_tableViewer.getTable().removeAll();
        Set<String> keys = this.m_policies_orig.keySet();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(keys);
        Collections.sort(list);
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            boolean validOk = false;
            String name_old = (String)iter.next();
            GroupTreeObjectLast gtol = this.m_policies_orig.get(name_old);
            String name = gtol.getName();
            if (type.equals(PolicyRenamingDialog.PREFIX_SUFFIX)) {
                name_new = String.valueOf(string1) + name + string2;
                validOk = this.validateName(name_new, gtol.getTreeObject().getType());
            } else if (type.equals(PolicyRenamingDialog.FIND_REPLACE)) {
                name_new = string1.length() == 0 ? name : (name.contains(string1) ? name.replaceAll("\\Q" + string1 + "\\E", string2) : name);
                validOk = this.validateName(name_new, gtol.getTreeObject().getType());
            }
            if (validOk) {
                this.appendLine(name_new, gtol.getPath(), gtol.getTreeObject().getType(), MATCH_TRUE);
            } else {
                this.appendLine(name_new, gtol.getPath(), gtol.getTreeObject().getType(), MATCH_FALSE);
                ++numOfConflicts;
                this.m_conflicts.put(name_new, gtol);
            }
            hm.put(name_old, name_new);
        }
        if (!hm.isEmpty()) {
            this.updateHashmap(hm);
        }
        return numOfConflicts;
    }

    public void updateHashmap(HashMap<String, String> hm) {
        Set<String> keys = hm.keySet();
        for (String name_old : keys) {
            String name_new;
            if (name_old.equalsIgnoreCase(name_new = hm.get(name_old))) continue;
            GroupTreeObjectLast gtol = this.m_policies.get(name_old);
            this.m_policies.remove(name_old);
            this.m_policies.put(name_new, gtol);
        }
    }

    public boolean validateName(String name, String type) {
        boolean isValid = false;
        if (name.length() < 1) {
            return false;
        }
        GroupTreeObject policyRoot = PolicyManager.getInstance().getPolicyTree();
        GroupTreeObjectLast gtol = policyRoot.findElement(name, type);
        if (gtol == null) {
            isValid = true;
        }
        if (name.startsWith(".")) {
            return false;
        }
        return isValid;
    }

    public void appendLine(String name, String path, String type, String status) {
        TableItem item = new TableItem(this.m_tableViewer.getTable(), 0);
        item.setText(new String[]{"", "", name, this.getDisplayPath(path)});
        if (status != null) {
            item.setImage(0, this.getImage(status));
        }
        if (type != null) {
            item.setImage(1, this.getImage(type));
        }
    }

    public String getDisplayPath(String treePath) {
        String path = null;
        if (treePath.startsWith("/root/")) {
            path = treePath.substring(6);
        }
        return path;
    }

    public void removeLines() {
        if (this.m_tableViewer.getTable().getSelectionCount() > 0) {
            TableItem[] items = this.m_tableViewer.getTable().getSelection();
            int index = 0;
            while (index < items.length) {
                TableItem ti = items[index];
                String name = ti.getText(2);
                if (this.m_policies.containsKey(name)) {
                    this.m_policies.remove(name);
                }
                ++index;
            }
            int[] indices = this.m_tableViewer.getTable().getSelectionIndices();
            this.m_tableViewer.getTable().remove(indices);
        }
    }

    public void removeConflicts() {
        String type = null;
        TableItem[] items = this.m_tableViewer.getTable().getItems();
        int index = 0;
        while (index < items.length) {
            TableItem ti = items[index];
            Image image = ti.getImage(0);
            type = this.getImageType(image);
            String name = ti.getText(2);
            if (type != null && type.equalsIgnoreCase(MATCH_FALSE) && this.m_policies.containsKey(name)) {
                this.m_policies.remove(name);
            }
            ++index;
        }
        this.updateTable();
    }

    public void clearStatus() {
        TableItem[] items = this.m_tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setImage(0, null);
            ++i;
        }
    }

    public HashMap<String, GroupTreeObjectLast> getConflicts() {
        return this.m_conflicts;
    }

    public void loadImages() {
        try {
            this.m_imageList.put(MATCH_TRUE, BMUI.IMAGE_ACCEPT_GREEN);
            this.m_imageList.put(MATCH_FALSE, BMUI.IMAGE_CANCEL_ROUND);
            this.m_imageList.put(MON, BMUI.IMAGE_MON);
            this.m_imageList.put(MSG, BMUI.IMAGE_MSG);
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error loading image", e);
        }
    }

    public Image getImage(String type) {
        return this.m_imageList.get(type);
    }

    public String getImageType(Image image) {
        String type2 = null;
        if (this.m_imageList.containsValue(image)) {
            Set<String> keys = this.m_imageList.keySet();
            for (String type2 : keys) {
                Image img = this.m_imageList.get(type2);
                if (img.equals((Object)image)) break;
            }
        }
        return type2;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

