/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PolicyTreeFilter
extends ViewerFilter {
    private String m_text = null;
    private List<String> m_textList = null;
    List<GroupTreeObject> m_elements = null;
    WeakHashMap<GroupTreeObject, Object> m_cache = new WeakHashMap();

    public PolicyTreeFilter(String text) {
        this.m_elements = new ArrayList<GroupTreeObject>();
        if (text != null && text.length() > 0) {
            this.m_text = text.toLowerCase();
        }
    }

    public PolicyTreeFilter(List<String> textList) {
        this.m_elements = new ArrayList<GroupTreeObject>();
        if (textList != null) {
            this.m_textList = textList;
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.m_text == null && this.m_textList == null) {
            return true;
        }
        if (element instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)element;
            ITreeObject ito = gtol.getTreeObject();
            if (ito != null) {
                if (this.m_text != null) {
                    if (ito.getComparableName().toLowerCase().contains(this.m_text)) {
                        this.m_elements.add(gtol);
                        return true;
                    }
                } else if (this.m_textList != null) {
                    int i = 0;
                    while (i < this.m_textList.size()) {
                        String agtName = this.m_textList.get(i);
                        if (ito.getComparableName().toLowerCase().contains(agtName)) {
                            this.m_elements.add(gtol);
                            return true;
                        }
                        ++i;
                    }
                }
            }
            return false;
        }
        if (this.m_cache.containsKey(element)) {
            return true;
        }
        GroupTreeObject gto = (GroupTreeObject)element;
        if (gto.getParent() != null && gto.getParent().getName().equals("root")) {
            this.m_cache.put(gto, "");
            return true;
        }
        for (GroupTreeObject child : gto.getElements()) {
            boolean hasChildMatched = this.select(viewer, gto, child);
            if (!hasChildMatched) continue;
            this.m_cache.put(gto, "");
            return true;
        }
        return false;
    }

    public List<GroupTreeObject> getFilteredElements() {
        return this.m_elements;
    }

    public Collection<GroupTreeObject> getFilteredFolders() {
        return this.m_cache.keySet();
    }
}

