/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.MessageBrowserTableFilter;
import com.blixx.boom.gui.views.BTableViewer;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.log.RTLogger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QuickFilterComposite {
    private Object m_object = null;
    private Composite m_searchComp = null;
    private Text m_searchText = null;
    private Label m_filterIcon = null;
    protected static final String APPLY_FILTER = "APPLY_FILTER";
    protected static final String REMOVE_FILTER = "REMOVE_FILTER";
    private MessageBrowserTableFilter m_filter;
    private StartSearchUIJob m_uijob = null;
    private Future<Boolean> m_uiJobFuture = null;
    private static ScheduledThreadPoolExecutor m_executor = new ScheduledThreadPoolExecutor(1);

    public QuickFilterComposite(Composite parent, Object object) {
        this.m_object = object;
        this.m_uijob = new StartSearchUIJob();
        this.createComposite(parent);
    }

    public void createComposite(Composite parent) {
        this.m_searchComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        this.m_searchComp.setLayout((Layout)gl);
        this.m_searchComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_filterIcon = new Label(this.m_searchComp, 0);
        this.m_filterIcon.setImage(BMUI.IMAGE_FILTERED_14x14);
        this.m_filterIcon.setEnabled(false);
        this.m_searchText = new Text(this.m_searchComp, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 10;
        this.m_searchText.setLayoutData((Object)gd);
        GUIDisplayElements gui = new GUIDisplayElements();
        gui.addDefaultTextContentMenu(this.m_searchText, true);
        this.m_searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                QuickFilterComposite.this.runFilter();
            }
        });
    }

    public void setCompositeLayoutData(GridData gridData) {
        this.m_searchComp.setLayoutData((Object)gridData);
        this.m_searchComp.layout(true);
    }

    public void setTextMinWidth(int minWidth) {
        ((GridData)this.m_searchText.getLayoutData()).minimumWidth = minWidth;
    }

    public void setFilter(String text) {
        try {
            this.m_searchText.setText(text);
            this.applyFilter();
        }
        catch (Throwable throwable) {}
    }

    public String getFilter() {
        try {
            return this.m_searchText.getText();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void applyFilter() {
        if (this.m_searchText.getText().trim().length() > 0) {
            this.setFilter();
        } else {
            this.removeFilter();
            this.m_uiJobFuture.cancel(true);
            this.m_uiJobFuture = null;
        }
    }

    private void setFilter() {
        String searchText_trimmed = this.m_searchText.getText().trim();
        if (this.m_object instanceof MessageBrowserTab) {
            MessageBrowserTab tab = (MessageBrowserTab)((Object)this.m_object);
            BTableViewer tv = tab.getTableViewer();
            try {
                LinkedList<ViewerFilter> filters = new LinkedList<ViewerFilter>(Arrays.asList(tv.getFilters()));
                if (this.m_filter != null) {
                    filters.remove((Object)this.m_filter);
                }
                this.m_filter = new MessageBrowserTableFilter(tab, searchText_trimmed);
                filters.add(this.m_filter);
                tv.setFilters(filters.toArray(new ViewerFilter[0]));
                tab.createSummary();
            }
            catch (Throwable e) {
                RTLogger.print(5, "", e);
            }
            this.activateFilterIcon(true);
        }
    }

    public void removeFilter() {
        this.activateFilterIcon(false);
        this.clearSearchText();
        if (this.m_filter != null && this.m_object instanceof MessageBrowserTab) {
            MessageBrowserTab tab = (MessageBrowserTab)((Object)this.m_object);
            BTableViewer tv = tab.getTableViewer();
            tv.removeFilter(this.m_filter);
            this.m_filter = null;
        }
    }

    public void clearSearchText() {
        if (this.m_searchText.getText().length() > 0) {
            this.m_searchText.setText("");
        }
    }

    public void setSearchText(String text) {
        if (text != null && text.length() > 0) {
            this.m_searchText.setText(text);
        }
    }

    public void activateFilterIcon(boolean activate) {
        this.m_filterIcon.setEnabled(activate);
    }

    public void runFilter() {
        if (this.m_uiJobFuture != null) {
            this.m_uiJobFuture.cancel(true);
        }
        this.m_uiJobFuture = m_executor.schedule(this.m_uijob, 1L, TimeUnit.SECONDS);
    }

    public class StartSearchUIJob
    implements Callable<Boolean> {
        @Override
        public Boolean call() throws Exception {
            UIJob uijob = new UIJob("QF" + QuickFilterComposite.this.m_object){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    QuickFilterComposite.this.applyFilter();
                    return Status.OK_STATUS;
                }
            };
            UIJobManager.getInstance().schedule(uijob);
            return true;
        }
    }
}

