/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.gui.utils.IRefreshListener;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class STreeViewer
extends TreeViewer {
    protected static Map<TreeViewer, GroupTreeObject> m_trees = new ConcurrentHashMap<TreeViewer, GroupTreeObject>();
    protected Map<IRefreshListener, Object> m_linkedViews = new HashMap<IRefreshListener, Object>();

    public STreeViewer(Composite parent) {
        super(parent);
    }

    public STreeViewer(Tree tree) {
        super(tree);
    }

    public STreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void addRefreshListener(IRefreshListener rl) {
        this.m_linkedViews.put(rl, null);
    }

    public void removeRefreshListener(IRefreshListener rl) {
        this.m_linkedViews.remove(rl);
    }

    protected void notifyRefreshListeners() {
        try {
            Object input = this.getInput();
            if (input != null && input instanceof GroupTreeObject) {
                GroupTreeObject updatedGTO = (GroupTreeObject)input;
                Iterator<IRefreshListener> it = this.m_linkedViews.keySet().iterator();
                while (it.hasNext()) {
                    it.next().linkedRefresh(updatedGTO);
                }
            }
        }
        catch (Throwable throwable) {}
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        if (input != null && input instanceof GroupTreeObject) {
            m_trees.put(this, (GroupTreeObject)input);
            this.notifyRefreshListeners();
        }
    }

    public void refresh(Object element, boolean updateLabels) {
        this.getTree().setRedraw(false);
        try {
            super.refresh(element, updateLabels);
            this.notifyRefreshListeners();
        }
        catch (Throwable throwable) {
            try {
                this.getTree().setRedraw(true);
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            this.getTree().setRedraw(true);
        }
        catch (Throwable throwable) {}
    }

    public void setSelection(ISelection selection, boolean reveal) {
        super.setSelection(selection, reveal);
    }
}

