/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.utils;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.AdmConfigEditDialog;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.IntervalHelpListener;
import com.blixx.boom.gui.views.ServerJobTab;
import com.blixx.boom.gui.views.ServerJobsStatusTab;
import com.blixx.boom.gui.views.SimpleTableProvider;
import com.blixx.log.RTLogger;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.ListAttribute;
import com.blixx.shared.jobs.MapAttribute;
import com.blixx.shared.jobs.PasswordAttribute;
import com.blixx.shared.jobs.SelectAttribute;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.jobs.UnsupportedTypeException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ServerJobTabComposite
extends Composite
implements ModifyListener,
SelectionListener,
MouseListener {
    private CTabItem m_cTab = null;
    public AbstractAttribute m_attribute = null;
    private String m_attr_type = null;
    private SimpleTableProvider m_tableProvider = null;
    private boolean m_isReadOnly = false;
    private Text m_tableEditorText = null;
    private GUIDisplayElements gui = new GUIDisplayElements();
    private Text m_text_field = null;
    private Text m_pwd_field = null;
    private Button m_checkbox = null;
    private CCombo m_combo = null;
    private org.eclipse.swt.widgets.List m_UIList = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private Label m_edit_image = null;
    private Label m_add_image = null;
    private Label m_del_image = null;
    private Label m_up_image = null;
    private Label m_down_image = null;
    public static final String ATTRIBUTE_TABLE = "SJOBS_OVERVIEW_TABLE";
    public static String OBJECT = "OBJECT";
    public static String KEY_EDITABLE = "KEY_EDITABLE";
    public static String VALUE_EDITABLE = "VALUE_EDITABLE";
    public static String MAP = "MAP";
    public static String TYPE_TEXT = "TYPE_TEXT";
    public static String TYPE_PASSWORD = "TYPE_PASSWORD";
    public static String TYPE_MAP = "TYPE_MAP";
    public static String TYPE_LIST = "TYPE_LIST";
    public static String TYPE_COMBO = "TYPE_COMBO";
    public static String ACTIVE = "ACTIVE";
    public static String TYPE = "TYPE";
    public static String EDIT = "Edit";
    public static String ADD = "Add";
    public static String DEL = "Del";
    public static String UP = "Up";
    public static String DOWN = "Down";

    public ServerJobTabComposite(Composite parent, AbstractAttribute attribute, CTabItem ctab) {
        super(parent, 0);
        this.m_attribute = attribute;
        this.m_attr_type = this.m_attribute.getType();
        this.m_cTab = ctab;
        this.m_isReadOnly = ServerJobsStatusTab.isReadOnly();
        if (this.m_attr_type.equals("text")) {
            this.createTextComposite();
        } else if (this.m_attr_type.equals("list")) {
            this.createListComposite();
        } else if (this.m_attr_type.equals("check")) {
            this.createCheckboxComposite();
        } else if (this.m_attr_type.equals("select")) {
            this.createCComboComposite();
        } else if (this.m_attr_type.equals("map")) {
            this.createTableComposite();
        } else if (this.m_attr_type.equals("password")) {
            this.createPasswordComposite();
        }
    }

    public void createTextComposite() {
        String desc;
        TextAttribute attribute = (TextAttribute)this.m_attribute;
        String label = String.valueOf(attribute.getLabel()) + ": ";
        if (label == null || label.length() == 0) {
            return;
        }
        String value = attribute.getValue();
        if (value == null) {
            value = "";
        }
        if ((desc = attribute.getDescription()) == null) {
            desc = "";
        }
        boolean editable = attribute.isEditable();
        if (this.m_isReadOnly) {
            editable = false;
        }
        if (value.indexOf(10) != -1 || attribute.getHeight() > 0) {
            this.setCompositeLayout(2);
            int heightHint = 70;
            if (attribute.getHeight() > 0) {
                heightHint = attribute.getHeight();
            }
            this.m_text_field = this.gui.addInputFieldMultiLine(this, TYPE_TEXT, label, value, 1, 1, heightHint, 100, 5, 1, this);
        } else if (this.m_cTab instanceof ServerJobTab && label.startsWith("Interval:")) {
            this.setCompositeLayout(3);
            this.m_text_field = this.gui.addInputFieldSingle(this, TYPE_TEXT, label, value, 1, 1, 5, 1, 100, this);
            Label helpIcon = new Label((Composite)this, 0);
            helpIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            helpIcon.setImage(BMUI.IMAGE_HELP);
            helpIcon.addListener(4, (Listener)new IntervalHelpListener());
        } else {
            this.setCompositeLayout(2);
            this.m_text_field = this.gui.addInputFieldSingle(this, TYPE_TEXT, label, value, 1, 1, 5, 1, 100, this);
        }
        try {
            if (attribute.getWidth() > 0) {
                GridData gd = (GridData)this.m_text_field.getLayoutData();
                gd.widthHint = attribute.getWidth();
            }
        }
        catch (Throwable throwable) {}
        this.m_text_field.setEditable(editable);
        this.m_text_field.setToolTipText(desc);
    }

    public void createListComposite() {
        this.setCompositeLayout(1);
        ListAttribute attribute = (ListAttribute)this.m_attribute;
        String label = String.valueOf(attribute.getLabel()) + ": ";
        if (label == null || label.length() == 0) {
            return;
        }
        String desc = attribute.getDescription();
        if (desc == null) {
            desc = "";
        }
        boolean editable = attribute.isEditable();
        Group grp = new Group((Composite)this, 0);
        grp.setText(label);
        grp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.verticalIndent = 10;
        grp.setLayoutData((Object)gd);
        Composite compLeft = new Composite((Composite)grp, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compLeft.setLayout((Layout)gl);
        compLeft.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 2820;
        this.m_UIList = new org.eclipse.swt.widgets.List(compLeft, style);
        this.m_UIList.setToolTipText(desc);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 120;
        gd.widthHint = 10;
        gd.verticalSpan = 3;
        this.m_UIList.setLayoutData((Object)gd);
        if (!this.m_isReadOnly) {
            this.m_UIList.addSelectionListener((SelectionListener)this);
            this.m_UIList.addMouseListener((MouseListener)this);
            this.addContentMenuToUIList();
        }
        this.refreshList(null);
        if (editable) {
            Composite compRight = new Composite((Composite)grp, 0);
            gl = new GridLayout(1, true);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.horizontalSpacing = 10;
            compRight.setLayout((Layout)gl);
            compRight.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.m_edit_image = this.createSelectableIcon(compRight, BMUI.IMAGE_EDIT, EDIT, false, this.m_UIList);
            this.m_add_image = this.createSelectableIcon(compRight, BMUI.IMAGE_ADD, ADD, true, this.m_UIList);
            this.m_del_image = this.createSelectableIcon(compRight, BMUI.IMAGE_DEL, DEL, false, this.m_UIList);
        }
    }

    public void addContentMenuToUIList() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)this.m_UIList);
        this.m_UIList.setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new AddElementAction(TYPE_LIST));
                    String[] sel = ServerJobTabComposite.this.m_UIList.getSelection();
                    if (sel.length > 0) {
                        manager.add((IAction)new EditElementAction(TYPE_LIST));
                        manager.add((IAction)new DeleteElementAction(TYPE_LIST));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu for UIList", e);
                }
            }
        });
    }

    public void createCheckboxComposite() {
        this.setCompositeLayout(2);
        CheckAttribute attribute = (CheckAttribute)this.m_attribute;
        String label = attribute.getLabel();
        if (label == null || label.length() == 0) {
            return;
        }
        boolean value = attribute.getValue();
        String desc = attribute.getDescription();
        if (desc == null) {
            desc = "";
        }
        boolean editable = attribute.isEditable();
        if (this.m_isReadOnly) {
            editable = false;
        }
        this.m_checkbox = this.gui.addCheckbox(this, "", label, value, 1, 1, 1, this);
        ((GridData)this.m_checkbox.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_checkbox.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_checkbox.setToolTipText(desc);
        this.m_checkbox.setEnabled(editable);
    }

    public void createCComboComposite() {
        SelectAttribute attribute = (SelectAttribute)this.m_attribute;
        String label = String.valueOf(attribute.getLabel()) + ": ";
        if (label == null || label.length() == 0) {
            return;
        }
        String selection = attribute.getValue();
        List<String> list = attribute.getList();
        if (list == null) {
            return;
        }
        String desc = attribute.getDescription();
        if (desc == null) {
            desc = "";
        }
        boolean editable = attribute.isEditable();
        this.m_combo = this.gui.addDropDown(this, "", label, new String[0], null, desc, 1, 1, 15, 5, null);
        ((GridData)this.m_combo.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_combo.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_combo.getLayoutData()).widthHint = 40;
        if (!this.m_isReadOnly) {
            this.m_combo.addSelectionListener((SelectionListener)this);
        }
        this.refreshCombo(selection);
        if (editable) {
            this.setCompositeLayout(5);
            Composite compBtn = new Composite((Composite)this, 0);
            GridLayout gl = new GridLayout(3, true);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.horizontalSpacing = 10;
            compBtn.setLayout((Layout)gl);
            compBtn.setLayoutData((Object)new GridData(4, 1024, false, false));
            this.m_edit_image = this.createSelectableIcon(compBtn, BMUI.IMAGE_EDIT, EDIT, !this.m_isReadOnly, this.m_combo);
            this.m_add_image = this.createSelectableIcon(compBtn, BMUI.IMAGE_ADD, ADD, !this.m_isReadOnly, this.m_combo);
            this.m_del_image = this.createSelectableIcon(compBtn, BMUI.IMAGE_DEL, DEL, !this.m_isReadOnly, this.m_combo);
        } else {
            this.setCompositeLayout(4);
        }
    }

    public void createTableComposite() {
        this.setCompositeLayout(2);
        MapAttribute attribute = (MapAttribute)this.m_attribute;
        String label = attribute.getLabel();
        if (label == null || label.length() == 0) {
            return;
        }
        String desc = attribute.getDescription();
        if (desc == null) {
            desc = "";
        }
        boolean editable = attribute.isEditable();
        boolean keyEditable = attribute.isKeyEditable();
        boolean valueEditable = attribute.isValueEditable();
        this.m_table = new Table((Composite)this, 268503812);
        this.m_table.setData(KEY_EDITABLE, (Object)keyEditable);
        this.m_table.setData(VALUE_EDITABLE, (Object)valueEditable);
        TableColumn col1 = new TableColumn(this.m_table, 16384);
        col1.setText("Key");
        col1.setWidth(200);
        TableColumn col2 = new TableColumn(this.m_table, 16384);
        col2.setText("Value");
        col2.setWidth(200);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(TYPE, (Object)ATTRIBUTE_TABLE);
        this.m_tableProvider = new SimpleTableProvider(this.m_tableViewer);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        if (!this.m_isReadOnly) {
            this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSource() instanceof TableViewer) {
                        int selCount = ((TableViewer)event.getSource()).getTable().getSelectionCount();
                        if (ServerJobTabComposite.this.m_del_image != null && ((MapAttribute)ServerJobTabComposite.this.m_attribute).isEditable()) {
                            if (selCount > 0) {
                                ServerJobTabComposite.this.m_del_image.setEnabled(true);
                            } else {
                                ServerJobTabComposite.this.m_del_image.setEnabled(false);
                            }
                        }
                    }
                }
            });
        }
        this.refreshTable();
        if (!this.m_isReadOnly) {
            final TableEditor editor = new TableEditor(this.m_table);
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            this.m_table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent event) {
                    Control old = editor.getEditor();
                    if (old != null) {
                        old.dispose();
                    }
                    Point pt = new Point(event.x, event.y);
                    final TableItem ti = ServerJobTabComposite.this.m_table.getItem(pt);
                    if (ti == null) {
                        return;
                    }
                    ServerJobTabComposite.this.m_table.setSelection(ti);
                    int column = -1;
                    int i = 0;
                    int n = ServerJobTabComposite.this.m_table.getColumnCount();
                    while (i < n) {
                        Rectangle rect = ti.getBounds(i);
                        if (rect.contains(pt)) {
                            column = i;
                            break;
                        }
                        ++i;
                    }
                    boolean keyEditable = (Boolean)ServerJobTabComposite.this.m_table.getData(KEY_EDITABLE);
                    boolean valueEditable = (Boolean)ServerJobTabComposite.this.m_table.getData(VALUE_EDITABLE);
                    if (column == 0 && !keyEditable) {
                        return;
                    }
                    if (column == 1 && !valueEditable) {
                        return;
                    }
                    ServerJobTabComposite.this.m_tableEditorText = new Text((Composite)ServerJobTabComposite.this.m_table, 0);
                    ServerJobTabComposite.this.m_tableEditorText.setForeground(ti.getForeground());
                    ServerJobTabComposite.this.m_tableEditorText.setText(ti.getText(column));
                    ServerJobTabComposite.this.m_tableEditorText.setForeground(ti.getForeground());
                    ServerJobTabComposite.this.m_tableEditorText.selectAll();
                    ServerJobTabComposite.this.m_tableEditorText.setFocus();
                    editor.minimumWidth = ((ServerJobTabComposite)ServerJobTabComposite.this).m_tableEditorText.getBounds().width;
                    editor.setEditor((Control)ServerJobTabComposite.this.m_tableEditorText, ti, column);
                    final int col = column;
                    ServerJobTabComposite.this.m_tableEditorText.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent event) {
                            ServerJobTabComposite.this.setCTabDirty(true);
                            ti.setText(col, ServerJobTabComposite.this.m_tableEditorText.getText());
                            ServerJobTabComposite.this.updateAttributeObject(TYPE_MAP);
                        }
                    });
                    ServerJobTabComposite.this.m_tableEditorText.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            switch (event.keyCode) {
                                case 13: {
                                    ServerJobTabComposite.this.m_tableEditorText.dispose();
                                    break;
                                }
                                case 27: {
                                    ServerJobTabComposite.this.m_tableEditorText.dispose();
                                }
                            }
                        }
                    });
                }
            });
        }
        if (editable) {
            Composite compBtn = new Composite((Composite)this, 0);
            GridLayout gl = new GridLayout(1, true);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.horizontalSpacing = 10;
            compBtn.setLayout((Layout)gl);
            compBtn.setLayoutData((Object)new GridData(4, 128, false, false));
            this.m_add_image = this.createSelectableIcon(compBtn, BMUI.IMAGE_ADD, ADD, !this.m_isReadOnly, this.m_table);
            this.m_del_image = this.createSelectableIcon(compBtn, BMUI.IMAGE_DEL, DEL, false, this.m_table);
            this.m_up_image = this.createSelectableIcon(compBtn, BMUI.IMAGE_ARROW_UP2, UP, !this.m_isReadOnly, this.m_table);
            this.m_down_image = this.createSelectableIcon(compBtn, BMUI.IMAGE_ARROW_DOWN2, DOWN, !this.m_isReadOnly, this.m_table);
        }
    }

    public void refreshTable() {
        Object map = ((MapAttribute)this.m_attribute).getValue();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            String[] elements = new String[]{key, value};
            rows.add(elements);
        }
        this.m_tableViewer.setInput(rows);
    }

    public void refreshList(String selection) {
        this.m_UIList.removeAll();
        Object list = ((ListAttribute)this.m_attribute).getValue();
        int i = 0;
        while (i < list.size()) {
            this.m_UIList.add((String)list.get(i));
            ++i;
        }
        if (selection != null) {
            int index = this.m_UIList.indexOf(selection);
            if (index != -1) {
                this.m_UIList.setSelection(index);
            } else {
                this.m_UIList.deselectAll();
            }
        } else {
            this.m_UIList.deselectAll();
        }
    }

    public void refreshCombo(Object selection) {
        this.m_combo.setItems(new String[0]);
        List<String> list = ((SelectAttribute)this.m_attribute).getList();
        int i = 0;
        while (i < list.size()) {
            String elem = list.get(i);
            this.m_combo.add(elem);
            ++i;
        }
        if (selection != null) {
            if (selection instanceof String) {
                if (list.indexOf(selection) == -1) {
                    this.m_combo.clearSelection();
                } else {
                    this.m_combo.select(list.indexOf(selection));
                }
            } else if (selection instanceof Integer) {
                try {
                    this.m_combo.select(Integer.parseInt("" + selection));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            this.m_combo.clearSelection();
        }
    }

    public void updateTextField(String text) {
        if (this.m_text_field != null) {
            this.m_text_field.setText(text);
        }
    }

    public void createPasswordComposite() {
        String desc;
        this.setCompositeLayout(2);
        PasswordAttribute attribute = (PasswordAttribute)this.m_attribute;
        String label = String.valueOf(attribute.getLabel()) + ": ";
        if (label == null || label.length() == 0) {
            return;
        }
        String value = attribute.getValue();
        if (value == null) {
            value = "";
        }
        if ((desc = attribute.getDescription()) == null) {
            desc = "";
        }
        boolean editable = attribute.isEditable();
        if (this.m_isReadOnly) {
            editable = false;
        }
        this.m_pwd_field = this.gui.addInputFieldSingle(this, TYPE_PASSWORD, label, value, 1, 1, 5, 1, 100, this);
        this.m_pwd_field.setEditable(editable);
        this.m_pwd_field.setToolTipText(desc);
        this.m_pwd_field.setEchoChar('*');
    }

    public void setCompositeLayout(int columnCount) {
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        this.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
    }

    public Label createSelectableIcon(Composite comp, Image icon, String actionType, boolean isEnabled, Object object) {
        Label label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        label.setImage(icon);
        label.setData(TYPE, (Object)actionType);
        label.setEnabled(isEnabled);
        if (!this.m_isReadOnly) {
            if (object instanceof org.eclipse.swt.widgets.List) {
                label.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.widget instanceof Label) {
                            Label l = (Label)event.widget;
                            String actionType = (String)l.getData(TYPE);
                            if (actionType.equals(EDIT)) {
                                if (ServerJobTabComposite.this.m_UIList.getSelection().length > 0) {
                                    EditElementAction editAction = new EditElementAction(TYPE_LIST);
                                    editAction.run();
                                }
                            } else if (actionType.equals(ADD)) {
                                AddElementAction addAction = new AddElementAction(TYPE_LIST);
                                addAction.run();
                            } else if (actionType.equals(DEL) && ServerJobTabComposite.this.m_UIList.getSelection().length > 0) {
                                DeleteElementAction deleteAction = new DeleteElementAction(TYPE_LIST);
                                deleteAction.run();
                            }
                        }
                    }
                });
            } else if (object instanceof Table) {
                label.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.widget instanceof Label) {
                            Label l = (Label)event.widget;
                            String actionType = (String)l.getData(TYPE);
                            if (actionType.equals(ADD)) {
                                AddElementAction addAction = new AddElementAction(TYPE_MAP);
                                addAction.run();
                            } else if (actionType.equals(DEL)) {
                                if (ServerJobTabComposite.this.m_table.getSelectionCount() > 0) {
                                    if (ServerJobTabComposite.this.m_tableEditorText != null) {
                                        ServerJobTabComposite.this.m_tableEditorText.dispose();
                                    }
                                    DeleteElementAction deleteAction = new DeleteElementAction(TYPE_MAP);
                                    deleteAction.run();
                                }
                            } else if (actionType.equals(UP)) {
                                MoveOneUpAction moveOneUpAction = new MoveOneUpAction();
                                moveOneUpAction.run();
                            } else if (actionType.equals(DOWN)) {
                                MoveOneDownAction moveOneDownAction = new MoveOneDownAction();
                                moveOneDownAction.run();
                            }
                        }
                    }
                });
            } else if (object instanceof CCombo) {
                label.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.widget instanceof Label) {
                            Label l = (Label)event.widget;
                            String actionType = (String)l.getData(TYPE);
                            if (actionType.equals(EDIT)) {
                                if (ServerJobTabComposite.this.m_combo.getSelectionIndex() > -1) {
                                    EditElementAction editAction = new EditElementAction(TYPE_COMBO);
                                    editAction.run();
                                }
                            } else if (actionType.equals(ADD)) {
                                AddElementAction addAction = new AddElementAction(TYPE_COMBO);
                                addAction.run();
                            } else if (actionType.equals(DEL) && ServerJobTabComposite.this.m_combo.getSelectionIndex() > -1) {
                                DeleteElementAction deleteAction = new DeleteElementAction(TYPE_COMBO);
                                deleteAction.run();
                            }
                        }
                    }
                });
            }
        }
        return label;
    }

    public void updateAttributeObject(String type) {
        if (type.equals(TYPE_MAP)) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            TableItem[] items = this.m_table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem ti = items[i];
                map.put(ti.getText(0), ti.getText(1));
                ++i;
            }
            try {
                ((MapAttribute)this.m_attribute).setValue(map);
            }
            catch (UnsupportedTypeException e) {
                e.printStackTrace();
            }
        }
    }

    public void checkButtonStatus(org.eclipse.swt.widgets.List list) {
        if (list.getSelectionCount() == 0) {
            this.m_edit_image.setEnabled(false);
            this.m_del_image.setEnabled(false);
        } else if (list.getSelectionCount() > 0) {
            this.m_edit_image.setEnabled(true);
            this.m_del_image.setEnabled(true);
        }
    }

    public void setCTabDirty(boolean dirty) {
        if (this.m_cTab != null && this.m_cTab instanceof ServerJobTab) {
            ((ServerJobTab)this.m_cTab).setDirty(dirty);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget instanceof Text) {
            Text text = (Text)e.widget;
            if (text.getData().equals(TYPE_TEXT)) {
                try {
                    ((TextAttribute)this.m_attribute).setValue(text.getText().trim());
                }
                catch (UnsupportedTypeException e1) {
                    e1.printStackTrace();
                }
            } else if (text.getData().equals(TYPE_PASSWORD)) {
                try {
                    ((PasswordAttribute)this.m_attribute).setValue(text.getText().trim());
                }
                catch (UnsupportedTypeException e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.setCTabDirty(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof org.eclipse.swt.widgets.List) {
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.getSource();
            this.checkButtonStatus(list);
        } else if (e.getSource() instanceof CCombo) {
            CCombo combo = (CCombo)e.getSource();
            try {
                ((SelectAttribute)this.m_attribute).setValue(combo.getText());
            }
            catch (UnsupportedTypeException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() instanceof Button) {
            Button checkBox = (Button)e.getSource();
            if (this.m_attribute instanceof CheckAttribute) {
                try {
                    ((CheckAttribute)this.m_attribute).setValue(checkBox.getSelection());
                }
                catch (UnsupportedTypeException unsupportedTypeException) {}
            }
        }
        this.setCTabDirty(true);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.m_UIList.getSelection().length > 0) {
            EditElementAction editAction = new EditElementAction(TYPE_LIST);
            editAction.run();
        }
        this.setCTabDirty(true);
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public class AddElementAction
    extends Action {
        private String m_type;

        public AddElementAction(String type) {
            super("add");
            this.m_type = null;
            this.setId("add");
            this.setText("Add");
            this.m_type = type;
        }

        public void run() {
            String newVal = this.addElement();
            if (newVal != null && newVal.length() > 0) {
                if (this.m_type.equals(TYPE_LIST)) {
                    ServerJobTabComposite.this.refreshList(newVal);
                } else if (this.m_type.equals(TYPE_MAP)) {
                    ServerJobTabComposite.this.refreshTable();
                } else if (this.m_type.equals(TYPE_COMBO)) {
                    ServerJobTabComposite.this.refreshCombo(newVal);
                }
            }
        }

        public String addElement() {
            String newValue;
            AdmConfigEditDialog dialog;
            int res;
            String newVal = null;
            if (this.m_type.equals(TYPE_MAP)) {
                String[] newValues;
                AdmConfigEditDialog dialog2 = new AdmConfigEditDialog(Display.getCurrent().getActiveShell(), TYPE_MAP, ADD, null, ServerJobTabComposite.this.m_attribute);
                int res2 = dialog2.open();
                if (res2 == 0 && (newValues = (String[])dialog2.getResult()) != null && newValues.length == 2) {
                    Object map = ((MapAttribute)ServerJobTabComposite.this.m_attribute).getValue();
                    map.put(newValues[0], newValues[1]);
                    newVal = newValues[0];
                    ServerJobTabComposite.this.setCTabDirty(true);
                }
            } else if (this.m_type.equals(TYPE_LIST)) {
                String newValue2;
                AdmConfigEditDialog dialog3 = new AdmConfigEditDialog(Display.getCurrent().getActiveShell(), TYPE_LIST, ADD, null, ServerJobTabComposite.this.m_attribute);
                int res3 = dialog3.open();
                if (res3 == 0 && (newValue2 = (String)dialog3.getResult()) != null) {
                    ListAttribute listAttribute = (ListAttribute)ServerJobTabComposite.this.m_attribute;
                    Object list = listAttribute.getValue();
                    list.add(newValue2);
                    newVal = newValue2;
                    ServerJobTabComposite.this.setCTabDirty(true);
                }
            } else if (this.m_type.equals(TYPE_COMBO) && (res = (dialog = new AdmConfigEditDialog(Display.getCurrent().getActiveShell(), TYPE_COMBO, ADD, null, ServerJobTabComposite.this.m_attribute)).open()) == 0 && (newValue = (String)dialog.getResult()) != null) {
                SelectAttribute attribute = (SelectAttribute)ServerJobTabComposite.this.m_attribute;
                List<String> list = attribute.getList();
                list.add(newValue);
                newVal = newValue;
                ServerJobTabComposite.this.setCTabDirty(true);
            }
            return newVal;
        }
    }

    public class DeleteElementAction
    extends Action {
        private String m_type;

        public DeleteElementAction(String type) {
            int selIndex;
            super("delete");
            this.m_type = null;
            this.setId("delete");
            this.setText("Delete");
            this.m_type = type;
            if (this.m_type.equals(TYPE_MAP)) {
                TableItem[] items = ServerJobTabComposite.this.m_table.getSelection();
                if (items.length == 0) {
                    this.setEnabled(false);
                    return;
                }
            } else if (this.m_type.equals(TYPE_LIST)) {
                String[] sel = ServerJobTabComposite.this.m_UIList.getSelection();
                if (sel.length == 0) {
                    this.setEnabled(false);
                    return;
                }
            } else if (this.m_type.equals(TYPE_COMBO) && (selIndex = ServerJobTabComposite.this.m_combo.getSelectionIndex()) == -1) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            boolean deleted = this.deleteElement();
            if (deleted) {
                if (this.m_type.equals(TYPE_LIST)) {
                    ServerJobTabComposite.this.refreshList(null);
                } else if (this.m_type.equals(TYPE_MAP)) {
                    ServerJobTabComposite.this.refreshTable();
                } else if (this.m_type.equals(TYPE_COMBO)) {
                    ServerJobTabComposite.this.refreshCombo(null);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean deleteElement() {
            if (this.m_type.equals(TYPE_MAP)) {
                TableItem selected;
                String key;
                Object map = ((MapAttribute)ServerJobTabComposite.this.m_attribute).getValue();
                TableItem[] items = ServerJobTabComposite.this.m_table.getSelection();
                if (items.length <= 0 || !map.containsKey(key = (selected = items[0]).getText(0))) return true;
                String msg = "Do you want to delete " + key;
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Delete Element", msg, "Delete", "Cancel");
                int res = dialog.open();
                if (res != 0) return false;
                map.remove(key);
                ServerJobTabComposite.this.setCTabDirty(true);
                return true;
            } else if (this.m_type.equals(TYPE_LIST)) {
                ListAttribute attribute = (ListAttribute)ServerJobTabComposite.this.m_attribute;
                Object list = attribute.getValue();
                String[] sel = ServerJobTabComposite.this.m_UIList.getSelection();
                if (sel.length <= 0 || !list.contains(sel[0])) return true;
                String msg = "Do you want to delete " + sel[0];
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Delete Element", msg, "Delete", "Cancel");
                int res = dialog.open();
                if (res != 0) return false;
                if (!list.contains(sel[0])) return true;
                list.remove(sel[0]);
                ServerJobTabComposite.this.setCTabDirty(true);
                return true;
            } else {
                String sel;
                if (!this.m_type.equals(TYPE_COMBO)) return true;
                SelectAttribute attribute = (SelectAttribute)ServerJobTabComposite.this.m_attribute;
                List<String> list = attribute.getList();
                int selIndex = ServerJobTabComposite.this.m_combo.getSelectionIndex();
                if (selIndex == -1 || !list.contains(sel = ServerJobTabComposite.this.m_combo.getText())) return true;
                String msg = "Do you want to delete the element '" + sel + "'";
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Delete Element", msg, "Delete", "Cancel");
                int res = dialog.open();
                if (res != 0) return false;
                if (!list.contains(sel)) return true;
                list.remove(sel);
                ServerJobTabComposite.this.setCTabDirty(true);
            }
            return true;
        }
    }

    public class EditElementAction
    extends Action {
        private String m_type;

        public EditElementAction(String type) {
            int selIndex;
            super("edit");
            this.m_type = null;
            this.setId("edit");
            this.setText("Edit");
            this.m_type = type;
            if (this.m_type.equals(TYPE_MAP)) {
                TableItem[] items = ServerJobTabComposite.this.m_table.getSelection();
                if (items.length == 0) {
                    this.setEnabled(false);
                    return;
                }
            } else if (this.m_type.equals(TYPE_LIST)) {
                String[] sel = ServerJobTabComposite.this.m_UIList.getSelection();
                if (sel.length == 0) {
                    this.setEnabled(false);
                    return;
                }
            } else if (this.m_type.equals(TYPE_COMBO) && (selIndex = ServerJobTabComposite.this.m_combo.getSelectionIndex()) == -1) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            String newVal = this.editElement();
            if (newVal != null && newVal.length() > 0) {
                if (this.m_type.equals(TYPE_LIST)) {
                    ServerJobTabComposite.this.refreshList(newVal);
                } else if (this.m_type.equals(TYPE_MAP)) {
                    ServerJobTabComposite.this.refreshTable();
                } else if (this.m_type.equals(TYPE_COMBO)) {
                    ServerJobTabComposite.this.refreshCombo(newVal);
                }
            }
        }

        public String editElement() {
            String changedValue = null;
            if (this.m_type.equals(TYPE_LIST)) {
                String[] sel = ServerJobTabComposite.this.m_UIList.getSelection();
                if (sel.length > 0) {
                    String selected = sel[0];
                    AdmConfigEditDialog dialog = new AdmConfigEditDialog(Display.getCurrent().getActiveShell(), TYPE_LIST, EDIT, selected, ServerJobTabComposite.this.m_attribute);
                    int res = dialog.open();
                    if (res == 0 && (changedValue = (String)dialog.getResult()) != null && !selected.equals(changedValue)) {
                        Object list = ((ListAttribute)ServerJobTabComposite.this.m_attribute).getValue();
                        if (list.contains(selected)) {
                            list.set(list.indexOf(selected), changedValue);
                            ServerJobTabComposite.this.setCTabDirty(true);
                        } else {
                            changedValue = null;
                        }
                    }
                }
            } else if (this.m_type.equals(TYPE_COMBO)) {
                AdmConfigEditDialog dialog;
                int res;
                String selection = ServerJobTabComposite.this.m_combo.getText();
                if (selection != null && (res = (dialog = new AdmConfigEditDialog(Display.getCurrent().getActiveShell(), TYPE_COMBO, EDIT, selection, ServerJobTabComposite.this.m_attribute)).open()) == 0 && (changedValue = (String)dialog.getResult()) != null && !selection.equals(changedValue)) {
                    List<String> list = ((SelectAttribute)ServerJobTabComposite.this.m_attribute).getList();
                    if (list.contains(selection)) {
                        list.set(list.indexOf(selection), changedValue);
                        ServerJobTabComposite.this.setCTabDirty(true);
                    } else {
                        changedValue = null;
                    }
                }
            } else {
                this.m_type.equals(TYPE_MAP);
            }
            return changedValue;
        }
    }

    public class MoveOneDownAction
    extends Action {
        public void run() {
            boolean success;
            Object map;
            int selIndex = ServerJobTabComposite.this.m_tableViewer.getTable().getSelectionIndex();
            if (selIndex != (map = ((MapAttribute)ServerJobTabComposite.this.m_attribute).getValue()).size() - 1 && selIndex > -1 && (success = this.moveDown(selIndex))) {
                if (ServerJobTabComposite.this.m_tableEditorText != null & !ServerJobTabComposite.this.m_tableEditorText.isDisposed()) {
                    ServerJobTabComposite.this.m_tableEditorText.dispose();
                }
                ServerJobTabComposite.this.refreshTable();
                ServerJobTabComposite.this.m_tableViewer.getTable().select(selIndex + 1);
                ServerJobTabComposite.this.setCTabDirty(true);
            }
        }

        public boolean moveDown(int index) {
            Object map = ((MapAttribute)ServerJobTabComposite.this.m_attribute).getValue();
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(map.keySet());
            String elem = (String)list.remove(index);
            list.add(index + 1, elem);
            LinkedHashMap<String, String> updatedMap = new LinkedHashMap<String, String>();
            for (String string : list) {
                updatedMap.put(string, (String)map.get(string));
            }
            try {
                ((MapAttribute)ServerJobTabComposite.this.m_attribute).setValue(updatedMap);
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                RTLogger.print(5, "Error moving table element down in ServerJobs MappingTable. ", unsupportedTypeException);
                return false;
            }
            return true;
        }
    }

    public class MoveOneUpAction
    extends Action {
        public void run() {
            boolean success;
            int selIndex = ServerJobTabComposite.this.m_tableViewer.getTable().getSelectionIndex();
            if (selIndex != 0 && selIndex > 0 && (success = this.moveUp(selIndex))) {
                if (ServerJobTabComposite.this.m_tableEditorText != null & !ServerJobTabComposite.this.m_tableEditorText.isDisposed()) {
                    ServerJobTabComposite.this.m_tableEditorText.dispose();
                }
                ServerJobTabComposite.this.refreshTable();
                ServerJobTabComposite.this.m_tableViewer.getTable().select(selIndex - 1);
                ServerJobTabComposite.this.setCTabDirty(true);
            }
        }

        public boolean moveUp(int index) {
            Object map = ((MapAttribute)ServerJobTabComposite.this.m_attribute).getValue();
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(map.keySet());
            String elem = (String)list.remove(index);
            list.add(index - 1, elem);
            LinkedHashMap<String, String> updatedMap = new LinkedHashMap<String, String>();
            for (String string : list) {
                updatedMap.put(string, (String)map.get(string));
            }
            try {
                ((MapAttribute)ServerJobTabComposite.this.m_attribute).setValue(updatedMap);
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                RTLogger.print(5, "Error moving table element up in ServerJobs MappingTable. ", unsupportedTypeException);
                return false;
            }
            return true;
        }
    }
}

